/*
    Copyright 2002, 2003, Steve Thompson <stevet010@softhome.net>

    This software is free for non-commercial, non-military use.

    Included with this package, you should have received a file called
    `Licensing' which contains detailed terms of use.

*/

#ifndef SCSI_COMPARE_H
#define SCSI_COMPARE_H

#define compare_segment_descriptor_00	    copy_segment_descriptor_00
#define compare_segment_descriptor_01	    copy_segment_descriptor_01
#define compare_segment_descriptor_02	    copy_segment_descriptor_02
#define compare_segment_descriptor_03	    copy_segment_descriptor_03
#define compare_segment_descriptor_04	    copy_segment_descriptor_04
#define compare_segment_descriptor_0a	    copy_segment_descriptor_0a
#define compare_segment_descriptor_0b	    copy_segment_descriptor_0b
#define compare_segment_descriptor_0c	    copy_segment_descriptor_0c


struct scsi_compare_plist {
    u8      priority:3;
    u8      function_code:5;
    u16     reserved1;
    union {
            struct compare_segment_descriptor_00    sd0[0];
            struct compare_segment_descriptor_01    sd1[0];
            struct compare_segment_descriptor_02    sd2[0];
            struct compare_segment_descriptor_03    sd3[0];
            struct compare_segment_descriptor_04    sd4[0];
            struct compare_segment_descriptor_0a    sda[0];
            struct compare_segment_descriptor_0b    sdb[0];
            struct compare_segment_descriptor_0c    sdc[0];
            u8					    b[0];
    } u;
} __attribute__ ((packed));


#endif
