/* @(#)scsicmds.c	1.27 96/12/19 Copyright 1988 J. Schilling */
#ifndef lint
static	char sccsid[] =
	"@(#)scsicmds.c	1.27 96/12/19 Copyright 1988 J. Schilling";
#endif
/*
 *	SCSI commands for sformat program
 *
 *	Copyright (c) 1988 J. Schilling
 */
/* This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 */

#include <sys/param.h>
#include <stdio.h>
#include <standard.h>
#include <signal.h>
#include <errno.h>
#include <stdxlib.h>
#include <sys/time.h>
#include <sys/ioctl.h>
#include <sys/buf.h>

#include <sun/dklabel.h>
#include <sun/dkio.h>
 
#include "scgio.h"

#include "scsireg.h"
#include "scsitransp.h"

#ifdef	FMT
#include "fmt.h"
#endif

char	buf[63*1024];
int	debug;
int	xdebug;
int	silent;
int	verbose;

extern	int	target;
extern	int	lun;

#define	G0_MAXADDR	0x1FFFFFL

struct	scg_cmd scmd;

struct	scsi_capacity cap;

EXPORT	int	test_unit_ready		__PR((void));
EXPORT	int	rezero_unit		__PR((void));
EXPORT	int	mode_select		__PR((u_char *dp, int cnt, int smp, int pf));
EXPORT	int	mode_sense		__PR((u_char *dp, int cnt, int page, int pcf));
EXPORT	int	format_unit		__PR((struct scsi_format_data *fmt, int ndefects, int list_format, int dmdl, int dgdl, int interlv, int pattern, int timeout));
EXPORT	int	inquiry			__PR((caddr_t bp, int cnt));
EXPORT	int	read_capacity		__PR((void));
EXPORT	int	reassign_block		__PR((struct scsi_def_list *bad, int nbad));
EXPORT	int	read_scsi		__PR((caddr_t bp, long addr, int cnt));
EXPORT	int	read_g0			__PR((caddr_t bp, long addr, int cnt));
EXPORT	int	read_g1			__PR((caddr_t bp, long addr, int cnt));
EXPORT	int	write_scsi		__PR((caddr_t bp, long addr, int cnt));
EXPORT	int	write_g0		__PR((caddr_t bp, long addr, int cnt));
EXPORT	int	write_g1		__PR((caddr_t bp, long addr, int cnt));
EXPORT	int	seek_scsi		__PR((long addr));
EXPORT	int	seek_g0			__PR((long addr));
EXPORT	int	seek_g1			__PR((long addr));
EXPORT	int	translate		__PR((struct scsi_def_bfi *dp, long lba));
EXPORT	int	qic02			__PR((int cmd));
EXPORT	int	start_stop_unit		__PR((int flg));
EXPORT	int	receive_diagnostic	__PR((caddr_t bp, int len));
EXPORT	int	send_diagnostic		__PR((caddr_t bp, int len));
EXPORT	int	write_verify		__PR((caddr_t bp, long start, int count, long *bad_block));
EXPORT	int	verify			__PR((long start, int count, long *bad_block));
EXPORT	int	write_verify_split	__PR((caddr_t bp, long start, int count, long *bad_block));
EXPORT	int	read_defect_list	__PR((int list_type, int list_format, BOOL print));
EXPORT	void	xclear_phys_null	__PR((void));
EXPORT	void	clear_phys_null		__PR((void));
EXPORT	void	read_phys_null		__PR((BOOL ccs));
EXPORT	void	md21_read_phys_null	__PR((void));
EXPORT	void	ccs_read_phys_null	__PR((void));
EXPORT	void	damage_phys_blk		__PR((void));

EXPORT int
test_unit_ready()
{
	fillbytes((caddr_t)&scmd, sizeof(scmd), '\0');
	scmd.addr = (caddr_t)0;
	scmd.size = 0;
	scmd.flags = SCG_DISRE_ENA | (silent ? SCG_SILENT:0);
	scmd.cdb_len = SC_G0_CDBLEN;
	scmd.sense_len = CCS_SENSE_LEN;
	scmd.target = target;
	scmd.cdb.g0_cdb.cmd = SC_TEST_UNIT_READY;
	scmd.cdb.g0_cdb.lun = lun;
	
	return (scsicmd("test unit ready"));
}

EXPORT int
rezero_unit()
{
	fillbytes((caddr_t)&scmd, sizeof(scmd), '\0');
	scmd.addr = (caddr_t)0;
	scmd.size = 0;
	scmd.flags = SCG_DISRE_ENA;
	scmd.cdb_len = SC_G0_CDBLEN;
	scmd.sense_len = CCS_SENSE_LEN;
	scmd.target = target;
	scmd.cdb.g0_cdb.cmd = SC_REZERO_UNIT;
	scmd.cdb.g0_cdb.lun = lun;
	
	return (scsicmd("rezero unit"));
}

EXPORT int
mode_select(dp, cnt, smp, pf)
	u_char	*dp;
	int	cnt;
	int	smp;
	int	pf;
{
	fillbytes((caddr_t)&scmd, sizeof(scmd), '\0');
	scmd.addr = (caddr_t)dp;
	scmd.size = cnt;
	scmd.flags = SCG_DISRE_ENA;
	scmd.cdb_len = SC_G0_CDBLEN;
	scmd.sense_len = CCS_SENSE_LEN;
	scmd.target = target;
	scmd.cdb.g0_cdb.cmd = SC_MODE_SELECT;
	scmd.cdb.g0_cdb.lun = lun;
	scmd.cdb.g0_cdb.high_addr = smp ? 1 : 0 | pf ? 0x10 : 0;
	scmd.cdb.g0_cdb.count = cnt;

	printf("%s ", smp?"Save":"Set ");
	scsiprbytes("Mode Parameters", dp, cnt);

	return (scsicmd("mode select"));
}

EXPORT int
mode_sense(dp, cnt, page, pcf)
	u_char	*dp;
	int	cnt;
	int	page;
	int	pcf;
{
	fillbytes((caddr_t)&scmd, sizeof(scmd), '\0');
	scmd.addr = (caddr_t)dp;
	scmd.size = 0xFF;
	scmd.size = cnt;
	scmd.flags = SCG_RECV_DATA|SCG_DISRE_ENA;
	scmd.cdb_len = SC_G0_CDBLEN;
	scmd.sense_len = CCS_SENSE_LEN;
	scmd.target = target;
	scmd.cdb.g0_cdb.cmd = SC_MODE_SENSE;
	scmd.cdb.g0_cdb.lun = lun;
#ifdef	nonono
	scmd.cdb.g0_cdb.high_addr = 1<<4;	/* XXX PCF ???*/
#endif
	scmd.cdb.g0_cdb.mid_addr = (page&0x3F) | ((pcf<<6)&0xC0);
	scmd.cdb.g0_cdb.count = page ? 0xFF : 24;
	scmd.cdb.g0_cdb.count = cnt;

	if (scsicmd("mode sense") < 0)
		return (-1);
	if (xdebug) scsiprbytes("Mode Sense Data", dp, cnt - scmd.resid);
	return (0);
}

#define	FMTDAT	0x10
#define	CMPLST	0x08

EXPORT int
format_unit(fmt, ndefects, list_format, dmdl, dgdl, interlv, pattern, timeout)
	struct	scsi_format_data *fmt;
	int	ndefects;
	int	list_format;
	int	dmdl;		/* disable manufacturers defect list	*/
	int	dgdl;		/* disable grown defect list		*/
	int	interlv;
	int	pattern;
	int	timeout;
{
	if (fmt)
		fillbytes((caddr_t)fmt, sizeof(fmt->hd), '\0');
	else if (dmdl || ndefects || list_format || !dgdl)
		raisecond("fmt == 0", 0L);
	if (dmdl) {
		fmt->hd.enable = 1;
		fmt->hd.dmdl = 1;
		fmt->hd.dcert = 1;
	}
	if (fmt) {
		switch (list_format) {

		case SC_DEF_BLOCK:
			fmt->hd.length = ndefects * sizeof(fmt->def_block[0]);
			break;
		case SC_DEF_BFI:
			fmt->hd.length = ndefects * sizeof(fmt->def_bfi[0]);
			break;
		case SC_DEF_PHYS:
			fmt->hd.length = ndefects * sizeof(fmt->def_phys[0]);
			break;
		default:
			raisecond("list_format", 0L);
		}
	}
	fillbytes((caddr_t)&scmd, sizeof(scmd), '\0');
	scmd.addr = (caddr_t)fmt;
	scmd.size = fmt ? sizeof(fmt->hd)+fmt->hd.length/*+1*/ : 0;
	scmd.flags = SCG_DISRE_ENA;
	scmd.cdb_len = SC_G0_CDBLEN;
	scmd.sense_len = CCS_SENSE_LEN;
	scmd.target = target;
	if (timeout < 0)
		timeout = 24*3600;	/* Kein Timeout XXX kann haengen */
	scmd.timeout = timeout;
	scmd.cdb.g0_cdb.cmd = 0x04;	/* Format Unit */
	scmd.cdb.g0_cdb.lun = lun;
	scmd.cdb.g0_cdb.high_addr = (fmt?FMTDAT:0)|(dgdl?CMPLST:0)|list_format;
	scmd.cdb.g0_cdb.mid_addr = pattern;
	scmd.cdb.g0_cdb.count = interlv;

	if (verbose && fmt)
		scsiprbytes("Defect list Header: ", (u_char *)fmt, scmd.size);
	return (scsicmd("format unit"));
}

#ifdef	OLD
EXPORT int
old_format_unit(fmt, ndefects)
	struct	scsi_format_data *fmt;
	int	ndefects;
{
	fillbytes((caddr_t)&scmd, sizeof(scmd), '\0');
	fillbytes((caddr_t)fmt, sizeof(*fmt), '\0'); /* XXX */
	if (disable_mdl) {
		fmt->hd.enable = 1;
		fmt->hd.dmdl = 1;
		fmt->hd.dcert = 1;
	}
	fmt->hd.length = ndefects * sizeof(long);
	scmd.addr = (caddr_t)fmt;
	scmd.size = sizeof(fmt->hd)+fmt->hd.length/*+1*/;
	scmd.flags = SCG_DISRE_ENA;
	scmd.cdb_len = SC_G0_CDBLEN;
	scmd.sense_len = CCS_SENSE_LEN;
	scmd.target = target;
	scmd.cdb.g0_cdb.cmd = 0x04;	/* Format Unit */
	scmd.cdb.g0_cdb.lun = lun;
#ifdef	nonono
	scmd.cdb.g0_cdb.high_addr = 0x00; /* Archive */
#endif
	scmd.cdb.g0_cdb.high_addr = 0x18;
	scmd.cdb.g0_cdb.count = interleave;

	scsiprbytes("Defect list Header: ", (u_char *)fmt, scmd.size);
	return (scsicmd("format unit"));
}

EXPORT int
format_unit_ncl(fmt, ndefects)
	struct	scsi_format_data *fmt;
	int	ndefects;
{
	fillbytes((caddr_t)&scmd, sizeof(scmd), '\0');
	fillbytes((caddr_t)fmt, sizeof(*fmt), '\0'); /* XXX */
	if (disable_mdl) {
		fmt->hd.enable = 1;
		fmt->hd.dmdl = 1;
		fmt->hd.dcert = 1;
	}
	fmt->hd.length = ndefects * sizeof(long);
	scmd.addr = (caddr_t)fmt;
	scmd.size = sizeof(fmt->hd)+fmt->hd.length/*+1*/;
	scmd.flags = SCG_DISRE_ENA;
	scmd.cdb_len = SC_G0_CDBLEN;
	scmd.sense_len = CCS_SENSE_LEN;
	scmd.target = target;
	scmd.cdb.g0_cdb.cmd = 0x04;	/* Format Unit */
	scmd.cdb.g0_cdb.lun = lun;
	scmd.cdb.g0_cdb.high_addr = 0x10;
	scmd.cdb.g0_cdb.count = interleave;

	scsiprbytes("Defect list Header: ", (u_char *)fmt, scmd.size);
	return (scsicmd("format unit"));
}
#endif	/* OLD */

EXPORT int
inquiry(bp, cnt)
	caddr_t	bp;
	int	cnt;
{
	fillbytes(bp, cnt, '\0');
	fillbytes((caddr_t)&scmd, sizeof(scmd), '\0');
	scmd.addr = bp;
	scmd.size = cnt;
	scmd.flags = SCG_RECV_DATA|SCG_DISRE_ENA;
	scmd.cdb_len = SC_G0_CDBLEN;
	scmd.sense_len = CCS_SENSE_LEN;
	scmd.target = target;
	scmd.cdb.g0_cdb.cmd = SC_INQUIRY;
	scmd.cdb.g0_cdb.lun = lun;
	scmd.cdb.g0_cdb.count = cnt;
	
	if (scsicmd("inquiry") < 0)
		return (-1);
	if (verbose) {
		scsiprbytes("Inquiry Data: ", (u_char *)bp, cnt - scmd.resid);
		printf("\n");
	}
	return (0);
}

EXPORT int
read_capacity()
{
	fillbytes((caddr_t)&scmd, sizeof(scmd), '\0');
	scmd.addr = (caddr_t)&cap;
	scmd.size = sizeof(cap);
	scmd.flags = SCG_RECV_DATA|SCG_DISRE_ENA;
	scmd.cdb_len = SC_G1_CDBLEN;
	scmd.sense_len = CCS_SENSE_LEN;
	scmd.target = target;
	scmd.cdb.g1_cdb.cmd = 0x25;	/* Read Capacity */
	scmd.cdb.g1_cdb.lun = lun;
	g1_cdblen(&scmd.cdb.g1_cdb, 0); /* Full Media */
	
	if (scsicmd("read capacity") < 0) {
		return (-1);
	} else {
		long	kb;
		long	mb;
		long	prmb;
		double	dkb;
		long	cbsize;
		long	cbaddr;

		cbsize = a_to_u_long(&cap.c_bsize);
		cbaddr = a_to_u_long(&cap.c_baddr);
		cap.c_bsize = cbsize;
		cap.c_baddr = cbaddr;

		if (silent)
			return (0);

		dkb =  (cap.c_baddr+1.0) * (cap.c_bsize/1024.0);
		kb = dkb;
		mb = dkb / 1024.0;
		prmb = dkb / 1000.0 * 1.024;
		printf("Capacity: %ld Blocks = %ld kBytes = %ld MBytes = %ld prMB\n",
			cap.c_baddr+1, kb, mb, prmb);
		printf("Sectorsize: %d Bytes\n", cap.c_bsize);
	}
	return (0);
}

EXPORT int
reassign_block(bad, nbad)
	struct scsi_def_list *bad;
	int	nbad;
{
	fillbytes((caddr_t)&scmd, sizeof(scmd), '\0');
	fillbytes((caddr_t)&bad->hd, sizeof(struct scsi_def_header), '\0');
	bad->hd.length = sizeof(long) * nbad;
	scmd.addr = (caddr_t)bad;
	scmd.size = bad->hd.length + sizeof(struct scsi_def_header)/*+1*/;
	scmd.flags = SCG_DISRE_ENA;
	scmd.cdb_len = SC_G0_CDBLEN;
	scmd.sense_len = CCS_SENSE_LEN;
	scmd.target = target;
/*	scmd.timeout = nbad*20;*/
	scmd.timeout = nbad*200;
	scmd.cdb.g0_cdb.cmd = 0x07;	/* Reassign Block */
	scmd.cdb.g0_cdb.lun = lun;
	
	return (scsicmd("reassign block"));
}

EXPORT int
read_scsi(bp, addr, cnt)
	caddr_t	bp;
	long	addr;
	int	cnt;
{
	if(addr <= G0_MAXADDR)
		return(read_g0(bp, addr, cnt));
	else
		return(read_g1(bp, addr, cnt));
}

EXPORT int
read_g0(bp, addr, cnt)
	caddr_t	bp;
	long	addr;
	int	cnt;
{
	if (cap.c_bsize <= 0)
		raisecond("capacity_not_set", 0L);

	fillbytes((caddr_t)&scmd, sizeof(scmd), '\0');
	scmd.addr = bp;
	scmd.size = cnt*cap.c_bsize;
	scmd.flags = SCG_RECV_DATA|SCG_DISRE_ENA;
	scmd.cdb_len = SC_G0_CDBLEN;
	scmd.sense_len = CCS_SENSE_LEN;
	scmd.target = target;
	scmd.cdb.g0_cdb.cmd = SC_READ;
	scmd.cdb.g0_cdb.lun = lun;
	g0_cdbaddr(&scmd.cdb.g0_cdb, addr);
	scmd.cdb.g0_cdb.count = cnt;
	
	return (scsicmd("read_g0"));
}

EXPORT int
read_g1(bp, addr, cnt)
	caddr_t	bp;
	long	addr;
	int	cnt;
{
	if (cap.c_bsize <= 0)
		raisecond("capacity_not_set", 0L);

	fillbytes((caddr_t)&scmd, sizeof(scmd), '\0');
	scmd.addr = bp;
	scmd.size = cnt*cap.c_bsize;
	scmd.flags = SCG_RECV_DATA|SCG_DISRE_ENA;
	scmd.cdb_len = SC_G1_CDBLEN;
	scmd.sense_len = CCS_SENSE_LEN;
	scmd.target = target;
	scmd.cdb.g1_cdb.cmd = SC_EREAD;
	scmd.cdb.g1_cdb.lun = lun;
	g1_cdbaddr(&scmd.cdb.g1_cdb, addr);
	g1_cdblen(&scmd.cdb.g1_cdb, cnt);
	
	return (scsicmd("read_g1"));
}

EXPORT int
write_scsi(bp, addr, cnt)
	caddr_t	bp;
	long	addr;
	int	cnt;
{
	if(addr <= G0_MAXADDR)
		return(write_g0(bp, addr, cnt));
	else
		return(write_g1(bp, addr, cnt));
}

EXPORT int
write_g0(bp, addr, cnt)
	caddr_t	bp;
	long	addr;
	int	cnt;
{
	if (cap.c_bsize <= 0)
		raisecond("capacity_not_set", 0L);

	fillbytes((caddr_t)&scmd, sizeof(scmd), '\0');
	scmd.addr = bp;
	scmd.size = cnt*cap.c_bsize;
	scmd.flags = SCG_DISRE_ENA;
	scmd.cdb_len = SC_G0_CDBLEN;
	scmd.sense_len = CCS_SENSE_LEN;
	scmd.target = target;
	scmd.cdb.g0_cdb.cmd = SC_WRITE;
	scmd.cdb.g0_cdb.lun = lun;
	g0_cdbaddr(&scmd.cdb.g0_cdb, addr);
	scmd.cdb.g0_cdb.count = cnt;
	
	return (scsicmd("write_g0"));
}

EXPORT int
write_g1(bp, addr, cnt)
	caddr_t	bp;
	long	addr;
	int	cnt;
{
	if (cap.c_bsize <= 0)
		raisecond("capacity_not_set", 0L);

	fillbytes((caddr_t)&scmd, sizeof(scmd), '\0');
	scmd.addr = bp;
	scmd.size = cnt*cap.c_bsize;
	scmd.flags = SCG_DISRE_ENA;
	scmd.cdb_len = SC_G1_CDBLEN;
	scmd.sense_len = CCS_SENSE_LEN;
	scmd.target = target;
	scmd.cdb.g1_cdb.cmd = SC_EWRITE;
	scmd.cdb.g1_cdb.lun = lun;
	g1_cdbaddr(&scmd.cdb.g1_cdb, addr);
	g1_cdblen(&scmd.cdb.g1_cdb, cnt);
	
	return (scsicmd("write_g1"));
}

EXPORT int
seek_scsi(addr)
	long	addr;
{
	if(addr <= G0_MAXADDR)
		return(seek_g0(addr));
	else
		return(seek_g1(addr));
}

EXPORT int
seek_g0(addr)
	long	addr;
{
	fillbytes((caddr_t)&scmd, sizeof(scmd), '\0');
	scmd.flags = SCG_DISRE_ENA;
	scmd.cdb_len = SC_G0_CDBLEN;
	scmd.sense_len = CCS_SENSE_LEN;
	scmd.target = target;
	scmd.cdb.g0_cdb.cmd = 0x0B;	/* Seek */
	scmd.cdb.g0_cdb.lun = lun;
	g0_cdbaddr(&scmd.cdb.g0_cdb, addr);
	
	return (scsicmd("seek_g0"));
}

EXPORT int
seek_g1(addr)
	long	addr;
{
	fillbytes((caddr_t)&scmd, sizeof(scmd), '\0');
	scmd.flags = SCG_DISRE_ENA;
	scmd.cdb_len = SC_G1_CDBLEN;
	scmd.sense_len = CCS_SENSE_LEN;
	scmd.target = target;
	scmd.cdb.g1_cdb.cmd = 0x2B;	/* Seek G1 */
	scmd.cdb.g1_cdb.lun = lun;
	g1_cdbaddr(&scmd.cdb.g1_cdb, addr);
	
	return (scsicmd("seek_g1"));
}

EXPORT int
translate(dp, lba)
	struct scsi_def_bfi *dp;
	long	lba;
{
	fillbytes((caddr_t)&scmd, sizeof(scmd), '\0');
	scmd.addr = (caddr_t)dp;
	scmd.size = sizeof (struct scsi_def_bfi);
	scmd.flags = SCG_RECV_DATA|SCG_DISRE_ENA;
	scmd.cdb_len = SC_G0_CDBLEN;
	scmd.sense_len = CCS_SENSE_LEN;
	scmd.target = target;
	scmd.cdb.g0_cdb.cmd = 0x0F;		/* Translate (Adaptec) */
	scmd.cdb.g0_cdb.lun = lun;
	g0_cdbaddr(&scmd.cdb.g0_cdb, lba);
	
	return (scsicmd("translate"));
}

EXPORT int
qic02(cmd)
	int	cmd;
{
	fillbytes((caddr_t)&scmd, sizeof(scmd), '\0');
	scmd.addr = (caddr_t)0;
	scmd.size = 0;
	scmd.flags = SCG_DISRE_ENA;
	scmd.cdb_len = SC_G0_CDBLEN;
	scmd.sense_len = DEF_SENSE_LEN;
	scmd.target = target;
	scmd.cdb.g0_cdb.cmd = 0x0D;	/* qic02 Sysgen SC4000 */
	scmd.cdb.g0_cdb.lun = lun;
	scmd.cdb.g0_cdb.mid_addr = cmd;
	
	return (scsicmd("qic 02"));
}

EXPORT int
start_stop_unit(flg)
	int	flg;
{
	fillbytes((caddr_t)&scmd, sizeof(scmd), '\0');
	scmd.addr = (caddr_t)0;
	scmd.size = 0;
	scmd.flags = SCG_DISRE_ENA;
	scmd.cdb_len = SC_G0_CDBLEN;
	scmd.sense_len = CCS_SENSE_LEN;
	scmd.target = target;
	scmd.cdb.g0_cdb.cmd = 0x1B;	/* Start Stop Unit */
	scmd.cdb.g0_cdb.lun = lun;
	scmd.cdb.g0_cdb.count = flg & 0x1;
	
	return (scsicmd("start/stop unit"));
}

EXPORT int
receive_diagnostic(bp, len)
	caddr_t	bp;
	int	len;
{
	fillbytes((caddr_t)&scmd, sizeof(scmd), '\0');
	scmd.addr = bp;
	scmd.size = len;
	scmd.flags = SCG_RECV_DATA|SCG_DISRE_ENA;
	scmd.cdb_len = SC_G0_CDBLEN;
	scmd.sense_len = CCS_SENSE_LEN;
	scmd.target = target;
	scmd.cdb.g0_cdb.cmd = 0x1C;	/* Receive Diagostic Results */
	scmd.cdb.g0_cdb.lun = lun;
	scmd.cdb.g0_cdb.low_addr = (len >> 8) & 0xFF;
	scmd.cdb.g0_cdb.count = len & 0xFF;
	
	return (scsicmd("receive diagnostic"));
}

EXPORT int
send_diagnostic(bp, len)
	caddr_t	bp;
	int	len;
{
	fillbytes((caddr_t)&scmd, sizeof(scmd), '\0');
	scmd.addr = bp;
	scmd.size = len;
	scmd.flags = SCG_DISRE_ENA;
	scmd.cdb_len = SC_G0_CDBLEN;
	scmd.sense_len = CCS_SENSE_LEN;
	scmd.target = target;
	scmd.cdb.g0_cdb.cmd = 0x1D;	/* Send Diagostic */
	scmd.cdb.g0_cdb.lun = lun;
	scmd.cdb.g0_cdb.low_addr = (len >> 8) & 0xFF;
	scmd.cdb.g0_cdb.count = len & 0xFF;
	
	return (scsicmd("send diagnostic"));
}

EXPORT int
write_verify(bp, start, count, bad_block)
	caddr_t	bp;
	long	start;
	int	count;
	long	*bad_block;
{
	if (cap.c_bsize <= 0)
		raisecond("capacity_not_set", 0L);

	fillbytes((caddr_t)&scmd, sizeof(scmd), '\0');
	scmd.addr = bp;
	scmd.size = count*cap.c_bsize;
	scmd.flags = SCG_DISRE_ENA;
	scmd.cdb_len = SC_G1_CDBLEN;
	scmd.sense_len = CCS_SENSE_LEN;
	scmd.target = target;
	scmd.cdb.g1_cdb.cmd = 0x2E;	/* Write Verify */
	scmd.cdb.g1_cdb.lun = lun;
	g1_cdbaddr(&scmd.cdb.g1_cdb, start);
	g1_cdblen(&scmd.cdb.g1_cdb, count);
	
	if (scsicmd("write verify") < 0) {
		if (scmd.sense.code >= 0x70) {	/* extended Sense */
			*bad_block =
				a_to_u_long(&((struct scsi_ext_sense *)
							&scmd.sense)->info_1);
		} else {
			*bad_block = a_to_3_byte(&scmd.sense.high_addr);
		}
		return (-1);
	}
	return (0);
}

EXPORT int
verify(start, count, bad_block)
	long	start;
	int	count;
	long	*bad_block;
{
	fillbytes((caddr_t)&scmd, sizeof(scmd), '\0');
	scmd.addr = (caddr_t)0;
	scmd.size = 0;
	scmd.flags = SCG_DISRE_ENA;
	scmd.cdb_len = SC_G1_CDBLEN;
	scmd.sense_len = CCS_SENSE_LEN;
	scmd.target = target;
	scmd.cdb.g1_cdb.cmd = 0x2F;	/* Verify */
	scmd.cdb.g1_cdb.lun = lun;
	g1_cdbaddr(&scmd.cdb.g1_cdb, start);
	g1_cdblen(&scmd.cdb.g1_cdb, count);
	
	if (scsicmd("verify") < 0) {
		if (scmd.sense.code >= 0x70) {	/* extended Sense */
			*bad_block =
				a_to_u_long(&((struct scsi_ext_sense *)
							&scmd.sense)->info_1);
		} else {
			*bad_block = a_to_3_byte(&scmd.sense.high_addr);
		}
		return (-1);
	}
	return (0);
}

/*	beim verify kein bitcompare !	*/
EXPORT int
write_verify_split(bp, start, count, bad_block)
	caddr_t	bp;
	long	start;
	int	count;
	long	*bad_block;
{
 	if(write_scsi(bp, start, count) < 0) {
		if (scmd.sense.code >= 0x70) {	/* exetend Sense */
			*bad_block =
				a_to_u_long(&((struct scsi_ext_sense *)
							&scmd.sense)->info_1);
		} else {
			*bad_block = a_to_3_byte(&scmd.sense.high_addr);
		}
		return (-1);
	}
	return(verify(start, count, bad_block));
}

EXPORT int
read_defect_list(list_type, list_format, print)
	int	list_type;
	int	list_format;
	BOOL	print;
{
	fillbytes((caddr_t)&scmd, sizeof(scmd), '\0');
	scmd.addr = (caddr_t)buf;
	scmd.size = sizeof(buf);
	scmd.flags = SCG_RECV_DATA|SCG_DISRE_ENA;
	scmd.cdb_len = SC_G1_CDBLEN;
	scmd.sense_len = CCS_SENSE_LEN;
	scmd.target = target;
	scmd.cdb.g1_cdb.cmd = 0x37;	/* Read Defect List */
	scmd.cdb.g1_cdb.lun = lun;
	scmd.cdb.g1_cdb.addr[0] = ((list_type&3) << 3) | (list_format & 7);
	g1_cdblen(&scmd.cdb.g1_cdb, sizeof(buf));
	
	if (scsicmd("read defect list") < 0)
		return (-1);
	if (print)
		print_defect_list((struct scsi_def_list *)buf);
	return (0);
}

EXPORT void
xclear_phys_null(/*bp, addr, cnt*/)
/*
	caddr_t	bp;
	int	addr;
	int	cnt;
*/
{
	caddr_t	bp;
	int	cnt;
	long	baddr = 0L;

	bp = buf;
/*	addr = 0;*/
#ifdef	nonono
	addr |= 0x80000000;	/* Physical Block address */
#endif
	cnt = 1;
loop:
	fillbytes((caddr_t)&scmd, sizeof(scmd), '\0');
	baddr &= ~((unsigned long)1 << 31);
	getlong("Block Address", &baddr, 0L, 1000000L);
	baddr |= (yes("Physical Address ? ")<<31);
	scmd.addr = bp;
#ifdef	nonono
	scmd.size = cnt*512+6;	/*XXX 6 Bytes ECC */
#endif
	scmd.size = cnt*512+512;/*XXX 512 Bytes ECC ??*/
	fillbytes(bp, scmd.size, '\0');
	scmd.flags = SCG_DISRE_ENA;
	scmd.cdb_len = SC_G1_CDBLEN;
	scmd.sense_len = CCS_SENSE_LEN;
	scmd.target = target;
	scmd.cdb.g1_cdb.cmd = 0xEA;	/* Write long */
	scmd.cdb.g1_cdb.lun = lun;
	g1_cdbaddr(&scmd.cdb.g1_cdb, baddr);
/*	scmd.cdb.g1_cdb.count = cnt;*/
	
	/*return*/(void)(scsicmd("write long"));
	goto loop;
/*	exit(0);*/
}

EXPORT void
clear_phys_null(/*bp, addr, cnt*/)
/*
	caddr_t	bp;
	int	addr;
	int	cnt;
*/
{
	caddr_t	bp;
	int	cnt;
	long	baddr = 0L;
	long	i;
	long	n;

	bp = buf;
/*	addr = 0;*/
#ifdef	nonono
	addr |= 0x80000000;	/* Physical Block address */
#endif
	cnt = 1;

	n = 0;
	getlong("Count", &n, 0L, 1000000L);

	for (i=0; n == 0 || i < n; i++) {

	if (i == 0 || n == 0) {
		baddr &= ~((unsigned long)1 << 31);
		getlong("Block Address", &baddr, 0L, 1000000L);
		baddr |= (yes("Physical Address ? ")<<31);
	} else {
		baddr += 1;
	}
	fillbytes((caddr_t)&scmd, sizeof(scmd), '\0');
	scmd.addr = bp;
#ifdef	nonono
	scmd.size = cnt*512+6;	/*XXX 6 Bytes ECC */
#endif
	scmd.size = cnt*512+512;/*XXX 512 Bytes ECC ??*/
	fillbytes(bp, scmd.size, '\0');
	scmd.flags = SCG_DISRE_ENA;
	scmd.cdb_len = SC_G1_CDBLEN;
	scmd.sense_len = CCS_SENSE_LEN;
	scmd.target = target;
	scmd.cdb.g1_cdb.cmd = 0xEA;	/* Write long */
	scmd.cdb.g1_cdb.lun = lun;
	g1_cdbaddr(&scmd.cdb.g1_cdb, baddr);
/*	scmd.cdb.g1_cdb.count = cnt;*/
	
	/*return*/(void)(scsicmd("write long"));
	}
	exit(0);
}

EXPORT void
read_phys_null(ccs)
	BOOL	ccs;
{
	if (ccs)
		ccs_read_phys_null();
	else
		md21_read_phys_null();
}

EXPORT void
md21_read_phys_null(/*bp, addr, cnt*/)
/*
	caddr_t	bp;
	int	addr;
	int	cnt;
*/
{
	caddr_t	bp;
	long	baddr;
	int	cnt;

	bp = buf;
	baddr = 0L;
	baddr |= 0x80000000;	/* Physical Block address */
loop:
	cnt = 1;
	fillbytes((caddr_t)&scmd, sizeof(scmd), '\0');
	baddr &= ~((unsigned long)1 << 31);
	getlong("Block Address", &baddr, 0L, 1000000L);
	baddr |= (yes("Physical Address ? ")<<31);
	scmd.addr = bp;
	scmd.size = cnt*512+6;	/*XXX 6 Bytes ECC */
	fillbytes(bp, scmd.size, '\0');
	scmd.flags = SCG_RECV_DATA|SCG_DISRE_ENA;
	scmd.cdb_len = SC_G1_CDBLEN;
	scmd.sense_len = CCS_SENSE_LEN;
	scmd.target = target;
	scmd.cdb.g1_cdb.cmd = 0xE8;	/* Read long */
	/* Read long */
	scmd.cdb.g1_cdb.lun = lun;
	g1_cdbaddr(&scmd.cdb.g1_cdb, baddr);
/*	scmd.cdb.g1_cdb.count = cnt;*/
	
	/*return*/ (void)(scsicmd("read long"));
	printf("Data: %d Bytes\n", scmd.size - scmd.resid);
	filewrite(stdout, bp, scmd.size - scmd.resid);
	printf("END\n");flush();
goto loop;
/*	exit(0);*/
}

EXPORT void
ccs_read_phys_null(/*bp, addr, cnt*/)
/*
	caddr_t	bp;
	int	addr;
	int	cnt;
*/
{
	caddr_t	bp;
	long	baddr;
	int	cnt = 512+6;

	bp = buf;
	baddr = 0L;
	getint("Byte count", &cnt, 0L, 10000L);
loop:
	cnt = 1;
	fillbytes((caddr_t)&scmd, sizeof(scmd), '\0');
	baddr &= ~((unsigned long)1 << 31);
	getlong("Block Address", &baddr, 0L, 1000000L);
	scmd.addr = bp;
	scmd.size = cnt*512+512;/*XXX 512 Bytes ECC ??*/
	fillbytes(bp, scmd.size, '\0');
	scmd.flags = SCG_RECV_DATA|SCG_DISRE_ENA;
	scmd.cdb_len = SC_G1_CDBLEN;
	scmd.sense_len = CCS_SENSE_LEN;
	scmd.target = target;
	scmd.cdb.g1_cdb.cmd = 0x3E;	/* CCS Read long */
	/* Read long */
	scmd.cdb.g1_cdb.lun = lun;
	g1_cdbaddr(&scmd.cdb.g1_cdb, baddr);
	g1_cdblen(&scmd.cdb.g1_cdb, cnt);
	
	/*return*/ (void)(scsicmd("read long"));
	printf("Data: %d Bytes\n", scmd.size - scmd.resid);
	filewrite(stdout, bp, scmd.size - scmd.resid);
	printf("END\n");flush();
goto loop;
/*	exit(0);*/
}

EXPORT void
damage_phys_blk(/*bp, addr, cnt*/)
/*
	caddr_t	bp;
	int	addr;
	int	cnt;
*/
{
	caddr_t	bp;
	long	baddr;
	int	cnt;

	bp = buf;
	baddr = 0L;
	baddr |= 0x80000000;	/* Physical Block address */
/*loop:*/
	cnt = 1;
	fillbytes((caddr_t)&scmd, sizeof(scmd), '\0');
	baddr &= ~((unsigned long)1 << 31);
	getlong("Block Address", &baddr, 0L, 1000000L);
	baddr |= (yes("Physical Address ? ")<<31);
	scmd.addr = bp;
#ifdef	nonono
	scmd.size = cnt*512+6;	/*XXX 6 Bytes ECC */
#endif
	scmd.size = cnt*512+512;/*XXX 512 Bytes ECC ??*/
	fillbytes(bp, scmd.size, '\0');
	scmd.flags = SCG_RECV_DATA|SCG_DISRE_ENA;
	scmd.cdb_len = SC_G1_CDBLEN;
	scmd.sense_len = CCS_SENSE_LEN;
	scmd.target = target;
	scmd.cdb.g1_cdb.cmd = 0xE8;	/* Read long */
	scmd.cdb.g1_cdb.lun = lun;
	g1_cdbaddr(&scmd.cdb.g1_cdb, baddr);
/*	scmd.cdb.g1_cdb.count = cnt;*/
	
	if (scsicmd("read long") < 0)
		exit(-1);

	buf[0] &= 0x7F;	/* damage */

	fillbytes((caddr_t)&scmd, sizeof(scmd), '\0');
	scmd.addr = bp;
	scmd.size = cnt*512+6;	/*XXX*/
	fillbytes(bp, scmd.size, '\0');
	scmd.flags = SCG_DISRE_ENA;
	scmd.cdb_len = SC_G1_CDBLEN;
	scmd.sense_len = CCS_SENSE_LEN;
	scmd.target = target;
	scmd.cdb.g1_cdb.cmd = 0xEA;	/* Write long */
	scmd.cdb.g1_cdb.lun = lun;
	g1_cdbaddr(&scmd.cdb.g1_cdb, baddr);
	/*return*/(void)(scsicmd("write long"));
/*goto loop;*/
	exit(0);
}
