/* %Z%%M%	%I% %E% Copyright 1987 J. Schilling */
#ifndef lint
static	char sccsid[] =
	"%Z%%M%	%I% %E% Copyright 1987 J. Schilling";
#endif
/*
 *	Skeleton for the use of the scg genearal SCSI - driver
 *
 *	Copyright (c) 1987 J. Schilling
 */
/* This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 */

/*XXX*/bmap(){}bcrypt(){}int cur_disk;
/*XXX*/cvt_cyls(){}
/*XXX*/cvt_bcyls(){}

#include <sys/time.h>

#include <sys/param.h>
#include <sys/ioctl.h>
#include <sys/buf.h>

/*#include "../sun/dklabel.h"
#include "../sun/dkio.h"

#include "../sundev/sireg.h"
#include "../sundev/scsi.h"*/

#include <stdio.h>
#include <standard.h>
/*#include "../berdev/scgio.h"*/
/*#include "../berdev/scsireg.h"*/
#include "scgio.h"
#include "scsireg.h"

#define	BAD		(-1)
#define	min(a,b)	((a) < (b) ? (a) : (b))
#define	max(a,b)	((a) > (b) ? (a) : (b))

#ifndef	TRUE
#	define	TRUE	1
#	define	FALSE	0
#endif

struct timeval	starttime;
struct timeval	stoptime;

char	buf[63*1024];
int	scsibus;
int	target;
int	lun;
int	dev = 400;

int	debug;
int	silent;
int	verbose;
int	help;

struct	scg_cmd	scmd;

struct	scsi_format_data fmt;
struct	scsi_capacity cap;
struct	scsi_inquiry inq;

extern	char	*astoi();

usage(ret)
	int	ret;
{
	error("Usage:\tscgskeleton [options]\n");
	error("options:\n");
	error("\t-debug,-d\tdo Kernel debugging\n");
	error("\t-silent,-s\tdo not print status of erreneous commands\n");
	exit(ret);
}	

char	opts[]   = "debug#,d#,verbose,v,silent,s,help,h";

main(ac, av)
	int	ac;
	char	*av[];
{
	int	fcount;
	int	cac;
	char	* const *cav;

	cac = --ac;
	cav = ++av;

	if(getallargs(&cac, &cav, opts,
			&debug, &debug,
			&verbose, &verbose,
			&silent, &silent,
			&help, &help) < 0) {
		errmsgno(BAD, "Bad flag: %s.\n", cav[0]);
		usage(BAD);
	}
	if (help)
		usage(0);

	fcount = 0;
	cac = ac;
	cav = av;

	while(getfiles(&cac, &cav, opts) > 0) {
		fcount++;
		if (fcount == 1) {
			if (*astoi(cav[0], &target) != '\0') {
				errmsgno(BAD,
					"Target '%s' is not a Number.\n",
								cav[0]);
				usage(BAD);
				/* NOTREACHED */
			}
		}
		if (fcount == 2) {
			if (*astoi(cav[0], &lun) != '\0') {
				errmsgno(BAD,
					"Lun is '%s' not a Number.\n",
								cav[0]);
				usage(BAD);
				/* NOTREACHED */
			}
		}
		if (fcount == 3) {
			if (*astoi(cav[0], &scsibus) != '\0') {
				errmsgno(BAD,
					"Scsibus is '%s' not a Number.\n",
								cav[0]);
				usage(BAD);
				/* NOTREACHED */
			}
		} else {
			scsibus = 0;
		}
		cac--;
		cav++;
	}

	if (scsi_open() < 0)
		comerr("Cannot open '%s'\n", "/dev/scg?");

	/* code to use SCG */

	doit();
}

int prstats()
{
	int	sec;
	int	usec;
	int	tmsec;

	if (gettimeofday(&stoptime, (struct timezone *)0) < 0)
		comerr("Cannot get time\n");

	sec = stoptime.tv_sec - starttime.tv_sec;
	usec = stoptime.tv_usec - starttime.tv_usec;
	tmsec = sec*1000 + usec/1000;
#ifdef	lint
	tmsec = tmsec;	/* Bisz spaeter */
#endif
	if (usec < 0) {
		sec--;
		usec += 1000000;
	}

	printf("Time total: %d.%03dsec\n", sec, usec/1000);
	return (sec + (usec / 500000));
}

doit()
{
	long	i = 0L;

	for(;;) {
		printf("0:read 1:veri   2:erase   3:read buffer 4:cache 5:ovtime 6:cap\n");
		printf("7:wne  8:floppy 9:verify 10:checkcmds  11:read disk 12:write disk\n");

		getlong("Enter selection:", &i, 0L, 13L);
		switch (i) {

		case 0:		rr();		break;
		case 1:		vd();		break;
		case 2:		erase_disk();	break;
		case 3:		rb();		break;
		case 4:		cache();	break;
		case 5:		ovtime();	break;
		case 6:		capacity();	break;
		case 7:		wne();		break;
		case 8:		floppy();	break;
		case 9:		verify(500, 1, &i);
				i = 9;
				rezero_unit();	break;
		case 10:	checkcmds();	break;
		case 11:	read_disk();	break;
		case 12:	write_disk();	break;
		case 13:	scsireset();	break;
		}
	}
}

floppy()
{
	u_char	mode[0x100];
	u_char	cmode[0x100];
	int	hd;
	int	spt;
	u_char	*p;
	int	c;

	fillbytes(mode, sizeof(mode), '\0');
	fillbytes(cmode, sizeof(cmode), '\0');

	(void)test_unit_ready();

	if (mode_sense(mode, 0xFF, 0x5, 0) >= 0)/* Page 0x05 current*/
		prbytes("Mode Sense Data", mode, 0xFF - scmd.resid);
	else return;

	mode[0] = 0;
	mode[2] = 0; /* ??? ist manchmal 0x80 */
	p = mode;
	p += mode[3] + 4;
	*p &= 0x3F;

	hd = yes("High density? ");
/*	spt = hd ? 18 : 9;*/
	spt = p[5];
	getint("Sektors per Track? ", &spt, 0, 254);

	p[2] = hd ? 1 : 0;
	p[3] = hd ? 0xF4 : 0xFA;
	p[4] = 2;
	p[5] = spt;

	p[14] = 0x0B;
	p[15] = 0xB8;

	p[22] = 1;
	p[23] = 1;

	mode_select(mode, 0xFF - scmd.resid, 0);

	fillbytes(mode, sizeof(mode), '\0');
	fillbytes(cmode, sizeof(cmode), '\0');

	if (mode_sense(mode, 0xFF, 0x2A, 0) >= 0)/* Page 0x2A current*/
		prbytes("Mode Sense Data", mode, 0xFF - scmd.resid);
	else return;

	mode[0] = 0;
	mode[2] = 0; /* ??? ist manchmal 0x80 */
	p = mode;
	p += mode[3] + 4;
	*p &= 0x3F;

	c = p[2] & 0xFF;
	getint("Bits? ", &c, 0, 255);
	p[2] = c & 0xFF;

	mode_select(mode, 0xFF - scmd.resid, 0);
}

rb()
{
	long	bs;
	FILE	*f = fileopen("buffer", "wctu");

	read_buffer(buf, sizeof(buf));
	bs = a_to_u_long(buf);
	printf("bufsize: %l bytes = %l.%02dk\n",
			bs,
			bs>>10, ((bs&1023)<<10)/10485);
	filewrite(f, buf, sizeof(buf)-scmd.resid);
}

rr()
{
	long	addr = 0L;
	long	cnt = 1L;
	int	f;

set_mode_Page_20();
/*return;*/
	read_capacity();
	f = creat("buffer", 0666);
	for (;;) {
		getlong("addr", &addr, -1000000L, 1000000L);
		getlong("cnt", &cnt, 0L, 126L*512L/cap.c_bsize);
		read_scsi_g1(buf, addr, cnt);
		lseek(f, 0, 0);
/*		write(f, buf, cnt*cap.c_bsize-scmd.resid);*/
		write(f, buf, cnt*cap.c_bsize);
	}
}

vd()
{
	long	addr;
	long	cnt;
	long	def;

set_mode_Page_20();
/*return;*/
/*read_long();*/
	for (;;) {
		getlong("addr", &addr, -1000000L, 1000000L);
		getlong("cnt", &cnt, 0L, 0xFFFFL);
		verify(addr, cnt, &def);
	}
}

erase_disk()
{
	long	addr = 0L;
	long	cnt = 0xFFFF;
	long	l;

set_mode_Page_20();
/*return;*/
	for (;;) {
		getlong("addr", &addr, -1000000L, 1000000L);
/*		getlong("cnt", &cnt, 0L, 0xFFFFL);*/
		getlong("cnt", &cnt, 0L, 1000000L);
		if (cnt < 10000)
			scsi_erase(addr, cnt);
		else {
			while (cnt > 0) {
				if (cnt > 10000)
					l = 10000;
				else
					l = cnt;
				if (scsi_erase(addr, l) < 0)
					break;
				printf(".");flush();
				cnt -= l;
				addr += l;
			}
		}
	}
}

cache()
{
	u_char	mode[0x100];
	u_char	cmode[0x100];
	int	cache_off;
	u_char	*p;

	cache_off = yes("Turn cache off? ");

	fillbytes(mode, sizeof(mode), '\0');
	fillbytes(cmode, sizeof(cmode), '\0');
	/* XXX Quick and dirty, musz verallgemeinert werden !!! */

	(void)test_unit_ready();

	if (yes("Page 8 ")) {
		if (mode_sense(mode, 0xFF, 0x8, 0) >= 0)/* Page 0x08 current*/
			prbytes("Mode Sense Data", mode, 0xFF - scmd.resid);
		mode[0] = 0;
		p = mode;
		p += mode[3] + 4;
		*p &= 0x3F;
		if (cache_off)
			p[2] |= 0x01;
		else
			p[2] &= ~0x01;
		mode_select(mode, 0xFF - scmd.resid, 0);
	} else if (yes("Page 38 ")) {
		if (mode_sense(mode, 0xFF, 0x38, 0) >= 0)/* Page 0x38 current*/
			prbytes("Mode Sense Data", mode, 0xFF - scmd.resid);
		mode[0] = 0;
		p = mode;
		p += mode[3] + 4;
		*p &= 0x3F;
		if (cache_off)
			p[2] &= ~0x10;
		else
			p[2] |= 0x10;
		mode_select(mode, 0xFF - scmd.resid, 0);
	} else {
		if (mode_sense(mode, 0xFF, 0x37, 0) >= 0)/* Page 0x37 current*/
			prbytes("Mode Sense Data", mode, 0xFF - scmd.resid);
/*		if (mode_sense(cmode, 0xFF, 0x37, 1) >= 0)/* Page 0x37 change*/
/*			prbytes("Mode Sense Data", cmode, 0xFF - scmd.resid);*/
		mode[0] = 0;
		p = mode;
		p += mode[3] + 4;
		*p &= 0x3F;
		if (cache_off)
			p[2] &= ~0x03;
		else
			p[2] |= 0x03;
		mode_select(mode, 0xFF - scmd.resid, 0);
	}
}

ovtime()
{
	register int	i;

	silent++;
	(void)test_unit_ready();
	silent--;
	if (test_unit_ready() < 0)
		return;

	printf("Doing 1000 'TEST UNIT READY' operations.\n");

	if (gettimeofday(&starttime, (struct timezone *)0) < 0)
		comerr("Cannot get start time\n");

	for (i = 1000; --i >= 0;)
		(void)test_unit_ready();

	prstats();

	printf("Doing 1000 'SEEK_G0 (0)' operations.\n");

	if (gettimeofday(&starttime, (struct timezone *)0) < 0)
		comerr("Cannot get start time\n");

	for (i = 1000; --i >= 0;)
		(void)seek_g0(0L);

	prstats();

	printf("Doing 1000 'SEEK_G1 (0)' operations.\n");

	if (gettimeofday(&starttime, (struct timezone *)0) < 0)
		comerr("Cannot get start time\n");

	for (i = 1000; --i >= 0;)
		(void)seek_g1(0L);

	prstats();
}

capacity()
{
	long	addr = 0L;
	long	maxaddr;
	long	adiff = 0L;
	long	rcnt = 10L;
	long	cnt;
	long	def;
	int	ret;
	int	i;

	getlong("retry count", &rcnt, 1L, 1000L);
	getlong("addr", &addr, 0L, 10000000L);
	read_capacity_X(addr, 1);
	silent++;
	read_capacity_X(0L, 0);
	maxaddr = cap.c_baddr;
	for (addr = 0L; addr < maxaddr;) {
		for(i=0; i < rcnt && (ret=read_capacity_X(addr, 1)) < 0; i++);
/*printf("a: %d ret: %d\n", cap.c_baddr, ret);*/
		if (ret < 0) {
			addr++;
			continue;
		}
		if ((cap.c_baddr + 1 - addr) != adiff) {
			adiff = (cap.c_baddr + 1 - addr);
			printf("addr: %d adiff: %d\n", addr, adiff);
		}
		addr = cap.c_baddr+1;
		if (adiff == 0)
			addr++;
	}
	silent--;
	for (;;) {
		getlong("addr", &addr, 0L, 10000000L);
		read_capacity_X(addr, 1);
	}
}

read_capacity_X(addr, pm)
	long	addr;
	int	pm;
{
	fillbytes((caddr_t)&scmd, sizeof(scmd), '\0');
	scmd.addr = (caddr_t)&cap;
	scmd.size = sizeof(cap);
	scmd.flags = SCG_RECV_DATA|SCG_DISRE_ENA;
	scmd.cdb_len = SC_G1_CDBLEN;
	scmd.sense_len = CCS_SENSE_LEN;
	scmd.target = target;
	scmd.cdb.g1_cdb.cmd = 0x25;	/* Read Capacity */
	scmd.cdb.g1_cdb.lun = lun;
	g1_cdbaddr(&scmd.cdb.g1_cdb, addr);
	g1_cdblen(&scmd.cdb.g1_cdb, pm); /* Partial Media */
	
	if (scsicmd("read capacity") < 0) {
		return (-1);
	} else {
		long	kb;
		long	mb;
		double	dkb;

		if (silent)
			return (0);

		dkb =  (cap.c_baddr+1.0) * (cap.c_bsize/1024.0);
		kb = dkb;
		mb = dkb / 1024.0;
		printf("Capacity: %ld Blocks = %ld kBytes = %ld MBytes\n",
			cap.c_baddr+1, kb, mb);
		printf("Sectorsize: %d Bytes\n", cap.c_bsize);
	}
	return (0);
}

wne()
{
	int	i;

	strcpy(buf, "test");
	read_capacity();

	if (gettimeofday(&starttime, (struct timezone *)0) < 0)
		comerr("Cannot get start time\n");

	for (i=0; i < 100;i++) {
		write_scsi_ne(buf, 1+i*63, 63);
	}

	prstats();
}

write_scsi_ne(bp, addr, cnt)
	caddr_t	bp;
	long	addr;
	int	cnt;
{
	fillbytes((caddr_t)&scmd, sizeof(scmd), '\0');
	scmd.addr = bp;
/*	scmd.size = cnt*512;*/
	scmd.size = cnt*cap.c_bsize;
	scmd.flags = SCG_DISRE_ENA;
	scmd.cdb_len = SC_G0_CDBLEN;
	scmd.sense_len = CCS_SENSE_LEN;
	scmd.target = target;
	scmd.cdb.g0_cdb.cmd = SC_WRITE;
	scmd.cdb.g0_cdb.lun = lun;
	g0_cdbaddr(&scmd.cdb.g0_cdb, addr);
	scmd.cdb.g0_cdb.count = cnt;
	scmd.cdb.g0_cdb.vu_56 = 1;	/* Sony no erase */
	
	return (scsicmd("write"));
}


set_mode_Page_20()
{
	u_char	mode[0x100];

if (!yes("Set Mode Page 20 ?"))
	return;
	/* XXX Quick and dirty, musz verallgemeinert werden !!! */

	(void)test_unit_ready();

	if (mode_sense(mode, 0xFF, 0x20, 0) >= 0)/* Page 0x20 current */
		prbytes("Mode Sense Data", mode, 0xFF - scmd.resid);
fillbytes(mode, 100, '\0');
mode[4] = 0x20;
mode[5] = 0xA;
mode[6] = 0x0;
		mode_select(mode, 0xFF - scmd.resid, 0);

	if (mode_sense(mode, 0xFF, 0x20, 0) >= 0)/* Page 0x20 current */
		prbytes("Mode Sense Data", mode, 0xFF - scmd.resid);

	if (mode_sense(mode, 0xFF, 0x20, 2) >= 0) {/* Page 0x20 default */
		prbytes("Mode Sense Data", mode, 0xFF - scmd.resid);
		mode[0] = 0;
		mode[12] &= 0x7F;
		mode[15] = 16;			/* Retry count */
/*		mode_select(mode, 0xFF - scmd.resid, 1);*/
	}
return;
#ifdef	notdef
	if (mode_sense(mode, 0xFF, 2, 2) >= 0) {	/* Page 2 default */
/*		prbytes("Mode Sense Data", mode, 0xFF - scmd.resid);*/
		mode[0] = 0;
		mode[12] &= 0x7F;
		mode[17] = 40;			/* 4.0 ms Disconnect time */
		mode_select(mode, 0xFF - scmd.resid, 1);
	}
#endif
}

read_scsi_g1(bp, addr, cnt)
	caddr_t	bp;
	long	addr;
	int	cnt;
{
	fillbytes((caddr_t)&scmd, sizeof(scmd), '\0');
	scmd.addr = bp;
/*	scmd.size = cnt*512;*/
	scmd.size = cnt*cap.c_bsize;
	scmd.flags = SCG_RECV_DATA|SCG_DISRE_ENA;
	scmd.cdb_len = SC_G1_CDBLEN;
	scmd.sense_len = CCS_SENSE_LEN;
	scmd.target = target;
	scmd.cdb.g1_cdb.cmd = 0x28;
	scmd.cdb.g1_cdb.lun = lun;
	g1_cdbaddr(&scmd.cdb.g1_cdb, addr);
	g1_cdblen(&scmd.cdb.g1_cdb, cnt);
	
	return (scsicmd("read extended"));
}


read_buffer(bp, cnt)
	caddr_t	bp;
	int	cnt;
{
	fillbytes((caddr_t)&scmd, sizeof(scmd), '\0');
	scmd.addr = bp;
	scmd.size = cnt;
	scmd.dma_read = 1;
	scmd.cdb_len = SC_G1_CDBLEN;
	scmd.sense_len = CCS_SENSE_LEN;
	scmd.target = target;
	scmd.cdb.g1_cdb.cmd = 0x3C;	/* Read Buffer */
	scmd.cdb.g1_cdb.lun = lun;
	g1_cdblen(&scmd.cdb.g1_cdb, cnt);
	
	return (scsicmd("read buffer"));
}

print_defect_list(){}

scsi_erase(addr, cnt)
	long	addr;
	int	cnt;
{
	fillbytes((caddr_t)&scmd, sizeof(scmd), '\0');
	scmd.addr = (caddr_t)0;
	scmd.size = 0;
	scmd.dma_read = 0;
	scmd.cdb_len = SC_G1_CDBLEN;
	scmd.sense_len = CCS_SENSE_LEN;
	scmd.target = target;
	scmd.cdb.g1_cdb.cmd = 0x29;	/* Erase */
	scmd.cdb.g1_cdb.lun = lun;
	g1_cdbaddr(&scmd.cdb.g1_cdb, addr);
	g1_cdblen(&scmd.cdb.g1_cdb, cnt);
	
	return (scsicmd("erase"));
}

read_long(/*bp, addr, cnt*/)
/*
	caddr_t	bp;
	int	addr;
	int	cnt;
*/
{
	caddr_t	bp;
	long	baddr;
	int	cnt;

	bp = buf;
	baddr = 0L;
	baddr |= 0x80000000;	/* Physical Block address */
loop:
	cnt = 1;
	fillbytes((caddr_t)&scmd, sizeof(scmd), '\0');
	baddr &= ~((unsigned long)1 << 31);
	getlong("Block Address", &baddr, 0L, 1000000L);
	baddr |= (yes("Physical Address ? ")<<31);
	scmd.addr = bp;
	scmd.size = cnt*5126;
	scmd.size = 2048;
	fillbytes(bp, scmd.size, '\0');
	scmd.flags = SCG_RECV_DATA|SCG_DISRE_ENA;
	scmd.cdb_len = SC_G1_CDBLEN;
	scmd.sense_len = CCS_SENSE_LEN;
	scmd.target = target;
	scmd.cdb.g1_cdb.cmd = 0x3E;	/* Read long */
	scmd.cdb.g1_cdb.lun = lun;
	g1_cdbaddr(&scmd.cdb.g1_cdb, baddr);
	g1_cdblen(&scmd.cdb.g1_cdb, 1);
/*	scmd.cdb.g1_cdb.count = cnt;*/
	
	/*return*/ (void)(scsicmd("read long"));
	printf("Data: %d Bytes\n", scmd.size - scmd.resid);
	filewrite(stdout, bp, scmd.size - scmd.resid);
	printf("END\n");flush();
goto loop;
/*	exit(0);*/
}

checkcmds()
{
	fillbytes((caddr_t)&scmd, sizeof(scmd), '\0');
	scmd.addr = (caddr_t)0;
	scmd.size = 0;
	scmd.flags = 0;
	scmd.cdb_len = SC_G0_CDBLEN;
	scmd.sense_len = CCS_SENSE_LEN;
	scmd.target = target;
	scmd.cdb.g1_cdb.cmd = 0x2;
	scmd.cdb.g1_cdb.lun = 7;
	
	scsicmd("cmd 2");
}

read_disk()
{
	char	filename[512];
	FILE	*f;
	long	addr = 0L;
	long	cnt;
	long	end;
	int	nsec;
	int	start;

	read_capacity();
	end = cap.c_baddr + 1;

	printf("Copy from SCSI (%d,%d,%d) disk to file\n",
					scsibus, target, lun);
	printf("Enter filename [disk.out]: ");flush();
	(void)getline(filename, sizeof(filename));
	if (filename[0] == '\0')
		strcpy(filename, "disk.out");
	if (streql(filename, "-"))
		f = stdout;
	else if ((f = fileopen(filename, "wcu")) == NULL)
		comerr("Cannot open '%s'.\n", filename);

	getlong("Enter starting sector for copy:", &addr, 0L, end-1);
	start = addr;
	cnt = end - addr;
	getlong("Enter number of sectors to copy:", &cnt, 1L, cnt);
	end = addr + cnt;

	cnt = sizeof(buf) / cap.c_bsize;
	getlong("Enter number of sectors per copy:", &cnt, 1L, cnt);
	printf("end:  %8d\n", end);

	if (gettimeofday(&starttime, (struct timezone *)0) < 0)
		comerr("Cannot get start time\n");

	for(;addr < end; addr += cnt) {

		if ((addr + cnt) > end)
			cnt = end - addr;

		error("addr: %8d cnt: %d\r", addr, cnt);

		if (read_scsi(buf, addr, cnt) < 0)
			comerr("Cannor read source disk\n");
		if (filewrite(f, buf, cnt * cap.c_bsize) < 0)
			comerr("Cannot write '%s'\n", filename);
	}
	printf("\n");
	nsec = prstats();
	printf("Read %.2f kB at %.1f kB/sec.\n",
		(addr - start)/(1024.0/cap.c_bsize),
		((addr - start)/(1024.0/cap.c_bsize)) / nsec);
}

write_disk()
{
	char	filename[512];
	FILE	*f;
	long	addr = 0L;
	long	cnt;
	long	amt;
	long	end;
	int	nsec;
	int	start;

	read_capacity();
	end = cap.c_baddr + 1;

	printf("Copy from file to SCSI (%d,%d,%d) disk\n",
					scsibus, target, lun);
	printf("Enter filename [disk.out]: ");flush();
	(void)getline(filename, sizeof(filename));
	if (filename[0] == '\0')
		strcpy(filename, "disk.out");
	if (streql(filename, "-"))
		f = stdout;
	else if ((f = fileopen(filename, "rcu")) == NULL)
		comerr("Cannot open '%s'.\n", filename);

	printf("Notice: reading from file always starts at offset 0.\n");

	getlong("Enter starting sector for copy:", &addr, 0L, end-1);
	start = addr;
	cnt = end - addr;
	getlong("Enter number of sectors to copy:", &end, 1L, end);
	end = addr + cnt;

	cnt = sizeof(buf) / cap.c_bsize;
	getlong("Enter number of sectors per copy:", &cnt, 1L, cnt);
	printf("end:  %8d\n", end);

	if (gettimeofday(&starttime, (struct timezone *)0) < 0)
		comerr("Cannot get start time\n");

	for(;addr < end; addr += cnt) {

		if ((addr + cnt) > end)
			cnt = end - addr;

		error("addr: %8d cnt: %d\r", addr, cnt);

		if ((amt = fileread(f, buf, cnt * cap.c_bsize)) < 0)
			comerr("Cannot read '%s'\n", filename);
		if (amt == 0)
			break;
		if ((amt / cap.c_bsize) < cnt)
			cnt = amt / cap.c_bsize;
		if (write_scsi(buf, addr, cnt) < 0)
			comerr("Cannor write destination disk\n");
	}
	printf("\n");
	nsec = prstats();
	printf("Wrote %.2f kB at %.1f kB/sec.\n",
		(addr - start)/(1024.0/cap.c_bsize),
		((addr - start)/(1024.0/cap.c_bsize)) / nsec);
}
