/* @(#)io.c	1.14 96/11/03 Copyright 1988 J. Schilling */
#ifndef lint
static	char sccsid[] =
	"@(#)io.c	1.14 96/11/03 Copyright 1988 J. Schilling";
#endif
/*
 *	Copyright (c) 1988 J. Schilling
 */
/* This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 */

#include <stdio.h>
#include <standard.h>
#include <ctype.h>
#ifdef	__STDC__
#	include <stdarg.h>
#else
#	include <varargs.h>
#endif
#include <stdxlib.h>
#include <string.h>

#include "fmt.h"

#define	BAD	(-1)

LOCAL BOOL	cvt_blocks __PR((char *, long *, long, long, struct disk *));
LOCAL void	prt_std	   __PR((char *, long, long, long, struct disk *));
LOCAL void	prt_blocks __PR((char *, long, long, long, struct disk *));

EXPORT
char *skipwhite(s)
	register const char	*s;
{
	while (*s) {
		if (!isspace(*s))
			break;
		s++;
	}
	return ((char *)s);
}

/* ARGSUSED */
EXPORT
BOOL
cvt_std(linep, lp, mini, maxi, dp)
	char	*linep;
	long	*lp;
	long	mini;
	long	maxi;
	struct disk	*dp;
{
	long	l	= -1L;

/*	printf("cvt_std(\"%s\", %d, %d, %d);\n", linep, *lp, mini, maxi);*/

	if (linep[0] == '?') {
		printf("Enter a number in the range from %d to %d\n", mini, maxi);
		printf("The default radix is 10\n");
		printf("Precede number with '0x' for hexadecimal or with '0' for octal\n");
		printf("Shorthands are:\n");
		printf("\t'^' for minimum value (%d)\n", mini);
		printf("\t'$' for maximum value (%d)\n", maxi);
		printf("\t'+' for incrementing value to %d\n", *lp + 1);
		printf("\t'-' for decrementing value to %d\n", *lp - 1);
		return (FALSE);
	}
	if (linep[0] == '^' && *skipwhite(&linep[1]) == '\0') {
		l = mini;
	} else if (linep[0] == '$' && *skipwhite(&linep[1]) == '\0') {
		l = maxi;
	} else if (linep[0] == '+' && *skipwhite(&linep[1]) == '\0') {
		if (*lp < maxi)
			l = *lp + 1;
	} else if (linep[0] == '-' && *skipwhite(&linep[1]) == '\0') {
		if (*lp > mini)
			l = *lp - 1;
	} else if (*astol(linep, &l)) {
		printf("Not a number: '%s'.\n", linep);
		return (FALSE);
	}
	if (l < mini || l > maxi) {
		printf("'%s' is out of range.\n", linep);
		return (FALSE);
	}
	*lp = l;
	return (TRUE);
}

LOCAL BOOL
cvt_blocks(linep, lp, mini, maxi, dp)
	char	*linep;
	long	*lp;
	long	mini;
	long	maxi;
	struct disk	*dp;
{
	long	l;
	long	cyls	= 0L;
	long	heads	= 0L;
	long	secs	= 0L;
	char	*hp;
	char	*sp;

	if (linep[0] == '?') {
		printf("To enter blocks as simple block count:\n");
		(void) cvt_std(linep, lp, mini, maxi, dp);
		printf("\tNOTE: '$' will fill this partition to the end of the disk.\n");
		printf("To enter blocks as mega bytes:\n");
		printf("\tEnter size in megabytes as floating point number.\n");
		printf("\t(must be directly followed by 'm' or 'M' e.g. 12.5M)\n");
		printf("To enter blocks as cyls/tracks/sectors:\n");
		printf("\tEnter a number in the form cyls/tracks/secs or cyls/tracks or cyls/\n");
		(void) cvt_bcyls(linep, lp, mini, maxi, dp);
		return (FALSE);
	}
	/*
	 * If line contains no slash
	 * and no character which tells us to use megabytes
	 * convert as blocknumber.
	 */
	if (linep[0] != '>' &&
			!strchr(linep, '/') &&
			!strchr(linep, '.') &&
			!strchr(linep, 'm') && !strchr(linep, 'M'))
		return (cvt_std(linep, lp, mini, maxi, dp));

	sp = hp = strchr(linep, '/');
	if (hp) {
		/*
		 * It's a cyl/track/sec notation.
		 */
		*hp++ = '\0';
		if (!(sp = strchr(hp, '/'))) {
			sp = &hp[-1];		
		} else {
			*sp++ = '\0';
		}

		if (linep[0] && !cvt_std(linep, &cyls, 0L, dp->lncyl, dp))
			return (FALSE);
		if (hp[0] && !cvt_std(hp, &heads, 0L, dp->lhead-1L, dp))
			return (FALSE);
		if (sp[0] && !cvt_std(sp, &secs, 0L, dp->lspt-1L, dp))
			return (FALSE);

		l = secs + heads * dp->lspt +
			cyls * (dp->lhead * dp->lspt);

		if (l < mini || l > maxi) {
			printf("'%ld' is out of range.\n", l);
			return (FALSE);
		}
	} else if (linep[0] == '>') {
		/*
		 * It's ---> reach to the next partition's beginning.
		 */
		return (cvt_bcyls(linep, lp, mini, maxi, dp));
	} else {
		int a;
		double d;
		extern	double atof();
		/*
		 * It's megabytes
		 */
		d = atof(linep);
		d *= 2048.0;	/* Now we have 512 Byte sectors */
		l = d;

		/*
		 * Round up to next cylinder.
		 */
		a = l / (dp->lhead * dp->lspt);
		if (l % (dp->lhead * dp->lspt)) {
			l = ++a * (dp->lhead * dp->lspt);
		}
	}
	*lp = l;
	return (TRUE);
}

/* ARGSUSED */
LOCAL void
prt_std(s, l, mini, maxi, dp)
	char	*s;
	long	l;
	long	mini;
	long	maxi;
	struct disk *dp;
{
	printf("%s %ld (%ld - %ld)/<cr>:", s, l, mini, maxi);
}

LOCAL void
prt_blocks(s, l, mini, maxi, dp)
	char	*s;
	long	l;
	long	mini;
	long	maxi;
	struct disk	*dp;
{
	long	cyl;
	long	head;
	long	sec;

	cyl = l / (dp->lhead*dp->lspt);
	head = (l - (cyl * dp->lhead * dp->lspt)) / dp->lspt;
	sec = l - (cyl * dp->lhead * dp->lspt)
		- (head * dp->lspt);

	printf("%s %ld, %ld/%ld/%ld (%ld - %ld)/<cr>:", s, l, cyl, head, sec,
								mini, maxi);
}

EXPORT
BOOL getvalue(s, lp, mini, maxi, prt, cvt, dp)
	char	*s;
	long	*lp;
	long	mini;
	long	maxi;
	void	(*prt)();
	int	(*cvt)();
	struct disk	*dp;
{
	char	line[128];
	char	*linep;

	for(;;) {
		(*prt)(s, *lp, mini, maxi, dp);
		flush();
		line[0] = '\0';
		if (getline(line, 80) == EOF)
			exit(BAD);

		linep = skipwhite(line);
		/*
		 * Nicht initialisierte Variablen
		 * duerfen nicht uebernommen werden
		 */
		if (linep[0] == '\0' && *lp != -1L)
			return (FALSE);

		if (strlen(linep) == 0) {
			/* Leere Eingabe */
		} else if ((*cvt)(linep, lp, mini, maxi, dp))
			return (TRUE);
	}
	/* NOTREACHED */
}

EXPORT
BOOL getlong(s, lp, mini, maxi)
	char	*s;
	long	*lp;
	long	mini;
	long	maxi;
{
	return (getvalue(s, lp, mini, maxi, prt_std, cvt_std, (void *)0));
}

EXPORT
BOOL getint(s, ip, mini, maxi)
	char	*s;
	int	*ip;
	int	mini;
	int	maxi;
{
	long	l = *ip;
	BOOL	ret;

	ret = getlong(s, &l, (long)mini, (long)maxi);
	*ip = l;
	return (ret);
}

EXPORT
BOOL getdiskcyls(s, lp, mini, maxi)
	char	*s;
	long	*lp;
	long	mini;
	long	maxi;
{
	return (getvalue(s, lp, mini, maxi, prt_std, cvt_cyls, (void *)0));
}

EXPORT
BOOL getdiskblocks(s, lp, mini, maxi, dp)
	char	*s;
	long	*lp;
	long	mini;
	long	maxi;
	struct disk	*dp;
{
	return (getvalue(s, lp, mini, maxi, prt_blocks, cvt_blocks, dp));
}

/* VARARGS1 */
#ifdef	__STDC__
EXPORT BOOL yes(char *form, ...)
#else
EXPORT
BOOL yes(form, va_alist)
	char	*form;
	va_dcl
#endif
{
	va_list	args;
	char okbuf[10];

again:
#ifdef	__STDC__
	va_start(args, form);
#else
	va_start(args);
#endif
	printf("%r", form, args);
	va_end(args);
	flush();
	if (getline(okbuf, sizeof(okbuf)) == EOF)
		exit(BAD);
	if (okbuf[0] == '?') {
		printf("Enter 'y', 'Y', 'yes' or 'YES' if you agree with the previous asked question.\n");
		printf("All other input will be handled as if the question has beed answered with 'no'.\n");
		goto again;
	}
	if(streql(okbuf, "y") || streql(okbuf, "yes") ||
	   streql(okbuf, "Y") || streql(okbuf, "YES"))
		return(TRUE);
	else
		return(FALSE);
}

void prbytes(s, cp, n)
		char		*s;
	register unsigned char	*cp;
	register int		n;
{
	printf(s);
	while (--n >= 0)
		printf(" %02X", *cp++);
	printf("\n");
}

EXPORT
char	*permstring(s)
	const char	*s;
{
	char	*p;

	if (p = malloc(strlen(s)+1))
		strcpy(p, s);
	return (p);
}

EXPORT
struct strval *
strval(val, sp)
	int	val;
	struct strval *sp;
{
	while (sp->s_name) {
		if (val == sp->s_val)
			return sp;
		sp++;
	}
	return (struct strval *)0;
}

EXPORT
struct strval *
namestrval(name, sp)
	const char	*name;
	struct strval	*sp;
{
	while (sp->s_name) {
		if (strcmp(name, sp->s_name) == 0)
			return sp;
		sp++;
	}
	return (struct strval *)0;
}

EXPORT
BOOL getstrval(s, lp, sp, deflt)
	const char	*s;
	long		*lp;
	struct strval	*sp;
	long		deflt;
{
	struct strval *csp;
	char	line[128];
	char	*linep;

	for(;;) {
		csp = strval(*lp, sp);
		printf("%s [%s]:", s, csp->s_name);
		flush();
		line[0] = '\0';
		if (getline(line, 80) == EOF)
			exit(BAD);

		linep = skipwhite(line);
		/*
		 * Nicht initialisierte Variablen
		 * duerfen nicht uebernommen werden
		 */
		if (linep[0] == '\0' && *lp != -1L)
			return (FALSE);

		if (strlen(linep) == 0) {
			/* Leere Eingabe */
		} else if (streql(linep, "?") || streql(linep, "help")) {
			printf("Possible values are:\n");
			for (csp = sp; csp->s_name; csp++) {
				printf("%s\t%s\n", csp->s_name, csp->s_text);
			}
		} else if (csp = namestrval(linep, sp)) {
			*lp = csp->s_val;
			return (TRUE);
		}
	}
	/* NOTREACHED */
}
