/***********************************************************
*  bin2c -- convert binary data to C source                *
*----------------------------------------------------------*
*  1995 Artsoft Development                               *
*        Holger Schemel                                    *
*        33659 Bielefeld-Senne                             *
*        Telefon: (0521) 493245                            *
*        eMail: aeglos@valinor.owl.de                      *
*               aeglos@uni-paderborn.de                    *
*               q99492@pbhrzx.uni-paderborn.de             *
***********************************************************/

#include <stdio.h>
#include <stdlib.h>

#include "global.h"

#define COLUMNS		8
#define LINELENGTH	80

unsigned char hexvalues[16] =
{
  '0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
  'a', 'b', 'c', 'd', 'e', 'f'
};

int main(int argc, char **argv)
{
  int i;
  unsigned char inbyte;
  unsigned char *inptr=&inbyte;
  unsigned long incnt=0;
  char progname[1024],dataname[1024];
  char outstr[LINELENGTH+(2+COLUMNS*6)];
  FILE *infile=stdin, *outfile=stdout;

  strcpy(progname,GetFilename(argv[0]));
  strcpy(dataname,"stdin");

  if (argc>3 || argc>1 && (!strcmp(argv[1],"-?") || !strcmp(argv[1],"-h")))
  {
    fprintf(stderr,"Usage: %s [input file [output file]]\n", progname);
    exit(-1);
  }

  if (argc>1)
  {
    if (!(infile=fopen(argv[1],"r")))
    {
      perror(progname);
      exit(-1);
    }
    strcpy(dataname,GetFilename(argv[1]));
  }

  if (argc>2)
  {
    if (!(outfile=fopen(argv[2],"w")))
    {
      perror(progname);
      fclose(infile);
      exit(-1);
    }
    strcpy(dataname,GetFilename(argv[2]));
  }

  fprintf(outfile,"/* This is the data of the file '%s' ",
	  argc>1 ? argv[1] : "(stdin)");
  fprintf(outfile,"written by 'bin2c' */\n\n");

  fprintf(outfile,"unsigned char %s_bytes[] =\n",dataname);
  fprintf(outfile,"{\n");

  while(fread(inptr,1,1,infile))
  {
    inbyte = *inptr;

    if (!(incnt % COLUMNS))
      fprintf(outfile,"\n  ");

    fprintf(outfile,"0x%c%c, ",hexvalues[inbyte>>4],hexvalues[inbyte&15]);
    incnt++;
  }

  fprintf(outfile,"\n};\n");

  if (!feof(infile))
  {
    fprintf(stderr,"%s: cannot read input file\n", argv[0]);
    fclose(infile);
    fclose(outfile);
    exit(-1);
  }

  if (ferror(outfile))
  {
    fprintf(stderr,"%s: cannot write output file\n", argv[0]);
    fclose(infile);
    fclose(outfile);
    exit(-1);
  }

  fclose(infile);
  fclose(outfile);
  return(0);
}
