/*
  kwikdisk.cpp - KDiskFree

  written 1999 by Michael Kropfberger <michael.kropfberger@gmx.net>
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   
  */


#include <qlabel.h>

#include <kapp.h>
#include <kwm.h>
#include <kiconloader.h>
#include <kmsgbox.h>

#include "kwikdisk.h"
#include "kwikdisk.moc"


/***************************************************************/
MyToolTip::MyToolTip(QWidget *parent, QToolTipGroup * group= 0 ) 
      : QToolTip(parent,group)
{
  tipping=FALSE;
};

void MyToolTip::setPossibleTip(const QRect &the_rect,const char *the_text)
{
  //debug("setPossibleTip");
  rect=the_rect;
  text=the_text;
  setTipping(TRUE);
};

void MyToolTip::maybeTip(const QPoint &p)
{
  if ((!tipping) || (text==0) )return;
  //   debug("maybeTip in %i:%i [%s]  for: %ix%i+%i+%i",p.x(),p.y()
  //              ,text,rect.x(),rect.y(),rect.width(),rect.height());
  tip(rect,text);
}; 


/***************************************************************/
MyPopupMenu::MyPopupMenu(QWidget *parent=0, const char *name=0)
  : QPopupMenu(parent,name)
{
  toolTip=new MyToolTip(this);
  toolTipRow=-1;
};

void MyPopupMenu::mouseMoveEvent(QMouseEvent *e)
{
  //debug("mouse moved...");

  int row = findRow( e->pos().y() );		// ask table for row
  int col = findCol( e->pos().x() );		// ask table for column
  if ((row != -1) && (col != -1) && (row!=toolTipRow)) {
    //debug("mouse moved... we are now in row %i  col %i",row,col);
      toolTipRow=row;
      int cellPos=0;
      for (int j=0;j<row;j++) cellPos += cellHeight(j);
      toolTip->setPossibleTip(QRect(0,cellPos
                             ,totalWidth(),cellHeight(row)+2)
                             ,toolTips[idAt(row)]);
    };

  QPopupMenu::mouseMoveEvent(e);  //SuperCall
}

void MyPopupMenu::setToolTip(int id, const char *text)
{
  const char *tmp;
  tmp=toolTips.find(id);
  if (tmp!=0) {
    toolTips.remove(id);
    delete tmp;
  }
  toolTips.insert(id,text);
};



/***************************************************************/
DockWidget::DockWidget(QWidget *parent, const char *name=0)
  : QLabel(parent,name)
{
  connect(&diskList,SIGNAL(readDFDone()),this,SLOT(updateDFDone()) );
  clickMenu=0;
};


void DockWidget::startKDF() 
{
  system("kdf &");
};

void DockWidget::mousePressEvent(QMouseEvent *e)
{ 
  diskList.readFSTAB();
  diskList.readDF();
  setCursor(WaitCursor);
};

void DockWidget::sysCallError(DiskEntry *disk, int errno)
{ 
  if (errno!=0)
     KMsgBox::message(this,klocale->translate("KwikDisk"),
              disk->lastSysError(),KMsgBox::STOP);
};

void DockWidget::updateDFDone()
{ 
  //  debug("DockWidget::updateDFDone() %p",clickMenu);
  // QPopupMenu
  
  if (clickMenu!=0) delete clickMenu;
  clickMenu = new MyPopupMenu; CHECK_PTR(clickMenu);

  DiskEntry* disk;
  QString *toolTipText;
  QString entryName;
  KIconLoader *loader = kapp->getIconLoader();
  int id;
  for (disk=diskList.first();disk!=0;disk=diskList.next()) {
    toolTipText = new QString;
    toolTipText->sprintf("(%s) %s on %s",disk->fsType().data()
                                        ,disk->deviceName().data()
                                        ,disk->mountPoint().data());
    if (disk->mounted())  toolTipText->prepend("UNMOUNT");
    else toolTipText->prepend("MOUNT");
    entryName=disk->mountPoint().data();
    if (disk->mounted()) entryName+=QString("   [")
                                  +disk->prettyKBAvail().data()
                                  +QString("]");
    id=clickMenu->insertItem("",disk, SLOT(toggleMount()));
    clickMenu->changeItem(loader->loadMiniIcon(disk->iconName().data())
                           ,entryName,id);
   
    if ((getuid()!=0) && ( -1==disk->mountOptions().find("user",0,FALSE) )) {
      //clickMenu->setItemEnabled(id,FALSE);
       clickMenu->disconnectItem(id,disk,SLOT(toggleMount()));
       *toolTipText=klocale->translate("sorry, not root...");
    };
    
    connect(disk, SIGNAL(sysCallError(DiskEntry *, int) ),
            this, SLOT(sysCallError(DiskEntry *, int)) );

    clickMenu->setToolTip(id,toolTipText->data());
  } // every device found

  clickMenu->insertSeparator();
  id=clickMenu->insertItem(loader->loadMiniIcon("kdf.xpm")
                         ,klocale->translate("&Start KDiskFree")
                         ,this, SLOT(startKDF()),0);
  clickMenu->insertSeparator();
  id=clickMenu->insertItem(loader->loadMiniIcon("delete.xpm")
                         ,klocale->translate("&Quit KwikDisk")
                         ,this, SLOT(quit()),0);

   QRect r=KWM::getWindowRegion(KWM::desktop(this->winId()));
   QPoint p=QCursor::pos();
   if (r.y()>0) {  // panel on top
     p.setY(r.y());
     clickMenu->popup(p,0);
   } else {  // panel at bottom
     p.setY(r.height()-1- clickMenu->cellHeight(clickMenu->indexOf(id)) );
     clickMenu->popup(p,clickMenu->indexOf(id));
   }
   setCursor(ArrowCursor);
};


/***************************************************************/
KwikDiskTopLevel::KwikDiskTopLevel(QWidget *, const char *name=0)
      : KTopLevelWidget(name) 
{
    dockIcon=new DockWidget (this,"docked_icon");
    KIconLoader *loader = kapp->getIconLoader();
    dockIcon->setPixmap(QPixmap(loader->loadMiniIcon("kdf.xpm")));
    setView(dockIcon);
    this->resize(24,24);
};


/***************************************************************/
int main(int argc, char **argv)
{
  KApplication app(argc, argv,"kdf");
  
     KwikDiskTopLevel *ktl = new KwikDiskTopLevel();
     CHECK_PTR(ktl);
     ktl->setCaption("KwikDisk");
     app.setMainWidget(ktl);
     KWM::setDockWindow(ktl->winId());
     ktl->show();

  return app.exec();
};
