/*
  kdf.cpp - KDiskFree

  written 1998-1999 by Michael Kropfberger <michael.kropfberger@gmx.net>
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   
  */


#include <kapp.h>
#include <kwm.h>
#include <kiconloader.h>
#include <qlabel.h>
#include "kdf.h"
#include "kdf.moc"


/***************************************************************/
KDFTopLevel::KDFTopLevel(QWidget *, const char *name=0)
      : KTopLevelWidget(name) 
{
    kdf = new KDFWidget(this,"kdf_undocked",FALSE);  
    CHECK_PTR(kdf);
    kdf->loadSettings();
    resize(kdf->width(),kdf->height());
    setView(kdf);
};


/***************************************************************/
int main(int argc, char **argv)
{
  KApplication app(argc, argv,"kdf");
  //SessionManagement
    if (app.isRestored()) {
      int n = 1;
      while (KTopLevelWidget::canBeRestored(n)) {
        KDFTopLevel *ktl = new KDFTopLevel();
        CHECK_PTR(ktl);
        ktl->setCaption("KDiskFree");
        app.setMainWidget(ktl);
        ktl->setMinimumSize(335,200);
        ktl->restore(n);
        n++;
      } 
     } else {
        KDFTopLevel *ktl = new KDFTopLevel();
        CHECK_PTR(ktl);
        ktl->setCaption("KDiskFree");
        app.setMainWidget(ktl);
	ktl->setMinimumSize(335,200);
        ktl->show();
    }

  return app.exec();
};
