/*
  kcmdf.cpp - KDiskFree

  written 1998 by Michael Kropfberger <mkropfbe@edu.uni-klu.ac.at>
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   
  */


#include "kcontrol.h"
#include "kdfwidget.h"


class KDiskFree : public KControlApplication
{ 
public:

  KDiskFree(int &argc, char **arg, const char *name);

  virtual void init();
  virtual void apply();
   
private:

  KDFWidget *kdf;
};


KDiskFree::KDiskFree(int &argc, char **argv, const char *name)
  : KControlApplication(argc, argv, name)
{
  kdf = 0;

  if (runGUI())
    {
      if (!pages || pages->contains("kdf"))
	addPage(kdf = new KDFWidget(dialog, "kdf", FALSE), 
	     "&KDiskFree", "index.html");


      //dialog->setApplyButton(0);
      dialog->setCancelButton(0);
      if (kdf) {
        dialog->show();
      } else {
          fprintf(stderr, klocale->translate("usage: kdf [-init | kdf]\n"));
	  justInit = TRUE;
        }
    }
}

void KDiskFree::init()
{
  KDFWidget *kdfconfig = new KDFWidget(0, 0, TRUE);
  delete kdfconfig;
}

void KDiskFree::apply()
{  
  //debug("KDiskFree::apply");
  if (kdf)
      kdf->applySettings();      
}

int main(int argc, char **argv)
{
  KDiskFree app(argc, argv,"kdf");
  app.setTitle(klocale->translate("KDiskFree"));
  
  if (app.runGUI())
     return app.exec();
  else
    {
      app.init();
      return 0;
    }
}
