/*
 * disks.h
 *
 * Copyright (c) 1998 Michael Kropfberger <mkropfbe@edu.uni-klu.ac.at>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifndef __DISKS_H__
#define __DISKS_H__

#include <qobject.h>
#include <qstring.h>
#include <qlabel.h>
#include <qpushbt.h>
#include <qprogbar.h>

#include <kprogress.h>
#include <kprocess.h>

#define MOUNT_COMMAND "mount"
#define UMOUNT_COMMAND "umount"

class DiskEntry : public QObject
{
  Q_OBJECT
public:
  DiskEntry(QObject *parent=0, const char *name=0);
  DiskEntry(QString deviceName, QObject *parent=0, const char *name=0);
  ~DiskEntry();
  const char * lastSysError() {return sysStringErrOut; };
  QString deviceName() const { return device; };
  QString mountPoint() const { return mountedOn; };
  QString mountOptions() const { return options; };
  QString fsType() const { return type; };
  bool mounted() const { return isMounted; };
  int kBSize() const { return size; };
  QString iconName() { guessDiskIcon(); return icoName; };
  QString prettyKBSize() const { return prettyPrint(size); };
  int kBUsed() const { return used; };
  QString prettyKBUsed() const { return prettyPrint(used); };
  int kBAvail() const  { return avail; };
  QString prettyKBAvail() const { return prettyPrint(avail); };
  float percentFull() const;

signals:
  void sysCallError(DiskEntry *disk, int errno);
  void deviceNameChanged();
  void mountPointChanged();
  void mountOptionsChanged();
  void fsTypeChanged();
  void mountedChanged();
  void kBSizeChanged();
  void kBUsedChanged();
  void kBAvailChanged();
  void iconNameChanged();

public slots:

  int toggleMount();
  int mount();
  int umount();
  void setDeviceName(QString deviceName);
  void setMountPoint(QString mountPoint);
  void setMountOptions(QString mountOptions);
  void setFsType(QString fsType);
  void setMounted(bool nowMounted);
  void setKBSize(int kb_size);
  void setKBUsed(int kb_used);
  void setKBAvail(int kb_avail);

private slots:
   void receivedSysStdErrOut(KProcess *, char *data, int len);
   void guessDiskIcon();

private:
  void init();
  int sysCall(QString command);
  QString prettyPrint(int kBValue) const;

  KShellProcess     *sysProc;
  QString           sysStringErrOut;
  bool              readingSysStdErrOut;

  QString     device,
              type,
              mountedOn,
              options,
              icoName;

  int         size,
              used,
              avail;       // ATTENTION: used+avail != size (clustersize!)
  
  bool        isMounted;
};




#endif
