/*
 * disklist.cpp
 *
 * Copyright (c) 1999 Michael Kropfberger mkropfbe@edu.uni-klu.ac.at
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
 
#include <math.h>

#include <qstring.h>
#include <qmsgbox.h> 
#include <qfile.h>
#include <qtstream.h>
#include <qstring.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qpixmap.h>
#include <qpaintd.h>

#include <kapp.h> 
#include <kmsgbox.h> 
#include <kiconloader.h>

#include "disklist.h"
#include "disklist.moc"


#define BLANK ' '
#define DELIMITER '#'

/***************************************************************************
  * constructor
**/
DiskList::DiskList(QObject *parent, const char *name) 
    : QObject(parent,name)
{ 
#ifdef _OS_LINUX_
  debug("_OS_LINUX_");
#endif
#ifdef _OS_FREEBSD_
  debug("_OS_FREEBSD_");
#endif
#ifdef _OS_SUN_
  debug("_OS_SUN_");
#endif
#ifdef _OS_SOLARIS_
  debug("_OS_SOLARIS_");
#endif
#ifdef _OS_HPUX_
  debug("_OS_HPUX_");
#endif
#ifdef _OS_UNIX_
  debug("_OS_UNIX_");
#endif

if (NO_FS_TYPE)
  debug("df gives no FS_TYPE");
   
   disks = new Disks;
   disks->setAutoDelete(TRUE);

   // BackgroundProcesses ****************************************
      dfProc = new KProcess(); CHECK_PTR(dfProc);
       connect( dfProc, SIGNAL(receivedStdout(KProcess *, char *, int) ),
           this, SLOT (receivedDFStdErrOut(KProcess *, char *, int)) );
       connect( dfProc, SIGNAL(receivedStderr(KProcess *, char *, int) ),
           this, SLOT (receivedDFStdErrOut(KProcess *, char *, int)) );
       connect(dfProc,SIGNAL(processExited(KProcess *) ),
              this, SLOT(dfDone() ) );

       readingDFStdErrOut=FALSE;
       //readFSTAB();
       //readDF();
};


/***************************************************************************
  * tries to figure out the possibly mounted fs
**/
int DiskList::readFSTAB()
{
  if (readingDFStdErrOut || dfProc->isRunning()) return -1;
  //debug("DiskList::readFSTAB");
  QFile f(FSTAB);
  if ( f.open(IO_ReadOnly) ) {
    QTextStream t (&f);
    QString s;
    DiskEntry *disk;
    disks->clear();
    while (! t.eof()) {
      s=t.readLine();
      s=s.simplifyWhiteSpace();
      if ( (!s.isEmpty() ) && (s.find(DELIMITER)!=0) ) {
               // not empty or commented out by '#'
	//debug("GOT: [%s]",s.data() );
	disk = new DiskEntry();// CHECK_PTR(disk);	
        disk->setMounted(FALSE);
        disk->setDeviceName(s.left(s.find(BLANK)) );
            s=s.remove(0,s.find(BLANK)+1 );
	    //debug("    deviceName:    [%s]",(const char*)disk->deviceName() );
#ifdef _OS_SOLARIS_
            //device to fsck
            s=s.remove(0,s.find(BLANK)+1 );
#endif        
         disk->setMountPoint(s.left(s.find(BLANK)) );
            s=s.remove(0,s.find(BLANK)+1 );
	    //debug("    MountPoint:    [%s]",(const char*)disk->mountPoint() );
         disk->setFsType(s.left(s.find(BLANK)) );
            s=s.remove(0,s.find(BLANK)+1 );
	    //debug("    FS-Type:       [%s]",(const char*)disk->fsType() );
         disk->setMountOptions(s.left(s.find(BLANK)) );
            s=s.remove(0,s.find(BLANK)+1 );
	    //debug("    Mount-Options: [%s]",(const char*)disk->mountOptions() );
         if ( (disk->deviceName() != "none") && (disk->fsType() != "swap") 
                             && (disk->mountPoint() != "/dev/swap")
                             && (disk->deviceName() != "/proc") )
	   replaceDeviceEntry(disk); 
         else
           delete disk;

      } //if not empty
    } //while
    f.close();
  } //if f.open
  return 1;
}


/***************************************************************************
  * is called, when the df-command writes on StdOut or StdErr
**/
void DiskList::receivedDFStdErrOut(KProcess *, char *data, int len)
{
  //debug("DiskList::receivedDFStdErrOut");
  QString tmp = QString(data,len+1);  // adds a zero-byte 
  dfStringErrOut.append(tmp);
}

/***************************************************************************
  * reads the df-commands results
**/
int DiskList::readDF()
{ 
  //debug("DiskList::readDF");
  if (readingDFStdErrOut || dfProc->isRunning()) return -1; 
  dfStringErrOut=""; // yet no data received
  dfProc->clearArguments();
  (*dfProc) << DF_COMMAND << DF_ARGS;
  if (!dfProc->start( KProcess::NotifyOnExit, KProcess::AllOutput ))
     fatal(klocale->translate("could not execute [%s]"),DF_COMMAND);
  return 1;
}


/***************************************************************************
  * is called, when the df-command has finished
**/
void DiskList::dfDone()
{
  //debug("DiskList::dfDone");
  readingDFStdErrOut=TRUE;
  for ( DiskEntry *disk=disks->first(); disk != 0; disk=disks->next() )
    disk->setMounted(FALSE);  // set all devs unmounted

  QTextStream t (dfStringErrOut, IO_ReadOnly);
  QString s=t.readLine();
  if ( (s.isEmpty()) || ( s.left(10) != "Filesystem" ) ) 
    fatal("Error running df command... got [%s]",(const char *)s);
  while ( !t.eof() ) {
    QString u,v;
    DiskEntry *disk;
    s=t.readLine();
    s=s.simplifyWhiteSpace();
    if ( !s.isEmpty() ) {
      //debug("GOT: [%s]",s.data() );
      disk = new DiskEntry(); CHECK_PTR(disk);
      
      if (s.find(BLANK)<0)      // devicename was too long, rest in next line
	if ( !t.eof() ) {       // just appends the next line
            v=t.readLine();
            s=s.append(v.data() );
            s=s.simplifyWhiteSpace();
            //debug("SPECIAL GOT: [%s]",s.data() );
	 }//if silly linefeed

      //debug("EFFECTIVELY GOT %i chars: [%s]",s.length(),s.data() );
	 
      disk->setDeviceName(s.left(s.find(BLANK)) );
      s=s.remove(0,s.find(BLANK)+1 );
      //debug("    DeviceName:    [%s]",(const char*)disk->deviceName() );

      if (NO_FS_TYPE) {
	//debug("THERE IS NO FS_TYPE_FIELD!");
         disk->setFsType("?");
      } else {
         disk->setFsType(s.left(s.find(BLANK)) );
         s=s.remove(0,s.find(BLANK)+1 );
      };
      //debug("    FS-Type:       [%s]",(const char*)disk->fsType() );

      u=s.left(s.find(BLANK));
      disk->setKBSize(u.toInt() );
      s=s.remove(0,s.find(BLANK)+1 );
      //debug("    Size:       [%d]",disk->kBSize() );

      u=s.left(s.find(BLANK));
      disk->setKBUsed(u.toInt() );
      s=s.remove(0,s.find(BLANK)+1 );
      //debug("    Used:       [%d]",disk->kBUsed() );
    
      u=s.left(s.find(BLANK));
      disk->setKBAvail(u.toInt() );
      s=s.remove(0,s.find(BLANK)+1 );
      //debug("    Avail:       [%d]",disk->kBAvail() );
    

      s=s.remove(0,s.find(BLANK)+1 );  // delete the capacity 94%
      disk->setMountPoint(s.left(s.find(BLANK)) );
      s=s.remove(0,s.find(BLANK)+1 );
      //debug("    MountPoint:       [%s]",(const char*)disk->mountPoint() );
  
      if (disk->kBSize() > 0) {
        disk->setMounted(TRUE);    // its now mounted (df lists only mounted)
        replaceDeviceEntry(disk);
      }
    }//if not header
  }//while further lines available

  readingDFStdErrOut=FALSE;
  emit readDFDone();
}


/***************************************************************************
  * updates or creates a new DiskEntry in the KDFList and TabListBox
**/
void DiskList::replaceDeviceEntry(DiskEntry *disk)
{ 
  //debug("DiskList::replaceDeviceEntry [%s]",disk->deviceName().data());

  int pos=disks->find(disk);

  if ((pos == -1) && (disk->mounted()) )
    // no matching entry found for mounted disk
    if ((disk->fsType() == "?") || (disk->fsType() == "cachefs")) {
      //search for fitting cachefs-entry in static /etc/vfstab-data
      //debug("search for [%s]",(const char *)disk->deviceName());
      DiskEntry* olddisk = disks->first();
      QString odiskName;
      while (olddisk != 0) {
        int p;
        // cachefs deviceNames have no / behind the host-column
	// eg. /cache/cache/.cfs_mnt_points/srv:_home_jesus
	//                                      ^    ^
        odiskName = olddisk->deviceName().copy();
        int ci=odiskName.find(':'); // goto host-column
        while ((ci =odiskName.find('/',ci)) > 0) {
           odiskName.replace(ci,1,"_");
        }//while
        //debug("     check against [%s]",(const char *)olddisk->deviceName());
        // check if there is something that is exactly the tail
	// eg. [srv:/tmp3] is exact tail of [/cache/.cfs_mnt_points/srv:_tmp3]
        if ( ( (p=disk->deviceName().findRev(odiskName
	            ,disk->deviceName().length()) )
                != -1) 
	      && (p + odiskName.length()
	          == disk->deviceName().length()) ) 
        {
             pos = disks->at(); //store the actual position
	     //debug("   FOUND [%s] at pos %i at ListPos %i"
	     //  ,(const char *)olddisk->deviceName(),p,pos);
             disk->setDeviceName(olddisk->deviceName());
             olddisk=0;
	} else 
          olddisk=disks->next();       
      }// while
    }// if fsType == "?" or "cachefs"
  

#ifdef NO_FS_TYPE
  if (pos != -1) {
     DiskEntry * olddisk = disks->at(pos);
     if (olddisk)
        disk->setFsType(olddisk->fsType());     
  }
#endif  

  if (pos != -1) {  // replace
    //debug("dev %s is replaced",disk->deviceName().data());
      DiskEntry * olddisk = disks->at(pos);
      if ( (-1!=olddisk->mountOptions().find("user")) &&
           (-1==disk->mountOptions().find("user")) ) {
          // add "user" option to new diskEntry
          QString s=disk->mountOptions();
          if (s.length()>0) s.append(",");
          s.append("user");
          disk->setMountOptions(s);
       }
      disks->remove(pos); // delete old one
      disks->insert(pos,disk);
  } else {
    disks->append(disk);
  }//if 



/*
  QString s;
  s.sprintf("%s %s %s %s %s %s %s"
                          ,(const char *)disk->deviceName()
                          ,(const char *)disk->fsType()
                          ,(const char *)sizeS
                          ,(const char *)disk->mountPoint()
                          ,(const char *)disk->prettyKBAvail()
                          ,(const char *)percS
                          ,(const char *)disk->deviceName() );
  //debug("store [%s]", (const char *)s);
  if (pos != -1) {  // replace
    unsigned int ipos=0;

    QString e1, e2;
    while(ipos < tabList->count()) {  //replace data of old entry
       e1=tabList->text(ipos,0);
       e2=tabList->text(ipos,3);

       if (e1==(const char *)disk->deviceName()
	  && (e2==(const char *)disk->mountPoint())) {
             //entry found
          DiskEntry * olddisk = disks->at(pos);
          //debug("GOT %f vs. %f",olddisk->percentFull(),disk->percentFull());
          if ((popupIfFull) &&
               (olddisk->percentFull()<FULL_PERCENT) && 
	        (disk->percentFull()>FULL_PERCENT)) {
            QString st;
            st.sprintf("Device %s is getting critically full!"
                        ,(const char *)disk->deviceName());
            QMessageBox::warning(0,klocale->translate("WARNING")
                 ,(const char*)st);
	  }
          disks->remove(pos); // delete old one
          disks->insert(pos,disk);
          tabList->changeItem(s,ipos);
          ipos=tabList->count(); // exit forced
       }//if
       ipos++;
    }//while     
  } else {
    disks->append(disk);
    tabList->appendItem((const char *)s);
  }//if 

*/
}

