.TH [%s PRG_NAME] [%d MANUAL_NUMBER] [%s DATE_OF_LAST_MOD] "Version [%s VERSION_NUMBER]" "[%s MANUAL_SECTION_STR]"

.SH NAME
[%s prg_name] \- list information about an iso9660 image
.SH SYNOPSIS
.B [%s prg_name]
.RB [ -AbBhimMpPsSvV ]
.RB [ -I\ id-type ]
.RI [ file ]
.SH DESCRIPTION
.I [%s Prg_name]
lists information on an iso9660 image (volume space size,
identifiers and time stamps). If no
.I file
is specified,
.I [%s DEFAULT_INPUT_FILE]
is assumed.

If no options are given, (nearly) all available
information is listed and the output is in 
.I .mkisofsrc
format.
.SH OPTIONS
.TP
.B -A
list application identifier
.TP
.B -b
list image size in bytes
.TP
.B -B
list image size in blocks (of 2048 bytes)
.TP
.B -h
display some (more or less) helpful information and exit successfully
.TP
.B -i
print extended info
.TP
.BI "\-I " id
list identifier given by
.IR id ,
which must be one of the following strings:
.IR SYSI
(system), 
.IR VOLI
(volume, same as -V), 
.IR VOLS
(volume set),
.IR PUBL
(publisher, same as -P),
.IR PREP
(preparer, same as -p),
.IR APPI
(application, same as -A),
.IR COPY
(copyright file), 
.IR ABST
(abstract file) and
.IR BIBL
(bibliographic file)
.TP
.B -m
list image size in msf
.TP
.B -M
list image size in Mbytes
.TP
.B -p
list preparer identifier
.TP
.B -P
list publisher identifier
.TP
.B -s
list image size in bytes (same as -b)
.TP
.B -S
list image size in Mbytes (same as -M)
.TP
.B -v
be more talkative
.TP
.B -V
list volume identifier (diplayed in win95)

.SH RETURN VALUE
On  success,  0  is  returned.  On  error,  a  value >0 is returned.

.SH ERRORS
.TP
.B [%d RETVAL_BUG]
a program bug has seen the light. Please email me your command line
and the output produced by
.I [%s prg_name]
.TP
.B [%d RETVAL_ERROR]
the error is different from those explained above

.SH AUTHOR
[%s MY_EMAIL_ADDRESS]

.SH SEE ALSO
.BR mkisofs (8),
.BR isodump (1)
