/*
 *	$Id: isoinfo.h,v 1.11 2007-11-30 23:17:52 solyga Exp $
 */

#undef	DEBUG

#define	_LARGEFILE64_SOURCE
#define	_FILE_OFFSET_BITS	64

#include <stdio.h>		/* printf() */
#include <stdlib.h>		/* exit() */
#include <getopt.h>		/* getopt() */
#include <errno.h>		/* error numbers */
#include <unistd.h>		/* read(), write(), close(), STDIN_FILENO */
#include <sys/types.h>		/* open() */
#include <sys/stat.h>		/* open() */
#include <fcntl.h>		/* open(), O_RDONLY */
#include <ctype.h>		/* tolower() */
#include <string.h>		/* strrchr(), strerror() */
#include "iso9660.h"		/* iso9660 structures & definitions (mkisofs)*/

#define	STD_CHANNEL	stdout
#define	HELP_CHANNEL	stdout
#define	ERROR_CHANNEL	stderr
#define	VERSION_CHANNEL	stdout
#define	DEBUG_CHANNEL	stderr

#define	DEFAULT_INPUT_FILE	"/dev/cdrom"

#define	ISO_BLOCK_SIZE	2048
#define	ISO_PD_BLOCK	0x10	/* PD = primary descriptor */
#define	BOOT_VD_BLOCK	0x11	/* VD = volume descriptor */
#define	INFO_BLOCK	0x13	/* ext. info (mkisofs cmd-line) */

#ifndef	CD_SECS
#define	CD_SECS		60
#endif
#ifndef	CD_FRAMES
#define	CD_FRAMES	75
#endif

#define	ISO_STR( A )	iso_str( (A), sizeof(A) )

#define	RETVAL_OK	0
#define	RETVAL_BUG	1
#define	RETVAL_ERROR	2

#define	VERSION_NUMBER		"0.03.03"
#define	DATE_OF_LAST_MOD	"2007-12-01"
#define	MY_EMAIL_ADDRESS	"Steffen Solyga <solyga@absinth.net>"
#define	BUG_MSG			"Please send an email with your command line and the program output to"
