#include <sys/ioctl.h>
#include <sys/types.h>
#include <linux/cdrom.h>
#include <fcntl.h>
#include <getopt.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include <errno.h>

static char *id __attribute__ ((unused))
            = "@(#) $Id: cdselect.c,v 1.6 1999/10/15 09:12:25 heyder Exp $";

void usage(char *name)
{
  fprintf(stderr, " Usage: %s [ -d device ] -c|-n|slot\n", name);
  fprintf(stderr, "      -d use device instead of %s\n", CHANGER);
}

void parse_options(int argc, char *argv[], char **device, int *slot)
{
  int index  = 0;
  char c;
  int needslot = 1;
  static struct option long_options[] =
  {
    {"device",  1, 0, 'd' },
    {"none",    0, 0, 'n' },
    {"current", 0, 0, 'c' },
    {"help",    0, 0, 'h' },
    {0, 0, 0, 0}
  };

  *device = CHANGER;

  while (EOF != (c=getopt_long(argc, argv, "d:nch", long_options, &index))) {
    switch(c) {
    case 0:
      break;
    case 'd':
      *device=optarg;
      break;
    case 'c':
      *slot=CDSL_CURRENT;
      needslot=0;
      break;
    case 'n':
      *slot=CDSL_NONE;
      needslot=0;
      break;
    case 'h':
      usage(argv[0]);
      exit(0);
      break;
    default:
      ;
    }
  }
  if (needslot==1) {
    if (optind+1 == argc) {
      *slot = atoi(argv[optind]);
    } else {
      fprintf(stderr, "%s: Wrong parameter count\n", argv[0]);
      usage(argv[0]);
      exit(1);
    }
  } else {
    if (optind != argc) {
      fprintf(stderr, "%s: Wrong parameter count\n", argv[0]);
      usage(argv[0]);
      exit(1);
    }
  }
}


int main(int argc, char *argv[])
{
  char *device;
  int nrslots;
  int slot;
  int fd;
  int ret;
  struct cdrom_tochdr toc;

  parse_options(argc, argv, &device, &slot);

  fd = open(device, O_RDONLY|O_NONBLOCK);

  if (fd < 0) {
    fprintf(stderr, "%s: Can't open device %s\n", argv[0], device);
    exit (2);
  }

  nrslots = ioctl(fd, CDROM_CHANGER_NSLOTS, NULL);

  if (slot<0 || slot >= nrslots) {
    if (slot!=CDSL_CURRENT && slot!=CDSL_NONE)
      {
        fprintf(stderr, "%s: Slot-number out of range\n", argv[0]);
        exit (3);
      }
  }
  
  ioctl(fd, CDROMCLOSETRAY, NULL);
  ret = ioctl(fd, CDROM_SELECT_DISC, slot);

  if (ret < 0) {
    close(fd);
    fprintf(stderr, "%s: Slot empty\n", argv[0]);
    exit (4);
  }

  ret = ioctl(fd, CDROMREADTOCHDR, &toc);
  if (ret < 0) {
    close(fd);
    fprintf(stderr, "%s: Slot empty\n", argv[0]);
    exit (4);
  }
  close(fd);
  exit(0);
}
