#include "Nicknames.H"
#include "Types.H"
#include "Values.H"

#include <iostream.h>
#include <fstream.h>

#include <stdio.h>

static char *id __attribute__ ((unused))
            = "@(#) $Id: Nicknames.cc,v 1.5 1999/10/15 09:12:25 heyder Exp $";

int read_nicktable(nick_table &table, char *filename, char *override_default)
{
  device_set dset, oset;
  string name;
  string device;
  char buffer1[BUFFERSIZE];
  unsigned int line=0, count;
  int error;
  ifstream file(filename);

  if (override_default != NULL) {
    string buffer(override_default);
    while ((device = remove_first_word(buffer)) != "") {
      oset.insert(device);
    }
  }
  
  if (!file) {
    // no file just enter system default
    if (override_default == NULL) {
      dset.insert(DEFAULT_DEVICE);
      table.insert(nick_pair("", dset));
    } else {
      table.insert(nick_pair("", oset));
    }
    return 0;
  } else {
    error=0;
    while (!file.eof()) {
      file.getline(buffer1, BUFFERSIZE);
      string buffer(buffer1);
      line++;
      name = remove_first_word(buffer);
      if (name == "") continue;
      if (name[0] == '#') continue;
      if (name == "default") name = "";
      dset = table[name];
      count = dset.size();
      while ((device = remove_first_word(buffer)) != "") {
      	dset.insert(device);
      }
      if (dset.size() > count) {
	table.erase(name);
	table.insert(nick_pair(name, dset));
      } else {
	if (name=="") name="default";
	cerr << "Error: no argument to " << name;
	cerr << " in " << filename << " line " << line << endl;
	error++;
      }
    }
    if (override_default != NULL) {
      table.erase("");
      table.insert (nick_pair("", oset));
    }
    return error;
  }
  return 0;
}

nick_table nicknames;
