#define Q 65536

extern unsigned short lg[65536], alg[65535];

static inline unsigned add (unsigned m, unsigned n)
{
  return m ^ n;
}

static inline unsigned sub (unsigned m, unsigned n)
{
  return m ^ n;
}

static inline unsigned neg (unsigned n)
{
  return n;
}

static inline unsigned mul (unsigned m, unsigned n)
{
  if (m == 0 || n == 0)
    return 0;
  else {
    unsigned t = lg[m] + lg[n];
    if (t >= 65535) t -= 65535;
    return alg[t];
  }
}

static inline unsigned div (unsigned m, unsigned n)
{
#ifndef NDEBUG
  if (n == 0)
    abort ();
#endif
  if (m == 0)
    return 0;
  else {
    int t = lg[m] - lg[n];
    if (t < 0) t += 65535;
    return alg[t];
  }
}
