#if __GNUC__
#define PACKED __attribute ((packed))
#endif

/* Sector 0, the boot block. */

struct boot_block
{
  unsigned char jmp[3];
  unsigned char oem_id[8];
  unsigned short bytes_per_sector PACKED; 	/* 512 */
  unsigned char sectors_per_cluster;
  unsigned short n_reserved_sectors;
  unsigned char n_fats;				/* 2 */
  unsigned short n_rootdir_entries PACKED;
  unsigned short n_sectors_s PACKED;
  unsigned char media_byte;
  unsigned short sectors_per_fat;
  unsigned short sectors_per_track;
  unsigned short heads_per_cyl;
  unsigned int n_hidden_sectors;
  unsigned int n_sectors_l;
  unsigned char drive_number;
  unsigned char mbz;
  unsigned char sig_29h;
  unsigned char vol_serno[4];
  unsigned char vol_label[11];
  unsigned char fat_label[8];
  unsigned char pad[448];
  unsigned short magic;				/* aa55 */
};

/* ecc.c */

extern void fatal (char *fmt, ...);
extern void warning (char *fmt, ...);

/* sysdep.c */

extern int open_dev (char *dev, int wflag);
extern void get_standard_format (int fd, struct boot_block *b);
extern int read_sector (int fd, int n, void *buf);
extern int write_sector (int fd, int n, void *buf);
extern int sync_writes (int fd);
