.\"
.\"	$Id: diskwrite.man,v 1.2 1999/11/22 02:17:59 solyga Exp $
.\"
.TH [%s PRG_NAME] [%d MANUAL_NUMBER] "[%s DATE_OF_LAST_MOD]" "Version [%s VERSION_NUMBER]" "[%s MANUAL_SECTION_STR]"
.SH NAME
[%s prg_name] \- write to file at given offset
.SH SYNOPSIS
.B [%s prg_name]
.RB [ -chvV ]
.RB [ -f
.IR in_file ]
.RB [ -n
.IR bytes ]
.RB [ -o
.IR offset ]
.I out_file

.SH DESCRIPTION
.B [%s Prg_name]
copies
.I bytes
bytes from
.I in_file
to
.I out_file
where writing starts at offset
.IR offset .
The only mandatory argument is
.IR out_file
--
.IR in_file ,
.IR bytes
and
.I offset
default to stdin, infinit and zero, respectively.
If end-of-file is reached on
.IR in_file,
.B [%s prg_name]
exits without further consequences.

.B [%s Prg_name]
has been written for manipulation of raw harddisks, however, it may be used
with usual files, too. In the latter case you might want to specify the
.B -c
option for creating
.I out_file
if it doesn't exist.

As already told, a specified
.I offset
applies to the output but not to the input.
If you want to specify an offset for
.I in_file
use
.B diskdump
writing through a pipe to
.BR [%s prg_name] .

.SH OPTIONS
.TP
.B -c
create
.I out_file
(only if it doesn't exist)
.TP
.BI "\-f " in_file
use
.I in_file
as input (default stdin)
.TP
.B -h
display some helpful information on
.I [%s HELP_CHANNEL_STR]
and exit successfully
.TP
.BI "\-n " bytes
read only (up to)
.I bytes
bytes from input (default infinit)
.TP
.BI "\-o " offset
write to
.I out_file
at offset
.I offset
(default 0)
.TP
.B -v
raise verbosity level on [%s VERBOSE_CHANNEL_STR] by one
(maximum [%d VERBOSE_LEVEL_MAX])
.TP
.B -V
display version and compilation info on
.I [%s VERSION_CHANNEL_STR]
and exit successfully

.SH RETURN VALUE
On success, [%d RETVAL_OK] is returned. On error, a value >0 is returned.

.SH ERRORS
.TP
.B [%d RETVAL_BUG]
a program bug has seen the light
.TP
.B [%d RETVAL_ERROR]
the error is different from those explained above

.SH AUTHOR
[%s MY_EMAIL_ADDRESS]

.SH SEE ALSO
.BR diskdump (1),
.BR diskerase (8),
.BR disksize (1)
