.TH [%s PRG_NAME] [%d MANUAL_NUMBER] [%s DATE_OF_LAST_MOD] "Version [%s VERSION_NUMBER]" "[%s MANUAL_SECTION_STR]"

.SH NAME
[%s prg_name] \- list file sizes

.SH SYNOPSIS
.B [%s prg_name]
.RB [ -hivVkMG ]
.I file
.RI [ "file list" ]

.SH DESCRIPTION
.I [%s Prg_name]
lists the sizes of normal and special files by using
.IR llseek(2) / lseek(2) .
It has been created for determining the sizes of raw harddisks but it may
work on other special files, too.

.SH OPERATION
The operation of
.I [%s prg_name]
depends on the behaviour of the file specified.
.PP
1) After opening the file read-only, its offset is tried to set to its
end by size=
.IR lseek( fd,0,SEEK_END ) .
If size is greater than zero, it is printed and we're ready.
.PP
2) Unfortunately, for harddisks zero is returned. Thus, if size equals
zero the file is a usual one of zero size or a special file like a harddisk.
Reading the first byte of the file by nbr=
.IR read( fd,buf,1 ) 
decides upon this. If nbr equals zero, zero is printed and we're ready.
.PP
3) Otherwise the file is a special one and its size is determined iteratively
by a loop of
.IR lseek( fd,offset,SEEK_SET )
and a subsequent
.IR read( fd,buf,1 ) .
The smallest offset at which
.I read()
returns zero (or -1 with
.I errno
== EIO, see
.BR -i )
is the file size which is printed.

.SH OPTIONS
.TP
.B -h
display some (more or less) helpful information and exit successfully
.TP
.B -i
ignore read errors when iterating
.TP
.B -v
raise verbosity level
.TP
.B -V
display version and compilation info and exit successfully
.TP
.B -k
set unit to (full) kBytes
.TP
.B -M
set unit to (full) MBytes
.TP
.B -G
set unit to (full) GBytes

.SH BUGS
When operating on a CD-ROM data track
.I [%s prg_name]
may return a value that is larger than the size of the image dumped by
`dd if=/dev/cdrom of=image.raw'. If this should be the case you've got
a data track with a hole -- at least as seen by the system. However,
both sizes should be at least as large as the value returned by
.IR isoinfo (1).
Otherwise your disk or/and drive do not work properly or the disk is
"copy protected".

When determining the size of a raw harddisk with C cylinders, H heads and
S sectors per track, it is not a bug if
.I [%s prg_name]
returns a value different from C*H*S*512 (at least if it returns a value
smaller than (C+1)*H*S*512). The CHS-value of a modern harddisk has
nothing to do with its physical layout. The area beginning at offset
C*H*S*512 does not belong to any partition, you may store your secret
stuff there.

.SH AUTHOR
[%s MY_EMAIL_ADDRESS]

.SH SEE ALSO
.BR diskdump (1),
.BR diskerase (8),
.BR diskwrite (8),
.BR isoinfo (1)
