#undef	DEBUG
#define	USE_LLSEEK

/*
 If your system doesn't know about loff_t, llseek() and strtoq(), undefine
 USE_LLSEEK and it should compile. However, this way the program will
 report on sizes >2GB as ">2147483647" only.
#undef  USE_LLSEEK
*/

#include <stdio.h>		/* printf() */
#include <getopt.h>		/* getopt() */
#include <fcntl.h>		/* open(), O_RDONLY */
#include <errno.h>		/* error numbers */
#include <unistd.h>		/* close() */
#include <limits.h>		/* LONG_MAX */

#define	STD_CHANNEL	stdout
#define	HELP_CHANNEL	stdout
#define	ERROR_CHANNEL	stderr
#define	VERSION_CHANNEL	stdout
#define	DEBUG_CHANNEL	stderr

#define	RETVAL_OK	0
#define	RETVAL_ERROR	1
#define	RETVAL_BUG	2

#define VERSION_NUMBER		"0.32"
#define DATE_OF_LAST_MOD	"1999-07-16"
#define	MY_EMAIL_ADDRESS	"Steffen Solyga <solyga@absinth.net>"


#define	SIZE_MIN	0L
#define	SIZE_MAX	(LONG_MAX)	/* usually 2047 MB */
#define LSEEK(A,B,C)	lseek((A),(B),(C))

#ifdef USE_LLSEEK
/* Didn't find the llseek() header... */
loff_t  llseek( int fd, loff_t offset, int whence );
/* correct sizes */
#undef	SIZE_MIN
#define	SIZE_MIN	0LL
#undef	SIZE_MAX
#define SIZE_MAX	9223372036854775807LL	/* 2^63-1 (LL_MAX) */
/* use the right macro */
#undef	LSEEK()
#define	LSEEK(A,B,C)	llseek((A),(B),(C))
#endif
