.TH [%s PRG_NAME] [%d MANUAL_NUMBER] [%s DATE_OF_LAST_MOD] "Version [%s VERSION_NUMBER]" "[%s MANUAL_SECTION_STR]"

.SH NAME
[%s prg_name] \- write a pattern periodically to a device

.SH SYNOPSIS
.B [%s prg_name]
.RB [ -fhvV ]
.RB [ -H\ size ]
.RB [ -p\ pattern | -s\ string ]
.I device
.SH DESCRIPTION
.I [%s Prg_name]
writes a pattern periodically to
.IR device 
as long as possible.
This may be considered as useful with disks for tracing system actions like
partitioning, formatting or boot record writing or for destroying data
irreversibly.
.PP
The pattern may be specified binary with the
.B -p
or by a character sequence with the
.B -s
option.  If no pattern is explicitely given,
.I [%s prg_name]
uses the binary pattern 0x[%02x DEFAULT_BYTE].

.SH OPTIONS
.TP
.B -f
force erasing
.TP
.B -h
display some helpful information on [%s HELP_CHANNEL_STR] and exit successfully
.TP
.B -v
be more talkative on [%s STD_CHANNEL_STR]
.TP
.B -V
display version and compilation settings on [%s VERSION_CHANNEL_STR] and exit successfully
.TP
.BI "\-H " size
Write on hash mark per
.I size
bytes on [%s STD_CHANNEL_STR].
.I Size
must be either an integer or a combination of an integer and one of the
units
.IR k ,
.I M
or
.IR G .
.TP
.BI "\-p " pattern
Use binary pattern
.I pattern
for writing.
.I Pattern
is a sequence of integer numbers separated by a divider.
Valid numbers are out of [ 0, 255 ]. Numbers with leading `0x' and `0' are
treated as hexadecimal and octal, respectively.
Valid dividers are the characters ' ', '\\t', ',' and ';'.
.TP
.BI "\-s " string
Use the string
.I string
for writing (excluding the terminating '\\0'). This option makes pattern
specification more simple if the numbers are out of [ 0x20, 0x7e].

.SH AUTHOR
[%s MY_EMAIL_ADDRESS]

.SH SEE ALSO
.BR diskdump (1),
.BR disksize (1),
.BR diskwrite (8)
