.\"
.\"	$Id: ckdisk.man,v 1.2 2005/07/22 00:45:35 solyga Exp $
.\"
.TH [%s PRG_NAME] [%d MANUAL_NUMBER] "[%s DATE_OF_LAST_MOD]" "Version [%s VERSION_NUMBER]" "[%s MANUAL_SECTION_STR]"
.SH NAME
[%s prg_name] \- check drive by writing and reading special patterns
.SH SYNOPSIS
.B [%s prg_name]
.RB [ -hvwV ]
.RB [ -s\ size ]
.I device

.SH DESCRIPTION
.B [%s Prg_name]
checks a disk drive
.I device
for addressing problems by writing a special pattern to it and
verifying the data afterwards. In contrast to
.BR badblocks ,
.B [%s prg_name]
uses a single pattern block of
.I size
ascending bytes starting with zero.

.SH OPTIONS
.TP
.B -h
display some helpful information on [%s HELP_CHANNEL_STR]
and exit successfully
.TP
.BI "\-s " size
set blocksize to
.IR size
bytes (default is [%d BLK_SZE])
.TP
.B -v
raise verbosity level on [%s VERBOSE_CHANNEL_STR] by one
(maximum [%d VERBOSE_LEVEL_MAX])
.TP
.B -V
display version and compilation info on [%s VERSION_CHANNEL_STR]
and exit successfully
.TP
.B -w
write to
.I device
(default is read/verify)

.SH RETURN VALUE
On success, [%d RETVAL_OK] is returned. On error, a value >0 is returned.

.SH ERRORS
.TP
.B [%d RETVAL_SIG]
program terminated due to signal SIGINT
.TP
.B [%d RETVAL_MALLOC]
not enough memory available
.TP
.B [%d RETVAL_DIFF]
verification was unsuccessful
.TP
.B [%d RETVAL_BUG]
a program bug has seen the light
.TP
.B [%d RETVAL_ERROR]
the error is different from those explained above

.SH AUTHOR
[%s MY_EMAIL_ADDRESS]

.SH SEE ALSO
.BR badblocks (8)

