#!/bin/bash
# CDW-Tools 
# MAIN-MODULE.

# Needs dialog 0.6 or above, isosize, cdwrite 2.0, isovfy...
# Make sure you set all their path in the section below.

# This file may be copied under the terms and conditions of version 2
# of the GNU General Public License, as published by the Free
# Software Foundation (Cambridge, Massachusetts). 


#####################################################################
# by T.Niederreiter
#
# History:
#  v0.1 25.7.95  Initial Release
#  v0.2  3.8.95  Added: Net on/off, Dummy Mode, Enhanced Verify
#                       Minor Code-enhancement
#  v0.3 29.8.95  Added: Enhanced User-detection, Haltsys-Option
#                       Partition-Security-Check, Abort-Verify now ok. 
#  v0.4 22.10.95 Switched from CD-Copy to CD-Tools which also cover
#                       Audio-Support  
#  v0.5 26.10.95 Switched to dialog 0.6. Better interface. Listen to Audio-
#                       track. Automount Audio. Show users before shutdown.
#                       Delete Audio-tracks. 
#  v0.6 29.10.95 Added: Mixed-Mode-Support. Verify-Warning
#  v0.7  5.11.95 Added: Self-Master-Support.
#  v0.8  7.11.95 Changed: Moved settings into their modules. New Automount
#  v0.9 16.11.95 Added: Non-ISO9660-CD's copying. Write-speed-setting.
#                       Get ISO-Header-Strings from CD.
#  v0.91 21.11.95 Added: Program-Info in mainmenu, bug-fix in automount,
#                        new directory structure
#  v0.92 27.11.95 Changed: Now works with cdwrite-2.0. Added Writer-Model-
#                          Selection.
#  v0.93 20.01.96 Added: Swap byte-order switch for non-big-endian writer
#                        (affects Audio only). Audio-readback support
#			 for all writers.         
#
#####################################################################

SCRIPT_VERSION="0.93"
MKDIRHIER="/usr/X11/bin/mkdirhier"
DIALOG="./bin/dialog"
CAT2="./bin/cat2"
CMP2="./bin/cmp2"
ISODETECT="./bin/isodetect"
PLAYCDR="./bin/playcdr"
CDDA2CDR="./bin/cdda2cdr"
CDWRITE="./bin/cdwrite"
ISOSIZE="./bin/isosize"
ISOVFY="./bin/isovfy"
MKISOFS="./bin/mkisofs"

#--------- Modules-Defaults ---------

#- GLOBAL Defaults -
SOURCE_CD_DRIVE_IOC="/dev/cdrom" 
SOURCE_CD_DRIVE_GEN="/dev/sgd"
DEST_CD_WRITER="/dev/sgc"
CDW_MODEL="philips" # or yamaha or hp
CDWSPEED="2"
DUMMY_MODE="Off"
NETWORK_STATUS="On"

#- DataCD Defaults -
TEMP_PART_IMAGE="/dev/sdb2"
MOUNT_IMAGE="/mnt2"

#- AudioCD Defaults -
TEMP_PART_AUDIO="none"
MOUNT_AUDIO="/mnt2"
AUDIO_FILENAME="audio"
SWAP_BYTE_ORDER="Off" # Should be "On" for Yamaha-Writers

#- Master Defaults -
MASTER_SOURCE="none"
MOUNT_MASTER="/mnt"
MASTER_DIR="/mnt/cdstuff"
IMAGE_DEST="/dev/sdb2"
IMAGE_TYPE="RockRidge" # or "MSDOS"
ISOVOLID=""
ISOPUBID=""
ISOPREID=""
ISOAPPID=""
 
#- some security preparations:
#Change this to your partitions you want to lock. This means the user
#cant specify one of these in any menu. So an accidentely erasing can 
#be avoided. 

echo "/dev/hda1 /dev/hda2 /dev/hda3 /dev/hda4 /dev/hda5 /dev/hda6 /dev/sda1 \
/dev/sda2 /dev/sda3 /dev/sda4 /dev/sda5 /dev/sda6 /dev/sga" >/tmp/SeTsecu

# on this partitions is writing not allowed

#--------End of Defaults ---------

# Allow only users who are in group cdwrite
GROUP_CDWRITE_ONLY=0

reset

if [ "$UID" != "0" ]; then	# check for root
 $DIALOG --title "CDW-Tools $SCRIPT_VERSION" --msgbox \
 "                       Warning!\n\
       You need root-rights to run this program!" 7 60
 reset
 exit 	# Quit Script 
fi

#if GROUP_CDWRITE_ONLY is 1 then only people in group "cdwrite" can run
#the program
if [ "$GROUP_CDWRITE_ONLY" = "1" ]; then
 if [ "`groups $LOGNAME | fgrep -c cdwrite`" != "1" ]; then
  $DIALOG --title "CDW-Tools $SCRIPT_VERSION" --msgbox \
  "                       Warning! \n\
       Only the user \"cdw\" may run this program!" 7 60
  reset
  exit
 fi
fi


# Trap CTRL-C
trap 'echo "Aborted operation - Press RETURN"' 2

while [ 0 ]; do

#--------------MAINMENU---------

$DIALOG --title "CDW-Tools $SCRIPT_VERSION" --menu \
"\nWith CDW-Tools you can copy/create Data- and Audio-CDs.\n \
Take care that all devices are correctly set.\n" \
24 76 14 \
"INFO"   "Program-Information" \
"      " "---------------------------------------------------------" \
"SOURCE" "Set Source-CD-Rom               [now: $SOURCE_CD_DRIVE_IOC,$SOURCE_CD_DRIVE_GEN]" \
"DEST"   "Set CD-Writer-Device            [now: $DEST_CD_WRITER]" \
"MODEL"  "Set CD-Writer-Model             [now: $CDW_MODEL]" \
"SPEED"  "Set CD-Writer-Speed             [now: $CDWSPEED x]" \
"DUMMY"  "Dummy-Write-Mode?               [now: $DUMMY_MODE]" \
"NET"    "Network-Status?                 [now: $NETWORK_STATUS]" \
"      " "---------------------------------------------------------" \
"HALT" "Shutdown System" \
"COPY_D" "Copy Data-CD" \
"COPY_A" "Copy Audio- or Mixed-Mode-CD" \
"MASTER" "Master Data-CD" \
"EXIT" "Exit Program" 2> /tmp/SeTmain
 if [ $? = 1 -o $? = 255 ]; then 	#Cancel choosen
   echo "EXIT" >/tmp/SeTmain		#Simulate EXIT
 fi
MAINSELECT="`cat /tmp/SeTmain`"
rm -f /tmp/SeTmain


#-------------INFO-MENU---------------

if [ "$MAINSELECT" = "INFO" ]; then
 $DIALOG --title "Program Information" --msgbox \
"\nCDW-Tools is a frontend for some CD related programs like \n\
mkisofs, cdwrite and cdda2cdr. The intention is that a normal \n\
user can operate the CD-Writer without bothering with the quite \n\
complex commandlines of the programs. \n\n\
You need : \n\
 - A CD-Writer supported by cdwrite. \n\
    (Version 2.0 now only supports Philips, Yamaha and HP-Writers)\n\
 - A Harddrive with at least one 700 MB partition for storing \n\
   disk-images. If you want master your own CD's you need also \n\
   the space for your data in addition to that partition.\n\
 - A CD-ROM-Drive is no longer needed. The CD-Writer can be used.\n\
   Full Data- and Audio-read is now implemented.\n\n\
Please contact me if you are working with this program, so that I \n\
can enhance it.\n                                Thomas Niederreiter\n\
                                (p7003ad@sunmail.lrz-muenchen.de)" 24 75 
fi

#-------------HALT-MENU---------------

if [ "$MAINSELECT" = "HALT" ]; then
$DIALOG --title "Shutdown System?" --yesno \
"\nAre you sure that you want shutdown the system? You may want to\ndo this to \
connect the SCSI-Devices you need for writing CDs.\nThe time until halt is \
2 min. to give users working on the system\na chance to logout. When the \
message \"The system is halted\" is\non the screen you can switch off." 11 70
 if [ $? = 1 ]; then
  continue;
 fi

 clear
 echo "************************************************"
 echo "Notice: You can abort the shutdown with CTRL-C !"
 echo "************************************************"
 echo 
 echo "   **** Logged in users ****"
 who 
 echo
 /sbin/shutdown -h +2
fi
 
#-------------SOURCE-MENU--------------

if [ "$MAINSELECT" = "SOURCE" ]; then
$DIALOG --title "Set Source-CD-Rom?" --yesno \
"\nThe Source-CD-Rom is needed to read in a CD-Image and save it on\nthe \
harddrive. You have to enter the SCSI-Device-name and the\n\
Generic-Device-name. The SCSI-Device-name is shown at boottime by\nthe \
kernel and the generic-one is the number of the connected\ndevice as shown \
by the kernel.\n\nAre you sure you want to change the Source-CD-Rom?" 13 70
  if [ $? = 1 ]; then		#We clicked on NO
   continue;
  fi
  $DIALOG --inputbox \
"SCSI-Device of the Source-CD-Rom?\n\n\
Valid inputs are e.g. /dev/sr0 or \n/dev/sr1." 12 42 2> /tmp/SeTsource
  if [ -s /tmp/SeTsource ]; then
   SOURCE_CD_DRIVE_IOC="`cat /tmp/SeTsource`"

#Security
if [ `fgrep -c $SOURCE_CD_DRIVE_IOC /tmp/SeTsecu` = 1 ]; then
  $DIALOG --msgbox "\n       You've entered a locked device.\n         Please \
choose another one!" 8 50
  SOURCE_CD_DRIVE_IOC="invalid"
fi 
#Security off

  else
   rm -f /tmp/SeTsource
#   continue
  fi

  $DIALOG --inputbox \
"Generic-Device of the Source-CD-Rom?\n\n\
Valid inputs are e.g. /dev/sgb or \n/dev/sgc." 12 42 2> /tmp/SeTsource
  if [ -s /tmp/SeTsource ]; then
   SOURCE_CD_DRIVE_GEN="`cat /tmp/SeTsource`"

#Security
if [ `fgrep -c $SOURCE_CD_DRIVE_GEN /tmp/SeTsecu` = 1 ]; then
  $DIALOG --msgbox "\n       You've entered a locked device.\n         Please \
choose another one!" 8 50
  SOURCE_CD_DRIVE_GEN="invalid"
fi 
#Security off

  else
   rm -f /tmp/SeTsource
   continue
  fi

  rm -f /tmp/SeTsource
fi

#---------------DEST-MENU---------------

if [ "$MAINSELECT" = "DEST" ]; then
$DIALOG --title "Set CD-Writer-Device?" --yesno \
"\nThe CD-Writer writes the image from the HD-Partition back to a\nCD. \
Here you have to enter the Generic-SCSI-Device of the writer.\nTo find \
out what is the right device, look at the kernel-messages\nat boottime. \
The first recognized device is \"/dev/sga\", the\nsecond \"/dev/sgb\" and \
so on. Therefore, when the writer was\nrecognized on the third place, its \
device is \"/dev/sgc\".\n\n\
Are you sure you want to change the CD-Writer-Device?" \
14 70
  if [ $? = 1 ]; then		#We clicked on NO
   continue;
  fi
  $DIALOG --inputbox "CD-Writer-Device?\n\n\
Valid inputs are e.g. /dev/sgc or \n/dev/sgd" 12 42 2> /tmp/SeTdest
  if [ -s /tmp/SeTdest ]; then
   DEST_CD_WRITER="`cat /tmp/SeTdest`"

#Security
if [ `fgrep -c $DEST_CD_WRITER /tmp/SeTsecu` = 1 ]; then
  $DIALOG --msgbox "\n       You've entered a locked device.\n         Please \
choose another one!" 8 50
  DEST_CD_WRITER="invalid"
fi 
#Security off

  else
   rm -f /tmp/SeTdest
   continue
  fi
  rm -f /tmp/SeTdest
fi

#---------------MODEL-MENU---------------

if [ "$MAINSELECT" = "MODEL" ]; then
 $DIALOG --title "Set CD-Writer-Model?" --radiolist \
"\nSince version 2.0 of the cdwrite-program different types of \n\
CD-Writers are supported. Here you select your CD-Writer- \n\
Model. For an exact description of each model look in the \n\
cdwrite-manpage.\n" \
15 70 3 \
"philips" "Philips/IMS/Kodak CDD-52x" On \
"yamaha" "Yamaha CDR10x" Off \
"hp" "HP 4020i (C4324/C4325)" Off 2>/tmp/SeTwritertype

 if [ $? = 1 -o $? = 255 ]; then        #Cancel choosen
  rm -f /tmp/SeTwritertype
  continue;
 fi

 CDW_MODEL="`cat /tmp/SeTwritertype`"
 rm -f /tmp/SeTwritertype

fi

#---------------SPEED-MENU---------------

if [ "$MAINSELECT" = "SPEED" ]; then
$DIALOG --title "Set CD-Writer-Speed?" --yesno \
"\nThis is the writing speed of the CD-Writer. To write with 300kB/s\n\
enter \"2\", or to write with 150kB/s enter \"1\". Higher speeds \n\
may be supported by your writer. (Untested) \n\n\
Are you sure you want to change the CD-Writer-Speed?" 11 70  
  if [ $? = 1 ]; then		#We clicked on NO
   continue;
  fi
  $DIALOG --inputbox "CD-Writer-Speed?\n\n\
Valid inputs are e.g. 1, 2 or 4" 12 42 2> /tmp/SeTspeed
  if [ -s /tmp/SeTspeed ]; then
   CDWSPEED="`cat /tmp/SeTspeed`"
  else
   rm -f /tmp/SeTspeed
   continue
  fi
  rm -f /tmp/SeTspeed
fi

#---------DUMMY---------

if [ "$MAINSELECT" = "DUMMY" ]; then
 if [ "$DUMMY_MODE" = "Off" ]; then
    $DIALOG --title "Dummy-Write-Mode ON?" --yesno \
"\nDo you want to enable the Dummy-Mode of the CD-Writer?\n\n\
This results in a deactivation of the write-laser, what leads \n\
to a simulation of the write-process. The CD-Recordable won't \n\
be written." 12 70 
  if [ $? = 1 ]; then		#We clicked on NO
   continue;
  fi
  DUMMY_MODE="On"
  continue
 fi
 if [ "$DUMMY_MODE" = "On" ]; then
    $DIALOG --title "Dummy-Write-Mode OFF?" --yesno \
"\nDo you want to disable the Dummy-Mode of the CD-Writer?\n\n\
The write-process will then be done fully. The CD-Recordable \n\
will be fixated." 11 70 
  if [ $? = 1 ]; then		#We clicked on NO
   continue;
  fi
  DUMMY_MODE="Off"
 fi
fi

#---------NET----------

if [ "$MAINSELECT" = "NET" ]; then
 if [ "$NETWORK_STATUS" = "Off" ]; then
$DIALOG --title "Network-Status ON?" --yesno \
"\nDo you want reactivate the network of the system?" 11 70
  if [ $? = 1 ]; then		#We clicked on NO
   continue;
  fi
  /etc/rc.d/rc.inet1		#rerun Network-initscript
  NETWORK_STATUS="On"
  $DIALOG --msgbox "\n   The network is active again!" 7 40
  continue;
 fi

 if [ "$NETWORK_STATUS" = "On" ]; then
  $DIALOG --title "Network-Status OFF?" --yesno \
"\nDo you want to disable the network of the system? \n\
This ensures that nobody can disturb the write-process \n\
over a network-link. Please watch for other users working \n\
on the system." 11 70
  if [ $? = 1 ]; then		#We clicked on NO
   continue;
  fi
  /sbin/ifconfig eth0 down	#Shutdown Network
  NETWORK_STATUS="Off"
  $DIALOG --msgbox "\n    The network is disabled!" 7 40
 fi
fi 

#---------COPY_A----------

if [ "$MAINSELECT" = "COPY_A" ]; then
	source cdwt_copy_a.sh
fi
#---------COPY_D----------

if [ "$MAINSELECT" = "COPY_D" ]; then
	source cdwt_copy_d.sh
fi

#---------MASTER----------

if [ "$MAINSELECT" = "MASTER" ]; then
	source cdwt_master.sh
fi

#---------EXIT----------

if [ "$MAINSELECT" = "EXIT" ]; then
 rm -f /tmp/SeT*
 /etc/rc.d/rc.inet1	# Make sure network is running again
 reset
 break
fi

done


