#!/bin/bash
# Subprogram for CDWTOOLS 
# Master Data-CD's

##########################################################
# 29.10.95 T.Niederreiter
##########################################################


reset

AutoMountMaster() {
$MKDIRHIER $MOUNT_MASTER

#Auto-mount the Master-partition if needed.
#checks if partition is already mounted or if partition is valid or
#if there is an ext2-fs on the partition. If not, format partition

if [ $MASTER_SOURCE != "none" ]; then
#check if the partition is already mounted.
 mount >/tmp/SeTmounted
 fgrep "$MASTER_SOURCE" /tmp/SeTmounted >/dev/null
 if [ $? = 1 ]; then            #is NOT mounted, so do it now
  mount $MASTER_SOURCE $MOUNT_MASTER 2>/tmp/SeTmounted
  if [ $? = 1 ]; then           # mount failed
   fgrep "valid" /tmp/SeTmounted >/dev/null
   if [ $? = 0 ]; then          # no such device
    $DIALOG --title "Error" --msgbox "\n Unable to mount Master-Source \
$MASTER_SOURCE: No such device\n\n\
 Are you sure you connected all external drives you may need?\n\n\
If you want mount another partition (or none), set in the next\n\
menu a new Master-Source-Partition." 12 70
    MASTER_SOURCE="none"
    rm -f /tmp/SeTmounted
    return;                     # back to caller
   else                 # perhaps wrong filesystem
    $DIALOG --title "Error" --yesno "\n Unable to mount Master-Source \
$MASTER_SOURCE: No filesystem\n\n\
 Shall I create an ext2-filesystem on this device? WARNING,\n all data on that \partition will be lost!\n\n\
If you want mount another partition (or none), set in the next\n\
menu a new Master-Source-Partition (and say NO now)." 13 70
     if [ $? = 1 ]; then                #We clicked on NO
       rm -f /tmp/SeTmounted
       MASTER_SOURCE="none"
       return;
     fi
     $DIALOG --title "Formating" --infobox "\n      Creating an ext2-fs on $MASTER_SOURCE\n\n\
                PLEASE WAIT" 7 50
     mke2fs $MASTER_SOURCE

     $DIALOG --title "Formating" --msgbox "\n         PROCESS FINISHED" 7 40
     rm -f /tmp/SeTmounted
     AutoMountMaster;
     return;
   fi
  fi
  $DIALOG --msgbox "\n     Mounted Master-Source-Partition $MASTER_SOURCE\
 on $MOUNT_MASTER\n\n\
If you want mount another partition (or none), set in the next\n\
menu a new Master-Source-Partition." 10 70
 fi
 rm -f /tmp/SeTmounted
fi
}

UmountMaster() {
# umount master-partition

 if [ $MASTER_SOURCE != "none" ]; then
  umount $MOUNT_MASTER 2>/dev/null
  if [ $? = 0 ]; then
   $DIALOG --msgbox "\n Unmounted Master-Source-Partition $MASTER_SOURCE" 7 50
  fi
 fi
}

# Try to Automount the Master-Source-Partition
AutoMountMaster;

# Mainloop

while [ 0 ]; do

#--------------MAINMENU---------

$DIALOG --title "Master Data-CD $SCRIPT_VERSION" --menu \
"\nFunctions for mastering of an ISO9660-Image.\n\
This image can be written with the \"Copy Data-CD\"-Option.\n" \
21 76 11 \
"SOURCE" "Set Master-Source-Partition      [now: $MASTER_SOURCE]" \
"MOUNTM" "Set Mountpoint for Master-Source [now: $MOUNT_MASTER]" \
"DIR"    "Set Master-Directory             [now: $MASTER_DIR]" \
"DEST"   "Set Image-Destination            [now: $IMAGE_DEST]" \
"TYPE"   "Set Image-Type                   [now: $IMAGE_TYPE]" \
"      " "---------------------------------------------------------" \
"ISO"    "Define ISO9660-Header-Strings" \
"GET"    "Get Header-Strings from a CD" \
"MASTER" "Master Image" \
"VERIFY" "Verify Image" \
"EXIT" "Exit Menu" 2> /tmp/SeTmastermain
 if [ $? = 1 -o $? = 255 ]; then 	#Cancel choosen
  echo "EXIT" >/tmp/SeTmastermain
 fi
MAINSELECTCDMASTER="`cat /tmp/SeTmastermain`"
rm -f /tmp/SeTmastermain

#-------------SOURCE-MENU--------------

if [ "$MAINSELECTCDMASTER" = "SOURCE" ]; then
$DIALOG --title "Set Master-Source-Partition?" --yesno \
"\nHere you set where you stored your data you want to master.\n\
Typically this is an external harddrive-partition. You can also\n\
enter \"none\" if you don't want that a partition is mounted. This \n\
is useful if you have the data on a premounted or local\ndirectory.\n\n\
Are you sure you want to change the Master-Source-Partition?" 13 70
  if [ $? = 1 ]; then           #We clicked on NO
   continue;
  fi

  $DIALOG --inputbox \
"Master-Source-Partition?\n\n\
Valid inputs are e.g. /dev/sdb1 or \n/dev/sdc3 or \"none\"." 12 42 2> /tmp/SeTsource
  if [ -s /tmp/SeTsource ]; then

UmountMaster;

   MASTER_SOURCE="`cat /tmp/SeTsource`"

#Security
if [ `fgrep -c $MASTER_SOURCE /tmp/SeTsecu` = 1 ]; then
  $DIALOG --msgbox "\n       You've entered a locked device.\n         Please \
choose another one!" 8 50
  MASTER_SOURCE="invalid"
fi
#Security off

AutoMountMaster;

  else
   rm -f /tmp/SeTsource
   continue
  fi

  rm -f /tmp/SeTsource
fi

#---------------MOUNTM-MENU---------------

if [ "$MAINSELECTCDMASTER" = "MOUNTM" ]; then
$DIALOG --title "Set Mountpoint for Master-Source?" --yesno \
"\nThis is the mountpoint where the Master-Source-Partition will be\n\
mounted. If you choosed \"none\" as your Master-Source-Partition,\n\
nothing will be mounted.\n\n\
Are you sure you want to change the mountpoint?" 11 70
  if [ $? = 1 ]; then           #We clicked on NO
   continue;
  fi
  $DIALOG --inputbox "Mountpoint for Master-Source?\n\n\
Valid inputs are e.g. /mnt or /mnt2" 12 42 2> /tmp/SeTmount
  if [ -s /tmp/SeTmount ]; then
  UmountMaster;
   MOUNT_MASTER="`cat /tmp/SeTmount`"
  AutoMountMaster;
  else
   rm -f /tmp/SeTmount
   continue
  fi
  rm -f /tmp/SeTmount
fi

#---------------DIR-MENU---------------

if [ "$MAINSELECTCDMASTER" = "DIR" ]; then
$DIALOG --title "Set Master-Directory?" --yesno \
"\nThis is the root-directory of the data to master. If you have\n\
your Master-Source-Partition mounted on \"/mnt\" and your data is\n\
on that partition in the directory \"cdstuff\", you would enter \n\
\"/mnt/cdstuff\" here. The resulting ISO9660-image would have \n\
the data in \"/mnt/cdstuff/*\" as root-directory.\n\n\
Are you sure you want to change the Master-Directory?" 13 70
  if [ $? = 1 ]; then           #We clicked on NO
   continue;
  fi
  $DIALOG --inputbox "Set Master-Directory?\n\n\
Valid inputs are e.g. /master or \n/mnt/cdstuff" 13 42 2> /tmp/SeTmount
  if [ -s /tmp/SeTmount ]; then
   MASTER_DIR="`cat /tmp/SeTmount`"
  else
   rm -f /tmp/SeTmount
   continue
  fi
  rm -f /tmp/SeTmount
fi

#-------------DEST-MENU--------------

if [ "$MAINSELECTCDMASTER" = "DEST" ]; then
$DIALOG --title "Set Image-Destination?" --yesno \
"\nHere you set where the generated ISO9660-image should be\n\
stored. This can be a partition or a filename. If you choose to\n\
save the image on a partition (recommended) make sure that it is \n\
NOT mounted and sufficent in size. You should set this partition\n\
like the HD-Partition for Image-Data. If you prefer to master into\n\
a file (e.g. to be able to write as Mixed-Mode-CD) enter here the\n\
full filename (with path) of the destination-file.\n\n\
Are you sure you want to change the Image-Destination?" 15 70
  if [ $? = 1 ]; then           #We clicked on NO
   continue;
  fi

  $DIALOG --inputbox \
"Set Image-Destination\n\n\
Valid inputs are e.g. /dev/sdb1 or \n\"/mnt/isoimage.raw\"." 12 42 2> /tmp/SeTdest
  if [ -s /tmp/SeTdest ]; then
   IMAGE_DEST="`cat /tmp/SeTdest`"

#Security
if [ `fgrep -c $IMAGE_DEST /tmp/SeTsecu` = 1 ]; then
  $DIALOG --msgbox "\n       You've entered a locked device.\n         Please \
choose another one!" 8 50
  IMAGE_DEST="invalid"
fi
#Security off

  else
   rm -f /tmp/SeTdest
   continue
  fi

  rm -f /tmp/SeTdest
fi

#---------TYPE----------

if [ "$MAINSELECTCDMASTER" = "TYPE" ]; then

 if [ "$IMAGE_TYPE" = "RockRidge" ]; then
  MSFLAG="Off"
  RRFLAG="On"
 else
  MSFLAG="On"
  RRFLAG="Off"
 fi

 $DIALOG --title "Set Image-Type?" --radiolist \
"\nHere you set of which type the image should be.\n\n\
 MSDOS: Make the CD fully readable by DOS/Windows.\n\
        Uses only short filenames and no mixed cases.\n\
        - Use with caution if you create that from a Unix-\n\
          filesystem.\n\n\
 RockRidge: Suitable for Unix/OS/2/Win95-Systems. \n\
        Allows long filenames and upper/lower-cases.\n\
        With DOS/Windows mostly readable.\n" \
21 70 2 \
"MSDOS" "" $MSFLAG \
"RockRidge" "" $RRFLAG 2>/tmp/SeTimagetype 

 if [ $? = 1 -o $? = 255 ]; then        #Cancel choosen
  rm -f /tmp/SeTimagetype
  continue;
 fi

 IMAGE_TYPE="`cat /tmp/SeTimagetype`"
 rm -f /tmp/SeTimagetype

fi

#---------ISO------------

if [ "$MAINSELECTCDMASTER" = "ISO" ]; then
 $DIALOG --title "Define ISO9660-Header-Strings" --yesno \
"\nHere you can define what Info-Strings should be written in \n\
the Image-Header.\n\n\
- Volume-ID (max 32 chars): \n\
    Volume ID to be written in the master block.\n\
    [now: $ISOVOLID] \n\
- Publisher-ID (max. 128 chars): \n\
    Describes the publisher of the disc. Usually with a mailing\n\
    address and phone number.
    [now: $ISOPUBID] \n\
- Preparer-ID (max. 128 chars): \n\
    Describes the preparer of the disc.  
    [now: $ISOPREID] \n\
- Application-ID (max. 128 chars): \n\
    This describes the application that will be on the disc.\n\
    [now: $ISOAPPID] \n\n\
Are you sure you want to change the strings?" 24 70

  if [ $? = 1 ]; then           #We clicked on NO
   continue;
  fi

  $DIALOG --inputbox "\nDefine Volume-ID:\n" \
 11 42 2> /tmp/SeTheader
  if [ -s /tmp/SeTheader ]; then
   ISOVOLID="`cat /tmp/SeTheader`"
  fi

  $DIALOG --inputbox "\nDefine Publisher-ID:\n" \
 11 42 2> /tmp/SeTheader
  if [ -s /tmp/SeTheader ]; then
   ISOPUBID="`cat /tmp/SeTheader`"
  fi

  $DIALOG --inputbox "\nDefine Preparer-ID:\n" \
 11 42 2> /tmp/SeTheader
  if [ -s /tmp/SeTheader ]; then
   ISOPREID="`cat /tmp/SeTheader`"
  fi

  $DIALOG --inputbox "\nDefine Application-ID:\n" \
 11 42 2> /tmp/SeTheader
  if [ -s /tmp/SeTheader ]; then
   ISOAPPID="`cat /tmp/SeTheader`"
  fi

  rm -f /tmp/SeTheader

fi

#----------GET------------

if [ "$MAINSELECTCDMASTER" = "GET" ]; then
 $DIALOG --title "Get Header-Strings from a CD?" --yesno \
"\nThis functions reads the Header-Strings out of an ISO9660-\n\
Image. The CD-Rom-Device $SOURCE_CD_DRIVE_IOC will be checked.\n\n\
Warning! This deletes all Header-Strings you have already defined.\n\n\
Are you sure you want to get the Strings from CD?" 12 70
  if [ $? = 1 ]; then           #We clicked on NO
   continue;
  fi

 ISOVOLID=`$ISODETECT -d $SOURCE_CD_DRIVE_IOC -V`
 ISOPUBID=`$ISODETECT -d $SOURCE_CD_DRIVE_IOC -P`
 ISOPREID=`$ISODETECT -d $SOURCE_CD_DRIVE_IOC -p`
 ISOAPPID=`$ISODETECT -d $SOURCE_CD_DRIVE_IOC -A`

 $DIALOG --title "Get Header-Strings" --msgbox \
"\n                             RESULTS\n\n\
- Volume-ID: \n\
    [$ISOVOLID] \n\n\
- Publisher-ID: \n\
    [$ISOPUBID] \n\n\
- Preparer-ID: \n\
    [$ISOPREID] \n\n\
- Application-ID: \n\
    [$ISOAPPID] \n" 19 70

fi

#---------MASTER----------

if [ "$MAINSELECTCDMASTER" = "MASTER" ]; then
 $DIALOG --title "Master Image?" --yesno \
"\nMastering of an ISO9660-image:\n\n\
 Master from: $MASTER_DIR\n\
 Master to:   $IMAGE_DEST\n\
 Image-Type:  $IMAGE_TYPE\n\n\
Are sure everything is correctly set?" 13 70
  if [ $? = 1 ]; then           #We clicked on NO
   continue;
  fi

 if [ ! -d "$MASTER_DIR" ]; then    #Master-dir does not exist
  $DIALOG --title "Error" --msgbox "\n    Cannot find Master-Directory! \n\
        Please check the path." 8 40
  continue;
 fi

# Build Header-Strings
 ISOHEADER=""
 if [ "$ISOVOLID" ]; then
 ISOHEADER="$ISOHEADER -V \"$ISOVOLID\""
 fi 
 if [ "$ISOPUBID" ]; then
 ISOHEADER="$ISOHEADER -P \"$ISOPUBID\""
 fi 
 if [ "$ISOPREID" ]; then
 ISOHEADER="$ISOHEADER -p \"$ISOPREID\""
 fi 
 if [ "$ISOAPPID" ]; then
 ISOHEADER="$ISOHEADER -A \"$ISOAPPID\""
 fi 

# Master accordingly to the image type

 case "$IMAGE_TYPE" in
  "MSDOS")
  echo "$MKISOFS -a -v $ISOHEADER -o $IMAGE_DEST $MASTER_DIR" >/tmp/SeTmasterscript
    ;;
  "RockRidge")
  echo "$MKISOFS -a -v -L -R -l $ISOHEADER -o $IMAGE_DEST $MASTER_DIR" >/tmp/SeTmasterscript 
    ;;
 esac

 source /tmp/SeTmasterscript
 rm -f /tmp/SeTmasterscript

 $DIALOG --title "Mastering Image" --msgbox "\n             PROCESS FINISHED" \
 7 50

fi

#---------VERIFY----------

if [ "$MAINSELECTCDMASTER" = "VERIFY" ]; then
 $DIALOG --title "Verify Image?" --yesno \
"\nHere we do a quick consistency-check of the generated image.\n\
This lasts only a few seconds.\n\n\
 Location of Image: $IMAGE_DEST\n\n\
Do you want to start the check now?" 12 70
  if [ $? = 1 ]; then           #We clicked on NO
   continue;
  fi

$DIALOG --title "Verifing Image" --infobox \
"\n             PLEASE WAIT" 5 40

 $ISOVFY $IMAGE_DEST >/tmp/SeTverify

 $DIALOG --title "Results of Verify" --textbox /tmp/SeTverify 20 75
 
 rm -f /tmp/SeTverify

fi

#---------EXIT----------

if [ "$MAINSELECTCDMASTER" = "EXIT" ]; then
 UmountMaster;
 reset
 break
fi

done
