#!/bin/bash
#Subprogram for CDWTOOLS
#Handles Copying of DATA-CDs

#####################################################################
# by T.Niederreiter
#####################################################################

reset

AutoMountData() {
#create directory to store data 
$MKDIRHIER $MOUNT_IMAGE

#mount the data-partition if needed.
#checks if partition is already mounted or if partition is valid or
#if there is an ext2-fs on the partition. If not, format partition

if [ $TEMP_PART_IMAGE != "none" ]; then
#check if the partition is already mounted.
 mount >/tmp/SeTmounted
 fgrep "$TEMP_PART_IMAGE" /tmp/SeTmounted >/dev/null
 if [ $? = 1 ]; then            #is NOT mounted, so do it now
  mount -t ext2 $TEMP_PART_IMAGE $MOUNT_IMAGE 2>/tmp/SeTmounted
  if [ $? = 1 ]; then           # mount failed
   fgrep "valid" /tmp/SeTmounted >/dev/null
   if [ $? = 0 ]; then          # no such device
    $DIALOG --title "Error" --msgbox "\n Unable to mount Image-HD-Partition \
$TEMP_PART_IMAGE: No such device\n\n\
 Are you sure you connected all external drives you may need?\n\n\
If you want mount another partition (or none), set in the next\n\
menu a new Image-HD-Partition." 12 70
    TEMP_PART_IMAGE="none"
    rm -f /tmp/SeTmounted
    return;                     # back to caller
   else                 # perhaps wrong filesystem
    $DIALOG --title "Error" --yesno "\n Unable to mount Image-HD-Partition \
$TEMP_PART_IMAGE: No filesystem\n\n\
 Shall I create an ext2-filesystem on this device? WARNING,\n all data on that partition will be lost!\n\n\
If you want mount another partition (or none), set in the next\n\
menu a new Image-HD-Partition (and say NO now)." 13 70
     if [ $? = 1 ]; then                #We clicked on NO
       TEMP_PART_IMAGE="none"
       rm -f /tmp/SeTmounted
       return;
     fi
     $DIALOG --title "Formating" --infobox "\n      Creating an ext2-fs on $TEMP_PART_IMAGE\n\n\
                PLEASE WAIT" 7 50
     mke2fs $TEMP_PART_IMAGE

     $DIALOG --title "Formating" --msgbox "\n         PROCESS FINISHED" 7 40
     rm -f /tmp/SeTmounted
     AutoMountData;
     return;
   fi
  fi
  $DIALOG --msgbox "\n     Mounted Image-HD-Partition $TEMP_PART_IMAGE\
 on $MOUNT_IMAGE\n\n\
If you want mount another partition (or none), set in the next\n\
menu a new Image-HD-Partition." 10 70
 fi
 rm -f /tmp/SeTmounted
fi
}

UmountData() {
# umount data-partition

 if [ $TEMP_PART_IMAGE != "none" ]; then
  umount $MOUNT_IMAGE 2>/dev/null
  if [ $? = 0 ]; then
   $DIALOG --msgbox "\n   Unmounted Image-HD-Partition $TEMP_PART_IMAGE" 7 50
  fi
 fi
}

while [ 0 ]; do

#--------------MAINMENU---------

$DIALOG --title "Copy Data-CD $SCRIPT_VERSION" --menu \
"\nCopies a Data-CD in 3 steps. First read the CD-Image from the \n\
Source-CD and save it on the HD-Partition. Next verify the image \n\
and then write it onto a CD-Recordable.\n" \
18 76 7 \
"TEMP_D" "Set HD-Partition for Image-Data [now: $TEMP_PART_IMAGE]" \
"MOUNTD" "Set Mountpoint for Image-Data   [now: $MOUNT_IMAGE]" \
"      " "---------------------------------------------------------" \
"READ" "Read CD-Image" \
"VERIFY" "Verify CD-Image" \
"WRITE" "Write CD-Image" \
"EXIT" "Exit Menu" 2> /tmp/SeTmaincddata
 if [ $? = 1 -o $? = 255 ]; then 	#Cancel choosen
   echo "EXIT" >/tmp/SeTmaincddata           #Simulate EXIT
 fi
MAINSELECTCDDATA="`cat /tmp/SeTmaincddata`"
rm -f /tmp/SeTmaincddata


#---------------TEMP_D-MENU---------------

if [ "$MAINSELECTCDDATA" = "TEMP_D" ]; then
$DIALOG --title "Set HD-Partition for Image-Data?" --yesno \
"\nThis partition is used to store the CD-Image on the harddrive.\nThe \
partition will be formatted and mounted if you want to copy a \n\
Non-ISO9660-CD. An ISO9660-CD will be copied raw to that \n\
partition. In this case the partition must not be mounted. \n\
If you want write the data to a local or premounted directory \n\
enter \"none\".\n\n\
Are you sure you want to change the HD-Partition for Image-Data?" 14 70
  if [ $? = 1 ]; then           #We clicked on NO
   continue;
  fi
  $DIALOG --inputbox "HD-Partition for Image-Data?\n\n\
Valid inputs are e.g. /dev/sdb2 or \n/dev/sdb3" 12 42 2> /tmp/SeTtemp
  if [ -s /tmp/SeTtemp ]; then
   TEMP_PART_IMAGE="`cat /tmp/SeTtemp`"
#Security
if [ `fgrep -c $TEMP_PART_IMAGE /tmp/SeTsecu` = 1 ]; then
  $DIALOG --msgbox "\n       You've entered a locked device.\n         Please \
choose another one!" 8 50
  TEMP_PART_IMAGE="invalid"
fi
#Security off

  else
   rm -f /tmp/SeTtemp
   continue
  fi
  rm -f /tmp/SeTtemp
fi

#---------------MOUNTD-MENU---------------

if [ "$MAINSELECTCDDATA" = "MOUNTD" ]; then
$DIALOG --title "Set Mountpoint for Image-Data?" --yesno \
"\nWhen you read in Images from Non-ISO9660-CD's this is the path\nwhere they \
will be stored. \n\
Actually this is the mountpoint where the HD-Partition\nfor the Image-Data \
will be mounted. If you choosed \"none\" as \
your\nImage-HD-Partition, nothing will be mounted. \n\
(But then be sure to have enough space free in that directory!)\n\n\
Are you sure you want to change the mountpoint?" 14 70
  if [ $? = 1 ]; then           #We clicked on NO
   continue;
  fi

  $DIALOG --inputbox "Mountpoint for Image-Data?\n\n\
Valid inputs are e.g. /mnt or /mnt2" 12 42 2> /tmp/SeTmount
  if [ -s /tmp/SeTmount ]; then
   MOUNT_IMAGE="`cat /tmp/SeTmount`"
  else
   rm -f /tmp/SeTmount
   continue
  fi
  rm -f /tmp/SeTmount
fi

#---------READ----------

if [ "$MAINSELECTCDDATA" = "READ" ]; then
$DIALOG --title "Read CD-Image" --yesno \
"\nCopying the CD-Image to the Image-HD-Partition:\n\n \
CD-Rom-Device      : $SOURCE_CD_DRIVE_IOC\n \
Image HD-Partition : $TEMP_PART_IMAGE\n \
Image Mount-Point  : $MOUNT_IMAGE \n  \
(only needed for Non-ISO9660-CD's) \n\n\
Are you sure that the devices are correcty set?" 14 70
  if [ $? = 1 ]; then		#We clicked on NO
   continue;
  fi

  UmountData;

  $DIALOG --msgbox "\n   Put the Source-CD in the CD-Rom-Drive." 7 50 

# check if this is really an iso9660-CD.
  $ISODETECT -d $SOURCE_CD_DRIVE_IOC >/dev/null
  if [ $? = 0 ]; then

  CDISOSIZE="`$ISOSIZE $SOURCE_CD_DRIVE_IOC`"
  STARTTIME="`date +%T`"

 $CAT2 -S $CDISOSIZE $SOURCE_CD_DRIVE_IOC -o $TEMP_PART_IMAGE 2>/dev/null \
 | $DIALOG --title "Copying CD->Image" --guage \
"\nThis process can take up to 75 min. when copying with a \n\
single speed drive a full CD. A full CD contains \n\
approx. 680000000 bytes. \n\n\
This CD contains $CDISOSIZE bytes.\nStarttime: $STARTTIME\n\n\
                      PLEASE WAIT" 15 60 0

 else
 # this is not a ISO9660-CD...we have to handle this one different 

  $DIALOG --title "Warning" --yesno \
"\nThis is not an ISO9660-CD. To be able to copy it I have to\n\
mount $TEMP_PART_IMAGE on $MOUNT_IMAGE. This partition will most \n\
likely be formatted. \n\n\
Are you sure you want to proceed?" 11 70
  if [ $? = 1 ]; then		#We clicked on NO
   continue;
  fi
  
  AutoMountData;

  STARTTIME="`date +%T`"
  $DIALOG --title "Copying CD->Image" --infobox \
"\nThis process can take up to 75 min. when copying with a \n\
single speed drive a full CD. A full CD contains \n\
approx. 680000000 bytes. \n\n\
This CD contains <unknown> bytes.\nStarttime: $STARTTIME\n\n\
                      PLEASE WAIT" 15 60 

 $CAT2 $SOURCE_CD_DRIVE_IOC -o $MOUNT_IMAGE/noniso.raw 2>/dev/null 

 fi
 

  $DIALOG --title "Copying CD->Image" --yesno "\n             PROCESS FINISHED\n\n\
 Do you want to go to the VERIFY part now?" 9 50  
  if [ $? = 0 ]; then
   MAINSELECTCDDATA="VERIFY"
  fi
fi

#---------VERIFY----------

if [ "$MAINSELECTCDDATA" = "VERIFY" ]; then
 $DIALOG --title "Compare CD->Image" --yesno \
"\nPASS 1:\n \
Here we do a quick compare between the original-CD and the \n \
Image. This method is not 100% secure, but takes only a few \n \
seconds.\n\n\
PASS 2:\n \
Here we compare byte-by-byte. This can take quite long, but \n \
it is possible to abort anytime.\n\n \
CD-Rom-Device      : $SOURCE_CD_DRIVE_IOC\n \
Image-HD-Partition : $TEMP_PART_IMAGE\n \
Image Mount-Point  : $MOUNT_IMAGE \n  \
(only needed for Non-ISO9660-CD's) \n\n\
Do you want to start the verify now?" 21 70
  if [ $? = 1 ]; then		#We clicked on NO
   continue;
  fi
 rm -f /tmp/SeTverify
$DIALOG --title "Compare CD->Image (PASS 1)" --infobox \
"\n             PLEASE WAIT" 5 40

 $ISOVFY $SOURCE_CD_DRIVE_IOC >/tmp/SeTverify1

# check if this is really an iso9660-CD.
  $ISODETECT -d $SOURCE_CD_DRIVE_IOC >/dev/null
  if [ $? = 0 ]; then
    $ISOVFY $TEMP_PART_IMAGE >/tmp/SeTverify2
  else
    AutoMountData;
    $ISOVFY $MOUNT_IMAGE/noniso.raw >/tmp/SeTverify2 
  fi 

 echo "----------------------------------------------------------" >/tmp/SeTverify
 echo "|         Results of Compare CD->Image (PASS 1)          |" >>/tmp/SeTverify
 echo "----------------------------------------------------------" >>/tmp/SeTverify
 echo " " >>/tmp/SeTverify
 echo "Differences of \"isovfy\" on CD-Rom and Image : " >>/tmp/SeTverify
 echo "---------------------------------------------- " >>/tmp/SeTverify
 echo " " >>/tmp/SeTverify
 diff -s /tmp/SeTverify1 /tmp/SeTverify2 >>/tmp/SeTverify

 $DIALOG --title "Compare CD->Image" --textbox /tmp/SeTverify 20 75
 rm -f /tmp/SeTverify 
 rm -f /tmp/SeTverify1
 rm -f /tmp/SeTverify2

# check if this is really an iso9660-CD.
  $ISODETECT -d $SOURCE_CD_DRIVE_IOC >/dev/null
  if [ $? = 0 ]; then
  
 CDISOSIZE="`$ISOSIZE $SOURCE_CD_DRIVE_IOC`"

$CMP2 -S $CDISOSIZE $SOURCE_CD_DRIVE_IOC $TEMP_PART_IMAGE 2>/tmp/SeTcmpstatus \
| $DIALOG --title "Compare CD->Image (PASS 2)" --guage \
"\nHere we do a byte-by-byte compare between CD-Rom and Image.\n\
This takes exactly as long as the reading of the image.\n\
But experience shows that you can abort this test after a few\n\
moments. To do that press CTRL-C.\n\
\n                        PLEASE WAIT" 13 67 0 

else
 $DIALOG --title "Compare CD->Image (PASS 2)" --infobox \
"\nHere we do a byte-by-byte compare between CD-Rom and Image.\n\
This takes exactly as long as the reading of the image.\n\
But experience shows that you can abort this test after a few\n\
moments. To do that press CTRL-C.\n\
\n                        PLEASE WAIT" 13 67  

 $CMP2 $SOURCE_CD_DRIVE_IOC $MOUNT_IMAGE/noniso.raw 2>/tmp/SeTcmpstatus 

fi
 
CMPNOTOK=`fgrep "differ" /tmp/SeTcmpstatus`
rm -f /tmp/SeTcmpstatus

 if [ "$CMPNOTOK" ]; then
   $DIALOG --title "Compare CD->Image (PASS 2)" --msgbox "\n\
              WARNING! \n\
           VERIFY FAILED. \n\n\
    You should reread the Image.\n" 10 40 
   continue;
 fi

  $DIALOG --title "Compare CD->Image" --yesno "\n             PROCESS FINISHED\n\n\
 Do you want to go to the WRITE part now?" 9 50  
  if [ $? = 0 ]; then
   MAINSELECTCDDATA="WRITE"
  fi

fi

#---------WRITE----------

if [ "$MAINSELECTCDDATA" = "WRITE" ]; then
$DIALOG --title "Write CD-Image" --yesno \
"\nCopying of the image onto a CD-Recordable:\n\n \
Image HD-Partition : $TEMP_PART_IMAGE\n \
CD-Writer-Device   : $DEST_CD_WRITER\n \
Dummy-Writer-Mode  : $DUMMY_MODE\n\n\
Are you sure that the devices are correctly set?" 13 70
  if [ $? = 1 ]; then		#We clicked on NO
   continue;
  fi

# check if this is really an iso9660-image
  $ISODETECT -d $TEMP_PART_IMAGE >/dev/null 2>/dev/null
  if [ $? = 0 ]; then

  $DIALOG --msgbox "\n  Put the CD-Recordable into the CD-Writer." 7 50 

  CDISOSIZE="`$ISOSIZE $TEMP_PART_IMAGE`"
  STARTTIME="`date +%T`"
  $DIALOG --title "Copying Image->CD" --infobox \
"\nThe writing of an image of a full CD takes up to \n\
40 min, when using a double-speed CD-Writer. A full CD \n\
contains approx. 680000000 bytes.\n\n\
This image contains $CDISOSIZE bytes.\nStarttime : $STARTTIME\n\n\
                      PLEASE WAIT" 12 60 

  if [ "$DUMMY_MODE" = "Off" ]; then

# This line works for CDWRITE-1.5
#    $CDWRITE -v -speed $CDWSPEED $DEST_CD_WRITER -bytes $CDISOSIZE $TEMP_PART_IMAGE

     $CDWRITE -v -e -s $CDWSPEED --$CDW_MODEL -D $DEST_CD_WRITER -b $CDISOSIZE $TEMP_PART_IMAGE 
  else

# This line works for CDWRITE-1.5
#    $CDWRITE -v -dummy -speed $CDWSPEED $DEST_CD_WRITER -bytes $CDISOSIZE $TEMP_PART_IMAGE

     $CDWRITE -vy -e -s $CDWSPEED --$CDW_MODEL -D $DEST_CD_WRITER -b $CDISOSIZE $TEMP_PART_IMAGE 
  fi
  
else

  AutoMountData;

  $DIALOG --title "Warning" --yesno \
"\nI am ready to write a Non-ISO9660-CD. If you don't want that, \n\
or if this is an error, quit now.\n\n\
Are you sure you want to continue?" 10 70 
  if [ $? = 1 ]; then		#We clicked on NO
   continue;
  fi

  $DIALOG --msgbox "\n  Put the CD-Recordable into the CD-Writer." 7 50 

  CDISOSIZE="`$CAT2 -x $MOUNT_IMAGE/noniso.raw`"
  STARTTIME="`date +%T`"
  $DIALOG --title "Copying Image->CD" --infobox \
"\nThe writing of an image of a full CD takes up to \n\
40 min, when using a double-speed CD-Writer. A full CD \n\
contains approx. 680000000 bytes.\n\n\
This image contains $CDISOSIZE bytes.\nStarttime : $STARTTIME\n\n\
                      PLEASE WAIT" 12 60 

  if [ "$DUMMY_MODE" = "Off" ]; then

# This line works for CDWRITE-1.5
#    $CDWRITE -v -speed $CDWSPEED $DEST_CD_WRITER $MOUNT_IMAGE/noniso.raw
 
     $CDWRITE -v -e -s $CDWSPEED --$CDW_MODEL -D $DEST_CD_WRITER $MOUNT_IMAGE/noniso.raw 
  else

# This line works for CDWRITE-1.5
#    $CDWRITE -v -dummy -speed $CDWSPEED $DEST_CD_WRITER $MOUNT_IMAGE/noniso.raw

     $CDWRITE -vy -e -s $CDWSPEED --$CDW_MODEL -D $DEST_CD_WRITER $MOUNT_IMAGE/noniso.raw 
  fi

fi

  $DIALOG --title "Copying Image->CD" --msgbox "\n              PROCESS FINISHED"\
  7 50
fi

#---------EXIT----------

if [ "$MAINSELECTCDDATA" = "EXIT" ]; then
 UmountData;
 break;
fi

done
