#!/bin/bash
# Subprogram for CDWTOOLS 
# Read and write Audio-CD's and Mixed-Mode-CD

##########################################################
# 16.10.95 T.Niederreiter
##########################################################

reset

AutoMountAudio() {
#create directory to store audio-tracks
$MKDIRHIER $MOUNT_AUDIO

#Auto-mount the audio-track-partition if needed.
#checks if partition is already mounted or if partition is valid or
#if there is an ext2-fs on the partition. If not, format partition

if [ $TEMP_PART_AUDIO != "none" ]; then
#check if the partition is already mounted.
 mount >/tmp/SeTmounted
 fgrep "$TEMP_PART_AUDIO" /tmp/SeTmounted >/dev/null
 if [ $? = 1 ]; then		#is NOT mounted, so do it now
  mount -t ext2 $TEMP_PART_AUDIO $MOUNT_AUDIO 2>/tmp/SeTmounted
  if [ $? = 1 ]; then		# mount failed 
   fgrep "valid" /tmp/SeTmounted >/dev/null
   if [ $? = 0 ]; then		# no such device
    $DIALOG --title "Error" --msgbox "\n Unable to mount Audio-HD-Partition \
$TEMP_PART_AUDIO: No such device\n\n\
 Are you sure you connected all external drives you may need?\n\n\
If you want mount another partition (or none), set in the next\n\
menu a new Audio-HD-Partition." 12 70
    TEMP_PART_AUDIO="none"
    rm -f /tmp/SeTmounted
    return;			# back to caller 
   else			# perhaps wrong filesystem
    $DIALOG --title "Error" --yesno "\n Unable to mount Audio-HD-Partition \
$TEMP_PART_AUDIO: No filesystem\n\n\
 Shall I create an ext2-filesystem on this device? WARNING,\n all data on that \
partition will be lost!\n\n\
If you want mount another partition (or none), set in the next\n\
menu a new Audio-HD-Partition (and say NO now)." 13 70
     if [ $? = 1 ]; then		#We clicked on NO
       TEMP_PART_AUDIO="none"
       rm -f /tmp/SeTmounted
       return;
     fi
     $DIALOG --title "Formating" --infobox "\n      Creating an ext2-fs on $TEMP_PART_AUDIO\n\n\
                PLEASE WAIT" 7 50
     mke2fs $TEMP_PART_AUDIO

     $DIALOG --title "Formating" --msgbox "\n         PROCESS FINISHED" 7 40
     rm -f /tmp/SeTmounted
     AutoMountAudio; # Now we can mount it, hopefully
     return;
   fi	 
  fi
  $DIALOG --msgbox "\n     Mounted Audio-HD-Partition $TEMP_PART_AUDIO\
 on $MOUNT_AUDIO\n\n\
If you want mount another partition (or none), set in the next\n\
menu a new Audio-HD-Partition." 10 70
 fi
 rm -f /tmp/SeTmounted
fi
}

UmountAudio() {
# umount audio-partition

 if [ $TEMP_PART_AUDIO != "none" ]; then
  umount $MOUNT_AUDIO 2>/dev/null
  if [ $? = 0 ]; then
   $DIALOG --msgbox "\n   Unmounted Audio-HD-Partition $TEMP_PART_AUDIO" 7 50
  fi
 fi
}

#Trying to mount audio-partiton 
AutoMountAudio;

# Mainloop

while [ 0 ]; do

#--------------MAINMENU---------

#Calculate free space on filesystem
df -k $MOUNT_AUDIO >/tmp/SeTfreespace
sed -n "2 p" /tmp/SeTfreespace | tr -s " " >/tmp/SeTfreespace2
FREESPACE=`cut -f 4 -d " " /tmp/SeTfreespace2`
FREETIME=`expr $FREESPACE \* 1024`
FREETIME=`$CAT2 -y $FREETIME` 	#show time-code
rm -f /tmp/SeTfreespace /tmp/SeTfreespace2 

$DIALOG --title "Copy Audio-CD $SCRIPT_VERSION" --menu \
"\nFunctions for handling Audio- and Mixed-Mode-CD's.\nFree space for Audio-tracks: $FREESPACE kb \
($FREETIME)\n" \
21 76 11 \
"TEMP_A" "Set HD-Partition for Audio-Data  [now: $TEMP_PART_AUDIO]" \
"MOUNTA" "Set Mountpoint for Audio-Tracks  [now: $MOUNT_AUDIO]" \
"NAME" "Define filename for Audio-files  [now: $AUDIO_FILENAME]" \
"ORDER" "Swap byte-order for Audio-Tracks [now: $SWAP_BYTE_ORDER]" \
"      " "---------------------------------------------------------" \
"INFO" "View tracks of Audio-CD" \
"READ" "Read digital Audio-tracks" \
"LISTEN" "Listen to Audio-tracks" \
"WRITE" "Write Audio-CD" \
"DELETE" "Delete Audio-tracks" \
"EXIT" "Exit Menu" 2> /tmp/SeTaudiomain
 if [ $? = 1 -o $? = 255 ]; then 	#Cancel choosen
  echo "EXIT" >/tmp/SeTaudiomain        #Simulate EXIT
 fi
MAINSELECTCDAUDIO="`cat /tmp/SeTaudiomain`"
rm -f /tmp/SeTaudiomain

#---------------TEMP_A-MENU---------------

if [ "$MAINSELECTCDAUDIO" = "TEMP_A" ]; then
$DIALOG --title "Set HD-Partition for Audio-Data?" --yesno \
"\nThis partition is used to store Audio-tracks on the harddrive.\nThe \
partition will be formatted and mounted if necessary. It\nshould be \
about 700 MB in size. If you enter \"none\" then no\npartition will \
be prepared. This is useful if you want write the\ntracks on a premounted \
or local directory.\n\n\
Are you sure you want to change the HD-Partition for Audio-Data?" 13 70
  if [ $? = 1 ]; then           #We clicked on NO
   continue;
  fi
  $DIALOG --inputbox "HD-Partition for Audio-Data?\n\n\
Valid inputs are e.g. /dev/sdb2 or \n/dev/sdb3 or \"none\"" 12 42 2> /tmp/SeTtemp 
if [ -s /tmp/SeTtemp ]; then

   UmountAudio;

   TEMP_PART_AUDIO="`cat /tmp/SeTtemp`"

#Security
if [ `fgrep -c $TEMP_PART_AUDIO /tmp/SeTsecu` = 1 ]; then
  $DIALOG --msgbox "\n       You've entered a locked device.\n         Please \
choose another one!" 8 50
  TEMP_PART_AUDIO="none"
fi
#Security off

   AutoMountAudio;

  else
   rm -f /tmp/SeTtemp
   continue
  fi
  rm -f /tmp/SeTtemp
fi

#---------------MOUNTA-MENU---------------

if [ "$MAINSELECTCDAUDIO" = "MOUNTA" ]; then
$DIALOG --title "Set Mountpoint for Audio-Tracks?" --yesno \
"\nWhen you read in Audio-Tracks this is the path where they will be\nstored. \
Actually this is the mountpoint where the HD-Partition\nfor the Audio-Data \
will be mounted. If you choosed \"none\" as \
your\nAudio-HD-Partition, nothing will be mounted. \n\n\
Are you sure you want to change the mountpoint?" 12 70
  if [ $? = 1 ]; then           #We clicked on NO
   continue;
  fi

  $DIALOG --inputbox "Mountpoint for Audio-Tracks?\n\n\
Valid inputs are e.g. /mnt or /mnt2" 12 42 2> /tmp/SeTmount
  if [ -s /tmp/SeTmount ]; then
   UmountAudio;
   MOUNT_AUDIO="`cat /tmp/SeTmount`"
   AutoMountAudio;
  else
   rm -f /tmp/SeTmount
   continue
  fi
  rm -f /tmp/SeTmount
fi

#---------INFO----------

if [ "$MAINSELECTCDAUDIO" = "INFO" ]; then
  $CDDA2CDR -D$SOURCE_CD_DRIVE_GEN -fio >/tmp/SeTaudioinfo
  $DIALOG --title "Audio-CD Information" --textbox /tmp/SeTaudioinfo 20 75
  rm -f /tmp/SeTaudioinfo
fi


#---------------NAME---------------

if [ "$MAINSELECTCDAUDIO" = "NAME" ]; then
$DIALOG --title "Define Filename" --yesno \
"\nHere you can specify under which filename the Audio-\ntracks should be \
written on the harddisk. The real\nfilename is \"<filename><trackno>.cdr\". \n\
Data-Tracks from Mixed-Mode-CD's get the extension\n\
 \".raw\"\n\n\
Are you sure you want to change the name?" \
 13 60
  if [ $? = 1 ]; then		#We clicked on NO
   continue;
  fi
  $DIALOG --inputbox "\nNew filename for Audio-tracks?\n" 10 42 2> /tmp/SeTaudioname
  if [ -s /tmp/SeTaudioname ]; then
   AUDIO_FILENAME="`cat /tmp/SeTaudioname | tr -d " "`"
  else
   rm -f /tmp/SeTaudioname
   continue
  fi
  rm -f /tmp/SeTaudioname
fi

#---------ORDER---------

if [ "$MAINSELECTCDAUDIO" = "ORDER" ]; then
 if [ "$SWAP_BYTE_ORDER" = "Off" ]; then
    $DIALOG --title "Swap-Byte-Order ON?" --yesno \
"\nDo you want to swap the byte-order of the Audio-Tracks?\n\n\
Most CD-Writers need their Audio-Data in the big-endian format\n\
which is active now. When you swap the byte-order the Audio-Data\n\
will be handeled litte-endian. \n\
If you are unsure you should leave this setting at 'Off' when you\n\
read and write Audio-Data with a Philips or HP Writer. The Yamaha\n\
requires here an 'On'." 15 70 
  if [ $? = 1 ]; then           #We clicked on NO
   continue;
  fi
  SWAP_BYTE_ORDER="On"
  continue
 fi
 if [ "$SWAP_BYTE_ORDER" = "On" ]; then
    $DIALOG --title "Swap-Byte-Order OFF?" --yesno \
"\nDo you want to swap the byte-order of the Audio-Tracks?\n\n\
At the moment the setting is little-endian, which is needed e.g.\n\
for the Yamaha Writer. When you use a Philips or HP Writer for\n\
Audioread and write you should set this back to 'Off' now." 12 70 
  if [ $? = 1 ]; then           #We clicked on NO
   continue;
  fi
  SWAP_BYTE_ORDER="Off"
 fi
fi

#---------READ----------

if [ "$MAINSELECTCDAUDIO" = "READ" ]; then

if [ "$SWAP_BYTE_ORDER" = "Off" ]; then
  SWAPFLAG=" ";
else 
  SWAPFLAG="-x";
fi

cat << EOF >/tmp/SeTtmpscript
$DIALOG --title "Choose Audio-tracks" --checklist \
"\nUse spacebar to select the Audio-tracks to read.\n\
_____________________________________________________________________\n\
       Track  pre-   copy-  Type  Chan. Sub-Q-channel     Time\n\
             empha. permit." 22 75 11 \\
EOF
$CDDA2CDR -D$SOURCE_CD_DRIVE_GEN -fmv >>/tmp/SeTtmpscript
 echo "2> /tmp/SeTaudioreturn" >>/tmp/SeTtmpscript
source /tmp/SeTtmpscript 

#find out if there is a DATA-Track on that CD
fgrep "DATA" /tmp/SeTtmpscript >/dev/null
if [ $? = 0 ]; then
  DATATRACKFOUND=1
else
  DATATRACKFOUND=0
fi

#this writes the selected tracks into the variable in the form "01 02 13"
CHOOSENTRACKS="`cat /tmp/SeTaudioreturn | tr -d "\042"`"
rm -f /tmp/SeTtmpscript /tmp/SeTaudioreturn

  clear
  for ILOOP in $CHOOSENTRACKS; do
   if [ $ILOOP = "01" -a $DATATRACKFOUND = 1 ]; then
    echo "-------- DATA-TRACK 01 ---------"

    CDISOSIZE="`$ISOSIZE $SOURCE_CD_DRIVE_IOC`"
    STARTTIME="`date +%T`"

 $CAT2 -S $CDISOSIZE $SOURCE_CD_DRIVE_IOC -o $MOUNT_AUDIO/$AUDIO_FILENAME$ILOOP.raw 2>/dev/null \
 | $DIALOG --title "Copying CD->Image" --guage \
"\nThis process can take up to 75 min. when copying with a \n\
single speed drive a full CD. A full CD contains \n\
approx. 680000000 bytes. \n\n\
This CD contains $CDISOSIZE bytes.\nStarttime: $STARTTIME\n\n\
                      PLEASE WAIT" 15 60 0

    clear 
   else
    echo "---------- Track $ILOOP ------------"
    $CDDA2CDR -D$SOURCE_CD_DRIVE_GEN $SWAPFLAG -t $ILOOP $MOUNT_AUDIO/$AUDIO_FILENAME$ILOOP.cdr 
   fi
  done
fi 

#---------LISTEN----------

if [ "$MAINSELECTCDAUDIO" = "LISTEN" ]; then

if [ "$SWAP_BYTE_ORDER" = "Off" ]; then
  SWAPFLAG=" ";
else 
  SWAPFLAG="-x";
fi

  ILOOP=`ls $MOUNT_AUDIO/*.cdr 2>/dev/null`
   if [ -z "$ILOOP" ]; then
    $DIALOG --title "Error" --msgbox "\n       No Audio-tracks found!" 7 40
    continue;
   fi

 $DIALOG --title "Scanning" --infobox "\n     Scanning for Audio-tracks" 5 40

 rm -f /tmp/SeTselectedaudio /tmp/SeTselectedaudio2
# for case if we select nothing..then we need that file
touch /tmp/SeTselectedaudio2

cat <<EOF >/tmp/SeTtmpscript 
$DIALOG --title "Select the Track" --radiolist "Select the track \
you want listen to.\nYou can abort playing with CTRL-C. \n\
_____________________________________________________________________\n
         Track           Filename          Size (bytes)  Length " 22 75 11 \\
EOF
 ICOUNT=1
 for ILOOP in `ls $MOUNT_AUDIO/*.cdr`; do
 TRACKLNG=`$CAT2 -x $ILOOP` 
 echo $ILOOP >>/tmp/SeTselectedaudio
  printf " \" %02d\" \"%30s %12d %8s\" off " $ICOUNT $ILOOP \
   $TRACKLNG `$CAT2 -y $TRACKLNG` >>/tmp/SeTtmpscript
  echo "\\" >>/tmp/SeTtmpscript
  ICOUNT=`expr $ICOUNT + 1`
 done
 echo "2> /tmp/SeTaudioreturn" >>/tmp/SeTtmpscript
 source /tmp/SeTtmpscript
 if [ $? = 1 -o $? = 255 ]; then 	#Cancel choosen
  continue; 			
 fi

 LISTENTRACKNR="`cat /tmp/SeTaudioreturn`"
 LISTENTRACK=`sed -n "$LISTENTRACKNR p" /tmp/SeTselectedaudio` 

 if [ -z "$LISTENTRACKNR" ]; then 
    continue; 			# No track choosen
 fi

 rm -f /tmp/SeTselectedaudio /tmp/SeTselectedaudio2 /tmp/SeTtmpscript

 $DIALOG --title "Playing Track" --infobox "\n  Playing track $LISTENTRACK" \
 5 50

 $PLAYCDR -q $SWAPFLAG $LISTENTRACK

fi

#--------WRITE----------
# This is gonna be complicated *sweat*

if [ "$MAINSELECTCDAUDIO" = "WRITE" ]; then

  ILOOP=`ls $MOUNT_AUDIO/*.raw $MOUNT_AUDIO/*.cdr 2>/dev/null`
   if [ -z "$ILOOP" ]; then
    $DIALOG --title "Error" --msgbox "\n       No Audio-tracks found!" 7 40
    continue;
   fi

 $DIALOG --title "Scanning" --infobox "\n     Scanning for Audio-tracks" 5 40

rm -f /tmp/SeTselectedaudio /tmp/SeTselectedaudio2
# for case if we select nothing..then we need that file
touch /tmp/SeTselectedaudio2

cat <<EOF >/tmp/SeTtmpscript 
$DIALOG --title "Select Tracks To Write" --checklist "Select the tracks \
you want to write on CD.\nPlease take care about the maximum lenght of a CD \
(aprox. 70min)\n\
_____________________________________________________________________\n
         Track           Filename          Size (bytes)  Length " 22 75 11 \\
EOF
 ICOUNT=1
 for ILOOP in `ls -f $MOUNT_AUDIO/*.raw $MOUNT_AUDIO/*.cdr 2>/dev/null`; do
 TRACKLNG=`$CAT2 -x $ILOOP` 
 echo $ILOOP >>/tmp/SeTselectedaudio
  printf " \" %02d\" \"%30s %12d %8s\" on " $ICOUNT $ILOOP \
   $TRACKLNG `$CAT2 -y $TRACKLNG` >>/tmp/SeTtmpscript
  echo "\\" >>/tmp/SeTtmpscript
  ICOUNT=`expr $ICOUNT + 1`
 done
 echo "2> /tmp/SeTaudioreturn" >>/tmp/SeTtmpscript
 source /tmp/SeTtmpscript
 if [ $? = 1 -o $? = 255 ]; then 	#Cancel choosen
  continue; 			
 fi
  CHOOSENTRACKS="`cat /tmp/SeTaudioreturn | tr -d "\042"`"
  rm -f /tmp/SeTtmpscript /tmp/SeTaudioreturn

# write selected track-filenames into tmp-file 
 for ILOOP in $CHOOSENTRACKS; do
  INAME=`sed -n "$ILOOP p" /tmp/SeTselectedaudio` 
  echo $INAME >>/tmp/SeTselectedaudio2
 done

 $DIALOG --title "Processing" --infobox "\n         One Moment, Please" 5 40
 rm -f /tmp/SeTselectedaudio
 touch /tmp/SeTselectedaudio

cat <<EOF >/tmp/SeTtmpscript 

The track-layout so far:
If you want to change the sequence of the tracks, you have to write
down your prefered order now. In the next screen you can enter the
new order.

      Track              Filename          Size (bytes)  Length 
_____________________________________________________________________
EOF
 ICOUNT=1
 FULLTRACKLNG=0
 for ILOOP in `cat /tmp/SeTselectedaudio2`; do
 TRACKLNG=`$CAT2 -x $ILOOP` 
 echo $ILOOP >>/tmp/SeTselectedaudio
  printf "       %02d %30s %12d %8s\n" $ICOUNT $ILOOP \
   $TRACKLNG `$CAT2 -y $TRACKLNG` >>/tmp/SeTtmpscript
  ICOUNT=`expr $ICOUNT + 1`
  FULLTRACKLNG=`expr $FULLTRACKLNG + $TRACKLNG`
 done
 echo "_____________________________________________________________________" >>/tmp/SeTtmpscript
 printf "                                  Total: %12d %8s\n" \
  $FULLTRACKLNG `$CAT2 -y $FULLTRACKLNG` >>/tmp/SeTtmpscript
 $DIALOG --title "Track-Layout" --textbox /tmp/SeTtmpscript 22 75 

 $DIALOG --title "Change Track-Sequence?" --yesno "\nDo you want change the \
track-\nsequence shown before?" 8 40
  if [ $? = 0 ]; then		#We clicked on YES 
    $DIALOG --title "New Sequence" --inputbox "\nEnter the number of the tracks, \
seperated by\nspaces.\n" 11 50 2> /tmp/SeTaudiosequence
    if [ -s /tmp/SeTaudiosequence ]; then
     CHOOSENTRACKS=`cat /tmp/SeTaudiosequence`
    else
     rm -f /tmp/SeTaudiosequence
     continue
    fi

   rm -f /tmp/SeTselectedaudio2
   touch /tmp/SeTselectedaudio2

  # write selected track-filenames into tmp-file 
   for ILOOP in $CHOOSENTRACKS; do
    INAME=`sed -n "$ILOOP p" /tmp/SeTselectedaudio` 
    echo $INAME >>/tmp/SeTselectedaudio2
   done

 $DIALOG --title "Processing" --infobox "\n         One Moment, Please" 5 40
 rm -f /tmp/SeTselectedaudio
 touch /tmp/SeTselectedaudio

cat <<EOF >/tmp/SeTtmpscript 

Final track-layout:

      Track              Filename          Size (bytes)  Length 
_____________________________________________________________________
EOF
 ICOUNT=1
 FULLTRACKLNG=0
 for ILOOP in `cat /tmp/SeTselectedaudio2`; do
 TRACKLNG=`$CAT2 -x $ILOOP` 
 echo $ILOOP >>/tmp/SeTselectedaudio
  printf "       %02d %30s %12d %8s\n" $ICOUNT $ILOOP \
   $TRACKLNG `$CAT2 -y $TRACKLNG` >>/tmp/SeTtmpscript
  ICOUNT=`expr $ICOUNT + 1`
  FULLTRACKLNG=`expr $FULLTRACKLNG + $TRACKLNG`
 done
 echo "_____________________________________________________________________" >>/tmp/SeTtmpscript
 printf "                                  Total: %12d %8s\n" \
  $FULLTRACKLNG `$CAT2 -y $FULLTRACKLNG` >>/tmp/SeTtmpscript
 $DIALOG --title "Track-Layout" --textbox /tmp/SeTtmpscript 22 75 

  fi

  rm -f /tmp/SeTselectedaudio2 /tmp/SeTtmpscript /tmp/SeTaudiosequence

#we are now ready to write the tracks listed in /tmp/SeTselectedaudio
 if [ "$DUMMY_MODE" = "Off" ]; then

#THIS LINE WORKS FOR CDWRITE 1.5
#  echo -n "$CDWRITE -v -speed $CDWSPEED $DEST_CD_WRITER " >/tmp/SeTwriteaudio

   echo -n "$CDWRITE -v -s $CDWSPEED --$CDW_MODEL -D $DEST_CD_WRITER " >/tmp/SeTwriteaudio
 else

#THIS LINE WORKS FOR CDWRITE 1.5
#  echo -n "$CDWRITE -v -dummy -speed $CDWSPEED $DEST_CD_WRITER " >/tmp/SeTwriteaudio

   echo -n "$CDWRITE -vy -s $CDWSPEED --$CDW_MODEL -D $DEST_CD_WRITER " >/tmp/SeTwriteaudio

 fi

# Seperate Data and Audio Tracks
  awk '/raw/' /tmp/SeTselectedaudio >/tmp/SeTselecteddata
  awk \!'/raw/' /tmp/SeTselectedaudio >/tmp/SeTselectedaudio2
  mv -f /tmp/SeTselectedaudio2 /tmp/SeTselectedaudio

# Prepare DATA-Tracks
  if [ -s /tmp/SeTselecteddata ]; then
#THIS LINE WORKS FOR CDWRITE 1.5
#   echo -n "-data " >>/tmp/SeTwriteaudio
   echo -n "--data " >>/tmp/SeTwriteaudio
   for ILOOP in `cat /tmp/SeTselecteddata`; do
    echo -e "\\" >>/tmp/SeTwriteaudio
    echo -ne "$ILOOP " >>/tmp/SeTwriteaudio
   done
  fi

# Prepare AUDIO-Tracks
  if [ -s /tmp/SeTselectedaudio ]; then
#THIS LINE WORKS FOR CDWRITE 1.5
#   echo -n "-audio " >>/tmp/SeTwriteaudio
   echo -n "--audio " >>/tmp/SeTwriteaudio
   for ILOOP in `cat /tmp/SeTselectedaudio`; do
    echo -e "\\" >>/tmp/SeTwriteaudio
    echo -ne "$ILOOP " >>/tmp/SeTwriteaudio
   done
   echo -e "\n" >>/tmp/SeTwriteaudio
  fi

  rm -f /tmp/SeTselectedaudio /tmp/SeTselecteddata

  $DIALOG --title "Write Audio-CD" --yesno "\nWe are ready to write an \
Audio-CD:\n\n Number of Tracks : `echo $CHOOSENTRACKS | wc -w`\n\
 Total Time        : `$CAT2 -y $FULLTRACKLNG`\n\
 CD-Writer-Device  : $DEST_CD_WRITER\n\
 Dummy-Writer-Mode : $DUMMY_MODE\n\n\
Are you sure you want to start?" 14 70
  if [ $? = 1 ]; then           #We clicked on NO
   continue;
  fi
  $DIALOG --msgbox "\n  Put the CD-Recordable into the CD-Writer." 7 50
  $DIALOG --title "Writing Audio-CD" --infobox "\n   Writing Audio-CD, please wait" 5 40 
  source /tmp/SeTwriteaudio
  $DIALOG --title "Write Audio-CD" --msgbox "\n         PROCESS FINISHED" 7 40
  rm -f /tmp/SeTwriteaudio
fi

#---------DELETE----------

if [ "$MAINSELECTCDAUDIO" = "DELETE" ]; then

  ILOOP=`ls $MOUNT_AUDIO/*.raw $MOUNT_AUDIO/*.cdr 2>/dev/null`
   if [ -z "$ILOOP" ]; then
    $DIALOG --title "Error" --msgbox "\n       No Audio-tracks found!" 7 40
    continue;
   fi

 $DIALOG --title "Scanning" --infobox "\n     Scanning for Audio-tracks" 5 40

rm -f /tmp/SeTselectedaudio /tmp/SeTselectedaudio2
# for case if we select nothing..then we need that file
touch /tmp/SeTselectedaudio2

cat <<EOF >/tmp/SeTtmpscript 
$DIALOG --title "Select Tracks To Delete" --checklist "\nSelect the tracks \
you want to delete from the Audio-HD-Partition.\n\n\
                 WARNING! No undelete possible!\n\
_____________________________________________________________________\n\
         Track           Filename          Size (bytes)  Length " 23 75 11 \\
EOF
 ICOUNT=1
 for ILOOP in `ls -f $MOUNT_AUDIO/*.raw $MOUNT_AUDIO/*.cdr 2>/dev/null`; do
 TRACKLNG=`$CAT2 -x $ILOOP` 
 echo $ILOOP >>/tmp/SeTselectedaudio
  printf " \" %02d\" \"%30s %12d %8s\" off " $ICOUNT $ILOOP \
   $TRACKLNG `$CAT2 -y $TRACKLNG` >>/tmp/SeTtmpscript
  echo "\\" >>/tmp/SeTtmpscript
  ICOUNT=`expr $ICOUNT + 1`
 done
 echo "2> /tmp/SeTaudioreturn" >>/tmp/SeTtmpscript
 source /tmp/SeTtmpscript
 if [ $? = 1 -o $? = 255 ]; then 	#Cancel choosen
  rm -f /tmp/SeTtmpscript /tmp/SeTaudioreturn
  continue; 			
 fi
  CHOOSENTRACKS="`cat /tmp/SeTaudioreturn | tr -d "\042"`"
  rm -f /tmp/SeTtmpscript /tmp/SeTaudioreturn

# write selected track-filenames into tmp-file 
ICOUNT=0
 for ILOOP in $CHOOSENTRACKS; do
  INAME=`sed -n "$ILOOP p" /tmp/SeTselectedaudio` 
  echo $INAME >>/tmp/SeTselectedaudio2
  ICOUNT=`expr $ICOUNT + 1`
 done

if [ $ICOUNT = 0 ]; then
   rm -f /tmp/SeTselectedaudio /tmp/SeTselectedaudio2
   continue;
fi

 $DIALOG --title "Delete Tracks?" --yesno "\n Are you sure you want to \
delete $ICOUNT tracks?" 7 50 
  if [ $? = 1 ]; then		#We clicked on NO
   rm -f /tmp/SeTselectedaudio /tmp/SeTselectedaudio2
   continue;
  fi

 $DIALOG --title "Processing" --infobox "\n         One Moment, Please" 5 40
 for ILOOP in `cat /tmp/SeTselectedaudio2`; do
  rm $ILOOP
 done
fi 

#---------EXIT----------

if [ "$MAINSELECTCDAUDIO" = "EXIT" ]; then

 UmountAudio;
 reset
 break
fi

done
