/*  cdrdao - write audio CD-Rs in disc-at-once mode
 *
 *  Copyright (C) 1998  Andreas Mueller <mueller@daneb.ping.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __PLEXTOR_READER_H__
#define __PLEXTOR_READER_H__

#include "CdrDriver.h"

class Toc;
class Track;

class PlextorReader : public CdrDriver {
public:

  PlextorReader(ScsiIf *scsiIf, Toc *);
  static CdrDriver *instance(ScsiIf *scsiIf, Toc *);

  int speed(int);

  int loadUnload(int) const { return 0; }

  int initDao();
  int startDao();
  int finishDao();

  Toc *readDiscToc();
private:
  int modeSelectPlay(int immediate, int sotc, unsigned char volume);

  int readCatalog(Toc *);
  void playAudioBlock(long start);
  int readIsrc(int trackNr, Track *track);
  int readSubChannelData(int *trackNr, int *indexNr, long *);
  long findPregap(int trackNr, long trackStart, long trackLength);

};

#endif
