/*  cdrdao - write audio CD-Rs in disc-at-once mode
 *
 *  Copyright (C) 1998  Andreas Mueller <mueller@daneb.ping.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __CDD2600_H__
#define __CDD2600_H__

#include "CdrDriver.h"

class Toc;
class Track;

class CDD2600 : public CdrDriver {
public:

  CDD2600(ScsiIf *scsiIf, Toc *);
  static CdrDriver *instance(ScsiIf *scsiIf, Toc *);

  int speed(int);

  int loadUnload(int) const;
  
  int initDao();
  int startDao();
  int finishDao();

  Toc *readDiscToc();
private:
  long leadInLength_;
  long leadOutLength_;

  int modeSelectBlockSize(int blockSize);
  int modeSelectSpeed();
  int modeSelectCatalog(const Toc *);
  int modeSelectPlay(int immediate, int sotc, unsigned char volume);

  int readSessionInfo();
  int writeSession(const Toc *);

  int writeZeros(long count) const;

  int readCatalog(Toc *);
  void playAudioBlock(long start);
  int readIsrc(int trackNr, Track *track);
  int readSubChannelData(int *trackNr, int *indexNr, long *);
  long findPregap(int trackNr, long trackStart, long trackLength);



};

#endif
