/*
 *  Copyright (C) 1998  Jesper Pedersen <jews@imada.ou.dk>
 *  This code is released under GNU GPL version 2 or later
 */

#include <stdio.h>            // Standard library
#include <stdlib.h>           // Standard library
#include <malloc.h>           // Memory allocation
#include <fcntl.h>            // File I/O defines
#include <strings.h>          // String functions
#include <linux/soundcard.h>  // Soundcard functins

#define DEFAULT_SPEED             44100
#define FRAMESIZE                  2352
#define DEFAULT_AUDIO_DEVICE "/dev/dsp"

int speed = DEFAULT_SPEED;   // 44100 Hz
int stereo = 1;              // Stereo
int samplesize = 16;         // 16 bit
int swap_audio = 1;          // Dont swap (CDR files)
int audio, buffer_size;      // 
int cont = 1;                // Continue flag
char *buffer;                // Audio buffer

char audiodevice[20] = DEFAULT_AUDIO_DEVICE;  // Name of audio device

void playfile(char *input) {
int fd;				// File descriptor
int len;                        // Length
int index;			// Index
char swap;                      // Swap character

    fd = open(input, O_RDONLY, 0);  // Open the source file

    while (cont) {
      if ((len = read(fd, buffer, buffer_size)) > 0) {
	if (swap_audio) {
	  // If we should swap the audio source; do it
	  for (index=0; index<len; index+=2) {
	    swap=buffer[index];
	    buffer[index]=buffer[index+1];
	    buffer[index+1]=swap;
	  }
	}
	if (write(audio, buffer, len) != len) {
	  printf("In there");
	  exit(1);
	}
      } else {
	cont=0;     // Finished reading the file
      }
    }
    
    // Close the file
    if (fd != 0) {
      close (fd);
    }
}

int main(int argc, char *argv[]) {
char *in;

     if ((argc < 2)||(argc > 3)) {
       printf("Usage: play [-x] filename\n");
       printf("Plays 44100Hz 16bit stereo .CDR or .WAV files\n");
       return 1;
     }

     if (!strcmp(argv[1],"-x")) {
       swap_audio = 0;
     }

     if (swap_audio == 0) {
       in = argv[2];
     } else {
       in = argv[1];
     }

     audio = open (audiodevice, O_WRONLY, 0);           // Open audio device
     ioctl(audio, SNDCTL_DSP_SAMPLESIZE, &samplesize);  // Set samplesize
     ioctl(audio, SNDCTL_DSP_STEREO, &stereo);          // Set stereo
     ioctl(audio, SNDCTL_DSP_SPEED, &speed);            // Set speed
     ioctl(audio, SNDCTL_DSP_GETBLKSIZE, &buffer_size); // Set buffer size
     buffer = malloc(buffer_size);                      // Allocate buffer
     playfile(in);                                      // Play file
     close (audio);                                     // Close audio device

     return 0;                                          // Exit
}
