#!/bin/sh
# 
#  Copyright (C) 1998  Jesper Pedersen <jews@imada.ou.dk>
#  This code is released under GNU GPL version 2 or later
# 
#  Usage: install.sh         for install in /usr/local/BurnIT
#         install.sh <path>  for install in <path>

# Set the destination path
if test -z $1 
then dest=/usr/local/BurnIT
else dest=$1
fi

# Remove the old installation
rm -Rf $dest

# Make destination path
mkdir $dest

# Compile the JAVA-files
echo "Compiling JAVA files ..."
javac *.java 

# Compile play
echo "Compiling play ..."
gcc play.c -o play 

# Compile cdrecord and mkisofs
echo "Compiling cdrecord and mkisofs ..."
cd cdrecord-1.6.1
./Gmake.linux 
cd ..

# Compile cdda2wav
echo "Compiling cdda2wav ..."
cd cdda2wav-0.95beta08
./configure 
make 
cd ..

# Compile encoder
echo "Compiling encoder ..."
cd encoder
./configure 
make 
cd ..

# Make the exec script
cat /dev/null > BurnIT
echo "#!/bin/sh" >> BurnIT
echo -n "cd " >> BurnIT
echo $dest >> BurnIT

java=`which java`
if test -z $java 
then java="java"
fi
echo -n $java >> BurnIT
echo " BurnIT" >> BurnIT

chmod 755 BurnIT

# Install the files
echo "Installing files ..."

# cdrecord, mkisofs, cdda2wav, encode and play
cp -f `find . -type f -name cdrecord` $dest 
cp -f `find . -type f -name mkisofs` $dest 
cp -f `find . -type f -name cdda2wav` $dest 
cp -f `find . -type f -name play` $dest 
cp -f `find . -type f -name encode` $dest 

cp -Rf encoder/tables $dest 

# CLASS-files
mv -f *.class $dest 

# Default ini-file and help for the Advanced-menu
cp -f BurnIT.ini $dest 
cp -f advanced.man $dest 

# Logo
#cp -f BurnIT.gif $dest 

# Misc text files
cp -f COPYING $dest 
cp -f Readme* $dest 
cp -f THANKS $dest 
cp -f TODO $dest 
cp -f Changelog $dest 
cp -f VERSIONS $dest 

# The exec script
mv -f BurnIT /usr/local/bin 

# Clean up
echo "Cleaning up ..."

rm -f play

cd cdda2wav-0.95beta08
make clean 
cd ..

cd encoder
make clean 
cd ..

cd cdrecord-1.6.1
./Gmake.linux clean 
cd ..
