#include <stdlib.h>
#include <stddef.h>
#include <stdio.h>
#if defined (HAVE_UNISTD_H) && (HAVE_UNISTD_H == 1)
#include <sys/types.h>
#include <unistd.h>
#endif

#if defined(HAVE_SEMCTL) && (HAVE_SEMCTL == 1)
#include <sys/ipc.h>
#include <sys/sem.h>
#endif

#include "global.h"
#include "interface.h"
#include "ringbuff.h"
#include "semshm.h"

#undef WARN_INTERRUPT

myringbuff **fill_buffer;
myringbuff **last_buffer;
static myringbuff *previous_read_buffer;
static unsigned int total_buffers;

#define FREE_SEM (0)
#define DEF_SEM (1)
#define SEMS 2

#define INC(a) (myringbuff *)(((char *)RB_BASE) + (((((char *) (a))-((char *)RB_BASE))/entry_size + 1) % total_buffers)*entry_size)

#undef _DEBUG
#include <assert.h>
#ifdef _DEBUG
static unsigned short valarr[SEMS];

static int get_snapshot(void)
{
  union my_semun mysemun;

  mysemun.array = valarr;
  return semctl(sem_id,0,GETALL,mysemun);
}

#define free_buffers() (valarr[FREE_SEM])
#define occupied_buffers() (total_buffers - valarr[FREE_SEM])
#define defined_buffers() (valarr[DEF_SEM])
#endif

void set_total_buffers(unsigned int num_buffers, int mysem_id)
{
#if defined(HAVE_SEMCTL) && (HAVE_SEMCTL == 1)
  union my_semun mysemun;

  mysemun.val   = 0;
  if (semctl(mysem_id,(int) DEF_SEM,SETVAL,mysemun) < 0) {
    perror("semctl DEF_SEM");
  }

  mysemun.val   = num_buffers;
  if (semctl(mysem_id,(int) FREE_SEM,SETVAL,mysemun) < 0) {
    perror("semctl FREE_SEM");
  }
#endif

  total_buffers = num_buffers;
  *fill_buffer = *last_buffer = previous_read_buffer = NULL;
#ifdef DEBUG_SHM
fprintf(stderr, "init: fill_b = %p,  last_b = %p\n", *fill_buffer, *last_buffer);
#endif
}

const myringbuff *get_previous_read_buffer(void)
{
  assert(previous_read_buffer != NULL);
  assert(previous_read_buffer != *fill_buffer);
  return previous_read_buffer;
}

const myringbuff *get_fill_buffer(void)
{
  assert(*fill_buffer != NULL);
  assert(previous_read_buffer != *fill_buffer);
  return *fill_buffer;
}

void define_buffer(void)
{
#ifdef _DEBUG
  get_snapshot();

  assert(defined_buffers() < total_buffers);

  fprintf(stderr,"stop  reading  %p - %p\n",
                 *fill_buffer, (char *)(*fill_buffer) + entry_size -1);
#endif

  if (*last_buffer == NULL)
    *last_buffer = *fill_buffer;
#ifdef DEBUG_SHM
fprintf(stderr, "define: fill_b = %p,  last_b = %p\n", *fill_buffer, *last_buffer);
#endif

  semrelease(sem_id,DEF_SEM, 1);
}

void drop_buffer(void)
{
#ifdef _DEBUG
  get_snapshot();
  assert(free_buffers() < total_buffers);
  assert(occupied_buffers() > 0);

  fprintf(stderr," stop  writing %p - %p ",
                 *last_buffer, (char *)(*last_buffer) + entry_size -1);
#endif

  if (*last_buffer == NULL)
    *last_buffer = *fill_buffer;
  else
    *last_buffer = INC(*last_buffer);
#ifdef DEBUG_SHM
fprintf(stderr, "drop: fill_b = %p,  last_b = %p\n", *fill_buffer, *last_buffer);
#endif
  semrelease(sem_id,FREE_SEM, 1);
}

void drop_all_buffers(void)
{
  semrelease(sem_id,FREE_SEM, total_buffers);
}

static void occupy_buffer(void)
{
#ifdef _DEBUG
  get_snapshot();
  assert(occupied_buffers() <= total_buffers);
#endif

  previous_read_buffer = *fill_buffer;

  if (*fill_buffer == NULL) {
    *fill_buffer = RB_BASE;
  } else {
    *fill_buffer = INC(*fill_buffer);
  }
}

myringbuff * get_next_buffer(void)
{
#ifdef WARN_INTERRUPT
  get_snapshot();
  if (free_buffers() <= 0) {
    fprintf(stderr, "READER waits!!\n");
  }
#endif

  /* wait for a new buffer to become available */
  if (semrequest(sem_id,FREE_SEM, 1) != 0) {
    /* semaphore operation failed.
       try again...
       */
    fprintf(stderr, "child reader sem request failed, retry\n");
    if (semrequest(sem_id,FREE_SEM, 1) != 0) {
      exit(3);
    }
  }

  occupy_buffer();

#ifdef _DEBUG
  fprintf(stderr,"start reading  %p - %p\n",
                 *fill_buffer, (char *)(*fill_buffer) + entry_size -1);
#endif
#ifdef DEBUG_SHM
fprintf(stderr, "next: fill_b = %p,  last_b = %p, @last = %p\n", *fill_buffer, *last_buffer, last_buffer);
#endif
  return *fill_buffer;
}

myringbuff *get_oldest_buffer(void)
{
  myringbuff *retval;

  /* wait for buffer to be defined */
  if (semrequest(sem_id,DEF_SEM, 1) != 0) {
    /* semaphore operation failed.
       try again...
       */
    fprintf(stderr, "parent writer sem request failed, retry\n");
    if (semrequest(sem_id,DEF_SEM, 1) != 0) {
      exit(3);
    }
  }

  retval = *last_buffer;

#ifdef _DEBUG
  fprintf(stderr," begin writing %p - %p\n",
                  retval, (char *)retval + entry_size -1);
#endif

  return retval;
}

