
#if !defined(__linux__)

/*
 * -- <linux/cdrom.h>
 * general (not only SCSI) header library for linux CDROM drivers
 * (C) 1992         David Giller rafetmad@oxy.edu
 *     1994, 1995   Eberhard Moenkeberg emoenke@gwdg.de
 *
 */

#ifndef	_LINUX_CDROM_H
#define	_LINUX_CDROM_H

/*
 * some fix numbers
 */
#define CD_MINS             74 /* max. minutes per CD, not really a limit */
#define CD_SECS             60 /* seconds per minute */
#define CD_FRAMES           75 /* frames per second */

#define CD_SYNC_SIZE        12 /* 12 sync bytes per raw data frame, not transfered by the drive */
#define CD_HEAD_SIZE         4 /* header (address) bytes per raw data frame */
#define CD_SUBHEAD_SIZE      8 /* subheader bytes per raw XA data frame */
#define CD_XA_HEAD        (CD_HEAD_SIZE+CD_SUBHEAD_SIZE) /* "before data" part of raw XA frame */
#define CD_XA_SYNC_HEAD   (CD_SYNC_SIZE+CD_XA_HEAD)/* sync bytes + header of XA frame */

#define CD_FRAMESIZE      2048 /* bytes per frame, "cooked" mode */
#define CD_FRAMESIZE_RAW  2352 /* bytes per frame, "raw" mode */
/* most drives don't deliver everything: */
#define CD_FRAMESIZE_RAW1 (CD_FRAMESIZE_RAW-CD_SYNC_SIZE) /* 2340 */
#define CD_FRAMESIZE_RAW0 (CD_FRAMESIZE_RAW-CD_SYNC_SIZE-CD_HEAD_SIZE) /* 2336 */
/* Optics drive also has a 'read all' mode: */
#define CD_FRAMESIZE_RAWER 2646 /* bytes per frame */

#define CD_EDC_SIZE         4 /* bytes EDC per most raw data frame types */
#define CD_ZERO_SIZE        8 /* bytes zero per yellow book mode 1 frame */
#define CD_ECC_SIZE       276 /* bytes ECC per most raw data frame types */
#define CD_XA_TAIL        (CD_EDC_SIZE+CD_ECC_SIZE) /* "after data" part of raw XA frame */

#define CD_FRAMESIZE_SUB    96 /* subchannel data "frame" size */
#define CD_MSF_OFFSET      150 /* MSF numbering offset of first frame */

#define CD_CHUNK_SIZE       24 /* lowest-level "data bytes piece" */
#define CD_NUM_OF_CHUNKS    98 /* chunks per frame */

#define CD_FRAMESIZE_XA CD_FRAMESIZE_RAW1 /* obsolete name */
#define CD_BLOCK_OFFSET    CD_MSF_OFFSET /* obsolete name */

/*
 * the raw frame layout:
 *
 * - audio (red):                  | audio_sample_bytes |
 *                                 |        2352        |
 *
 * - data (yellow, mode1):         | sync - head - data - EDC - zero - ECC |
 *                                 |  12  -   4  - 2048 -  4  -   8  - 276 |
 *
 * - data (yellow, mode2):         | sync - head - data |
 *                                 |  12  -   4  - 2336 |
 *
 * - XA data (green, mode2 form1): | sync - head - sub - data - EDC - ECC |
 *                                 |  12  -   4  -  8  - 2048 -  4  - 276 |
 *
 * - XA data (green, mode2 form2): | sync - head - sub - data - EDC |
 *                                 |  12  -   4  -  8  - 2324 -  4  |
 */

/*
 * CDROM IOCTL structures
 */

struct cdrom_blk 
{
	unsigned from;
	unsigned short len;
};


struct cdrom_msf 
{
	unsigned char	cdmsf_min0;	/* start minute */
	unsigned char	cdmsf_sec0;	/* start second */
	unsigned char	cdmsf_frame0;	/* start frame */
	unsigned char	cdmsf_min1;	/* end minute */
	unsigned char	cdmsf_sec1;	/* end second */
	unsigned char	cdmsf_frame1;	/* end frame */
};

struct cdrom_ti 
{
	unsigned char	cdti_trk0;	/* start track */
	unsigned char	cdti_ind0;	/* start index */
	unsigned char	cdti_trk1;	/* end track */
	unsigned char	cdti_ind1;	/* end index */
};

struct cdrom_tochdr 	
{
	unsigned char	cdth_trk0;	/* start track */
	unsigned char	cdth_trk1;	/* end track */
};

struct cdrom_msf0		/* address in MSF format */
{
	unsigned char	minute;
	unsigned char	second;
	unsigned char	frame;
};

union cdrom_addr		/* address in either MSF or logical format */
{
	struct cdrom_msf0	msf;
	int			lba;
};

struct cdrom_tocentry 
{
	unsigned int	cdte_track      :8;
	unsigned int	cdte_adr	:4;
	unsigned int	cdte_ctrl	:4;
	unsigned char	cdte_format;
	union cdrom_addr cdte_addr;
	unsigned char	cdte_datamode;
};

/*
 * CD-ROM address types (cdrom_tocentry.cdte_format)
 */
#define	CDROM_LBA 0x01 /* "logical block": first frame is #0 */
#define	CDROM_MSF 0x02 /* "minute-second-frame": binary, not bcd here! */

/*
 * bit to tell whether track is data or audio (cdrom_tocentry.cdte_ctrl)
 */
#define	CDROM_DATA_TRACK	0x04

/*
 * The leadout track is always 0xAA, regardless of # of tracks on disc
 */
#define	CDROM_LEADOUT	0xAA

struct cdrom_subchnl 
{
	unsigned char	cdsc_format;
	unsigned int	cdsc_audiostatus :8;
	unsigned int 	cdsc_adr:	4;
	unsigned int	cdsc_ctrl:	4;
	unsigned char	cdsc_trk;
	unsigned char	cdsc_ind;
	union cdrom_addr cdsc_absaddr;
	union cdrom_addr cdsc_reladdr;
};

struct cdrom_mcn {
  unsigned char medium_catalog_number[14]; /* 13 ASCII digits, null-terminated */
};

/*
 * audio states (from SCSI-2, but seen with other drives, too)
 */
#define	CDROM_AUDIO_INVALID	0x00	/* audio status not supported */
#define	CDROM_AUDIO_PLAY	0x11	/* audio play operation in progress */
#define	CDROM_AUDIO_PAUSED	0x12	/* audio play operation paused */
#define	CDROM_AUDIO_COMPLETED	0x13	/* audio play successfully completed */
#define	CDROM_AUDIO_ERROR	0x14	/* audio play stopped due to error */
#define	CDROM_AUDIO_NO_STATUS	0x15	/* no current audio status to return */

struct cdrom_volctrl
{
	unsigned char	channel0;
	unsigned char	channel1;
	unsigned char	channel2;
	unsigned char	channel3;
};

struct cdrom_read      
{
	int	cdread_lba;
	caddr_t	cdread_bufaddr;
	int	cdread_buflen;
};

/*
 * extensions for transferring audio frames
 * currently used by sbpcd.c, cdu31a.c, ide-cd.c
 */
struct cdrom_read_audio
{
	union cdrom_addr addr; /* frame address */
	unsigned char addr_format; /* CDROM_LBA or CDROM_MSF */
	int nframes; /* number of 2352-byte-frames to read at once, limited by the drivers */
	unsigned char *buf; /* frame buffer (size: nframes*2352 bytes) */
};

/*
 * this has to be the "arg" of the CDROMMULTISESSION ioctl
 * for obtaining multi session info.
 * The returned "addr" is valid only if "xa_flag" is true.
 */
struct cdrom_multisession
{
	union cdrom_addr addr; /* frame address: start-of-last-session (not the new "frame 16"!)*/
	unsigned char xa_flag; /* 1: "is XA disk" */
	unsigned char addr_format; /* CDROM_LBA or CDROM_MSF */
};

#ifdef FIVETWELVE
#define	CDROM_MODE1_SIZE	512
#else
#define	CDROM_MODE1_SIZE	2048
#endif /*FIVETWELVE*/
#define	CDROM_MODE2_SIZE	2336



#endif
#else
#include <linux/cdrom.h>
#endif
