MKISOFS:
========
  -a     Include  all  files  on  the  iso9660   filesystem.
         Normally  files  that contain the characters '~' or
         '#' will  not  be  included  (these  are  typically
         backup files for editors under unix).

  -A application_id
         Specifies  a  text string that will be written into
         the volume header.  This should describe the appli
         cation that will be on the disc.  There is space on
         the disc for 128 characters of  information.   This
         parameter  can  also  be set in the file .mkisofsrc
         with APPI=id.  If specified  in  both  places,  the
         command line version is used.

  -b boot_image
         Specifies  the  path and filename of the boot image
         to be used when making an "El Torito" bootable  CD.
         The  pathname  must  be relative to the source path
         specified to mkisofs.  This option is  required  to
         make a bootable CD.  The boot image must be exactly
         the size of either a  1.2,  1.44,  or  a  2.88  meg
         floppy,  and mkisofs will use this size when creat
         ing the output iso9660 filesystem.  It  is  assumed
         that  the first 512 byte sector should be read from
         the boot image (it is essentially emulating a  nor
         mal floppy drive).  This will work, for example, if
         the boot image is a LILO based boot floppy.

  -c boot_catalog
         Specifies the path and filename of the boot catalog
         to  be used when making an "El Torito" bootable CD.
         The pathname must be relative to  the  source  path
         specified  to  mkisofs.  This option is required to
         make a bootable CD.  This file will be  created  by
         mkisofs  in  the  source filesystem, so be sure the
         specified filename does not conflict with an exist
         ing  file,  as it will be quietly overwritten! Usu
         ally a name like "boot.catalog" is chosen.

  -d     Omit trailing period from files that do not have  a
         period.  This violates the ISO9660 standard, but it
         happens to work on many systems.  Use with caution.

  -D     Do  not  use deep directory relocation, and instead
         just pack them in the way we see them.   This  vio
         lates  the  ISO9660  standard, but it works on many
         systems.  Use with caution.

  -f     Follow symbolic links when generating the  filesys
         tem.   When  this  option  is  not in use, symbolic
         links will be entered using Rock Ridge if  enabled,
         otherwise the file will be ignored.

  -l     Allow  full  32  character filenames.  Normally the
         ISO9660 filename will be in an 8.3 format which  is
         compatible  with  MS-DOS,  even  though the ISO9660
         standard allows filenames of up to  32  characters.
         If  you  use this option, the disc may be difficult
         to use on a MS-DOS system, but this comes in  handy
         on  some  other  systems  (such as the Amiga).  Use
         with caution.

  -J     Generate Joliet directory records  in  addition  to
         regular iso9660 file names.  This is primarily use
         ful when the discs are to be used on Windows-NT  or
         Windows-95  machines.    The  Joliet  filenames are
         specified in Unicode and each path component can be
         up to 64 Unicode characters long.

  -L     Allow filenames to begin with a period.  Usually, a
         leading dot is replaced with an underscore in order
         to maintain MS-DOS compatibility.

  -m glob
         Exclude  glob from being written to CDROM.  glob is
         a shell wild-card-style  pattern  that  must  match
         part  of  the filename (not the path as with option
         -x).   Technically  glob  is  matched  against  the
         d->d_name  part  of  the directory entry.  Multiple
         globs may be excluded (up to 1000).  Example:

         mkisofs -o rom -m '*.o' -m core -m foobar

         would exclude all  files  ending  in  ".o",  called
         "core" or "foobar" to be copied to CDROM. Note that
         if you had a directory called "foobar" it too  (and
         of course all its descendants) would be excluded.

  -M path
         Specifies  path  to  existing  iso9660  image to be
         merged.  The output of mkisofs will be a  new  ses
         sion  which  should  get  written to the end of the
         image specified in  -M.   Typically  this  requires
         multi-session capability for the recorder and cdrom
         drive that you are attempting to write  this  image
         to.   Support  for  this  is not yet 100% complete,
         because  some  handshaking  is   required   between
         mkisofs  and cdwrite in order to determine the next
         writable address on the cdrom.

  -N     Omit version numbers from ISO9660 file names.  This
         may violate the ISO9660 standard, but no one really
         uses the version numbers anyway.  Use with caution.

  -no-split-symlink-components
         Don't split the SL components, but begin a new Con
         tinuation Area (CE) instead. This  may  waste  some
         space,  but  the SunOS 4.1.4 cdrom driver has a bug
         in  reading  split  SL  components   (link_size   =
         component_size   instead  of  link_size  +=  compo
         nent_size).

  -no-split-symlink-fields
         Don't split the SL fields, but begin a new Continu
         ation Area (CE) instead. This may waste some space,
         but the SunOS 4.1.4 and Solaris 2.5.1 cdrom  driver
         have a bug in reading split SL fields (a `/' can be
         dropped).

  -o filename
         is the name  of  the  file  to  which  the  iso9660
         filesystem  image should be written.  This can be a
         disk file, a  tape  drive,  or  it  can  correspond
         directly  to  the  device  name of the optical disc
         writer.  If not specified, stdout  is  used.   Note
         that  the output can also be a block special device
         for a regular disk drive, in which  case  the  disk
         partition  can  be  mounted  and examined to ensure
         that the premastering was done correctly.

  -P publisher_id
         Specifies a text string that will be  written  into
         the  volume  header.  This should describe the pub
         lisher of the CDROM, usually with a mailing address
         and  phone  number.  There is space on the disc for
         128 characters of information.  This parameter  can
         also  be set in the file .mkisofsrc with PUBL=.  If
         specified in both places, the command line  version
         is used.

  -p preparer_id
         Specifies  a  text string that will be written into
         the volume header.  This should describe  the  pre
         parer  of the CDROM, usually with a mailing address
         and phone number.  There is space on the  disc  for
         128  characters of information.  This parameter can
         also be set in the file .mkisofsrc with PREP=.   If
         specified  in both places, the command line version
         is used.

  -R     Generate  SUSP  and RR records using the Rock Ridge
         protocol to  further  describe  the  files  on  the
         iso9660 filesystem.

  -r     This  is like the -R option, but file ownership and
         modes are set to more useful values.  The  uid  and
         gid  are set to zero, because they are usually only
         useful on the author's system, and  not  useful  to
         the  client.   All the file read bits are set true,
         so that files and directories are globally readable
         on  the  client.   If  any execute bit is set for a
         file, set all of the execute bits, so that executa
         bles are globally executable on the client.  If any
         search bit is set for a directory, set all  of  the
         search  bits,  so  that  directories  are  globally
         searchable on  the  client.   All  write  bits  are
         cleared,  because  the CD-Rom will be mounted read-
         only in any case.  If any of the special mode  bits
         are  set,  clear  them,  because file locks are not
         useful on a read-only file system, and set-id  bits
         are not desirable for uid 0 or gid 0.

  -T     Generate  a file TRANS.TBL in each directory on the
         CDROM, which can be used on non-Rock Ridge  capable
         systems  to  help establish the correct file names.
         There is also information present in the file  that
         indicates the major and minor numbers for block and
         character devices, and each symlink has the name of
         the link file given.

  -V volid
         Specifies the volume ID to be written into the mas
         ter block.  This parameter can also be set  in  the
         file .mkisofsrc with VOLI=id.  If specified in both
         places, the command line version is used.

  -v     Verbose execution.

  -x path
         Exclude path from being  written  to  CDROM.   path
         must  be  the  complete  pathname that results from
         concatenating the pathname given  as  command  line
         argument  and  the path relative to this directory.
         Multiple paths may be excluded (up to 1000).  Exam
         ple:

         mkisofs -o cd -x /local/dir1 -x /local/dir2 /local


/////////////////////////////////////////////////////////////////////////

CDRECORD:
=========

  -version
         Print version information and exit.

  -v     Increment the level of general  verbosity  by  one.
         This  is  used  e.g. to display the progress of the
         writing process.

  -V     Increment the verbose level in respect of SCSI com
         mand  transport  by one.  This helps to debug prob
         lems during the writing process, that occur in  the
         CD-Recorder.   If  you  get  incomprehensible error
         messages you should  use  this  flag  to  get  more
         detailed output.  -VV will show data buffer content
         in addition.  Using -V or -VV slows down  the  pro
         cess  and  may be the reason for a buffer underrun.
         Using

  -debug Print additional debug messages. This may  help  to
         find  out  problems  with  sector  sizes and sector
         types.  Using -debug slows down the process and may
         be the reason for a buffer underrun.

  -dummy The  CD-Recorder  will  go through all steps of the
         recording process, but the laser is turned off dur
         ing  this procedure.  It is recommended to run sev
         eral tests before actually  writing  to  a  Compact
         Disk, if the timing and load response of the system
         is not known.

  -multi Allow multi session CD's  to  be  made.  This  flag
         needs to be present on all sessions of a multi ses
         sion disk, except you want to create a session that
         will  be  the last session on the media.  The fixa
         tion will be done in a  way  that  allows  the  CD-
         Recorder  to append additional sessions later. This
         is done by generation a TOC with a link to the next
         program  area.  The  so generated media is not 100%
         compatible to  manufactured  CD's.   Use  only  for
         recording  a  multi  session CD.  If this option is
         present, the default track type is CD-ROM  XA  mode
         2.   The  Sony  drives have no hardware support for
         CD-ROM XA mode 2.  You have to  specify  the  -data
         option  in  order  to create multi session disks on
         these drives.

  -msinfo
         Retrieve multi session info in a form suitable  for
         mkisofs-1.10 or later.

         This  option  makes  only sense with a CD that con
         tains at least one closed session and is appendable
         (not finally closed yet).  Some drives create error
         messages if you try to get the multi  session  info
         for a disk that is not suitable for this operation.

  -toc   Retrieve and print out the table of content or  PMA
         of a CD.  With this option, cdrecord will with CD-R
         drives and CD-ROM drives.

  -fix   The disk will only be fixated (i.e. a TOC for a CD-
         Reader  will be written).  This may be used, if for
         some reason the disk has been written but not  fix
         ated. This option currently does not work with TEAC
         drives.

  -nofix Do not fixate the disk after  writing  the  tracks.
         This  may be used to create an audio disk in steps.
         An un-fixated disk can usually not be used on a non
         CD-writer type drive but there are audio CD players
         that will be able to play such a disk.

  -load  Load the media and exit. This  only  works  with  a
         tray  loading mechanism but seems to be useful when
         using the Kodak disk transporter.

  -eject Eject disk after  doing  the  work.   Some  Devices
         (e.g. Philips) need to eject the medium before cre
         ating a new disk. Doing a -dummy test  and  immedi
         ately  creating a real disk would not work on these
         devices.

  speed=#
         Set the speed factor of the writing process  to  #.
         #  is  an  integer,  representing a multiple of the
         audio speed.  This is about 150 KB/s for CD-ROM and
         about 172 KB/s for CD-Audio.  If no speed option is
         present, cdrecord will try to get the  speed  value
         from  the CDR_SPEED environment.  If your drive has
         problems with speed=2 or speed=4,  you  should  try
         speed=0.

  blank=type
         Blank  a  CD-RW  and  exit  or blank a CD-RW before
         writing. The blanking type may be one of:

         help        Display a  list  of  possible  blanking
                     types.

         all         Blank  the entire disk. This may take a
                     long time.

         fast        Minimally blank the disk. This  results
                     in  erasing  the  PMA,  the TOC and the
                     pregap.

         track       Blank a track.

         unreserve   Unreserve a reserved track.

         trtail      Blank the tail of a track.

         unclose     Unclose last session.

         session     Blank the last session.

  fs=#   Set the fifo (ring buffer) size to #.  You may  use
         the  same  method  as  in dd(1), sdd(1) or star(1).
         The number representing the size is taken in  bytes
         unless  otherwise  specified.   If a number is fol
         lowed directly by the letter `b', `k', `m', `s'  of
         `f',   the   size   is  multiplied  by  512,  1024,
         1024*1024, 2048 or 2352.  If the size  consists  of
         numbers  separated by `x' or `*', multiplication of
         the two numbers is performed.  Thus fs=10x63k  will
         specify a fifo size of 630 kBytes.

         The size specified by the fs= argument includes the
         shared memory that is  needed  for  administration.
         This  is  at  least  one page of memory.  If no fs=
         option is present, cdrecord will  try  to  get  the
         fifo  size value from the CDR_FIFOSIZE environment.
         The default fifo size is currently 4 MB.

         The fifo is used to increase buffering for the real
         time writing process.  It allows to run a pipe from
         mkisofs directly into cdrecord.   If  the  fifo  is
         active  and  a  pipe  from mkisofs into cdrecord is
         used to create a CD, cdrecord will abort  prior  to
         do  any  modifications  on the disk if mkisofs dies
         before it starts  writing.   The  recommended  fifo
         size  is  between  4  and  32 MBytes.  As a rule of
         dumb, the fifo size should be at least equal to the
         size  of the internal buffer of the CD-Recorder and
         no more than half of the  physical  amount  of  RAM
         available  in the machine.  If the fifo size is big
         enough, the fifo statistics will print a fifo empty
         count  of  zero  and the fifo min fill is not below
         20%.  It is not wise to use too much space for  the
         fifo.  If  you need more than 8 MB to write a CD on
         an idle machine, your machine is  either  underpow
         ered,  has  hardware problems or is mis-configured.
         The sun4c architecture (e.g. a Sparcstation-2)  has
         only  MMU page table entries for 16 MBytes per pro
         cess. Using more than 14 MBytes for  the  fifo  may
         cause  the  operating  system in this case to spend
         much time to  constantly  reload  the  MMU  tables.
         Newer  machines from Sun do not have this MMU hard
         ware problem. I have no information on  PC-hardware
         reflecting this problem.

         If  you  have  buffer underruns or similar problems
         and observe a zero fifo empty count, you have hard
         ware problems. The fifo size in this case is suffi
         cient.

  dev=target
         Sets the SCSI target for the CD-Recorder, see notes
         above.   If no dev option is present, cdrecord will
         try to get the device from the CDR_DEVICE  environ
         ment.

  timeout=#
         Set  the  default  SCSI command timeout value to #.
         The default SCSI command  timeout  is  the  minimum
         timeout  used for sending SCSI commands.  If a SCSI
         command fails due to a  timeout,  you  may  try  to
         raise  the  default  SCSI command timeout above the
         timeout value of the failed command.  If  the  com
         mand  runs correctly with a raised command timeout,
         please report the better timeout value and the cor
         responding  command  to  the author of the program.
         If no timeout option is present, a default  timeout
         of 40 seconds is used.

  driver=name
         Allows  to  use a user supplied driver name for the
         device.  To get a  list  of  possible  drivers  use
         driver=help.   The reason for the existence of this
         option is to  allow  users  to  use  cdrecord  with
         drives that are similar to supported drives but not
         known directly by cdrecord.  Use this  option  with
         extreme  care.  If  a  wrong  driver  is used for a
         device, the possibility of creating corrupted disks
         is  high.   The  minimum problem related to a wrong
         driver is that the -speed or -dummy will not  work.

  -checkdrive
         Checks if a driver for the current drive is present
         and exit.  If the drive is a known drive,  cdrecord
         uses exit code 0.

  -prcap Print the drive capabilities for SCSI-3/mmc compli
         ant drives as obtained from mode page 0x2A.  Values
         marked  with kB use 1000 bytes as kilo-byte, values
         marked with KB use 1024 bytes as Kilo-byte.

  -inq   Do an inquiry for the drive, print the inquiry info
         and exit.

  -scanbus
         Scan  all SCSI devices on all SCSI busses and print
         the inquiry strings. This option  may  be  used  to
         find  SCSI  address of the CD-Recorder on a system.
         The numbers printed out as labels are computed  by:
         bus * 100 + target * 10 + lun

  -reset Try  to reset the SCSI bus where the CD recorder is
         located. This works not on all operating systems.

  -ignsize
         Ignore the known size of the medium.  This  options
         should  be  used  with extreme care, it exists only
         for debugging purposes don't use it for other  rea
         sons.   It  is  not needed to write disks with more
         than the nominal capacity.

  defpregap=#
         Set the default pre-gap size for all tracks  except
         track  number  1.  This option currently only makes
         sense with the TEAC drive when  creating  track-at-
         once disks without the 2 second silence before each
         track.
         This option may go away in future.

  -packet
         Set Packet writing mode.  This is  an  experimental
         interface.

  pktsize=#
         Set  the paket size to #, forces fixed packet mode.
         This is an experimental interface.

  -noclose
         Do not close the current track, useful only when in
         packet  writing  mode.   This  is  an  experimental
         interface.

TRACK OPTIONS
  Track options may be mixed with track file names.

  -audio If this flag is present, all subsequent tracks  are
         written  in  CD-DA (similar to Red Book) audio for
         mat.  The file with data  for  this  tracks  should
         contain  stereo,  16-bit  digital  audio with 44100
         samples/s.  The byte order should be the following:
         MSB  left, LSB left, MSB right, LSB right, MSB left
         and so on. The track should be a multiple  of  2352
         bytes.  It  is not possible to put the master image
         of an audio track on a raw disk because  data  will
         be  read  in  multiple  of  2352  bytes  during the
         recording process.

         If a filename ends in .au or .waw the file is  con
         sidered   to  be  a  structured  audio  data  file.
         Cdrecord assumes that the file in this  case  is  a
         Sun  audio  file  or  a  Microsoft  .WAV  file  and
         extracts the audio data from the files by  skipping
         over  the  non-audio  header  information.   In all
         other cases, cdrecord will only work  correctly  if
         the  audio  data  stream  does not have any header.
         Because many structured audio files do not have  an
         integral   number  of  blocks  (1/75th  second)  in
         length, it is often necessary to specify  the  -pad
         option  as  well.   cdrecord  recognizes that audio
         data in a .WAV file is  stored  in  Intel  (little-
         endian)  byte  order,  and will automatically byte-
         swap the data if  the  CD  recorder  requires  big-
         endian  data.   Cdrecord will reject any audio file
         that does not match the Red  Book  requirements  of
         16-bit  stereo  samples in PCM coding at 44100 sam
         ples/second.
         Using other structured audio data formats as  input
         to  cdrecord  will usually work if the structure of
         the data is the structure described above (raw  pcm
         data  in  big-endian  byte order).  However, if the
         data format includes a  header,  you  will  hear  a
         click at the start of a track.

  -swab  If  this  flag is present, audio data is assumed to
         be in  byte-swapped  (little-endian)  order.   Some
         types  of  CD-Writers e.g. Yamaha, Sony and the new
         SCSI-3/mmc drives require audio  data  to  be  pre
         sented  in little-endian order, while other writers
         require audio data to  be  presented  in  the  big-
         endian  (network)  byte  order normally used by the
         SCSI protocol.  Cdrecord  knows  if  a  CD-Recorder
         needs  audio  data  in big- or little-endian order,
         and corrects the byte order of the data  stream  to
         match the needs of the recorder.  You only need the
         -swab flag if your data stream is in Intel (little-
         endian) byte order.

         Note  that the verbose output of cdrecord will show
         you if swapping is necessary to make the byte order
         of  the  input  data fit the required byte order of
         the recorder.  Cdrecord will not show  you  if  the
         -swab flag was actually present for a track.

  -data  If  this flag is present, all subsequent tracks are
         written in CD-ROM mode 1 (Yellow Book) format.  The
         data  is  a  multiple of 2048 bytes.  The file with
         track data should contain an ISO-9660 or Rock Ridge
         filesystem image (see mkisofs for more details). If
         the track data is an ufs filesystem image, fragment
         size  should  be  set  to 2 KB or more to allow CR-
         drives with 2 KB sector size  to  to  be  used  for
         reading.

         -data  is the default, if no other flag is present.

  -mode2 If this flag is present, all subsequent tracks  are
         written in CD-ROM mode 2 format. The data is a mul
         tiple of 2048 bytes.

  -xa1   If this flag is present, all subsequent tracks  are
         written  in  CD-ROM XA mode 1 format. The data is a
         multiple of 2048 bytes.

  -xa2   If this flag is present, all subsequent tracks  are
         written  in  CD-ROM XA mode 2 format. The data is a
         multiple of 2048 bytes.

  -cdi   If this flag is present, all subsequent tracks  are
         written  in  CDI  format. The data is a multiple of
         2048 bytes.
  -isosize
         Use the ISO-9660 file system size as  the  size  of
         the  next track.  This option is needed if you want
         to read the image of a track from a raw disk parti
         tion  or  on  a  master  CD.  In the first case the
         option -isosize is needed to limit the size of  the
         CD  to the size of the ISO filesystem.  In the sec
         ond case the option -isosize is needed  to  prevent
         cdrecord  from  reading the two run out blocks that
         are appended by each CD-recorder in track  at  once
         mode.  These  two run out blocks cannot be read and
         would cause a buffer under run that would  cause  a
         defective copy.  Do not use this option if cdrecord
         reads the track data from stdin.  This option  cur
         rently  cannot  be  used to determine the size of a
         file system if the multi session option is present.

  -pad   If  the track is a data track, 15 sectors of zeroed
         data will be added to the end of this and each sub
         sequent  data track.  In this case, the -pad option
         is superseded  by  the  padsize=  option.  It  will
         remain  however as a shorthand for padsize=15s.  If
         the -pad option refers to an audio track,  cdrecord
         will  pad  the  audio data to be a multiple of 2352
         bytes.  The audio data padding is done with  binary
         zeroes which is equal to absolute silence.

  padsize=#
         Set the amount of data to be appended as padding to
         the next track to #.  Opposed to  the  behavior  of
         the  -pad  option,  this value is reset to zero for
         each new track.  See fs= option for possible  argu
         ments.   Use  this  option  if your CD-drive is not
         able to read the last sectors of a track or if  you
         want  to  be  able to read the CD on a Linux system
         with the ISO-9660 filesystem read ahead bug.  If an
         empty  file is used for track data, this option may
         be used to create a disk that is entirely  made  of
         padding.

  -nopad Do not pad the following tracks - the default.

  pregap=#
         Set  the   pre-gap  size  for the next track.  This
         option currently only makes  sense  with  the  TEAC
         drive when creating track-at-once disks without the
         2 second silence before each track.
         This option may go away in future.

  -preemp
         If this flag is present, all TOC entries for subse
         quent  audio  tracks  will  indicate that the audio
         data has been sampled with 50/15 sec  preemphasis.
         The  data,  however  is  not  modified  during  the
         process of transferring from file  to  disk.   This
         option has no effect on data tracks.

  -nopreemp
         If this flag is present, all TOC entries for subse
         quent audio tracks will  indicate  that  the  audio
         data  has  been mastered with linear data - this is
         the default.

  bytes=#
         Obsolete option to specify the  size  of  the  next
         track.  Don't  use  this option, it will go away in
         cdrecord-1.7.

  tsize=#
         If the master image for the  next  track  has  been
         stored  on  a  raw disk, use this option to specify
         the valid amount of data on this disk. If the image
         of  the next track is stored in a regular file, the
         size of that file is taken to determine the  length
         of  this  track.  If the track contains an ISO 9660
         filesystem image use the -isosize option to  deter
         mine the length of that filesystem image.
         In Disk at Once mode (not yet implemented) and with
         some drives that use the  TEAC  programming  inter
         face, even in Track at Once mode, cdrecord needs to
         know the size of  each  track  before  starting  to
         write  the  disk.   Cdrecord  now  checks  this and
         aborts before starting to write.  If  this  happens
         you will need to run mkisofs -print-size before and
         use the output as an argument to the tsize=  option
         of cdrecord.
         See fs= option for possible arguments.
