/*
 *  Copyright (C) 1998  Jesper Pedersen <jews@imada.ou.dk>
 *  This code is released under GNU GPL version 2 or later
 */

import java.util.Vector;
import java.io.*;

class Utils {

  public void Utils(){
  }

  public String getVersion() {
    String version = new String("1.0.6");
    return version;
  }

  /** Get device number */
  public String getDevNumber() {
    ReadTextFile rf; 
    String s = new String("");

    try {
      rf = new ReadTextFile(getConfigFileName());
      s = rf.readLine();
      while (s.startsWith("CDR=") == false) {
	s = rf.readLine();
      }
      rf.close();
    } catch (Exception e) {
      System.out.println("I/O error");
      System.exit(1);
    }
    s = s.substring(s.indexOf("|")+2);
    return s;
  }

  /** Get SCSI devices */
  public Vector getSCSIDevices() {
    Vector units = new Vector();
    String unit = new String("");
    String unit_major = new String("");
    String unit_minor = new String("");

    try {
      Process procSETUP = Runtime.getRuntime().exec("./cdrecord -scanbus",null);
      MyInputStream lineIn = new MyInputStream(procSETUP.getInputStream());
      
      while (true) {
	String line = lineIn.readLine();
	if (line.startsWith("scsibus")) {
	  unit_major = new String(line.substring(7,8));
	}
	if (line.endsWith("Removable CD-ROM")) {
	  unit_minor = new String(line.substring(4,5));
	  unit = new String(unit_minor);
	  unit = unit.concat(",");
	  unit = unit.concat(unit_major);
	  units.addElement(unit);

	  String reply = new String("");

	  try {
	    String command = new String("./cdrecord");
	    command = command.concat(" dev=");
	    command = command.concat(unit);
	    command = command.concat(" -checkdrive");
	    Process procSETUP2 = Runtime.getRuntime().exec(command,null);
	    MyInputStream lineIn2 = new MyInputStream(procSETUP2.getInputStream());
	    
	    while (true) {
	      String line2 = lineIn2.readLine();
	      if (line2.startsWith("Device seems to be:")) {
		reply = reply.concat(line2.substring(20,line2.length()-1));
		break;
	      }
	    }
	    procSETUP.destroy();
	  } catch (Exception e) {
	  }
	  units.addElement(reply);
	}
	if (line.compareTo("") == 0) {
	  break;
	}
      }
      procSETUP.destroy();
    } catch (Exception e) {
    }
    return units;
  }

  /** Get Audio Tracks */
  public Vector getAudioTracks() {
    Vector result = new Vector();
    String command = new String("./cdrecord");

    command = command.concat(" dev=");
    command = command.concat(getDevNumber());
    command = command.concat(" -toc");
    try {
      Process procMSINFO = Runtime.getRuntime().exec(command,null);
      MyInputStream lineIn = new MyInputStream(procMSINFO.getInputStream());
      String line;

      while ((line = lineIn.readLine()).compareTo("") != 0) {
	if (line.endsWith("mode: 15")) {  // Audio Track
	  result.addElement(line.substring(8,10));
	}
      }
      procMSINFO.destroy();
    } catch (Exception e) {
    }
    return result;
  }

  /** Get magic parameters */
  public String getMagicParameters() {
    String command = new String("./cdrecord");

    command = command.concat(" dev=");
    command = command.concat(getDevNumber());
    command = command.concat(" -msinfo");
    try {
      Process procMSINFO = Runtime.getRuntime().exec(command,null);
      MyInputStream lineIn = new MyInputStream(procMSINFO.getInputStream());
      
      String line = lineIn.readLine();
      if ((line.charAt(0) >= '0')&&(line.charAt(0) <= '9')) {
	return line;
      }
      procMSINFO.destroy();
    } catch (Exception e) {
    }
    return new String("");
  }

  /** Get number of CPUs */
  public int getNrOfCPUs() {
    int result = 0;
    String command = new String("cat /proc/cpuinfo");

    if (System.getProperty("os.name").compareTo("Linux") == 0) {
      try {
	Process procMSINFO = Runtime.getRuntime().exec(command,null);
	MyInputStream lineIn = new MyInputStream(procMSINFO.getInputStream());
	String line;
	
	while (true) {
	  line = lineIn.readLine();
	  if (line.startsWith("processor")) {  
	    result++;
	  }
	}
	//procMSINFO.destroy();
      } catch (Exception e) {
	// No /proc directory
	if (result == 0) result = 1;
      }
    } else {
      result = 1;  // Defaults to 1 :-(
    }
    return result;
  }

  /** Execute command (stdout) */
  public void execute(String cmd) {
    execute(cmd,true);
  }

  /** Execute command (stdout) */
  public void execute(String cmd, boolean output) {
    if (output) {
      System.out.print("Executing : ");
      System.out.println(cmd);
    }
    try {
      Process proc = Runtime.getRuntime().exec(cmd,null);
      int c;
      if (output) {
	MyInputStream charIn = new MyInputStream(proc.getInputStream());
	while ((c = charIn.readChar()) != -1) {
	  System.out.print((char) c);
	}
	System.out.println("Command complete.");
      } else {
	c = proc.waitFor();
      }
      proc.destroy();
    } catch (Exception e) {
    }
  }

  /** Execute command (stderr) */
  public void execute_err(String cmd) {
    execute_err(cmd,true);
  }

  /** Execute command (stderr) */
  public void execute_err(String cmd, boolean output) {
    //String title = new String("Running: ");

    //title = title.concat(cmd);
    //Output out = new Output(title,500,500);
    if (output) {
      System.out.print("Executing : ");
      System.out.println(cmd);
    }
    try {
      Process proc = Runtime.getRuntime().exec(cmd,null);
      int c;
      if (output) {
	MyInputStream charIn = new MyInputStream(proc.getErrorStream());
	while ((c = charIn.readChar()) != -1) {
	  System.out.print((char) c);
	}
	System.out.println("Command complete.");
      } else {
	c = proc.waitFor();
      }
      proc.destroy();
    } catch (Exception e) {
    }
  }

  /** Execute pipe command (stdout) */
  public void execute_pipe(String cmd1,String cmd2) {
    System.out.print("Executing : ");
    System.out.print(cmd1);
    System.out.print(" | ");
    System.out.println(cmd2);

    /*
     Should work -- but doesn't :  Pipe I/O bug for Process?
    try {
      Process proc1 = Runtime.getRuntime().exec(cmd1,null);
      Process proc2 = Runtime.getRuntime().exec(cmd2,null);
      
      new Thread(new ExecutePipe(proc1.getInputStream(),proc2.getOutputStream())).start(); 
      new Thread(new ExecutePipe(proc1.getErrorStream(), System.out)).start();
      new Thread(new ExecutePipe(proc2.getInputStream(), System.out)).start();

      System.out.println ("Command complete.");
    } catch (Exception e) {
      System.out.println (e);
    }
    */
    String s = new String("");

    s = s.concat(cmd1);
    s = s.concat(" | ");
    s = s.concat(cmd2);

    // Create a script with the commands
    try {
      WriteTextFile wf = new WriteTextFile("./user.cmd");
      wf.writeLine("#!/bin/sh");
      wf.writeLine(s);
      wf.close();
    } catch (IOException e) {
      System.err.println(e);
    }
    // Change execute permissions
    execute("chmod 755 ./user.cmd",false);

    String[] cmds = {new String("./user.cmd"), new String("rm -f ./user.cmd")}; 
    ExecuteCmdsThread th = new ExecuteCmdsThread(cmds, 2, 1);
  }

  public int getFreeSpace() {
    String ret = new String("");

    try {
      String command = new String("./cdrecord");
      command = command.concat(" dev=");
      command = command.concat(getDevNumber());
      command = command.concat(" -toc");
      Process procSETUP = Runtime.getRuntime().exec(command,null);
      MyInputStream lineIn = new MyInputStream(procSETUP.getInputStream());
      
      while (true) {
	String line = lineIn.readLine();
	if (line.startsWith("track:lout")) {
	  ret = ret.concat(line.substring(19,25));
	  break;
	}
      }
      procSETUP.destroy();
    } catch (Exception e) {
    }
    return Integer.valueOf(ret).intValue();
  }


  /* Setup */
  public String getConfigFileName() {
    String s = new String("BurnIT.ini");
    return s;
  }

  public String getCDRModel() {
    ReadTextFile rf; 
    String s = new String("");

    try {
      rf = new ReadTextFile(getConfigFileName());
      s = rf.readLine();
      while (s.startsWith("CDR=") == false) {
	s = rf.readLine();
      }
      rf.close();
    } catch (Exception e) {
      System.out.println("I/O error");
      System.exit(1);
    }
    s = s.substring(4,s.indexOf("|")-1);
    return s;
  }

  public String getMnt() {
    ReadTextFile rf; 
    String s = new String("");

    try {
      rf = new ReadTextFile(getConfigFileName());
      s = rf.readLine();
      while (s.startsWith("MNT=") == false) {
	s = rf.readLine();
      }
      rf.close();
    } catch (Exception e) {
      System.out.println("I/O error");
      System.exit(1);
    }
    return s.substring(4);
  }

  public String getTmp() {
    ReadTextFile rf; 
    String s = new String("");

    try {
      rf = new ReadTextFile(getConfigFileName());
      s = rf.readLine();
      while (s.startsWith("TMP=") == false) {
	s = rf.readLine();
      }
      rf.close();
    } catch (Exception e) {
      System.out.println("I/O error");
      System.exit(1);
    }
    return s.substring(4);
  }

  public String getDflSourcePath() {
    ReadTextFile rf; 
    String s = new String("");

    try {
      rf = new ReadTextFile(getConfigFileName());
      s = rf.readLine();
      while (s.startsWith("SPATH=") == false) {
	s = rf.readLine();
      }
      rf.close();
    } catch (Exception e) {
      System.out.println("I/O error");
      System.exit(1);
    }
    return s.substring(6);
  }

  public String getReadDevice() {
    ReadTextFile rf; 
    String s = new String("");

    try {
      rf = new ReadTextFile(getConfigFileName());
      s = rf.readLine();
      while (s.startsWith("RDDEV=") == false) {
	s = rf.readLine();
      }
      rf.close();
    } catch (Exception e) {
      System.out.println("I/O error");
      System.exit(1);
    }
    return s.substring(6);
  }

  public String getReadDeviceGeneric() {
    ReadTextFile rf; 
    String s = new String("");

    try {
      rf = new ReadTextFile(getConfigFileName());
      s = rf.readLine();
      while (s.startsWith("RDGDEV=") == false) {
	s = rf.readLine();
      }
      rf.close();
    } catch (Exception e) {
      System.out.println("I/O error");
      System.exit(1);
    }
    return s.substring(7);
  }

  public String getConfigVersion() {
    ReadTextFile rf; 
    String s = new String("");

    try {
      rf = new ReadTextFile(getConfigFileName());
      s = rf.readLine();
      while (s.startsWith("VERSION=") == false) {
	s = rf.readLine();
      }
      rf.close();
    } catch (Exception e) {
      System.out.println("I/O error");
      System.exit(1);
    }
    return s.substring(8);
  }

  public String getComment() {
    ReadTextFile rf; 
    String s = new String("");

    try {
      rf = new ReadTextFile(getConfigFileName());
      s = rf.readLine();
      while (s.startsWith("COM=") == false) {
	s = rf.readLine();
      }
      rf.close();
    } catch (Exception e) {
      System.out.println("I/O error");
      System.exit(1);
    }
    return s.substring(4);
  }

  public String getAdv() {
    ReadTextFile rf; 
    String s = new String("");

    try {
      rf = new ReadTextFile(getConfigFileName());
      s = rf.readLine();
      while (s.startsWith("ADV=") == false) {
	s = rf.readLine();
      }
      rf.close();
    } catch (Exception e) {
      System.out.println("I/O error");
      System.exit(1);
    }
    return s.substring(4);
  }

  public String getRead() {
    ReadTextFile rf; 
    String s = new String("");

    try {
      rf = new ReadTextFile(getConfigFileName());
      s = rf.readLine();
      while (s.startsWith("READ=") == false) {
	s = rf.readLine();
      }
      rf.close();
    } catch (Exception e) {
      System.out.println("I/O error");
      System.exit(1);
    }
    return s.substring(5);
  }

  public String getWrite() {
    ReadTextFile rf; 
    String s = new String("");

    try {
      rf = new ReadTextFile(getConfigFileName());
      s = rf.readLine();
      while (s.startsWith("WRITE=") == false) {
	s = rf.readLine();
      }
      rf.close();
    } catch (Exception e) {
      System.out.println("I/O error");
      System.exit(1);
    }
    return s.substring(6);
  }

  public String getFileSystem() {
    ReadTextFile rf; 
    String s = new String("");

    try {
      rf = new ReadTextFile(getConfigFileName());
      s = rf.readLine();
      while (s.startsWith("FS=") == false) {
	s = rf.readLine();
      }
      rf.close();
    } catch (Exception e) {
      System.out.println("I/O error");
      System.exit(1);
    }
    return s.substring(3);
  }

}
