/*
 *  Copyright (C) 1998  Jesper Pedersen <jews@imada.ou.dk>
 *  This code is released under GNU GPL version 2 or later
 */
import java.awt.*;
import java.awt.event.*;

public class Simple extends Frame implements ActionListener, ItemListener {
  // CDTypeMenu windows
  private Checkbox MultisessionCD;
  private Checkbox CDROM;
  private Checkbox Audio;
  private Checkbox CDCopy;
  private Checkbox MixedModeCD;
  private CheckboxGroup CDType;

  // FileNameMenu window
  private Checkbox RockType;
  private Checkbox Joliet;
  private Checkbox RockRidge;
  private Checkbox Win95NT;
  private Checkbox DOS;
  private CheckboxGroup FileType;

  // ModeMenu window
  private Checkbox Mode1;
  private Checkbox XA2;
  private CheckboxGroup ModeType;

  // LoadContentsMenu window
  private Checkbox LoadYes;
  private Checkbox LoadNo;
  private CheckboxGroup Load;
  private TextField Offset;
  private TextField ReadDevice;
  private Button GetMSInfo;

  // DATAMenu window
  private TextField srcdir;
  private TextField volume_id;
  private TextField volume_pre;
  private TextField volume_pub;
  private TextField appl_id;

  // AUDIOMenu windows
  private TextField audio_files;
  private Checkbox SwapAudioYes;
  private Checkbox SwapAudioNo;
  private CheckboxGroup SwapAudio;

  // DiscToDiscMenu window
  private TextField src_drive;
  private TextField dest_drive;

  // BurnMenu window
  private Checkbox SpeedOne;
  private Checkbox SpeedTwo;
  private Checkbox SpeedFour;
  private CheckboxGroup Speed;
  private Checkbox TestBefore;
  private Checkbox WriteOnTheFly;

  // Other variables
  private static final int CDTypeMenu = 0;
  private static final int FileNameMenu = 1;
  private static final int ModeMenu = 2;
  private static final int LoadContentsMenu = 4;
  private static final int DATAMenu = 8;
  private static final int AUDIOMenu = 16;
  private static final int DiscToDiscMenu = 32;
  private static final int BurnMenu = 64;
  private int state = CDTypeMenu;

  private String s;

  private boolean isMultisessionCD = false;
  private boolean isCDROM = false;
  private boolean isAudio = false;
  private boolean isCDCopy = false;
  private boolean isMixedModeCD = false;

  private static Utils util = new Utils();

  private Button cancel_button;   
  private Button next_button;     
  private Button prev_button;     
  private Button burn_button;     
  private Button hlp_button;     
  private Font font,font2;            
  
  public Simple() {
    setTitle("Simple menu");

    font = new Font("Helvetica", Font.BOLD, 18);
    font2 = new Font("Helvetica", Font.BOLD, 12);

    // Set the background color
    setBackground(Color.white);

    // Create buttons.
    next_button = new Button("Next >");
    next_button.setForeground(Color.black);
    next_button.setBackground(Color.lightGray);
    add("South", next_button);
    next_button.addActionListener(this);
    next_button.setVisible(true);

    prev_button = new Button("< Prev");
    prev_button.setForeground(Color.black);
    prev_button.setBackground(Color.lightGray);
    add("South", prev_button);
    prev_button.addActionListener(this);
    prev_button.setVisible(false);

    cancel_button = new Button("Cancel");
    cancel_button.setForeground(Color.black);
    cancel_button.setBackground(Color.lightGray);
    add("South", cancel_button);
    cancel_button.addActionListener(this);
    cancel_button.setVisible(true);

    burn_button = new Button("Burn");
    burn_button.setForeground(Color.black);
    burn_button.setBackground(Color.lightGray);
    add("South", burn_button);
    burn_button.addActionListener(this);
    burn_button.setVisible(false);

    hlp_button = new Button("Help");
    hlp_button.setForeground(Color.black);
    hlp_button.setBackground(Color.lightGray);
    add("South", hlp_button);
    hlp_button.addActionListener(this);

    CDType = new CheckboxGroup();
    MultisessionCD = new Checkbox("Multisession CD", false, CDType);
    add(MultisessionCD);
    MultisessionCD.addItemListener(this);
    CDROM = new Checkbox("CD-ROM         ", true, CDType);
    add(CDROM);
    CDROM.addItemListener(this);
    Audio = new Checkbox("Audio CD       ", false, CDType);
    add(Audio);
    Audio.addItemListener(this);
    CDCopy = new Checkbox("CD Copy        ", false, CDType);
    add(CDCopy);
    CDCopy.addItemListener(this);
    MixedModeCD = new Checkbox("Mixed-Mode CD  ", false, CDType);
    add(MixedModeCD);
    MixedModeCD.addItemListener(this);

    FileType = new CheckboxGroup();
    RockRidge = new Checkbox("Rock Ridge   ", false, FileType);
    add(RockRidge);
    RockRidge.addItemListener(this);
    RockRidge.setVisible(false);
    Win95NT = new Checkbox("Windows 95/NT", false, FileType);
    add(Win95NT);
    Win95NT.addItemListener(this);
    Win95NT.setVisible(false);
    DOS = new Checkbox("ISO-9660     ", true, FileType);
    add(DOS);
    DOS.addItemListener(this);
    DOS.setVisible(false);
    RockType = new Checkbox("Clear User-ID", true);
    add(RockType);
    RockType.addItemListener(this);
    RockType.setVisible(false);
    Joliet = new Checkbox("Joliet Filesystem", false);
    add(Joliet);
    Joliet.addItemListener(this);
    Joliet.setVisible(false);

    s = util.getFileSystem();
    if (s.compareTo("Real Rock Ridge") == 0) {
      RockRidge.setState(true);
      RockType.setState(false);
    } else if (s.compareTo("Rock Ridge") == 0) {
      RockRidge.setState(true);
      RockType.setState(true);
    } else if (s.compareTo("Joliet") == 0) {
      Win95NT.setState(true);
      Joliet.setState(true);
    } else if (s.compareTo("Windows") == 0) {
      Win95NT.setState(true);
      Joliet.setState(false);
    } else if (s.compareTo("ISO9660") == 0) {
      DOS.setState(true);
    }

    ModeType = new CheckboxGroup();
    Mode1  = new Checkbox("Mode-1",false,ModeType);
    add(Mode1);
    Mode1.addItemListener(this);
    Mode1.setVisible(false);
    XA2 = new Checkbox("XA-2  ",true,ModeType);
    add(XA2);
    XA2.addItemListener(this);
    XA2.setVisible(false);

    Load = new CheckboxGroup();
    LoadYes = new Checkbox("Yes",false,Load);
    add(LoadYes);
    LoadYes.addItemListener(this);
    LoadYes.setVisible(false);
    LoadNo = new Checkbox("No ",true,Load);
    add(LoadNo);
    LoadNo.addItemListener(this);
    LoadNo.setVisible(false);
    Offset = new TextField(100);
    Offset.setEditable(true);
    Offset.setForeground(Color.black);
    Offset.setBackground(Color.white);
    Offset.setVisible(false);
    add(Offset);
    Offset.addActionListener(this);
    ReadDevice = new TextField(100);
    ReadDevice.setEditable(true);
    ReadDevice.setForeground(Color.black);
    ReadDevice.setBackground(Color.white);
    ReadDevice.setVisible(false);
    add(ReadDevice);
    ReadDevice.addActionListener(this);
    ReadDevice.setText(util.getReadDeviceGeneric());
    GetMSInfo = new Button("Get msinfo");
    GetMSInfo.setForeground(Color.black);
    GetMSInfo.setBackground(Color.lightGray);
    GetMSInfo.setVisible(false);
    add("South", GetMSInfo);
    GetMSInfo.addActionListener(this);

    srcdir = new TextField(100);
    srcdir.setEditable(true);
    srcdir.setForeground(Color.black);
    srcdir.setBackground(Color.white);
    srcdir.setVisible(false);
    add(srcdir);
    srcdir.addActionListener(this);
    srcdir.setText(util.getDflSourcePath());
    volume_id = new TextField(100);
    volume_id.setEditable(true);
    volume_id.setForeground(Color.black);
    volume_id.setBackground(Color.white);
    volume_id.setVisible(false);
    add(volume_id);
    volume_id.addActionListener(this);
    volume_pre = new TextField(128);
    volume_pre.setEditable(true);
    volume_pre.setForeground(Color.black);
    volume_pre.setBackground(Color.white);
    volume_pre.setVisible(false);
    add(volume_pre);
    volume_pre.addActionListener(this);
    volume_pub = new TextField(128);
    volume_pub.setEditable(true);
    volume_pub.setForeground(Color.black);
    volume_pub.setBackground(Color.white);
    volume_pub.setVisible(false);
    add(volume_pub);
    volume_pub.addActionListener(this);
    appl_id = new TextField(128);
    appl_id.setEditable(true);
    appl_id.setForeground(Color.black);
    appl_id.setBackground(Color.white);
    appl_id.setVisible(false);
    add(appl_id);
    appl_id.addActionListener(this);

    audio_files = new TextField(100);
    audio_files.setEditable(true);
    audio_files.setForeground(Color.black);
    audio_files.setBackground(Color.white);
    audio_files.setVisible(false);
    add(audio_files);
    audio_files.addActionListener(this);
    audio_files.setText(util.getDflSourcePath());
    SwapAudio = new CheckboxGroup();
    SwapAudioYes = new Checkbox("Yes",false,SwapAudio);
    SwapAudioYes.setVisible(false);
    add(SwapAudioYes);
    SwapAudioYes.addItemListener(this);
    SwapAudioNo = new Checkbox("No ",true,SwapAudio);
    SwapAudioNo.setVisible(false);
    add(SwapAudioNo);
    SwapAudioNo.addItemListener(this);

    src_drive = new TextField(100);
    src_drive.setEditable(true);
    src_drive.setForeground(Color.black);
    src_drive.setBackground(Color.white);
    src_drive.setVisible(false);
    add(src_drive);
    src_drive.addActionListener(this);
    src_drive.setText(util.getReadDevice());
    dest_drive = new TextField(100);
    dest_drive.setEditable(true);
    dest_drive.setForeground(Color.black);
    dest_drive.setBackground(Color.white);
    dest_drive.setVisible(false);
    add(dest_drive);
    dest_drive.addActionListener(this);

    Speed = new CheckboxGroup();
    SpeedOne = new Checkbox("1x (150kB/s)",false,Speed);
    SpeedOne.setVisible(false);
    add(SpeedOne);
    SpeedOne.addItemListener(this);
    SpeedTwo = new Checkbox("2x (300kB/s)",true,Speed);
    SpeedTwo.setVisible(false);
    add(SpeedTwo);
    SpeedTwo.addItemListener(this);
    SpeedFour = new Checkbox("4x (600kB/s)",false,Speed);
    SpeedFour.setVisible(false);
    add(SpeedFour);
    SpeedFour.addItemListener(this);
    if (util.getWrite().compareTo("1") == 0) {
      SpeedOne.setState(true);
    } else if (util.getWrite().compareTo("2") == 0) {
      SpeedTwo.setState(true);
    } else if (util.getWrite().compareTo("4") == 0) {
      SpeedFour.setState(true);
    }

    TestBefore = new Checkbox("Test write    ",false);
    TestBefore.setVisible(false);
    add(TestBefore);
    TestBefore.addItemListener(this);
    WriteOnTheFly = new Checkbox("Write directly",false);
    WriteOnTheFly.setVisible(false);
    add(WriteOnTheFly);
    WriteOnTheFly.addItemListener(this);

    setSize(400,300);
    setResizable(false);
    show();
    repaint();
  }

  public void paint(Graphics g) {
    next_button.setBounds(300,250,80,34);
    prev_button.setBounds(210,250,80,34);
    cancel_button.setBounds(20,250,80,34);
    hlp_button.setBounds(110,250,80,34);
    burn_button.setBounds(300,250,80,34);
    
    g.setFont(font);
    g.setColor(Color.black);
    if (state == CDTypeMenu) {
      g.drawString("Choose CD type",20,70);
      MultisessionCD.setBounds(230,50,150,26);
      CDROM.setBounds(230,80,150,26);
      Audio.setBounds(230,110,150,26);
      CDCopy.setBounds(230,140,150,26);
      MixedModeCD.setBounds(230,170,150,26);
    } else if (state == FileNameMenu) {
      if (Win95NT.getState()) {
	RockType.setVisible(false);
	Joliet.setVisible(true);
      } else if (RockRidge.getState()) {
	RockType.setVisible(true);
	Joliet.setVisible(false);
      } else {
	RockType.setVisible(false);
	Joliet.setVisible(false);
      }
      g.drawString("Choose filesystem",20,70);
      RockRidge.setBounds(230,50,150,26);
      Win95NT.setBounds(230,80,150,26);
      DOS.setBounds(230,110,150,26);
      RockType.setBounds(230,160,150,26);
      Joliet.setBounds(230,160,150,26);
    } else if (state == ModeMenu) {
      g.drawString("Which mode",20,70);
      Mode1.setBounds(230,50,150,26);
      XA2.setBounds(230,80,150,26);
    } else if (state == LoadContentsMenu) {
      if (LoadYes.getState()) {
	Offset.setVisible(true);
	ReadDevice.setVisible(true);
	GetMSInfo.setVisible(true);
	g.setFont(font2);
	g.drawString("Magic Parameters",20,135);
	g.drawString("Read Device",20,165);
      } else {
	Offset.setVisible(false);
	ReadDevice.setVisible(false);
	GetMSInfo.setVisible(false);
      }
      g.setFont(font);
      g.drawString("Load Contents from",20,70);
      g.drawString("previous session",20,90);
      LoadYes.setBounds(230,50,150,26);
      LoadNo.setBounds(230,80,150,26);
      Offset.setBounds(180,120,200,26);
      ReadDevice.setBounds(180,150,200,26);
      GetMSInfo.setBounds(20,200,80,34);
    } else if (state == DATAMenu) {
      g.setFont(font);
      g.drawString("Source Directory",20,70);
      g.setFont(font2);
      g.drawString("Volume ID",20,135);
      g.drawString("Volume Preparer",200,135);
      g.drawString("Volume Publisher",20,195);
      g.drawString("Application ID",200,195);
      g.setFont(font);
      srcdir.setBounds(180,50,200,30);
      volume_id.setBounds(20,140,170,30);
      volume_pre.setBounds(200,140,170,30);
      volume_pub.setBounds(20,200,170,30);
      appl_id.setBounds(200,200,170,30);
    } else if (state == AUDIOMenu) {
      g.drawString("Audio files",20,70);
      audio_files.setBounds(180,50,200,30);
      g.drawString("Swap audio",20,120);
      SwapAudioYes.setBounds(230,100,150,26);
      SwapAudioNo.setBounds(230,130,150,26);
    } else if (state == DiscToDiscMenu) {
      g.drawString("Source Device",20,70);
      src_drive.setBounds(20,75,200,30);
      g.drawString("Destination Device",20,140);
      dest_drive.setBounds(20,145,200,30);
    } else if (state == BurnMenu) {
      g.drawString("Speed",20,70);
      SpeedOne.setBounds(230,50,100,30);
      SpeedTwo.setBounds(230,80,100,30);
      SpeedFour.setBounds(230,110,100,30);
      TestBefore.setBounds(230,150,150,30);
      WriteOnTheFly.setBounds(230,180,150,30);
    }
  }

  private void help(int state) {
    String title = new String("Help: ");

    if (state == CDTypeMenu) {
      title = title.concat("CD Type Menu");
      Output hlp_window = new Output(title,400,400);

      hlp_window.println("Multisession CD-ROM:");
      hlp_window.println("Standard data CD-ROM. It can be multisession,");
      hlp_window.println("with data linking to an already present session");
      hlp_window.println("on the disc, or single session, if the media is new");
      hlp_window.println("or if the loading previous session option is not selected.");
      hlp_window.println("");
      hlp_window.println("CD-ROM:");
      hlp_window.println("Standard data CD-ROM. Select this CD type when");
      hlp_window.println("you no longer need to write more data to the disc. ");
      hlp_window.println("");
      hlp_window.println("Audio CD:");
      hlp_window.println("Audio CD in the Red Book (CD-DA) format. This type");
      hlp_window.println("of CD can be played back on any CD player.");
      hlp_window.println("");
      hlp_window.println("CD Copy:");
      hlp_window.println("Make a complete copy from an existing CD to another");
      hlp_window.println("CD using a SCSI CD-ROM drive as the source.");
      hlp_window.println("");
      hlp_window.println("Mixed-Mode CD:");
      hlp_window.println("A CD containing computer data in the first track");
      hlp_window.println("followed by one or more tracks of CD-DA audio.");
      hlp_window.println("A Mixed-Mode CD can be played back by any CD-ROM drive.");

    } else if (state == FileNameMenu) {
      title = title.concat("Filenames Menu");
      Output hlp_window = new Output(title,400,400);

      hlp_window.println("Rock Ridge:");
      hlp_window.println("Unix type file-system. You can clear the");
      hlp_window.println("user and group ids from the files.");
      hlp_window.println("");
      hlp_window.println("Windows 95/NT:");
      hlp_window.println("Windows type file-system. You can choose");
      hlp_window.println("the Joliet file-system, which supports up");
      hlp_window.println("to 64 characters.");
      hlp_window.println("");
      hlp_window.println("ISO-9660:");
      hlp_window.println("Standard type file-system. This file-system");
      hlp_window.println("can be read back by any operating system.");

    } else if (state == ModeMenu) {
      title = title.concat("Mode Menu");
      Output hlp_window = new Output(title,400,400);

      hlp_window.println("Mode-1:");
      hlp_window.println("CD-ROM data track in mode-1.");
      hlp_window.println("");
      hlp_window.println("XA-2:");
      hlp_window.println("CD-ROM data track in XA-2 mode.");
      hlp_window.println("Choose this mode, if you are not");
      hlp_window.println("sure which mode to select.");
    } else if (state == LoadContentsMenu) {
      title = title.concat("Load Contents Menu");
      Output hlp_window = new Output(title,400,400);

      hlp_window.println("Magic Parameters:");
      hlp_window.println("The magic parameters enables you to include");
      hlp_window.println("a previous session. Press the \"Get msinfo\"");
      hlp_window.println("button to get the parameters.");
      hlp_window.println("");
      hlp_window.println("Read Device:");
      hlp_window.println("The SCSI CDROM drive where the CD is located");
      hlp_window.println("your want to append to.");

    } else if (state == DATAMenu) {
      title = title.concat("DATA Menu");
      Output hlp_window = new Output(title,400,400);

      hlp_window.println("Source Directory:");
      hlp_window.println("The directory where the files you want to");
      hlp_window.println("burn are located.");
      hlp_window.println("");
      hlp_window.println("Volume ID:");
      hlp_window.println("The CD's label.");
      hlp_window.println("");
      hlp_window.println("Volume Preparer:");
      hlp_window.println("The CD's preparer.");
      hlp_window.println("");
      hlp_window.println("Volume Publisher:");
      hlp_window.println("The CD's publisher.");
      hlp_window.println("");
      hlp_window.println("Application ID:");
      hlp_window.println("The CD's application id.");
      hlp_window.println("");

    } else if (state == AUDIOMenu) {
      title = title.concat("Audio Menu");
      Output hlp_window = new Output(title,400,400);

      hlp_window.println("Audio files:");
      hlp_window.println("The path to the audio files you want to");
      hlp_window.println("burn.");
      hlp_window.println("");
      hlp_window.println("Swap audio:");
      hlp_window.println("Use the swap option if you are using");
      hlp_window.println("input files that are in little-endian (Intel)");
      hlp_window.println("order.");

    } else if (state == DiscToDiscMenu) {
      title = title.concat("Disc to Disc Menu");
      Output hlp_window = new Output(title,400,400);

      hlp_window.println("Source Device:");
      hlp_window.println("The source SCSI CD-ROM drive.");
      hlp_window.println("This must be different than your CD-Recorder.");
      hlp_window.println("");
      hlp_window.println("Destination Device:");
      hlp_window.println("This must be your CD-Recorder.");

    } else if (state == BurnMenu) {
      title = title.concat("Burn Menu");
      Output hlp_window = new Output(title,400,400);

      hlp_window.println("Speed:");
      hlp_window.println("Select the speed your CD-Recorder should");
      hlp_window.println("burn with.");
      hlp_window.println("");
      hlp_window.println("Test write:");
      hlp_window.println("Test the setup before burning anything for");
      hlp_window.println("real.");
      hlp_window.println("");
      hlp_window.println("Write directly:");
      hlp_window.println("Write the files directly to the CD-Recorder");
      hlp_window.println("without using a image.");
    }
  }

  private void showCDTypeMenu(boolean state) {
    MultisessionCD.setVisible(state);
    CDROM.setVisible(state);
    Audio.setVisible(state);
    CDCopy.setVisible(state);
    MixedModeCD.setVisible(state);
    prev_button.setVisible(!state);
  }

  private void showFileNameMenu(boolean state) {
    RockRidge.setVisible(state);
    Win95NT.setVisible(state);
    DOS.setVisible(state);
    RockType.setVisible(false);
    Joliet.setVisible(false);
  }

  private void showModeMenu(boolean state) {
    Mode1.setVisible(state);
    XA2.setVisible(state);
  }

  private void showLoadContentsMenu(boolean state) {
    LoadYes.setVisible(state);
    LoadNo.setVisible(state);
    ReadDevice.setVisible(false);
    Offset.setVisible(false);
    GetMSInfo.setVisible(false);
  }

  private void showDATAMenu(boolean state) {
    srcdir.setVisible(state);
    volume_id.setVisible(state);
    volume_pre.setVisible(state);
    volume_pub.setVisible(state);
    appl_id.setVisible(state);
  }

  private void showAUDIOMenu(boolean state) {
    audio_files.setVisible(state);
    SwapAudioYes.setVisible(state);
    SwapAudioNo.setVisible(state);
  }

  private void showDiscToDiscMenu(boolean state) {
    String cmd = new String("dev=");
    src_drive.setVisible(state);
    dest_drive.setVisible(state);
    cmd = cmd.concat(util.getDevNumber());
    dest_drive.setText(cmd);
  }

  private void showBurnMenu(boolean state) {
    next_button.setVisible(!state);
    burn_button.setVisible(state);
    SpeedOne.setVisible(state);
    SpeedTwo.setVisible(state);
    SpeedFour.setVisible(state);
    TestBefore.setVisible(state);
    if (state) {
      if (isMultisessionCD) {
	if (LoadNo.getState()) {
	  WriteOnTheFly.setVisible(true);
	} else {
	  WriteOnTheFly.setVisible(false);
	}
      } else if (isCDROM) {
	WriteOnTheFly.setVisible(true);
      } else if (isAudio) {
	WriteOnTheFly.setVisible(false);
      } else if (isCDCopy) {
	WriteOnTheFly.setVisible(false);
      } else if (isMixedModeCD) {
	WriteOnTheFly.setVisible(false);
      }
    } else {
      WriteOnTheFly.setVisible(false);
    }
  }

  private void clearState() {
    showCDTypeMenu(true);
    isMultisessionCD = false;
    isCDROM = false;
    isAudio = false;
    isCDCopy = false;
    isMixedModeCD = false;
    state = CDTypeMenu;
    setTitle("Simple menu");
  }

  private String cdrecordBase() {
    String cmd = new String(" dev=");

    cmd = cmd.concat(util.getDevNumber());
    cmd = cmd.concat(" speed=");
    if (SpeedOne.getState()) {
      cmd = cmd.concat("1");
    } else if (SpeedTwo.getState()) {
      cmd = cmd.concat("2");
    } else {
      cmd = cmd.concat("4");
    }
    cmd = cmd.concat(" -v");
    if (util.getComment().compareTo("") != 0) {
      cmd = cmd.concat(" ");
      cmd = cmd.concat(util.getComment());
    }
    if (TestBefore.getState()) {
      cmd = cmd.concat(" -dummy");
    }
    cmd = cmd.concat(" -pad");
    return cmd;
  }

  private String audioSwap() {
    String cmd = new String("");

    if (SwapAudioYes.getState()) {
      cmd = cmd.concat(" -swap");
    }
    return cmd;
  }

  private String mkisofsFile() {
    String cmd = new String("");

    if (RockRidge.getState()) {
      cmd = cmd.concat(" -a -l -L");
      if (RockType.getState()) {
	cmd = cmd.concat(" -r");
      } else {
	cmd = cmd.concat(" -R");
      }
    } else if (Win95NT.getState()) {
      cmd = cmd.concat(" -a -D -l");
      if (Joliet.getState()) {
	cmd = cmd.concat(" -J");
      }
    } else {
      cmd = cmd.concat(" -a");
    }
    cmd = cmd.concat(" -v");
    return cmd;
  }

  private String mkisofsInfo() {
    String cmd = new String("");

    if (volume_id.getText().compareTo("") != 0) {
      cmd = cmd.concat(" -V \"");
      cmd = cmd.concat(volume_id.getText());
      cmd = cmd.concat("\"");
    }
    if (volume_pre.getText().compareTo("") != 0) {
      cmd = cmd.concat(" -p \"");
      cmd = cmd.concat(volume_pre.getText());
      cmd = cmd.concat("\"");
    }
    if (volume_pub.getText().compareTo("") != 0) {
      cmd = cmd.concat(" -P \"");
      cmd = cmd.concat(volume_pub.getText());
      cmd = cmd.concat("\"");
    }
    if (appl_id.getText().compareTo("") != 0) {
      cmd = cmd.concat(" -A \"");
      cmd = cmd.concat(appl_id.getText());
      cmd = cmd.concat("\"");
    }
    return cmd;
  }

  private String mkisofsMulti() {
    String cmd = new String("");
    
    if (LoadYes.getState()) {
      cmd = cmd.concat(" -C ");
      cmd = cmd.concat(Offset.getText());
      cmd = cmd.concat(" -M ");
      cmd = cmd.concat(ReadDevice.getText());
    }
    return cmd;
  }

  private String mkisofsImage() {
    String cmd = new String("");
    
    if (WriteOnTheFly.getState() == false) {
      cmd = cmd.concat(" -o ");
      cmd = cmd.concat(util.getTmp());
      cmd = cmd.concat("/image");
    }
    return cmd;
  }

  private String mkisofsEnd() {
    String cmd = new String("");
    
    cmd = cmd.concat(" ");
    cmd = cmd.concat(srcdir.getText());
    return cmd;
  }

  private String cdrecordDATA() {
    String cmd = new String("");
    
    if (Mode1.getState()) {
      cmd = cmd.concat(" -data ");
    } else {
      cmd = cmd.concat(" -xa2 ");
    }
    if (WriteOnTheFly.getState() == false) {
      cmd = cmd.concat(util.getTmp());
      cmd = cmd.concat("/image");
    } else {
      cmd = cmd.concat(" -");
    }
    return cmd;
  }

  private String cdrecordAUDIO() {
    String cmd = new String("");

    cmd = cmd.concat(" -audio ");
    cmd = cmd.concat(audio_files.getText());
    return cmd;
  }

  private String cdrecordDisc2Disc() {
    String cmd = new String("");

    cmd = cmd.concat(" -v ");
    cmd = cmd.concat(dest_drive.getText());
    cmd = cmd.concat(" speed=");
    if (SpeedOne.getState()) {
      cmd = cmd.concat("1");
    } else if (SpeedTwo.getState()) {
      cmd = cmd.concat("2");
    } else {
      cmd = cmd.concat("4");
    }
    if (TestBefore.getState()) {
      cmd = cmd.concat(" -dummy");
    }
    cmd = cmd.concat(" -isosize ");
    cmd = cmd.concat(src_drive.getText());
    
    return cmd;
  }

  private void generate_cmds() {
    String commandCDRECORD = new String("./cdrecord");
    String commandMKISOFS = new String("./mkisofs");
    String commandDD = new String("dd");
    String cmd = new String("");

    if (isMultisessionCD) {
      commandMKISOFS = commandMKISOFS.concat(mkisofsFile());
      commandMKISOFS = commandMKISOFS.concat(mkisofsInfo());
      commandMKISOFS = commandMKISOFS.concat(mkisofsMulti());
      commandMKISOFS = commandMKISOFS.concat(mkisofsImage());
      commandMKISOFS = commandMKISOFS.concat(mkisofsEnd());

      commandCDRECORD = commandCDRECORD.concat(cdrecordBase());
      commandCDRECORD = commandCDRECORD.concat(" -multi");
      commandCDRECORD = commandCDRECORD.concat(cdrecordDATA());

      if (WriteOnTheFly.getState() == false) {
	Supervisor sv = new Supervisor();
	String[] cmdmkiso = new String[1];

	cmdmkiso[0] = commandMKISOFS;
	ExecuteCmdsThread th = new ExecuteCmdsThread(cmdmkiso, 1, 1, sv);
	sv.addThread(th);

	String[] cmdcdrec = new String[1];
	cmdcdrec[0] = commandCDRECORD;
	ExecuteCmdsThread th2 = new ExecuteCmdsThread(cmdcdrec, 1, 1, sv);
	sv.addThread(th2);

	cmd = cmd.concat("rm -f ");
	cmd = cmd.concat(util.getTmp());
	cmd = cmd.concat("/image");

	String[] cmdrm = new String[1];
	cmdrm[0] = cmd;
	ExecuteCmdsThread th3 = new ExecuteCmdsThread(cmdrm, 1, 1, sv);
	sv.addThread(th3);

	sv.go();
      } else {
	util.execute_pipe(commandMKISOFS,commandCDRECORD);
      }
    } else if (isCDROM) {
      commandMKISOFS = commandMKISOFS.concat(mkisofsFile());
      commandMKISOFS = commandMKISOFS.concat(mkisofsInfo());
      commandMKISOFS = commandMKISOFS.concat(mkisofsImage());
      commandMKISOFS = commandMKISOFS.concat(mkisofsEnd());

      commandCDRECORD = commandCDRECORD.concat(cdrecordBase());
      commandCDRECORD = commandCDRECORD.concat(cdrecordDATA());

      if (WriteOnTheFly.getState() == false) {
	Supervisor sv = new Supervisor();
	String[] cmdmkiso = new String[1];

	cmdmkiso[0] = commandMKISOFS;
	ExecuteCmdsThread th = new ExecuteCmdsThread(cmdmkiso, 1, 1, sv);
	sv.addThread(th);

	String[] cmdcdrec = new String[1];
	cmdcdrec[0] = commandCDRECORD;
	ExecuteCmdsThread th2 = new ExecuteCmdsThread(cmdcdrec, 1, 1, sv);
	sv.addThread(th2);

	cmd = cmd.concat("rm -f ");
	cmd = cmd.concat(util.getTmp());
	cmd = cmd.concat("/image");

	String[] cmdrm = new String[1];
	cmdrm[0] = cmd;
	ExecuteCmdsThread th3 = new ExecuteCmdsThread(cmdrm, 1, 1, sv);
	sv.addThread(th3);

	sv.go();
      } else {
	util.execute_pipe(commandMKISOFS,commandCDRECORD);
      }
    } else if (isAudio) {
      commandCDRECORD = commandCDRECORD.concat(cdrecordBase());
      commandCDRECORD = commandCDRECORD.concat(audioSwap());
      commandCDRECORD = commandCDRECORD.concat(cdrecordAUDIO());

      ExecuteThread th = new ExecuteThread(commandCDRECORD);
    } else if (isCDCopy) {
      commandCDRECORD = commandCDRECORD.concat(cdrecordDisc2Disc());

      ExecuteThread th = new ExecuteThread(commandCDRECORD);
    } else if (isMixedModeCD) {
      commandMKISOFS = commandMKISOFS.concat(mkisofsFile());
      commandMKISOFS = commandMKISOFS.concat(mkisofsInfo());
      commandMKISOFS = commandMKISOFS.concat(mkisofsImage());
      commandMKISOFS = commandMKISOFS.concat(mkisofsEnd());

      commandCDRECORD = commandCDRECORD.concat(cdrecordBase());
      commandCDRECORD = commandCDRECORD.concat(audioSwap());
      commandCDRECORD = commandCDRECORD.concat(cdrecordDATA());
      commandCDRECORD = commandCDRECORD.concat(cdrecordAUDIO());

      Supervisor sv = new Supervisor();
      String[] cmdmkiso = new String[1];

      cmdmkiso[0] = commandMKISOFS;
      ExecuteCmdsThread th = new ExecuteCmdsThread(cmdmkiso, 1, 1, sv);
      sv.addThread(th);

      String[] cmdcdrec = new String[1];
      cmdcdrec[0] = commandCDRECORD;
      ExecuteCmdsThread th2 = new ExecuteCmdsThread(cmdcdrec, 1, 1, sv);
      sv.addThread(th2);

      cmd = cmd.concat("rm -f ");
      cmd = cmd.concat(util.getTmp());
      cmd = cmd.concat("/image");
      
      String[] cmdrm = new String[1];
      cmdrm[0] = cmd;
      ExecuteCmdsThread th3 = new ExecuteCmdsThread(cmdrm, 1, 1, sv);
      sv.addThread(th3);
      
      sv.go();
    }
  }

  public void itemStateChanged(ItemEvent event) {
    // If a Checkbox was clicked on, handle it.
    if (event.getSource() instanceof Checkbox) {
      repaint();
    }
  }

  public void actionPerformed(ActionEvent event) {
    // If the Cancel button was clicked on, handle it.
    if (event.getSource() == cancel_button) {
      setVisible(false);
      dispose();
    }
    // If the Next button was clicked on, handle it.
    else if (event.getSource() == next_button) {
      if (state == CDTypeMenu) {
	showCDTypeMenu(false);
	if (MultisessionCD.getState()) {
	  setTitle("Simple menu : Multisession CD");
	  isMultisessionCD = true;
	  showFileNameMenu(true);
	  state = FileNameMenu;
	} else if (CDROM.getState()) {
	  setTitle("Simple menu : CD-ROM");
	  isCDROM = true;
	  showFileNameMenu(true);
	  state = FileNameMenu;
	} else if (Audio.getState()) {
	  setTitle("Simple menu : Audio CD");
	  isAudio = true;
	  showAUDIOMenu(true);
	  state = AUDIOMenu;
	} else if (CDCopy.getState()) {
	  setTitle("Simple menu : Disc To Disc");
	  isCDCopy = true;
	  showDiscToDiscMenu(true);
	  state = DiscToDiscMenu;
	} else if (MixedModeCD.getState()) {
	  setTitle("Simple menu : Mixed-Mode CD");
	  isMixedModeCD = true;
	  showFileNameMenu(true);
	  state = FileNameMenu;
	}
      } else if (state == FileNameMenu) {
	showFileNameMenu(false);
	if (isMultisessionCD) {
	  showModeMenu(true);
	  state = ModeMenu;
	} else if (isCDROM) {
	  showModeMenu(true);
	  state = ModeMenu;
	} else if (isMixedModeCD) {
	  showModeMenu(true);
	  state = ModeMenu;
	}
      } else if (state == ModeMenu) {
	showModeMenu(false);
	if (isMultisessionCD) {
	  showLoadContentsMenu(true);
	  state = LoadContentsMenu;
	} else if (isCDROM) {
	  showDATAMenu(true);
	  state = DATAMenu;
	} else if (isMixedModeCD) {
	  showDATAMenu(true);
	  state = DATAMenu;
	}
      } else if (state == LoadContentsMenu) {
	showLoadContentsMenu(false);
	showDATAMenu(true);
	state = DATAMenu;
      } else if (state == DATAMenu) {
	showDATAMenu(false);
	if (isMultisessionCD) {
	  showBurnMenu(true);
	  state = BurnMenu;
	} else if (isCDROM) {
	  showBurnMenu(true);
	  state = BurnMenu;
	} else if (isMixedModeCD) {
	  showAUDIOMenu(true);
	  state = AUDIOMenu;
	}
      } else if (state == AUDIOMenu) {
	showAUDIOMenu(false);
	showBurnMenu(true);
	state = BurnMenu;
      } else if (state == DiscToDiscMenu) {
	showDiscToDiscMenu(false);
	showBurnMenu(true);
	state = BurnMenu;
      } else if (state == BurnMenu) {

      }
      repaint();
    }
    // If the Prev button was clicked on, handle it.
    else if (event.getSource() == prev_button) {
      if (isMultisessionCD) {
	if (state == FileNameMenu) {
	  showFileNameMenu(false);
	  clearState();
	} else if (state == ModeMenu) {
	  showModeMenu(false);
	  showFileNameMenu(true);
	  state = FileNameMenu;
	} else if (state == LoadContentsMenu) {
	  showLoadContentsMenu(false);
	  showModeMenu(true);
	  state = ModeMenu;
	} else if (state == DATAMenu) {
	  showDATAMenu(false);
	  showLoadContentsMenu(true);
	  state = LoadContentsMenu;
	} else if (state == BurnMenu) {
	  showBurnMenu(false);
	  showDATAMenu(true);
	  state = DATAMenu;
	}
      } else if (isCDROM) {
	if (state == FileNameMenu) {
	  showFileNameMenu(false);
	  clearState();
	} else if (state == ModeMenu) {
	  showModeMenu(false);
	  showFileNameMenu(true);
	  state = FileNameMenu;
	} else if (state == DATAMenu) {
	  showDATAMenu(false);
	  showModeMenu(true);
	  state = ModeMenu;
	} else if (state == BurnMenu) {
	  showBurnMenu(false);
	  showDATAMenu(true);
	  state = DATAMenu;
	} 
      } else if (isAudio) {
	if (state == AUDIOMenu) {
	  showAUDIOMenu(false);
	  clearState();
	} else {
	  showBurnMenu(false);
	  showAUDIOMenu(true);
	  state = AUDIOMenu;
	}
      } else if (isCDCopy) {
	if (state == DiscToDiscMenu) {
	  showDiscToDiscMenu(false);
	  clearState();
	} else {
	  showBurnMenu(false);
	  showDiscToDiscMenu(true);
	  state = DiscToDiscMenu;
	}
      } else if (isMixedModeCD) {
	if (state == FileNameMenu) {
	  showFileNameMenu(false);
	  clearState();
	} else if (state == ModeMenu) {
	  showModeMenu(false);
	  showFileNameMenu(true);
	  state = FileNameMenu;
	} else if (state == DATAMenu) {
	  showDATAMenu(false);
	  showModeMenu(true);
	  state = ModeMenu;
	} else if (state == AUDIOMenu) {
	  showAUDIOMenu(false);
	  showDATAMenu(true);
	  state = DATAMenu;
	} else {
	  showBurnMenu(false);
	  showAUDIOMenu(true);
	  state = AUDIOMenu;
	}
      }
      repaint();
    }
    // If the Burn button was clicked on, handle it.
    else if (event.getSource() == burn_button) {
      generate_cmds();
    }
    // If the GetMSInfo button was clicked on, handle it.
    else if (event.getSource() == GetMSInfo) {
      Offset.setText(util.getMagicParameters());
    } else
    // If the Help button was clicked on, handle it.
    if (event.getSource() == hlp_button) {
      help(state);
    } 
  }
}
