/*
 *  Copyright (C) 1998  Jesper Pedersen <jews@imada.ou.dk>
 *  This code is released under GNU GPL version 2 or later
 */
import java.awt.*;
import java.awt.event.*;
import java.lang.*;
import java.util.*;

public class Setup extends Frame implements ActionListener, ItemListener {
  private Button cancel_button;   
  private Button next_button;     
  private Button prev_button;     
  private Button save_button;     
  private Button select_button;     
  private Button auto_button;     
  private Button hlp_button;     
  private Checkbox RockType;
  private Checkbox Joliet;
  private Checkbox RockRidge;
  private Checkbox Win95NT;
  private Checkbox DOS;
  private CheckboxGroup FileType;
  private TextField comments;
  private TextField unitnr;
  private List CDRModel;
  private String s = new String("");
  private Font font,font2;            
  private static Utils util = new Utils();
  private WriteTextFile wf;

  private static final int ModelMenu = 0;
  private static final int SourceMenu = 1;
  private static final int ReadMenu = 2;
  private static final int MntTmpMenu = 4;
  private int state = ModelMenu;

  private Choice ReadSpeed;
  private Choice WriteSpeed;

  private TextField source;
  private TextField mnt;
  private TextField tmp;
  private TextField rd;
  private TextField rdg;


  public Setup() {
    setTitle("Setup menu");

    font = new Font("Helvetica", Font.BOLD, 18);
    font2 = new Font("Helvetica", Font.BOLD, 12);

    // Set the background color
    setBackground(Color.white);

    // Create buttons.
    next_button = new Button("Next >");
    next_button.setForeground(Color.black);
    next_button.setBackground(Color.lightGray);
    add("South", next_button);
    next_button.addActionListener(this);

    prev_button = new Button("< Prev");
    prev_button.setForeground(Color.black);
    prev_button.setBackground(Color.lightGray);
    prev_button.setVisible(false);
    add("South", prev_button);
    prev_button.addActionListener(this);

    save_button = new Button("Save");
    save_button.setForeground(Color.black);
    save_button.setBackground(Color.lightGray);
    save_button.setVisible(false);
    add("South", save_button);
    save_button.addActionListener(this);

    select_button = new Button("Select");
    select_button.setForeground(Color.black);
    select_button.setBackground(Color.lightGray);
    add("South", select_button);
    select_button.addActionListener(this);

    auto_button = new Button("Auto");
    auto_button.setForeground(Color.black);
    auto_button.setBackground(Color.lightGray);
    add("South", auto_button);
    auto_button.addActionListener(this);

    hlp_button = new Button("Help");
    hlp_button.setForeground(Color.black);
    hlp_button.setBackground(Color.lightGray);
    add("South", hlp_button);
    hlp_button.addActionListener(this);

    cancel_button = new Button("Cancel");
    cancel_button.setForeground(Color.black);
    cancel_button.setBackground(Color.lightGray);
    add("South", cancel_button);
    cancel_button.addActionListener(this);

    comments = new TextField(100);
    comments.setEditable(false);
    comments.setForeground(Color.black);
    comments.setBackground(Color.white);
    add(comments);
    comments.addActionListener(this);

    unitnr = new TextField(100);
    unitnr.setEditable(true);
    unitnr.setForeground(Color.black);
    unitnr.setBackground(Color.white);
    add(unitnr);
    unitnr.addActionListener(this);

    if (util.getDevNumber().compareTo("") != 0) {
      unitnr.setText(util.getDevNumber());
    }

    ReadSpeed = new Choice();
    ReadSpeed.addItem(" 1");
    ReadSpeed.addItem(" 2");
    ReadSpeed.addItem(" 4");
    ReadSpeed.addItem(" 6");
    ReadSpeed.addItem(" 8");
    ReadSpeed.addItem("10");
    ReadSpeed.addItem("12");
    add("South",ReadSpeed);
    ReadSpeed.addItemListener(this);
    ReadSpeed.select(util.getRead());

    WriteSpeed = new Choice();
    WriteSpeed.addItem(" 1");
    WriteSpeed.addItem(" 2");
    WriteSpeed.addItem(" 4");
    add("South",WriteSpeed);
    WriteSpeed.addItemListener(this);
    WriteSpeed.select(util.getWrite());

    CDRModel = new List();
    CDRModel.addItem("COMPRO CW-7502");
    CDRModel.addItem("Dysan CR-622");
    CDRModel.addItem("Dysan CR-1622");
    CDRModel.addItem("DynaTec CDM-240J");
    CDRModel.addItem("DynaTec CDM-240");
    CDRModel.addItem("DynaTec CDM-400");
    CDRModel.addItem("Grundig CDR-100");
    CDRModel.addItem("Hewlett Packard 4020i");
    CDRModel.addItem("Hewlett Packard 6020i");
    CDRModel.addItem("HP C4324/C4325");
    CDRModel.addItem("HP 7100");
    CDRModel.addItem("HP 7110");
    CDRModel.addItem("Hi-Val CD-R");
    CDRModel.addItem("JVC XR-W2001");
    CDRModel.addItem("JVC XR-W2010");
    CDRModel.addItem("JVC XR-W2020");
    CDRModel.addItem("Kodak PCD-200");
    CDRModel.addItem("Kodak PCD-200 Plus");
    CDRModel.addItem("Kodak PCD-225");
    CDRModel.addItem("Kodak PCD-240");
    CDRModel.addItem("Kodak PCD-600");
    CDRModel.addItem("Matsushita CW-7502");
    CDRModel.addItem("Memorex CR-622");
    CDRModel.addItem("Memorex CR-1622");	
    CDRModel.addItem("Microboards PlayWrite 2000");
    CDRModel.addItem("Microboards PlayWrite 4000");
    CDRModel.addItem("Microboards PlayWrite 4001RW");
    CDRModel.addItem("MicroNet MasterCD Plus 4x4");
    CDRModel.addItem("MicroNet MasterCD Plus 4x6");
    CDRModel.addItem("Mitsumi CR-2401-TS");
    CDRModel.addItem("Mitsumi CR-2600-TE");
    CDRModel.addItem("Olympus CDS615E");
    CDRModel.addItem("Olympus CDS620E");
    CDRModel.addItem("Olympus CD-R2x6");
    CDRModel.addItem("Optima Dis Kovery 650 CD-R");
    CDRModel.addItem("OTI CDRW 965");
    CDRModel.addItem("Panasonic CW-7502");
    CDRModel.addItem("Philips CDD-521");
    CDRModel.addItem("Philips CDD-522");
    CDRModel.addItem("Philips CDD-2000");
    CDRModel.addItem("Philips CDD-2600");
    CDRModel.addItem("Philips CDD-3600");
    CDRModel.addItem("Philips CDD-3610");
    CDRModel.addItem("Philips Omniwriter 26");
    CDRModel.addItem("Philips Omniwriter 26A");
    CDRModel.addItem("Pinnacle Micro RCD-1000");
    CDRModel.addItem("Pinnacle Micro RCD-5020");
    CDRModel.addItem("Pinnacle Micro RCD-5040");
    CDRModel.addItem("Pinnacle Micro RCD-4x4");
    CDRModel.addItem("Pioneer DW-S114X");
    CDRModel.addItem("Plasmon CDR 4220");
    CDRModel.addItem("Plasmon RF-4100");
    CDRModel.addItem("Plasmon RF-4102");
    CDRModel.addItem("Plasmon CDR 4400");
    CDRModel.addItem("Plasmon CDR 480");
    CDRModel.addItem("Plextor PX-R24CS");
    CDRModel.addItem("Plextor PX-R412C");
    CDRModel.addItem("Procom PCDR 4");
    CDRModel.addItem("Ricoh RO-1420C");
    CDRModel.addItem("Ricoh MP-6200");
    CDRModel.addItem("Ricoh MP-6200I");
    CDRModel.addItem("Ricoh MP-6201");
    CDRModel.addItem("Smart & Friendly CD-R1002");
    CDRModel.addItem("Smart & Friendly CD-R1004");
    CDRModel.addItem("Smart & Friendly CD-R2004");
    CDRModel.addItem("Smart & Friendly CD-R2006 PLUS");
    CDRModel.addItem("Smart & Friendly CD-R2006 PRO");
    CDRModel.addItem("Smart & Friendly CD-R4000");
    CDRModel.addItem("Smart & Friendly CD-R4006");
    CDRModel.addItem("Smart & Friendly CD-R4012");
    CDRModel.addItem("Smart & Friendly CD-RW226");
    CDRModel.addItem("Sony CDU920S");
    CDRModel.addItem("Sony CDU924S");
    CDRModel.addItem("Sony CDU926S");
    CDRModel.addItem("Sony CDU940S");
    CDRModel.addItem("TEAC CD-R50S");
    CDRModel.addItem("TEAC CD-R55S");
    CDRModel.addItem("Taiyo Yuden CD-WO EW-50");
    CDRModel.addItem("Traxdata CDR-4120");
    CDRModel.addItem("Traxdata CDRW-4260");
    CDRModel.addItem("Turtle Beach 2040R");
    CDRModel.addItem("Wearnes CD-R622");
    CDRModel.addItem("Wearnes CD-R632P");
    CDRModel.addItem("Yamaha CDR-100");
    CDRModel.addItem("Yamaha CDR-102");
    CDRModel.addItem("Yamaha CDR-200");
    CDRModel.addItem("Yamaha CDR-400");
    CDRModel.addItem("Yamaha CDR-401");
    CDRModel.addItem("Yamaha CRW-2260");
    CDRModel.addItem("Yamaha CRW-4001");
    CDRModel.addItem("Yamaha CRW-4260");
    add("South",CDRModel);
    CDRModel.addActionListener(this);

    s = util.getCDRModel();
    if (s.compareTo("") != 0) {
      int i=0;
      CDRModel.select(i);
      while (CDRModel.getSelectedItem().compareTo(s) != 0) {
	i++;
	CDRModel.select(i);
      }
      CDRModel.makeVisible(CDRModel.getSelectedIndex());
      comments.setText(getComments());
    }

    source = new TextField(100);
    source.setEditable(true);
    source.setForeground(Color.black);
    source.setBackground(Color.white);
    source.setVisible(false);
    add(source);
    source.addActionListener(this);

    source.setText(util.getDflSourcePath());

    FileType = new CheckboxGroup();
    RockRidge = new Checkbox("Rock Ridge   ", false, FileType);
    add(RockRidge);
    RockRidge.addItemListener(this);
    RockRidge.setVisible(false);
    Win95NT = new Checkbox("Windows 95/NT", false, FileType);
    add(Win95NT);
    Win95NT.addItemListener(this);
    Win95NT.setVisible(false);
    DOS = new Checkbox("ISO-9660     ", true, FileType);
    add(DOS);
    DOS.addItemListener(this);
    DOS.setVisible(false);
    RockType = new Checkbox("Clear User-ID", true);
    add(RockType);
    RockType.addItemListener(this);
    RockType.setVisible(false);
    Joliet = new Checkbox("Joliet Filesystem", false);
    add(Joliet);
    Joliet.addItemListener(this);
    Joliet.setVisible(false);

    s = util.getFileSystem();
    if (s.compareTo("Real Rock Ridge") == 0) {
      RockRidge.setState(true);
      RockType.setState(false);
    } else if (s.compareTo("Rock Ridge") == 0) {
      RockRidge.setState(true);
      RockType.setState(true);
    } else if (s.compareTo("Joliet") == 0) {
      Win95NT.setState(true);
      Joliet.setState(true);
    } else if (s.compareTo("Windows") == 0) {
      Win95NT.setState(true);
      Joliet.setState(false);
    } else if (s.compareTo("ISO9660") == 0) {
      DOS.setState(true);
    }

    mnt = new TextField(100);
    mnt.setEditable(true);
    mnt.setForeground(Color.black);
    mnt.setBackground(Color.white);
    mnt.setVisible(false);
    mnt.setText(util.getMnt());
    add(mnt);
    mnt.addActionListener(this);

    tmp = new TextField(100);
    tmp.setEditable(true);
    tmp.setForeground(Color.black);
    tmp.setBackground(Color.white);
    tmp.setVisible(false);
    tmp.setText(util.getTmp());
    add(tmp);
    tmp.addActionListener(this);

    rd = new TextField(100);
    rd.setEditable(true);
    rd.setForeground(Color.black);
    rd.setBackground(Color.white);
    rd.setVisible(false);
    rd.setText(util.getReadDevice());
    add(rd);
    rd.addActionListener(this);

    rdg = new TextField(100);
    rdg.setEditable(true);
    rdg.setForeground(Color.black);
    rdg.setBackground(Color.white);
    rdg.setVisible(false);
    rdg.setText(util.getReadDeviceGeneric());
    add(rdg);
    rdg.addActionListener(this);

    setSize(430,300);
    setResizable(false);
    show();
    repaint();
  }

  private String getComments(){
    String comment = new String("");

    if (CDRModel.getSelectedItem().compareTo("DynaTec CDM-240J") == 0) {
      comment = comment.concat("use driver=teac_cdr50");
    } else if (CDRModel.getSelectedItem().compareTo("DynaTec CDM-240") == 0) {
      comment = comment.concat("use driver=yamaha_cdr100");
    } else if (CDRModel.getSelectedItem().compareTo("DynaTec CDM-400") == 0) {
      comment = comment.concat("use driver=yamaha_cdr100");
    } else if (CDRModel.getSelectedItem().compareTo("Kodak PCD-600") == 0) {
      comment = comment.concat("not tested");
    } else if (CDRModel.getSelectedItem().compareTo("Hi-Val CD-R") == 0) {
      comment = comment.concat("use driver=teac_cdr50");
    } else if (CDRModel.getSelectedItem().compareTo("JVC XR-W2001") == 0) {
      comment = comment.concat("uses TEAC alpha code - audio not working");
    } else if (CDRModel.getSelectedItem().compareTo("JVC XR-W2010") == 0) {
      comment = comment.concat("uses TEAC alpha code - audio not working");
    } else if (CDRModel.getSelectedItem().compareTo("JVC XR-W2020") == 0) {
      comment = comment.concat("uses TEAC alpha code - audio not working");
    } else if (CDRModel.getSelectedItem().compareTo("Microboards PlayWrite 2000") == 0) {
      comment = comment.concat("use driver=sony_cdu924");
    } else if (CDRModel.getSelectedItem().compareTo("Microboards PlayWrite 4000") == 0) {
      comment = comment.concat("use driver=yamaha_cdr100");
    } else if (CDRModel.getSelectedItem().compareTo("MicroNet MasterCD Plus 4x4") == 0) {
      comment = comment.concat("use driver=yamaha_cdr100");
    } else if (CDRModel.getSelectedItem().compareTo("Mitsumi CR-2401-TS") == 0) {
      comment = comment.concat("not tested");
    } else if (CDRModel.getSelectedItem().compareTo("Olympus CDS620E") == 0) {
      comment = comment.concat("use driver=sony_cdu924");
    } else if (CDRModel.getSelectedItem().compareTo("Olympus CD-R2x6") == 0) {
      comment = comment.concat("use driver=sony_cdu924");
    } else if (CDRModel.getSelectedItem().compareTo("Optima Dis Kovery 650 CD-R") == 0) {
      comment = comment.concat("use driver=sony_cdu924");
    } else if (CDRModel.getSelectedItem().compareTo("Philips CDD-521") == 0) {
      comment = comment.concat("use revision: 2.07");
    } else if (CDRModel.getSelectedItem().compareTo("Pinnacle Micro RCD-1000") == 0) {
      comment = comment.concat("uses TEAC alpha code : Need to upgrade firmware to 2.35");
    } else if (CDRModel.getSelectedItem().compareTo("Pinnacle Micro RCD-5020") == 0) {
      comment = comment.concat("uses TEAC alpha code - audio not working");
    } else if (CDRModel.getSelectedItem().compareTo("Pinnacle Micro RCD-5040") == 0) {
      comment = comment.concat("uses TEAC alpha code - audio not working");
    } else if (CDRModel.getSelectedItem().compareTo("Plasmon CDR 4220") == 0) {
      comment = comment.concat("not tested");
    } else if (CDRModel.getSelectedItem().compareTo("Plasmon CDR 4400") == 0) {
      comment = comment.concat("use driver=yamaha_cdr100");
    } else if (CDRModel.getSelectedItem().compareTo("Plextor PX-R24CS") == 0) {
      comment = comment.concat("use driver=ricoh_ro1420c");
    } else if (CDRModel.getSelectedItem().compareTo("Procom PCDR 4") == 0) {
      comment = comment.concat("use driver=yamaha_cdr100");
    } else if (CDRModel.getSelectedItem().compareTo("Smart & Friendly CD-R1002") == 0) {
      comment = comment.concat("use driver=sony_cdu924");
    } else if (CDRModel.getSelectedItem().compareTo("Smart & Friendly CD-R1004") == 0) {
      comment = comment.concat("use driver=yamaha_cdr100");
    } else if (CDRModel.getSelectedItem().compareTo("Smart & Friendly CD-R2004") == 0) {
      comment = comment.concat("use driver=sony_cdu924");
    } else if (CDRModel.getSelectedItem().compareTo("Smart & Friendly CD-R4000") == 0) {
      comment = comment.concat("use driver=yamaha_cdr100");
    } else if (CDRModel.getSelectedItem().compareTo("Turtle Beach 2040R") == 0) {
      comment = comment.concat("use driver=ricoh_ro1420c");
    } else if (CDRModel.getSelectedItem().compareTo("Yamaha CDR-400") == 0) {
      comment = comment.concat("use firmware revision 1.0d and up");
    }
    if (comment.compareTo("") != 0) {
      comments.setEditable(true);
    }
    return comment;
  }

  private void help(int state) {
    String title = new String("Help: ");

    if (state == ModelMenu) {
      title = title.concat("Recorder Menu");
      Output hlp_window = new Output(title,400,400);

      hlp_window.println("Selection of your CD-Recorder:");
      hlp_window.println("You should press the \"Auto\" button to see");
      hlp_window.println("if your drive is auto-detected.");
      hlp_window.println("");
      hlp_window.println("Otherwise find your drive in the list and");
      hlp_window.println("press the \"Select\" button and fill out the");
      hlp_window.println("field \"ID,Bus\" with the devicenumbers.");
      hlp_window.println("");
      hlp_window.println("After that select the default read and write speed.");

    } else if (state == SourceMenu) {
      title = title.concat("Default Source Path Menu");
      Output hlp_window = new Output(title,400,400);

      hlp_window.println("Default Source Path:");
      hlp_window.println("Choose the directory where you usually keeps");
      hlp_window.println("your files you want to burn.");
      hlp_window.println("");
      hlp_window.println("Default File System:");
      hlp_window.println("Choose the file system you usually burns");
      hlp_window.println("your files in.");

    } else if (state == ReadMenu) {
      title = title.concat("Read Device Menu");
      Output hlp_window = new Output(title,400,400);

      hlp_window.println("Read Device:");
      hlp_window.println("Choose your read device; it must be");
      hlp_window.println("different than your recorder.");
      hlp_window.println("It could be /dev/scd1");
      hlp_window.println("");
      hlp_window.println("Native Read Device:");
      hlp_window.println("Choose your native read device; it must be");
      hlp_window.println("same as your recorder.");
      hlp_window.println("It could be /dev/sr0");

    } else if (state == MntTmpMenu) {
      title = title.concat("Mount / Temp directory Menu");
      Output hlp_window = new Output(title,400,400);

      hlp_window.println("Image Mount Point:");
      hlp_window.println("Choose the directory where you want to");
      hlp_window.println("mount the generated image for testing.");
      hlp_window.println("");
      hlp_window.println("Temp directory:");
      hlp_window.println("Choose the temp directory you want to use.");
      hlp_window.println("Note: This directory should be able to");
      hlp_window.println("      hold 650Mb of data!");

    }
  }

  private void save() {
    WriteTextFile wf;
    String s;
    String version = new String("VERSION=");
    String model = new String("CDR=");
    String comment = new String("COM=");
    String read = new String("READ=");
    String write = new String("WRITE=");
    String mount = new String("MNT=");
    String tmppath = new String("TMP=");
    String sourcepath = new String("SPATH=");
    String filesys = new String("FS=");
    String readdev = new String("RDDEV=");
    String readdevgen = new String("RDGDEV=");
    String adv = new String("ADV=");
    
    s = comments.getText();

    StringTokenizer st = new StringTokenizer(s);
    while (st.hasMoreTokens()) {
      s = st.nextToken();
      if (s.startsWith("driver")) {
	comment = comment.concat(s);
      }
    }

    if (Win95NT.getState()) {
      if (Joliet.getState()) {
	filesys = filesys.concat("Joliet");
      } else {
	filesys = filesys.concat("Windows");
      }
    } else if (RockRidge.getState()) {
      if (RockType.getState()) {
	filesys = filesys.concat("Rock Ridge");
      } else {
	filesys = filesys.concat("Real Rock Ridge");
      }
    } else if (DOS.getState()) {
      filesys = filesys.concat("ISO9660");
    }

    try {
      adv = adv.concat(util.getAdv());
      wf = new WriteTextFile(util.getConfigFileName());
      version = version.concat(util.getVersion());
      model = model.concat(CDRModel.getSelectedItem());
      model = model.concat(" | ");
      model = model.concat(unitnr.getText());
      read = read.concat(ReadSpeed.getSelectedItem());
      write = write.concat(WriteSpeed.getSelectedItem());
      mount = mount.concat(mnt.getText());
      tmppath = tmppath.concat(tmp.getText());
      sourcepath = sourcepath.concat(source.getText());
      readdev = readdev.concat(rd.getText());
      readdevgen = readdevgen.concat(rdg.getText());
      wf.writeLine(version);
      wf.writeLine(model);
      wf.writeLine(comment);
      wf.writeLine(read);
      wf.writeLine(write);
      wf.writeLine(mount);
      wf.writeLine(tmppath);
      wf.writeLine(sourcepath);
      wf.writeLine(filesys);
      wf.writeLine(readdev);
      wf.writeLine(readdevgen);
      wf.writeLine(adv);
      wf.close();
    } catch (Exception e) {
      System.out.println("I/O error");
      System.exit(1);
    }
  }

  public void paint(Graphics g) {
    next_button.setBounds(320,250,80,34);
    prev_button.setBounds(230,250,80,34);
    cancel_button.setBounds(20,250,80,34);
    hlp_button.setBounds(110,250,80,34);
    save_button.setBounds(320,250,80,34);
    g.setFont(font);
    g.setColor(Color.black);
    if (state == ModelMenu) {
      select_button.setBounds(20,115,80,34);
      auto_button.setBounds(20,160,80,34);
      comments.setBounds(200,160,220,26);
      unitnr.setBounds(250,130,170,26);
      CDRModel.setBounds(200,50,220,70);
      ReadSpeed.setBounds(275,190,100,26);
      WriteSpeed.setBounds(275,220,100,26);
      g.drawString("Recorder",20,65);
      g.setFont(font2);
      g.drawString("Read Speed",200,205);
      g.drawString("Write Speed",200,235);
      g.drawString("ID,Bus:",200,145);
    } else if (state == SourceMenu) {
      if (Win95NT.getState()) {
	RockType.setVisible(false);
	Joliet.setVisible(true);
      } else if (RockRidge.getState()) {
	RockType.setVisible(true);
	Joliet.setVisible(false);
      } else {
	RockType.setVisible(false);
	Joliet.setVisible(false);
      }
      g.drawString("Default Source Path",20,65);
      source.setBounds(20,80,250,30);
      g.drawString("Default File System",20,140);
      RockRidge.setBounds(230,120,150,26);
      Win95NT.setBounds(230,150,150,26);
      DOS.setBounds(230,180,150,26);
      RockType.setBounds(230,210,150,26);
      Joliet.setBounds(230,210,150,26);
    } else if (state == ReadMenu) {
      g.drawString("Read Device",20,65);
      rd.setBounds(20,80,250,30);
      g.drawString("Native Read Device",20,140);
      rdg.setBounds(20,155,250,30);
    } else if (state == MntTmpMenu) {
      g.drawString("Image Mount point",20,65);
      mnt.setBounds(20,80,250,30);
      g.drawString("Temp Directory",20,140);
      tmp.setBounds(20,155,250,30);
    }
  }

  private void showModelMenu(boolean which) {
    select_button.setVisible(which);
    auto_button.setVisible(which);
    comments.setVisible(which);
    unitnr.setVisible(which);
    CDRModel.setVisible(which);
    ReadSpeed.setVisible(which);
    WriteSpeed.setVisible(which);
    prev_button.setVisible(!which);
  }

  private void showSourceMenu(boolean which) {
    source.setVisible(which);
    RockRidge.setVisible(which);
    Win95NT.setVisible(which);
    DOS.setVisible(which);
    RockType.setVisible(false);
    Joliet.setVisible(false);
  }

  private void showReadMenu(boolean which) {
    rd.setVisible(which);
    rdg.setVisible(which);
  }

  private void showMntTmpMenu(boolean which) {
    mnt.setVisible(which);
    tmp.setVisible(which);
    next_button.setVisible(!which);
    save_button.setVisible(which);
  }

  public void itemStateChanged(ItemEvent event) {
    // If a Checkbox was clicked on, handle it.
    if (event.getSource() instanceof Checkbox) {
      repaint();
    }
  }

  public void actionPerformed(ActionEvent event) {
    // If the Next button was clicked on, handle it.
    if (event.getSource() == next_button) {
      if ((state == ModelMenu)&&(unitnr.getText().compareTo("") != 0)) {
	showModelMenu(false);
	showSourceMenu(true);
	state = SourceMenu;
      } else if (state == SourceMenu) {
	showSourceMenu(false);
	showReadMenu(true);
	state = ReadMenu;
      } else if (state == ReadMenu) {
	showReadMenu(false);
	showMntTmpMenu(true);
	state = MntTmpMenu;
      }
      repaint();
    } else
    // If the Prev button was clicked on, handle it.
    if (event.getSource() == prev_button) {
      if (state == SourceMenu) {
	showSourceMenu(false);
	showModelMenu(true);
	state = ModelMenu;
      } else if (state == ReadMenu) {
	showReadMenu(false);
	showSourceMenu(true);
	state = SourceMenu;
      } else if (state == MntTmpMenu) {
	showMntTmpMenu(false);
	showReadMenu(true);
	state = ReadMenu;
      }
      repaint();
    } else
    // If the Save button was clicked on, handle it.
    if (event.getSource() == save_button) {
      save();
      setVisible(false);
      dispose();
    } else
    // If the Select button was clicked on, handle it.
    if (event.getSource() == select_button) {
      if (CDRModel.getSelectedIndex() >= 0) {
	comments.setText(getComments());
      }
    } else
    // If the Auto button was clicked on, handle it.
    if (event.getSource() == auto_button) {
      Vector units;
      String number = new String("");
      String name = new String("");
      int i;
      boolean found = false;
      boolean devices = false;

      units = util.getSCSIDevices();
      try {
	while (!found) {
	  number = (String)units.firstElement();
	  units.removeElementAt(0);
	  name = (String)units.firstElement();
	  units.removeElementAt(0);
	  devices = true;
	  for (i=0; i <= CDRModel.getItemCount(); i++) {
	    CDRModel.select(i);
	    if (CDRModel.getSelectedItem().compareTo(name) == 0) {
	      CDRModel.makeVisible(i);
	      unitnr.setText(number);
	      comments.setText(getComments());
	      found = true;
	      break;
	    }
	  }
	}
      } catch (Exception e) {
      }
      if (found == false) {
	CDRModel.deselect(CDRModel.getSelectedIndex());
	comments.setText("Unknown device");
      }
      if (devices == false) {
	CDRModel.deselect(CDRModel.getSelectedIndex());
	comments.setText("No device found");
      }
    } else
    // If the Cancel button was clicked on, handle it.
    if (event.getSource() == cancel_button) {
      setVisible(false);
      dispose();
    } else
    // If the Help button was clicked on, handle it.
    if (event.getSource() == hlp_button) {
      help(state);
    } 
  }
}
