/*
 *  Copyright (C) 1998  Jesper Pedersen <jews@imada.ou.dk>
 *  This code is released under GNU GPL version 2 or later
 */
import java.awt.*;
import java.awt.event.*;
import java.util.*;

public class Output extends Frame implements ActionListener {
  private Button ok_button;
  private int x_size;
  private int y_size;
  private TextArea txt;

  public Output(String title, int x,int y) {
    setTitle(title);

    setBackground(Color.white);

    ok_button = new Button("Ok");
    ok_button.setForeground(Color.black);
    ok_button.setBackground(Color.lightGray);
    add("South", ok_button);
    ok_button.addActionListener(this);

    txt = new TextArea("",100,200);
    txt.setEditable(false);
    txt.setForeground(Color.black);
    txt.setBackground(Color.white);
    add(txt);

    x_size = x;
    y_size = y;

    setSize(x,y);		
    setResizable(false);
    show();
    repaint();
  }

  public void print(String s) {
    txt.append(s);
  }

  public void println(String s) {
    txt.append(s);
    txt.append("\n");
  }

  public void print(char c) {
    char[] charray = {c};
    String s = new String(charray);
    txt.append(s);
  }

  public void paint(Graphics g) {
    txt.setBounds(20,30,x_size-30,y_size-100);
    ok_button.setBounds((x_size/2)-50,y_size-60,100,34);
  }

  public void actionPerformed(ActionEvent event) {
    if (event.getSource() == ok_button) {
      setVisible(false);
      dispose();
    }
  }
}



