/*
 *  Copyright (C) 1998  Jesper Pedersen <jews@imada.ou.dk>
 *  This code is released under GNU GPL version 2 or later
 */

import java.io.*;

class ExecuteThread extends Thread {
  String[] cmds;
  ExecuteCmdsThread callee = null;
  //Output out;
  boolean output;

  public ExecuteThread(String cmd_in) {
    cmds = new String[1];
    cmds[0] = cmd_in;
    output = true;
    //out = new Output("Executing ...", 500,300);

    start();
  }

  public ExecuteThread(String[] cmds_in, ExecuteCmdsThread callee_in) {
    cmds = cmds_in;
    output = true;
    callee = callee_in;
    //out = new Output("Executing ...", 500,300);

    start();
  }

  public ExecuteThread(String[] cmds_in) {
    cmds = cmds_in;
    output = true;
    //out = new Output("Executing ...", 500,300);

    start();
  }

  public ExecuteThread(String cmd_in, boolean output_in) {
    cmds = new String[1];
    cmds[0] = cmd_in;
    output = output_in;
    //out = new Output("Executing ...", 500,300);

    start();
  }

  public void run() {
    for (int procnr = 0; procnr < cmds.length; procnr++) {
      if (output) {
        System.out.print("Executing : ");
	System.out.println(cmds[procnr]);
      }
      try {
	Process proc = Runtime.getRuntime().exec(cmds[procnr],null);
	int c;
	if (output) {
	  if ((cmds[procnr].startsWith("./mkisofs") == false)&&
	      (cmds[procnr].startsWith("./cdda2wav") == false)&&
	      (cmds[procnr].startsWith("./encode") == false)) {
	    if ((cmds[procnr].startsWith("./cdrecord"))||
		(cmds[procnr].startsWith("./user.cmd"))) {
	      MyInputStream charIn = new MyInputStream(proc.getInputStream());
	      while ((c = charIn.readChar()) != -1) {
		System.out.print((char) c);
	      }
	    } else {
	      MyInputStream lineIn = new MyInputStream(proc.getInputStream());
	      try {
		String line;
		while (true) {
		  line = lineIn.readLine();
		  System.out.println(line);
		}
	      } catch (EOFException e) {
	      }
	    }
	  } else {
	    if (cmds[procnr].startsWith("./encode")) {
	      MyInputStream charIn = new MyInputStream(proc.getErrorStream());
	      while ((c = charIn.readChar()) != -1) {
		System.out.print((char) c);
	      }
	    } else {
	      MyInputStream lineIn = new MyInputStream(proc.getErrorStream());
	      try {
		String line;
		while (true) {
		  line = lineIn.readLine();
		  System.out.println(line);
		}
	      } catch (EOFException e) {
	      }
	    }
	  }
	  System.out.println("Command complete.");
	} else {
	  c = proc.waitFor();
	}
	proc.destroy();
      } catch (Exception e) {
      }
    }
    if (callee != null) {
      callee.threadFinished();
    }
  }
}

