/*
 *  Copyright (C) 1998  Jesper Pedersen <jews@imada.ou.dk>
 *  This code is released under GNU GPL version 2 or later
 */

import java.io.*;

class ExecutePipe implements Runnable {
  private BufferedInputStream myin;
  private BufferedOutputStream myout;

  public ExecutePipe(InputStream i_in, OutputStream o_in) {
    myin = new BufferedInputStream(i_in);
    myout = new BufferedOutputStream(o_in);
  }
  
  public void run() {
    try {
      int i;

      while ((i = myin.read()) != -1) {
	myout.write(i);
      }

      myin.close();
      myout.close();
    } catch (IOException e) {
      System.out.println ("Exception: " + e);
    }
  }
}

