/*
 *  Copyright (C) 1998  Jesper Pedersen <jews@imada.ou.dk>
 *  This code is released under GNU GPL version 2 or later
 */

class ExecuteCmdsThread extends Thread {
  private String[] cmds;
  private int howMany;
  private int nrCPUs;
  private Supervisor svisor;

  public ExecuteCmdsThread(String[] cmds_in, int howMany_in, int nrCPUs_in) {
    cmds = cmds_in;
    howMany = howMany_in;
    nrCPUs = nrCPUs_in;
    svisor = null;

    start();
  }

  public ExecuteCmdsThread(String[] cmds_in, int howMany_in, int nrCPUs_in, Supervisor svisor_in) {
    cmds = cmds_in;
    howMany = howMany_in;
    nrCPUs = nrCPUs_in;
    svisor = svisor_in;
  }

  public synchronized void threadFinished() {
    nrCPUs++;
  }

  public void run() {
    int to;
    int i;
    boolean notFinished = true;
    String[] cmd;


    i = 0;
    to = cmds.length;
    while (notFinished) {
      if (nrCPUs > 0) {
	if (i == to) {
	  notFinished = false;
	} else {
	  nrCPUs--;
	  
	  cmd = new String[howMany];
	  for (int j=0; j < howMany; j++) {
	    cmd[j] = cmds[i];
	    i++;
	  }

	  ExecuteThread th = new ExecuteThread(cmd,this);
	}
      } else {
	try {
	  sleep(2000);
	} catch (Exception e) {
	}
      }
    }
    if (svisor != null) {
      svisor.finished();
    }
  }
}
