/*
 *  Copyright (C) 1998  Jesper Pedersen <jews@imada.ou.dk>
 *  This code is released under GNU GPL version 2 or later
 */
import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import java.util.*;
import java.lang.*;

public class BurnIT extends Frame implements ActionListener {
  private Button Setup_button;
  private Button Simple_button;
  private Button Advanced_button;
  private Button Audio_button;
  private Button Quit_button;
  //private Image  logo;
  private boolean lock;
  private String VERSIONSTRING = new String("BurnIT "); 
  private static Utils util = new Utils();
  private Font font,font2;            

  public BurnIT() {
    setTitle("BurnIT");

    font = new Font("Helvetica", Font.BOLD, 12);
    font2 = new Font("Helvetica", Font.BOLD, 26);

    //logo = getToolkit().getImage("BurnIT.gif");

    // Set the background color
    setBackground(Color.white);

    Setup_button = new Button("Setup");
    Setup_button.setForeground(Color.black);
    Setup_button.setBackground(Color.lightGray);
    add("South", Setup_button);
    Setup_button.addActionListener(this);

    Simple_button = new Button("Simple");
    Simple_button.setForeground(Color.black);
    Simple_button.setBackground(Color.lightGray);
    add("South", Simple_button);
    Simple_button.addActionListener(this);

    Advanced_button = new Button("Advanced");
    Advanced_button.setForeground(Color.black);
    Advanced_button.setBackground(Color.lightGray);
    add("South", Advanced_button);
    Advanced_button.addActionListener(this);

    Audio_button = new Button("Audio");
    Audio_button.setForeground(Color.black);
    Audio_button.setBackground(Color.lightGray);
    add("South", Audio_button);
    Audio_button.addActionListener(this);

    Quit_button = new Button("Quit");
    Quit_button.setForeground(Color.black);
    Quit_button.setBackground(Color.lightGray);
    add("South", Quit_button);
    Quit_button.addActionListener(this);

    VERSIONSTRING = VERSIONSTRING.concat(util.getVersion());

    if (util.getVersion().compareTo(util.getConfigVersion()) == 0) {
      lock = false;
    } else {
      lock = true;
    }
    setSize(300,350);
    setResizable(false);
    show();
    repaint();
  }

  public void paint(Graphics g) {
    //g.drawImage(logo, 10, 50, this);
    Setup_button.setBounds(200,50,80,34);
    Simple_button.setBounds(200,100,80,34);
    Advanced_button.setBounds(200,150,80,34);
    Audio_button.setBounds(200,200,80,34);
    Quit_button.setBounds(200,250,80,34);
    g.setFont(font2);
    g.setColor(Color.black);
    g.drawString(VERSIONSTRING,30,80);
    g.setFont(font);
    g.setColor(Color.black);
    g.drawString("A JAVA front-end to mkisofs and cdrecord",20,310);
    g.drawString("by Jesper Pedersen <jews@imada.ou.dk>",20,325);
    g.drawString("1998 (C)",220,340);
  }

  public static void main(String argv[]) {
    BurnIT myself;

    myself = new BurnIT();
  }

  public void actionPerformed(ActionEvent event) {
    if (event.getSource() == Setup_button) {
      Setup setup_window = new Setup();
      lock = false;
    } else
    if (event.getSource() == Quit_button) {
      setVisible(false);
      dispose();
      System.exit(0);
    } else
    if (event.getSource() == Simple_button) {
      if (lock == false) {
	Simple simple_window = new Simple();
      }
    } else
    if (event.getSource() == Advanced_button) {
      if (lock == false) {
      Advanced advanced_window = new Advanced();
      }
    } else
    if (event.getSource() == Audio_button) {
      if (lock == false) {
      Audio audio_window = new Audio();
      }
    };
  }
}
