/*
 *  Copyright (C) 1998  Jesper Pedersen <jews@imada.ou.dk>
 *  This code is released under GNU GPL version 2 or later
 */

import java.awt.*;
import java.awt.event.*;
import java.util.*;

public class Audio extends Frame implements ActionListener, ItemListener {
  private Button cancel_button;   
  private Button hlp_button;     
  private Button refresh_button;     
  private Button tray_button;     
  private Button select_button;     
  private Button read_button;     
  private Button play_button;     
  private List   tracks;
  private TextField prefix;
  private TextField rate;
  private Checkbox Delete;
  private Checkbox MPEG;
  private Checkbox k64;
  private Checkbox k112;
  private Checkbox k128;
  private Checkbox k256;
  private Checkbox kother;
  private CheckboxGroup EncodingRate;
  private boolean open = false;

  private Font font,font2;            

  private static Utils util = new Utils();

  public Audio() {
    setTitle("Audio menu");

    font = new Font("Helvetica", Font.BOLD, 18);
    font2 = new Font("Helvetica", Font.BOLD, 12);

    // Set the background color
    setBackground(Color.white);

    // Create buttons.
    hlp_button = new Button("Help");
    hlp_button.setForeground(Color.black);
    hlp_button.setBackground(Color.lightGray);
    add("South", hlp_button);
    hlp_button.addActionListener(this);

    cancel_button = new Button("Cancel");
    cancel_button.setForeground(Color.black);
    cancel_button.setBackground(Color.lightGray);
    add("South", cancel_button);
    cancel_button.addActionListener(this);

    tray_button = new Button("Tray");
    tray_button.setForeground(Color.black);
    tray_button.setBackground(Color.lightGray);
    add("South", tray_button);
    tray_button.addActionListener(this);

    refresh_button = new Button("Refresh");
    refresh_button.setForeground(Color.black);
    refresh_button.setBackground(Color.lightGray);
    add("South", refresh_button);
    refresh_button.addActionListener(this);

    select_button = new Button("Select All");
    select_button.setForeground(Color.black);
    select_button.setBackground(Color.lightGray);
    add("South", select_button);
    select_button.addActionListener(this);

    read_button = new Button("Read");
    read_button.setForeground(Color.black);
    read_button.setBackground(Color.lightGray);
    add("South", read_button);
    read_button.addActionListener(this);

    play_button = new Button("Play");
    play_button.setForeground(Color.black);
    play_button.setBackground(Color.lightGray);
    add("South", play_button);
    play_button.addActionListener(this);

    tracks = new List(100,true);
    tracks.setForeground(Color.black);
    tracks.setBackground(Color.white);
    add("South", tracks);
    tracks.addActionListener(this);

    prefix = new TextField(100);
    prefix.setEditable(true);
    prefix.setForeground(Color.black);
    prefix.setBackground(Color.white);
    prefix.setText(util.getDflSourcePath());
    add(prefix);
    prefix.addActionListener(this);

    EncodingRate = new CheckboxGroup();
    k64 = new Checkbox("64k", false, EncodingRate);
    add(k64);
    k64.addItemListener(this);
    k112 = new Checkbox("112k", false, EncodingRate);
    add(k112);
    k112.addItemListener(this);
    k128 = new Checkbox("128k", true, EncodingRate);
    add(k128);
    k128.addItemListener(this);
    k256 = new Checkbox("256k", false, EncodingRate);
    add(k256);
    k256.addItemListener(this);
    kother = new Checkbox("Other", false, EncodingRate);
    add(kother); 
    kother.addItemListener(this);

    rate = new TextField(100);
    rate.setEditable(true);
    rate.setForeground(Color.black);
    rate.setBackground(Color.white);
    add(rate);
    rate.addActionListener(this);

    Delete = new Checkbox("Delete file  ", false);
    add(Delete);
    Delete.addItemListener(this);

    MPEG = new Checkbox("MPEG Encoding", false);
    add(MPEG);
    MPEG.addItemListener(this);

    showButtons(MPEG.getState());
    getTracks();

    setSize(430,500);
    setResizable(false);
    show();
    repaint();
  }

  private void getTracks() {
    Vector res;
    String s;

    if (tracks.getItemCount() > 0) {
      tracks.removeAll();
    }
    res = util.getAudioTracks();
    try {
      while (true) {
	s = (String)res.firstElement();
	s = s.concat(":");
	res.removeElementAt(0);
	tracks.add(s);
      }
    } catch (Exception e) {
    }

  }

  private void help() {
    String title = new String("Help: Audio menu");
    Output hlp_window = new Output(title,400,400);

    hlp_window.println("Tracks:");
    hlp_window.println("Select the audio tracks you want to rip.");
    hlp_window.println("");
    hlp_window.println("Destination path:");
    hlp_window.println("Select the path where the files are copied to.");
    hlp_window.println("");
    hlp_window.println("MPEG Encoding:");
    hlp_window.println("The tracks that are selected is converted to MPEG");
    hlp_window.println("files (MP3). The default bit rate is 128k.");
    hlp_window.println("In the \"Other\" field you can choose a value between");
    hlp_window.println("32k-384k.");
    hlp_window.println("");
    hlp_window.println("Delete file:");
    hlp_window.println("If the button is enabled the original");
    hlp_window.println("file is deleted (Play/Read).");
    hlp_window.println("");
    hlp_window.println("Refresh:");
    hlp_window.println("Refreshes the tracks window.");
    hlp_window.println("");
    hlp_window.println("Tray:");
    hlp_window.println("Opens/Closes the recorder tray.");
    hlp_window.println("");
    hlp_window.println("Play:");
    hlp_window.println("Plays the selected files.");
    hlp_window.println("(ripping -> playing [-> deleting]).");
    hlp_window.println("");
    hlp_window.println("Read:");
    hlp_window.println("Performs the requested operations");
    hlp_window.println("(ripping [-> MPEG-converting [-> deleting]]).");
  }

  private void showButtons(boolean which) {
    k64.setVisible(which);
    k112.setVisible(which);
    k128.setVisible(which);
    k256.setVisible(which);
    kother.setVisible(which);
    rate.setVisible(which);
  }

  public void paint(Graphics g) {
    g.setFont(font);
    g.setColor(Color.black);
    g.drawString("Tracks",20,60);
    g.setFont(font2);
    g.drawString("Destination path",20,390);
    cancel_button.setBounds(20,450,80,34);
    hlp_button.setBounds(120,450,80,34);
    play_button.setBounds(220,450,80,34);
    read_button.setBounds(330,450,80,34);
    tracks.setBounds(20,70,250,300);
    prefix.setBounds(20,400,250,30);
    refresh_button.setBounds(300,70,80,34);
    tray_button.setBounds(300,110,80,34);
    select_button.setBounds(300,150,80,34);
    MPEG.setBounds(300,200,120,30);
    k64.setBounds(300,290,60,30);
    k112.setBounds(300,320,60,30);
    k128.setBounds(300,350,60,30);
    k256.setBounds(300,380,60,30);
    kother.setBounds(300,410,60,30);
    rate.setBounds(360,410,60,30);
    Delete.setBounds(300,230,120,30);
    if (MPEG.getState()) {
      g.drawString("Bit rate",300,280);
    }
  }


  public void itemStateChanged(ItemEvent event) {
    // If a Checkbox was clicked on, handle it.
    if (event.getSource() instanceof Checkbox) {
      showButtons(MPEG.getState());
      repaint();
    }
  }

  public void actionPerformed(ActionEvent event) {
    // If the Cancel button was clicked on, handle it.
    if (event.getSource() == cancel_button) {
      setVisible(false);
      dispose();
    } else
    // If the Help button was clicked on, handle it.
    if (event.getSource() == hlp_button) {
      help();
    } else
    // If the Refresh button was clicked on, handle it.
    if (event.getSource() == refresh_button) {
      open = false;
      getTracks();
    } else
    // If the Select button was clicked on, handle it.
    if (event.getSource() == select_button) {
      for (int i=0; i < tracks.getItemCount(); i++) {
	if (select_button.getLabel().compareTo("Select All") == 0) {
	  tracks.select(i);
	} else {
	  tracks.deselect(i);
	}
      }
      if (select_button.getLabel().compareTo("Select All") == 0) {
	select_button.setLabel("Deselect All");
      } else {
	select_button.setLabel("Select All");
      }
    } else
    // If the Play button was clicked on, handle it.
    if (event.getSource() == play_button) {
      int i,index;
      String s,nr,cmd;
      String[] cmds;

      String[] seltrck = tracks.getSelectedItems();
      if (Delete.getState()) {
	cmds = new String[3*seltrck.length];
      } else {
	cmds = new String[2*seltrck.length];
      }
      index=0;
      for (i=0; i < seltrck.length; i++) {
	// Read the file
	cmd = new String("./cdda2wav -D ");
	s = util.getDevNumber();
	cmd = cmd.concat(s.substring(2,3));
	cmd = cmd.concat(",");
	cmd = cmd.concat(s.substring(0,1));
	cmd = cmd.concat(",0 -S ");
	cmd = cmd.concat(util.getRead());
	cmd = cmd.concat(" -x -H -O cdr -t ");
	nr = seltrck[i].substring(0,seltrck[i].indexOf(":"));
	if (nr.charAt(0) == ' ') {
	  s = nr.substring(1);
	  nr = nr.replace(' ','0');
	} else { 
	  s = nr;
	}
	cmd = cmd.concat(s);
	cmd = cmd.concat(" ");
	cmd = cmd.concat(util.getTmp());
	cmd = cmd.concat("/");
	cmd = cmd.concat(nr);
	cmd = cmd.concat(".cdr");
	cmds[index] = cmd;
	index++;

	// Play the file
	cmd = new String("./play ");

	nr = seltrck[i].substring(0,seltrck[i].indexOf(":"));
	if (nr.charAt(0) == ' ') {
	  nr = nr.replace(' ','0');
	}
	
	cmd = cmd.concat(util.getTmp());
	cmd = cmd.concat("/");

	cmd = cmd.concat(nr);
	cmd = cmd.concat(".cdr");
	cmds[index] = cmd;
	index++;
 
	if (Delete.getState()) {
	  // Remove the file
	  cmd = new String("rm -f ");
	  
	  nr = seltrck[i].substring(0,seltrck[i].indexOf(":"));
	  if (nr.charAt(0) == ' ') {
	    nr = nr.replace(' ','0');
	  }
	  
	  cmd = cmd.concat(util.getTmp());
	  cmd = cmd.concat("/");
	  
	  cmd = cmd.concat(nr);
	  cmd = cmd.concat(".cdr");
	  cmds[index] = cmd;
	  index++;
	}
      }
      int number;
      if (Delete.getState()) {
	number = 3;
      } else {
	number = 2;
      }
      ExecuteCmdsThread th = new ExecuteCmdsThread(cmds, number, 1);

    } else
    // If the Read button was clicked on, handle it.
    if (event.getSource() == read_button) {
      int i;
      String s,nr,cmd;
      String[] cmds;
      Supervisor sv = new Supervisor();

      String[] seltrck = tracks.getSelectedItems();
      cmds = new String[seltrck.length];
      for (i=0; i < seltrck.length; i++) {
	cmd = new String("./cdda2wav -D ");
	s = util.getDevNumber();
	cmd = cmd.concat(s.substring(2,3));
	cmd = cmd.concat(",");
	cmd = cmd.concat(s.substring(0,1));
	cmd = cmd.concat(",0 -S ");
	cmd = cmd.concat(util.getRead());
	cmd = cmd.concat(" -x -H -O cdr -t ");
	nr = seltrck[i].substring(0,seltrck[i].indexOf(":"));
	if (nr.charAt(0) == ' ') {
	  s = nr.substring(1);
	  nr = nr.replace(' ','0');
	} else { 
	  s = nr;
	}
	cmd = cmd.concat(s);
	cmd = cmd.concat(" ");
	cmd = cmd.concat(prefix.getText());
	if (cmd.endsWith("/") == false) {
	  cmd = cmd.concat("/");
	}
	cmd = cmd.concat(nr);
	cmd = cmd.concat(".cdr");
	cmds[i] = cmd;
      }
      ExecuteCmdsThread th = new ExecuteCmdsThread(cmds, 1, 1, sv);
      sv.addThread(th);
      
      if (MPEG.getState()) {
	int index=0;
	if (Delete.getState()) {
	  cmds = new String[2*seltrck.length];
	} else {
	  cmds = new String[seltrck.length];
	}
	for (i=0; i < seltrck.length; i++) {
	  cmd = new String("./encode -l 2 -p 2 -b ");
	  if (k64.getState()) {
	    cmd = cmd.concat("64 ");
	  } else if (k112.getState()) {
	    cmd = cmd.concat("112 ");
	  } else if (k128.getState()) {
	    cmd = cmd.concat("128 ");
	  } else if (k256.getState()) {
	    cmd = cmd.concat("256 ");
	  } else if (kother.getState()) {
	    if (rate.getText().compareTo("") != 0) {
	      cmd = cmd.concat(rate.getText());
	    } else {
	      cmd = cmd.concat("128");
	    }
	    cmd = cmd.concat(" ");
	  }
	  nr = seltrck[i].substring(0,seltrck[i].indexOf(":"));
	  if (nr.charAt(0) == ' ') {
	    nr = nr.replace(' ','0');
	  }
	  
	  cmd = cmd.concat(prefix.getText());
	  if (cmd.endsWith("/") == false) {
	    cmd = cmd.concat("/");
	  }
	  cmd = cmd.concat(nr);
	  cmd = cmd.concat(".cdr ");
	  cmd = cmd.concat(prefix.getText());
	  if (cmd.endsWith("/") == false) {
	    cmd = cmd.concat("/");
	  }
	  cmd = cmd.concat(nr);
	  cmd = cmd.concat(".mp3");

	  cmds[index] = cmd;
	  index++;

	  if (Delete.getState()) {
	    cmd = new String("rm -f ");
	    cmd = cmd.concat(prefix.getText());
	    if (cmd.endsWith("/") == false) {
	      cmd = cmd.concat("/");
	    }
	    cmd = cmd.concat(nr);
	    cmd = cmd.concat(".cdr");

	    cmds[index] = cmd;
	    index++;
	  }
	}
	int number;
	if (Delete.getState()) {
	  number = 2;
	} else {
	  number = 1;
	}
	ExecuteCmdsThread th2 = new ExecuteCmdsThread(cmds, number, util.getNrOfCPUs(), sv);
	sv.addThread(th2);
      }
      sv.go();
    } else
    // If the Tray button was clicked on, handle it.
    if (event.getSource() == tray_button) {
      String cmd = new String("./cdrecord dev=");
      cmd = cmd.concat(util.getDevNumber());
      if (open) {
	cmd = cmd.concat(" -load");
	util.execute(cmd,false);
	getTracks();
	open = false;
      } else {
	cmd = cmd.concat(" -eject");
	ExecuteThread th = new ExecuteThread(cmd,false);
	open = true;
      }
    }
  }
}
