/*
 *  Copyright (C) 1998  Jesper Pedersen <jews@imada.ou.dk>
 *  This code is released under GNU GPL version 2 or later
 */
import java.awt.*;
import java.awt.event.*;
import java.lang.*;
import java.io.*;
import java.util.*;

public class Advanced extends Frame implements ActionListener, ItemListener {
  // Buttons
  private Button Burn_button;
  private Button Cancel_button;
  private Button Generate_button;
  private Button Mount_button;
  private Button MSINFO_button;
  private Button Save_button;
  private Button hlp_button;     

  // cdrecord fields
  private Choice Output;
  private Choice Speed;
  private Choice Multi;
  private Choice Data1;
  private Choice Data2;
  private Choice Preemp;
  private Choice Pad;
  private Choice Eject;
  private Choice Dummy;
  private Choice Swap;
  private Checkbox WriteOnTheFly;
  private TextField Device;
  private TextField Imagefile;
  private TextField Soundfiles;
  private TextField Special;

  // mkisofs fields
  private Choice Mkiso_a;
  private Choice Mkiso_d;
  private Choice Mkiso_D;
  private Choice Mkiso_f;
  private Choice Mkiso_J;
  private Choice Mkiso_l;
  private Choice Mkiso_L;
  private Choice Mkiso_N;  
  private Choice Mkiso_quiet;
  private Choice Mkiso_r;
  private Choice Mkiso_T;
  private Choice Mkiso_v;
  private Choice Mkiso_nosym;
  private TextField Mkiso_b;
  private TextField Mkiso_c;
  private TextField Mkiso_C;
  private TextField Mkiso_m;
  private TextField Mkiso_M;
  private TextField Mkiso_o;
  private TextField Mkiso_x;
  private TextField Mkiso_A;
  private TextField Mkiso_p;
  private TextField Mkiso_P;
  private TextField Mkiso_V;
  private TextField Mkiso_files;

  // Other
  private Font font;
  private String s;
  private int cdrecoff = 210;
  private int mkisooff = 50;
  private boolean ButGenerate = false;
  private boolean ButMount = false;
  private boolean ButMsinfo = false;
  private boolean msinfo_enable = false;
  private int cddisp1 = 15;
  private int mkdisp1 = 15;
  private int disp2 = 45;
  private int disp3 = 60;
  private int disp4 = 75;
  private int disp5 = 90;
  private int disp6 = 70;
  private int disp7 = 85;
  private int disp8 = 105;
  private int disp9 = 120;
  private int mktxt3 = 60;
  private int mkchc3 = 45;
  private static Utils util = new Utils();
  
  public Advanced() {
    setTitle("Advanced menu");

    // Set the background color
    setBackground(Color.white);

    font = new Font("Helvetica", Font.BOLD, 12);

    ///////////////////////////////////////////////////////////////////
    Mkiso_a = new Choice();
    Mkiso_a.addItem(" ");
    Mkiso_a.addItem("-a");
    add("South",Mkiso_a);
    Mkiso_a.addItemListener(this);

    Mkiso_d = new Choice();
    Mkiso_d.addItem(" ");
    Mkiso_d.addItem("-d");
    add("South",Mkiso_d);
    Mkiso_d.addItemListener(this);

    Mkiso_D = new Choice();
    Mkiso_D.addItem(" ");
    Mkiso_D.addItem("-D");
    add("South",Mkiso_D);
    Mkiso_D.addItemListener(this);

    Mkiso_f = new Choice();
    Mkiso_f.addItem(" ");
    Mkiso_f.addItem("-f");
    add("South",Mkiso_f);
    Mkiso_f.addItemListener(this);

    Mkiso_J = new Choice();
    Mkiso_J.addItem(" ");
    Mkiso_J.addItem("-J");
    add("South",Mkiso_J);
    Mkiso_J.addItemListener(this);

    Mkiso_l = new Choice();
    Mkiso_l.addItem(" ");
    Mkiso_l.addItem("-l");
    add("South",Mkiso_l);
    Mkiso_l.addItemListener(this);

    Mkiso_L = new Choice();
    Mkiso_L.addItem(" ");
    Mkiso_L.addItem("-L");
    add("South",Mkiso_L);
    Mkiso_L.addItemListener(this);

    Mkiso_N = new Choice();
    Mkiso_N.addItem(" ");
    Mkiso_N.addItem("-N");
    add("South",Mkiso_N);
    Mkiso_N.addItemListener(this);

    Mkiso_quiet = new Choice();
    Mkiso_quiet.addItem(" ");
    Mkiso_quiet.addItem("-quiet");
    add("South",Mkiso_quiet);
    Mkiso_quiet.addItemListener(this);

    Mkiso_r = new Choice();
    Mkiso_r.addItem(" ");
    Mkiso_r.addItem("-r");
    Mkiso_r.addItem("-R");
    add("South",Mkiso_r);
    Mkiso_r.addItemListener(this);

    Mkiso_T = new Choice();
    Mkiso_T.addItem(" ");
    Mkiso_T.addItem("-T");
    add("South",Mkiso_T);
    Mkiso_T.addItemListener(this);

    Mkiso_v = new Choice();
    Mkiso_v.addItem(" ");
    Mkiso_v.addItem("-v");
    add("South",Mkiso_v);
    Mkiso_v.addItemListener(this);

    Mkiso_nosym = new Choice();
    Mkiso_nosym.addItem(" ");
    Mkiso_nosym.addItem("-no-split-symlink-components");
    Mkiso_nosym.addItem("-no-split-symlink-fields");
    add("South",Mkiso_nosym);
    Mkiso_nosym.addItemListener(this);

    Mkiso_b = new TextField(100);
    Mkiso_b.setEditable(true);
    Mkiso_b.setForeground(Color.black);
    Mkiso_b.setBackground(Color.white);
    add(Mkiso_b);
    Mkiso_b.addActionListener(this);

    Mkiso_c = new TextField(100);
    Mkiso_c.setEditable(true);
    Mkiso_c.setForeground(Color.black);
    Mkiso_c.setBackground(Color.white);
    add(Mkiso_c);
    Mkiso_c.addActionListener(this);

    Mkiso_C = new TextField(100);
    Mkiso_C.setEditable(true);
    Mkiso_C.setForeground(Color.black);
    Mkiso_C.setBackground(Color.white);
    add(Mkiso_C);
    Mkiso_C.addActionListener(this);
    Mkiso_C.setVisible(false);

    Mkiso_m = new TextField(100);
    Mkiso_m.setEditable(true);
    Mkiso_m.setForeground(Color.black);
    Mkiso_m.setBackground(Color.white);
    add(Mkiso_m);
    Mkiso_m.addActionListener(this);

    Mkiso_M = new TextField(100);
    Mkiso_M.setEditable(true);
    Mkiso_M.setForeground(Color.black);
    Mkiso_M.setBackground(Color.white);
    add(Mkiso_M);
    Mkiso_M.addActionListener(this);
    Mkiso_M.setText(util.getReadDeviceGeneric());
    Mkiso_M.setVisible(false);

    Mkiso_A = new TextField(128);
    Mkiso_A.setEditable(true);
    Mkiso_A.setForeground(Color.black);
    Mkiso_A.setBackground(Color.white);
    add(Mkiso_A);
    Mkiso_A.addActionListener(this);

    Mkiso_p = new TextField(128);
    Mkiso_p.setEditable(true);
    Mkiso_p.setForeground(Color.black);
    Mkiso_p.setBackground(Color.white);
    add(Mkiso_p);
    Mkiso_p.addActionListener(this);

    Mkiso_P = new TextField(128);
    Mkiso_P.setEditable(true);
    Mkiso_P.setForeground(Color.black);
    Mkiso_P.setBackground(Color.white);
    add(Mkiso_P);
    Mkiso_P.addActionListener(this);

    Mkiso_V = new TextField(100);
    Mkiso_V.setEditable(true);
    Mkiso_V.setForeground(Color.black);
    Mkiso_V.setBackground(Color.white);
    add(Mkiso_V);
    Mkiso_V.addActionListener(this);

    Mkiso_o = new TextField(100);
    Mkiso_o.setEditable(true);
    Mkiso_o.setForeground(Color.black);
    Mkiso_o.setBackground(Color.white);
    add(Mkiso_o);
    Mkiso_o.addActionListener(this);
    s = new String("");
    s = s.concat(util.getTmp());
    s = s.concat("/image");
    Mkiso_o.setText(s);

    Mkiso_x = new TextField(100);
    Mkiso_x.setEditable(true);
    Mkiso_x.setForeground(Color.black);
    Mkiso_x.setBackground(Color.white);
    add(Mkiso_x);
    Mkiso_x.addActionListener(this);

    Mkiso_files = new TextField(100);
    Mkiso_files.setEditable(true);
    Mkiso_files.setForeground(Color.black);
    Mkiso_files.setBackground(Color.white);
    add(Mkiso_files);
    Mkiso_files.addActionListener(this);
    s = new String(util.getDflSourcePath());
    Mkiso_files.setText(s);
    ///////////////////////////////////////////////////////////////////

    Output = new Choice();
    Output.addItem(" ");
    Output.addItem("-v");
    Output.addItem("-V");
    Output.addItem("-debug");
    add("South",Output);
    Output.addItemListener(this);

    Device = new TextField(3);
    Device.setEditable(true);
    Device.setForeground(Color.black);
    Device.setBackground(Color.white);
    Device.setText(util.getDevNumber());
    add(Device);
    Device.addActionListener(this);

    Speed = new Choice();
    Speed.addItem("1");
    Speed.addItem("2");
    Speed.addItem("4");
    Speed.addItem("0");
    add("South",Speed);
    Speed.addItemListener(this);
    Speed.select(util.getWrite());

    Multi = new Choice();
    Multi.addItem(" ");
    Multi.addItem("-multi");
    add("South",Multi);
    Multi.addItemListener(this);

    Preemp = new Choice();
    Preemp.addItem("-nopreemp");
    Preemp.addItem("-preemp");
    add("South",Preemp);
    Preemp.addItemListener(this);

    Pad = new Choice();
    Pad.addItem("-nopad");
    Pad.addItem("-pad");
    add("South",Pad);
    Pad.addItemListener(this);

    Data1 = new Choice();
    Data1.addItem("-audio");
    Data1.addItem("-data");
    Data1.addItem("-mode2");
    Data1.addItem("-xa1");
    Data1.addItem("-xa2");
    Data1.addItem("-cdi");
    add("South",Data1);
    Data1.addItemListener(this);
    Data1.select("-data");

    Data2 = new Choice();
    Data2.addItem(" ");
    Data2.addItem("-audio");
    add("South",Data2);
    Data2.addItemListener(this);

    Eject = new Choice();
    Eject.addItem(" ");
    Eject.addItem("-eject");
    add("South",Eject);
    Eject.addItemListener(this);

    Dummy = new Choice();
    Dummy.addItem(" ");
    Dummy.addItem("-dummy");
    add("South",Dummy);
    Dummy.addItemListener(this);

    Swap = new Choice();
    Swap.addItem(" ");
    Swap.addItem("-swap");
    add("South",Swap);
    Swap.addItemListener(this);

    Imagefile = new TextField(100);
    Imagefile.setEditable(true);
    Imagefile.setForeground(Color.black);
    Imagefile.setBackground(Color.white);
    add(Imagefile);
    Imagefile.addActionListener(this);

    Soundfiles = new TextField(100);
    Soundfiles.setEditable(true);
    Soundfiles.setForeground(Color.black);
    Soundfiles.setBackground(Color.white);
    add(Soundfiles);
    Soundfiles.addActionListener(this);

    Special = new TextField(100);
    Special.setEditable(true);
    Special.setForeground(Color.black);
    Special.setBackground(Color.white);
    Special.setText(util.getComment());
    add(Special);
    Special.addActionListener(this);

    ///////////////////////////////////////////////////////////////////

    WriteOnTheFly = new Checkbox("Write Directly");
    WriteOnTheFly.setState(false);
    add(WriteOnTheFly);
    WriteOnTheFly.addItemListener(this);

    MSINFO_button = new Button("Get msinfo");
    MSINFO_button.setForeground(Color.black);
    MSINFO_button.setBackground(Color.lightGray);
    add("South", MSINFO_button);
    MSINFO_button.addActionListener(this);

    Generate_button = new Button("Generate Image");
    Generate_button.setForeground(Color.black);
    Generate_button.setBackground(Color.lightGray);
    add("South", Generate_button);
    Generate_button.addActionListener(this);

    Mount_button = new Button("Mount Image");
    Mount_button.setForeground(Color.black);
    Mount_button.setBackground(Color.lightGray);
    add("South", Mount_button);
    Mount_button.addActionListener(this);

    Burn_button = new Button("Burn");
    Burn_button.setForeground(Color.black);
    Burn_button.setBackground(Color.lightGray);
    add("South", Burn_button);
    Burn_button.addActionListener(this);

    Cancel_button = new Button("Cancel");
    Cancel_button.setForeground(Color.black);
    Cancel_button.setBackground(Color.lightGray);
    add("South", Cancel_button);
    Cancel_button.addActionListener(this);

    Save_button = new Button("Save");
    Save_button.setForeground(Color.black);
    Save_button.setBackground(Color.lightGray);
    add("South", Save_button);
    Save_button.addActionListener(this);

    hlp_button = new Button("Help");
    hlp_button.setForeground(Color.black);
    hlp_button.setBackground(Color.lightGray);
    add("South", hlp_button);
    hlp_button.addActionListener(this);

    load();

    setSize(600,400);
    setResizable(false);
    show();
    repaint();
  }

  public void paint(Graphics g) {
    g.setFont(font);
    g.setColor(Color.black);
    g.drawString("cdrecord",20,cdrecoff);

    Output.setBounds(80,cdrecoff-cddisp1,100,24);

    g.drawString("dev=",150,cdrecoff);
    Device.setBounds(180,cdrecoff-cddisp1,50,24);

    g.drawString("speed=",235,cdrecoff);
    Speed.setBounds(280,cdrecoff-cddisp1,250,24);

    Multi.setBounds(325,cdrecoff-cddisp1,250,24);
    Pad.setBounds(400,cdrecoff-cddisp1,250,24);
    Eject.setBounds(470,cdrecoff-cddisp1,250,24);

    Dummy.setBounds(80,cdrecoff+cddisp1,250,24);

    Preemp.setBounds(150,cdrecoff+cddisp1,250,24);
    Swap.setBounds(240,cdrecoff+cddisp1,250,24);

    g.drawString("Special:",80,cdrecoff+disp7);
    Special.setBounds(150,cdrecoff+disp6,150,24);

    Data1.setBounds(80,cdrecoff+disp2,250,24);
    Data2.setBounds(305,cdrecoff+disp2,250,24);
    Imagefile.setBounds(150,cdrecoff+disp2,150,24);
    Soundfiles.setBounds(380,cdrecoff+disp2,150,24);

    if (Data1.getSelectedItem().compareTo("-audio") == 0) {
      Preemp.setVisible(true);
      Swap.setVisible(true);
      Data2.setVisible(false);
      Soundfiles.setVisible(false);
    } else {
      if (Data2.getSelectedItem().compareTo("-audio") != 0) {
	Preemp.setVisible(false);
	Swap.setVisible(false);
      }
      if (Multi.getSelectedItem().compareTo("-multi") != 0) {
	Data2.setVisible(true);
	Soundfiles.setVisible(true);
      }
    }
    if ((Data2.getSelectedItem().compareTo("-audio") == 0)&&
	(Multi.getSelectedItem().compareTo("-multi") != 0)) {
      Preemp.setVisible(true);
      Swap.setVisible(true);
    }
    if (Multi.getSelectedItem().compareTo("-multi") == 0) {
      Preemp.setVisible(false);
      Swap.setVisible(false);
      Data2.setVisible(false);
      Soundfiles.setVisible(false);
      if ((Data1.getSelectedItem().compareTo("-data") != 0)&&
	  (Data1.getSelectedItem().compareTo("-xa2") != 0)) {
	Data1.select("-xa2");
      }
      ButMsinfo = true;
    } else {
      ButMsinfo = false;
    }

    g.drawString("mkisofs",20,mkisooff);
    Mkiso_a.setBounds(80,mkisooff-mkdisp1,250,24);
    Mkiso_d.setBounds(130,mkisooff-mkdisp1,250,24);
    Mkiso_D.setBounds(180,mkisooff-mkdisp1,250,24);
    Mkiso_f.setBounds(230,mkisooff-mkdisp1,250,24);
    Mkiso_J.setBounds(280,mkisooff-mkdisp1,250,24);
    Mkiso_l.setBounds(330,mkisooff-mkdisp1,250,24);
    Mkiso_L.setBounds(380,mkisooff-mkdisp1,250,24);
    Mkiso_N.setBounds(430,mkisooff-mkdisp1,250,24);
    Mkiso_quiet.setBounds(480,mkisooff-mkdisp1,250,24);
    Mkiso_r.setBounds(80,mkisooff+mkdisp1,250,24);
    Mkiso_T.setBounds(130,mkisooff+mkdisp1,250,24);
    Mkiso_v.setBounds(180,mkisooff+mkdisp1,250,24);
    Mkiso_nosym.setBounds(230,mkisooff+mkdisp1,250,24);
    g.drawString("-m",430,mkisooff+mkdisp1+15);
    Mkiso_m.setBounds(455,mkisooff+mkdisp1,90,24);
    
    g.drawString("-b",80,mkisooff+mktxt3);
    Mkiso_b.setBounds(100,mkisooff+mkchc3,90,24);
    g.drawString("-c",195,mkisooff+mktxt3);
    Mkiso_c.setBounds(215,mkisooff+mkchc3,90,24);

    g.drawString("-A",80,mkisooff+disp5);
    Mkiso_A.setBounds(100,mkisooff+disp4,90,24);
    g.drawString("-p",195,mkisooff+disp5);
    Mkiso_p.setBounds(215,mkisooff+disp4,90,24);
    g.drawString("-P",310,mkisooff+disp5);
    Mkiso_P.setBounds(330,mkisooff+disp4,90,24);
    g.drawString("-V",425,mkisooff+disp5);
    Mkiso_V.setBounds(445,mkisooff+disp4,90,24);

    g.drawString("-o",80,mkisooff+disp9);
    Mkiso_o.setBounds(100,mkisooff+disp8,120,24);
    g.drawString("-x",230,mkisooff+disp9);
    Mkiso_x.setBounds(250,mkisooff+disp8,120,24);
    Mkiso_files.setBounds(380,mkisooff+disp8,155,24);

    if (msinfo_enable == true) {
      g.drawString("-C",310,mkisooff+mktxt3);
      Mkiso_C.setBounds(330,mkisooff+mkchc3,90,24);
      g.drawString("-M",425,mkisooff+mktxt3);
      Mkiso_M.setBounds(445,mkisooff+mkchc3,90,24);
      Mkiso_C.setVisible(true);
      Mkiso_M.setVisible(true);
    }
    WriteOnTheFly.setBounds(200,320,110,24);
    Burn_button.setBounds(410,350,80,34);
    Cancel_button.setBounds(500,350,80,34);
    Generate_button.setBounds(200,350,100,34);
    Mount_button.setBounds(305,350,100,34);
    Save_button.setBounds(20,350,80,34);
    hlp_button.setBounds(110,350,80,34);
    MSINFO_button.setBounds(20,310,80,34);
    if (ButMsinfo == true) {
      MSINFO_button.setVisible(true);
    } else {
      MSINFO_button.setVisible(false);
    }
  }

  private void load() {
    boolean mkoption = true;
    boolean second = false;
    String s;

    s = util.getAdv();

    StringTokenizer st = new StringTokenizer(s);
    while (st.hasMoreTokens()) {
      s = st.nextToken();
      if (s.compareTo("|") != 0) {
	if (mkoption) {
	  // MKISOFS Options
	  if (s.compareTo("-a") == 0) {
	    Mkiso_a.select("-a");
	  } else if (s.compareTo("-d") == 0) {
	    Mkiso_d.select("-d");
	  } else if (s.compareTo("-D") == 0) {
	    Mkiso_D.select("-D");
	  } else if (s.compareTo("-f") == 0) {
	    Mkiso_f.select("-f");
	  } else if (s.compareTo("-J") == 0) {
	    Mkiso_J.select("-J");
	  } else if (s.compareTo("-l") == 0) {
	    Mkiso_l.select("-l");
	  } else if (s.compareTo("-L") == 0) {
	    Mkiso_L.select("-L");
	  } else if (s.compareTo("-N") == 0) {
	    Mkiso_N.select("-N");
	  } else if (s.compareTo("-quiet") == 0) {
	    Mkiso_quiet.select("-quiet");
	  } else if (s.compareTo("-r") == 0) {
	    Mkiso_r.select("-r");
	  } else if (s.compareTo("-R") == 0) {
	    Mkiso_r.select("-R");
	  } else if (s.compareTo("-T") == 0) {
	    Mkiso_T.select("-T");
	  } else if (s.compareTo("-v") == 0) {
	    Mkiso_v.select("-v");
	  } else if (s.compareTo("-no-split-symlink-components") == 0) {
	    Mkiso_nosym.select("-no-split-symlink-components");
	  } else if (s.compareTo("-no-split-symlink-fields") == 0) {
	    Mkiso_nosym.select("-no-split-symlink-fields");
	  }
	} else {
	  // CDRECORD Options
	  if (s.compareTo("-v") == 0) {
	    Output.select("-v");
	  } else if (s.compareTo("-V") == 0) {
	    Output.select("-V");
	  } else if (s.compareTo("-debug") == 0) {
	    Output.select("-debug");
	  } else if (s.compareTo("1") == 0) {
	    Speed.select("1");
	  } else if (s.compareTo("2") == 0) {
	    Speed.select("2");
	  } else if (s.compareTo("4") == 0) {
	    Speed.select("4");
	  } else if (s.compareTo("0") == 0) {
	    Speed.select("0");
	  } else if (s.compareTo("-multi") == 0) {
	    Multi.select("-multi");
	  } else if (s.compareTo("-audio") == 0) {
	    if (second == false) {
	      Data1.select("-audio");
	      second = true;
	    } else {
	      Data2.select("-audio");
	    }
	  } else if (s.compareTo("-data") == 0) {
	    Data1.select("-data");
	    second = true;
	  } else if (s.compareTo("-mode2") == 0) {
	    Data1.select("-mode2");
	    second = true;
	  } else if (s.compareTo("-xa1") == 0) {
	    Data1.select("-xa1");
	    second = true;
	  } else if (s.compareTo("-xa2") == 0) {
	    Data1.select("-xa2");
	    second = true;
	  } else if (s.compareTo("-cdi") == 0) {
	    Data1.select("-cdi");
	    second = true;
	  } else if (s.compareTo("-nopreemp") == 0) {
	    Preemp.select("-nopreemp");
	  } else if (s.compareTo("-preemp") == 0) {
	    Preemp.select("-preemp");
	  } else if (s.compareTo("-nopad") == 0) {
	    Pad.select("-nopad");
	  } else if (s.compareTo("-pad") == 0) {
	    Pad.select("-pad");
	  } else if (s.compareTo("-eject") == 0) {
	    Eject.select("-eject");
	  } else if (s.compareTo("-dummy") == 0) {
	    Dummy.select("-dummy");
	  } else if (s.compareTo("-swap") == 0) {
	    Swap.select("-swap");
	  }
	}
      } else {
	mkoption = false;
      }
    }

  }


  private void save() {
    WriteTextFile wf;

    String version = new String("VERSION=");
    String model = new String("CDR=");
    String comment = new String("COM=");
    String read = new String("READ=");
    String write = new String("WRITE=");
    String mount = new String("MNT=");
    String tmppath = new String("TMP=");
    String sourcepath = new String("SPATH=");
    String filesys = new String("FS=");
    String readdev = new String("RDDEV=");
    String readdevgen = new String("RDGDEV=");
    String adv = new String("ADV=");
    

    try {
      version = version.concat(util.getVersion());
      model = model.concat(util.getCDRModel()); 
      model = model.concat(" | ");
      model = model.concat(util.getDevNumber());
      comment = comment.concat(Special.getText());
      read = read.concat(util.getRead());
      write = write.concat(util.getWrite());
      mount = mount.concat(util.getMnt());
      tmppath = tmppath.concat(util.getTmp());
      sourcepath = sourcepath.concat(util.getDflSourcePath());
      filesys = filesys.concat(util.getFileSystem());
      readdev = readdev.concat(util.getReadDevice());
      readdevgen = readdevgen.concat(util.getReadDeviceGeneric());

      // Build advanced options
      if (Mkiso_a.getSelectedItem().compareTo(" ") != 0) {
	adv = adv.concat("-a ");
      }
      if (Mkiso_d.getSelectedItem().compareTo(" ") != 0) {
	adv = adv.concat("-d ");
      }
      if (Mkiso_D.getSelectedItem().compareTo(" ") != 0) {
	adv = adv.concat("-D ");
      }
      if (Mkiso_f.getSelectedItem().compareTo(" ") != 0) {
	adv = adv.concat("-f ");
      }
      if (Mkiso_J.getSelectedItem().compareTo(" ") != 0) {
	adv = adv.concat("-J ");
      }
      if (Mkiso_l.getSelectedItem().compareTo(" ") != 0) {
	adv = adv.concat("-l ");
      }
      if (Mkiso_L.getSelectedItem().compareTo(" ") != 0) {
	adv = adv.concat("-L ");
      }
      if (Mkiso_N.getSelectedItem().compareTo(" ") != 0) {
	adv = adv.concat("-N ");
      }
      if (Mkiso_quiet.getSelectedItem().compareTo(" ") != 0) {
	adv = adv.concat("-quiet ");
      }
      if (Mkiso_r.getSelectedItem().compareTo(" ") != 0) {
	adv = adv.concat(Mkiso_r.getSelectedItem());
	adv = adv.concat(" ");
      }
      if (Mkiso_T.getSelectedItem().compareTo(" ") != 0) {
	adv = adv.concat("-T ");
      }
      if (Mkiso_v.getSelectedItem().compareTo(" ") != 0) {
	adv = adv.concat("-v ");
      }
      if (Mkiso_nosym.getSelectedItem().compareTo(" ") != 0) {
	adv = adv.concat(Mkiso_nosym.getSelectedItem());
	adv = adv.concat(" ");
      }
      adv = adv.concat("| ");
      
      if (Output.getSelectedItem().compareTo(" ") != 0) {
	adv = adv.concat(Output.getSelectedItem());
	adv = adv.concat(" ");
      }
      adv = adv.concat(Speed.getSelectedItem());
      adv = adv.concat(" ");
      if (Multi.getSelectedItem().compareTo(" ") != 0) {
	adv = adv.concat(Multi.getSelectedItem());
	adv = adv.concat(" ");
      }
      adv = adv.concat(Data1.getSelectedItem());
      adv = adv.concat(" ");
      if (Data2.getSelectedItem().compareTo(" ") != 0) {
	adv = adv.concat(Data2.getSelectedItem());
	adv = adv.concat(" ");
      }
      if (Preemp.getSelectedItem().compareTo(" ") != 0) {
	adv = adv.concat(Preemp.getSelectedItem());
	adv = adv.concat(" ");
      }
      if (Pad.getSelectedItem().compareTo(" ") != 0) {
	adv = adv.concat(Pad.getSelectedItem());
	adv = adv.concat(" ");
      }
      if (Eject.getSelectedItem().compareTo(" ") != 0) {
	adv = adv.concat(Eject.getSelectedItem());
	adv = adv.concat(" ");
      }
      if (Dummy.getSelectedItem().compareTo(" ") != 0) {
	adv = adv.concat(Dummy.getSelectedItem());
	adv = adv.concat(" ");
      }
      if (Swap.getSelectedItem().compareTo(" ") != 0) {
	adv = adv.concat(Swap.getSelectedItem());
      }

      wf = new WriteTextFile(util.getConfigFileName());
      wf.writeLine(version);
      wf.writeLine(model);
      wf.writeLine(comment);
      wf.writeLine(read);
      wf.writeLine(write);
      wf.writeLine(mount);
      wf.writeLine(tmppath);
      wf.writeLine(sourcepath);
      wf.writeLine(filesys);
      wf.writeLine(readdev);
      wf.writeLine(readdevgen);
      wf.writeLine(adv);
      wf.close();
    } catch (Exception e) {
      System.out.println("I/O error");
      System.exit(1);
    }
  }

  private void help() {
    ReadTextFile fr;
    String s;
    String title = new String("Help: ");

    title = title.concat("Advanced Menu");
    Output hlp_window = new Output(title,500,500);
    try {
      fr = new ReadTextFile("advanced.man");
      s = fr.readFile();
      hlp_window.println(s);
    } catch (IOException e) {
    }
  }

  private String buildMKISOFS(boolean full) {
    String command = new String("./mkisofs");

    if (Mkiso_a.getSelectedItem().compareTo(" ") != 0) {
      command = command.concat(" -a");
    }
    if (Mkiso_d.getSelectedItem().compareTo(" ") != 0) {
      command = command.concat(" -d");
    }
    if (Mkiso_D.getSelectedItem().compareTo(" ") != 0) {
      command = command.concat(" -D");
    }
    if (Mkiso_f.getSelectedItem().compareTo(" ") != 0) {
      command = command.concat(" -f");
    }
    if (Mkiso_J.getSelectedItem().compareTo(" ") != 0) {
      command = command.concat(" -J");
    }
    if (Mkiso_l.getSelectedItem().compareTo(" ") != 0) {
      command = command.concat(" -l");
    }
    if (Mkiso_L.getSelectedItem().compareTo(" ") != 0) {
      command = command.concat(" -L");
    }
    if (Mkiso_N.getSelectedItem().compareTo(" ") != 0) {
      command = command.concat(" -N");
    }
    if (Mkiso_quiet.getSelectedItem().compareTo(" ") != 0) {
      command = command.concat(" -quiet");
    }
    if (Mkiso_r.getSelectedItem().compareTo(" ") != 0) {
      command = command.concat(" ");
      command = command.concat(Mkiso_r.getSelectedItem());
    }
    if (Mkiso_T.getSelectedItem().compareTo(" ") != 0) {
      command = command.concat(" -T");
    }
    if (Mkiso_v.getSelectedItem().compareTo(" ") != 0) {
      command = command.concat(" -v");
    }
    if (Mkiso_nosym.getSelectedItem().compareTo(" ") != 0) {
      command = command.concat(" ");
      command = command.concat(Mkiso_nosym.getSelectedItem());
    }
    if (Mkiso_A.getText().compareTo("") != 0) {
	command = command.concat(" -A \"");
	command = command.concat(Mkiso_A.getText());
	command = command.concat("\"");
    }
    if (Mkiso_p.getText().compareTo("") != 0) {
	command = command.concat(" -p \"");
	command = command.concat(Mkiso_p.getText());
	command = command.concat("\"");
    }
    if (Mkiso_P.getText().compareTo("") != 0) {
	command = command.concat(" -P \"");
	command = command.concat(Mkiso_P.getText());
	command = command.concat("\"");
    }
    if (Mkiso_V.getText().compareTo("") != 0) {
	command = command.concat(" -V \"");
	command = command.concat(Mkiso_V.getText());
	command = command.concat("\"");
    }
    if (Mkiso_m.getText().compareTo("") != 0) {
	command = command.concat(" -m ");
	command = command.concat(Mkiso_m.getText());
    }
    if (Mkiso_b.getText().compareTo("") != 0) {
	command = command.concat(" -b ");
	command = command.concat(Mkiso_b.getText());
    }
    if (Mkiso_c.getText().compareTo("") != 0) {
	command = command.concat(" -c ");
	command = command.concat(Mkiso_c.getText());
    }
    if ((msinfo_enable == true)&&(Multi.getSelectedItem().compareTo(" ") != 0)&&
	(Mkiso_C.getText().compareTo("") != 0)) {
      command = command.concat(" -C ");
      command = command.concat(Mkiso_C.getText());
      command = command.concat(" -M ");
      command = command.concat(Mkiso_M.getText());
    }
    if (full == true) {
      command = command.concat(" -o ");
      command = command.concat(Mkiso_o.getText());
    }
    if (Mkiso_x.getText().compareTo("") != 0) {
	command = command.concat(" -x ");
	command = command.concat(Mkiso_x.getText());
    }
    command = command.concat(" ");
    command = command.concat(Mkiso_files.getText());
    
    return command;
  }

  private String buildCDRECORD(boolean full) {
    String command = new String("./cdrecord");
    
    // Arguments
    if (Output.getSelectedItem().compareTo(" ") != 0) {
	command = command.concat(" ");
	command = command.concat(Output.getSelectedItem());
    }
    command = command.concat(" dev=");
    command = command.concat(Device.getText());
    command = command.concat(" speed=");
    command = command.concat(Speed.getSelectedItem());
    if (Multi.getSelectedItem().compareTo(" ") != 0) {
      command = command.concat(" -multi");
    }
    command = command.concat(" ");
    command = command.concat(Pad.getSelectedItem());
    if (Eject.getSelectedItem().compareTo(" ") != 0) {
      command = command.concat(" -eject");
    }
    if (Dummy.getSelectedItem().compareTo(" ") != 0) {
      command = command.concat(" -dummy");
    }
    if ((Data1.getSelectedItem().compareTo("-audio") == 0)||
	((Data2.getSelectedItem().compareTo("-audio") == 0)&&
	 (Multi.getSelectedItem().compareTo("-multi") != 0))) {
      command = command.concat(" ");
      command = command.concat(Preemp.getSelectedItem());
      if (Swap.getSelectedItem().compareTo(" ") != 0) {
	command = command.concat(" -swap");
      }
    }
    if (Special.getText().compareTo("") != 0) {
      command = command.concat(" ");
      command = command.concat(Special.getText());
    }
    if (full == true) {
      command = command.concat(" ");
      command = command.concat(Data1.getSelectedItem());
      command = command.concat(" ");
      command = command.concat(Imagefile.getText());
    
      if (Multi.getSelectedItem().compareTo("-multi") != 0) {
	if (Data2.getSelectedItem().compareTo(" ") != 0) {
	  command = command.concat(" ");
	  command = command.concat(Data2.getSelectedItem());
	  command = command.concat(" ");
	  command = command.concat(Soundfiles.getText());
	}
      }
    } else {
      command = command.concat(" ");
      command = command.concat(Data1.getSelectedItem());
      command = command.concat(" -");
    }

    return command;
  }

  public void itemStateChanged(ItemEvent event) {
    // If a Choice was clicked on, repaint !
    if (event.getSource() instanceof Choice) {
      repaint();
    }
  }

  public void actionPerformed(ActionEvent event) {
    if (event.getSource() == Burn_button) {
      // Run cdrecord
      if (WriteOnTheFly.getState() == false) {
	// Write image
	if (ButGenerate) {
	  ExecuteThread th = new ExecuteThread(buildCDRECORD(true));
	}
      } else {
	if ((Data1.getSelectedItem().compareTo("-audio") != 0)&&
	    (Data2.getSelectedItem().compareTo("-audio") != 0)&&
	    (Mkiso_C.getText().compareTo("") == 0)) {
	  // Write directly to CDR
	  util.execute_pipe(buildMKISOFS(false),buildCDRECORD(false));
	} else {
	  WriteOnTheFly.setState(false);
	}
      }
    } else
    if (event.getSource() == Cancel_button) {
      setVisible(false);
      dispose();
    } else
    if (event.getSource() == Save_button) {
      save();
    } else
    if (event.getSource() == Generate_button) {
      // Generate iso-image
      ExecuteThread th = new ExecuteThread(buildMKISOFS(true));
      ButGenerate = true;
      Imagefile.setText(Mkiso_o.getText());
      repaint();
    } else
    if (event.getSource() == Mount_button) {
      if (ButGenerate == true) {
	if (ButMount == false) {
	  // Mount iso-image
	  String command = new String("mount");
	  if (System.getProperty("os.name").compareTo("Linux") == 0) {
	    command = command.concat(" -r -t iso9660 -o loop ");
	  } else {
	    command = command.concat(" -r -F fbk -o type=hsfs /dev/fbk0:");
	  }
	  command = command.concat(Mkiso_o.getText());
	  command = command.concat(" ");
	  command = command.concat(util.getMnt());
	  ExecuteThread th = new ExecuteThread(command);
	  ButMount = true;
	  Mount_button.setLabel("Unmount image");
	} else {
	  // Unmount iso-image
	  String command = new String("umount");
	  command = command.concat(" ");
	  command = command.concat(util.getMnt());
	  ExecuteThread th = new ExecuteThread(command);
	  ButMount = false;
	  Mount_button.setLabel("Mount image");
	}
      }
    } else
    if (event.getSource() == MSINFO_button) {
      String magic = new String("");

      magic = util.getMagicParameters();
      if (magic.compareTo("") != 0) {
	Mkiso_C.setText(util.getMagicParameters());
	msinfo_enable = true;
      }
      repaint();
    } else
    // If the Help button was clicked on, handle it.
    if (event.getSource() == hlp_button) {
      help();
    } 
  }
}
