/*
 *       vtscreensaveron.c  Start a dormant vtscreensaver process
 *       (c)1997 Jesse Reichler
 *       This program is free software; you can redistribute it and/or
 *       modify it under the terms of the GNU General Public License
 *       as published by the Free Software Foundation.
 *
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <dirent.h>
#include <signal.h>


#define VERSION "0.2"
#define TTYBASENAME "/dev/tty%d"
#define PROCDIR "/proc"
#define PROGNAME "vtscreensaver"



int debugmode=0; // carry over from vtscreensaver.c






void main (int argc, char **argv)
{
  int retv;

  retv=invokeold();
  if (retv>0)
    printf("invoking vtscreensaver...\n");
  else
    printf("vtscreensaver was not found running...\n");
}





int invokeold()
{
// send an invoke signal to a sleeping vtscreensaver process
 int fd;
 struct dirent *d;
 DIR *pdir;
 char pname[80],fname[255];
 char string[255];
 int pnum;
 int ourid;
 FILE *fp;
 int invoked=0;


 // first open the dir
 if ((pdir=opendir(PROCDIR))==NULL)
   {
     if (debugmode)
       printf("vtscreensaver warning: couldn't open %s to check for prev. running copies.\n",PROCDIR);
     return;
   }

 // get our own id
 ourid=getpid();

 // now check for proc files
 for (;;)
   {
     d=readdir(pdir);
     if (d==NULL)
       break;
     if (strlen(d->d_name)>=80)
       continue;
     strcpy(pname,d->d_name);
     if (pname[0]<'0' || pname[0]>'9')
       continue;
     // okay a candidate, now try to open its cmdline file
     sprintf(fname,"%s/%s/cmdline",PROCDIR,pname);
     if ((fp = fopen(fname, "r")) == NULL)
       continue;
     fgets(string,80,fp);
     fclose(fp);
     if (strstr(string,PROGNAME)!=NULL)
       {
         // okay we found a copy
         pnum=atoi(pname);
         if (ourid==pnum)
           continue; // we don't want to commit suicide
         if (debugmode)
           printf("vtscreensaver found a running copy [pid%d] which is now being invoked.\r\n",pnum);
         kill(pnum,SIGUSR1);
	 invoked=1;
         break;
       }
   }

 closedir(pdir);
 return(invoked);
}





