%{
	#include <stdio.h>
	#include <string.h>
	#include "termcolor.h"

	static	char	Termname[80];
	static	char	*Bold, *Reverse, *Standout, *Underline;
%}

%%

bold=[^,\n]*,	{
	if (*Bold)
		fprintf(tinfoout, "bold=%s,", ansi_color(Bold, 1));			/** Start bold **/
	else
		ECHO;	
}

rev=[^,\n]*, {
	if (*Reverse)
		fprintf(tinfoout, "rev=%s,", ansi_color(Reverse, 1));		/** Start reverse **/
	else
		ECHO;
}

smso=[^,\n]*,	{
	if (*Standout)
		fprintf(tinfoout, "smso=%s,", ansi_color(Standout, 1));	/** Start Standout **/
	else
		ECHO;
}

smul=[^,\n]*,	{
	if (*Underline)
		fprintf(tinfoout, "smul=%s,", ansi_color(Underline, 1));	/** Start Underline **/
	else
		ECHO;
}

rmso=[^,\n]*,	fprintf(tinfoout, "rmso=%s,", TIANSI_RESET);		/** End all modes **/
rmul=[^,\n]*,	fprintf(tinfoout, "rmul=%s,", TIANSI_RESET);		/** End standout **/
op=[^,\n]*,		fprintf(tinfoout, "op=%s,", TIANSI_RESET);			/** End underline **/

%%

int		change_terminfo(char *term,
					    char *bold,
					    char *reverse,
					    char *underline,
					    char *standout)

{
	int		rc;
	char	tmp[80];
	char	*tmpin;
	char	*tmpout;

	tmpin  = strdup(tmpnam(NULL));
	tmpout = strdup(tmpnam(NULL));

	/** Untic to temp filename **/

	sprintf(tmp, "%s %s >%s", UNTIC_BIN, term, tmpin);
	
	rc = system(tmp);

	/** Thou shalt not trust untic's error codes **/

	if (rc == -1 || rc == 127)
	{
		fprintf(stderr, "termcolor: Cannot execute untic\n");
		exit(1);
	}

	/** Open files **/

	if ((tinfoin = fopen(tmpin,"r")) == NULL)
	{
		perror("termcolor: Error reading temporary file");
		return -1;
	}

	if ((tinfoout = fopen(tmpout,"w")) == NULL)
	{
		perror("termcolor: Error creating temporary file");
		return -1;
	}

	Bold      = bold;
	Reverse   = reverse;
	Standout  = standout;
	Underline = underline;

	rc = tinfolex();

	fclose(tinfoin);
	fclose(tinfoout);

	/** Run TIC on the output filename **/

	sprintf(tmp, "%s %s", TIC_BIN, tmpout);
	
	rc = system(tmp);

	/** Thou shalt not trust tic's error codes **/

	if (rc == -1 || rc == 127)
	{
		fprintf(stderr, "termcolor: Cannot execute tic\n");
		exit(1);
	}

	unlink(tmpin);
	unlink(tmpout);

    free(tmpin);
    free(tmpout);

	return 0;
}

int  tinfowrap()
{
	return 1;
}
