/*
**	Termcolor.h - include for termcolor.c
**	1995 by Marco Paganini (paganini@ism.com.br)
*/

#define VERS				"0.2"			

#define TCANSI_RESET		"\\E[0m"		/* Fade to black & white... */
#define TIANSI_RESET		"^[[0m"			/* Same, using terminfo     */
#define TCANSI_COLOR_PREFIX	"\\E["			/* Used by termcap 			*/
#define TIANSI_COLOR_PREFIX	"^[["			/* Used by terminfo 		*/
#define ANSI_COLOR_SUFFIX	"m"
#define ANSI_HILITE			"1;"

#define TIC_BIN				"/usr/lib/terminfo/tic"
#define UNTIC_BIN			"/usr/lib/terminfo/untic"

#define ANSI_COLOR_LEN      10
#define COLOR_STR_LEN       40
#define TERMCAP             "/etc/termcap"

typedef struct
{
    char    color_name[ANSI_COLOR_LEN];
    int     fore;
    int     back;
} ANSI_COLORS;

/** Protos **/

void 	main(int ac, char **av);
char	*ansi_color(char *colorpair, int mode);
int     change_termcap(char *termfile,
                       char *term,
                       char *bold,
                       char *reverse,
                       char *underline,
                       char *standout);
int     change_terminfo(char *term,
                        char *bold,
                        char *reverse,
                        char *underline,
                        char *standout);
void	usage();
