%s TERMFOUND

%{
	#include <stdio.h>
	#include <string.h>
	#include "termcolor.h"

	static	char	Termname[80];
	static	char	*Bold, *Reverse, *Standout, *Underline;
%}

TERM		^[^:# \t\n][^:\n]+:

%%

{TERM}		{ 
	/** Our term? **/

	if (strncmp(tcaptext, Termname, strlen(Termname)) == 0)
		BEGIN(TERMFOUND);
	else
		BEGIN(0);
	ECHO;
}

<TERMFOUND>md=[^:\n]*:	{
	if (*Bold)
		fprintf(tcapout, "md=%s:", ansi_color(Bold, 0));			/** Start bold **/
	else
		ECHO;	
}

<TERMFOUND>mr=[^:\n]*: {
	if (*Reverse)
		fprintf(tcapout, "mr=%s:", ansi_color(Reverse, 0));		/** Start reverse **/
	else
		ECHO;
}

<TERMFOUND>so=[^:\n]*:	{
	if (*Standout)
		fprintf(tcapout, "so=%s:", ansi_color(Standout, 0));		/** Start Standout **/
	else
		ECHO;
}

<TERMFOUND>us=[^:\n]*:	{
	if (*Underline)
		fprintf(tcapout, "us=%s:", ansi_color(Underline, 0));	/** Start Underline **/
	else
		ECHO;
}

<TERMFOUND>me=[^:\n]*:	fprintf(tcapout, "me=%s:", TCANSI_RESET);		/** End all modes **/
<TERMFOUND>se=[^:\n]*:	fprintf(tcapout, "se=%s:", TCANSI_RESET);		/** End standout **/
<TERMFOUND>ue=[^:\n]*:	fprintf(tcapout, "ue=%s:", TCANSI_RESET);		/** End underline **/

%%

int		change_termcap(char *termfile,
					   char	*term,
					   char *bold,
					   char *reverse,
					   char *underline,
					   char *standout)

{
	int		rc;
	char	*tmpfile;
	char	tmp[80];

	/* HACK HACK HACK HACK
	** Only the FIRST terminal name will be used. Gotta fix this
	*/

	strcpy(Termname, term);
	strcat(Termname, "|");

	tmpfile = tmpnam(NULL);

	if ((tcapin = fopen(termfile,"r")) == NULL)
	{
		perror("termcolor: Error opening termcap file");
		return -1;
	}

	if ((tcapout = fopen(tmpfile,"w")) == NULL)
	{
		perror("termcolor: Error creating temporary file");
		return -1;
	}

	Bold      = bold;
	Reverse   = reverse;
	Standout  = standout;
	Underline = underline;

	rc = tcaplex();

	fclose(tcapin);
	fclose(tcapout);

	/** HACK HACK HACK HACK **/
	/** Copy temp file to /etc/termcap **/

	sprintf(tmp, "cp %s %s", tmpfile, TERMCAP);
	if (system(tmp) != 0)
	{
		perror("termcolor: writing termcap:");
		fprintf(stderr, "Please, copy /etc/termcap.OLD to /etc/termcap\n");
		return -1;
	}
	unlink(tmpfile);

	return 0;
}

int		tcapwrap()
{
	return 1;
}
