#include <fstream>
#include <string>
#include <cstdlib>
#include <cstring>

using namespace std;

string getProgram(string extension);
string findProg(string currentExtension);
int openfile(string filename, string program, string progArgs);

int checkassoc(string filename, string progArgs){

int periodLocation;
int filenameLength;
int extensionLength;
string extension;
string testExtension;
char extensionBuffer[1024];
string program;

filenameLength = filename.length();
periodLocation = filename.find_last_of(".");

if (periodLocation == -1){
	cout << "No extension provided.  Unable to open file.\n";
	cout << "Open file with application instead\n";
	return 0;
	}

extensionLength = filenameLength - periodLocation - 1;
extension = filename.substr(periodLocation + 1, extensionLength);

ifstream in("/etc/open.conf",ios::in);

while (!in.eof()){
	in.getline(extensionBuffer, 1024);
	testExtension = extensionBuffer;
	if (testExtension.substr(0,extensionLength) == extension){
		break;
		}
	}

if (in.eof()){
	cout << "Extension not found.  Open file with application\n";
	cout << "instead, or add extension to /etc/open.conf\n";
	}

in.close();

program = getProgram(extension);

if (program == "nogood"){
	return 0;
	}
openfile(filename,program, progArgs);

return 0;
}

string getProgram(string extension){

char confBuffer[1024];
string currentExtension;
string lineExtension;
string programName;

ifstream in("/etc/open.conf");

while (!in.eof()){
	in.getline(confBuffer, 1024);
	currentExtension = confBuffer;
	if (currentExtension.substr(0,extension.length()) == extension){
		break;
		}
	}

in.close();

lineExtension = currentExtension.substr(0,extension.length());

programName = findProg(currentExtension);
return programName;
}

string findProg(string currentExtension){

string programName;
string space;
string tab;
int a;

a = currentExtension.find_first_of("\t");
if (a == -1){
	a = currentExtension.find_first_of(" ");
	}
if (a == -1){
	cout << "/etc/open.conf is in an invalid format or the extension\n";
	cout << "does not have a valid program entry.\n";
	return "nogood";
	}

space = " ";
tab = "\t";

while ((currentExtension.at(a) == space.at(0)) || (currentExtension.at(a+1) == tab.at(0))){
	a++;
	}

programName = currentExtension.substr(++a, currentExtension.length() - a);
return programName;
}

int openfile(string filename, string program, string progArgs){
char argument[1024];
string space;
string sArgs;
space = " ";
sArgs = program + space + progArgs + space + filename;
strcpy (argument, sArgs.c_str());
system(argument);
}

