#!/bin/sh
#
# Example use of the `multirun' shell script.
#
# 25 May 1999 - Andrew Wood <andrew.wood@poboxes.com>

version=`./multirun --version | sed -n '1s/^.* version //p'`
distfiles="BLURB COPYING README LSM example.sh multirun"

name=multirun-$version

bash ./multirun \
           --title="Test messages 1 (2 seconds)" \
           "(echo Test message 1; sleep 1; echo Test message 2)" \
\
           --title="Test messages 2 (3 seconds)" \
           "(echo Test 2A; sleep 1; echo Test 2B; sleep 1; echo Test 2C)" \
\
           --title="Build distribution archive" \
           --title-foreground=blue \
           --title-background=cyan \
           --title-attribute=reversed \
           --foreground=cyan \
           "(mkdir $name && chmod 755 $name && cp -a $distfiles $name && \
             tar cvvf - $name | gzip -9 > $name.tar.gz && rm -rf $name && \
             echo && echo -n 'Completed: ' && ls -o $name.tar.gz && \
             du $name.tar.gz \
            )"

# EOF
