/*************************************************************************
 **									**
 ** doprog(8): Execute a program with arguments on a new tty		**
 **		AND wait if asked to					**
 **		Based on doshell(8) by Jim Wiegand.			**
 **									**
 ** Copyright 1992 by Jim Wiegand					**
 ** Copyright 1993,1994 by James H. Cloos, Jr. <James.Cloos@Rahul.NET>	**
 ** Copyright 1995 by Francois-Rene "Fare" Rideau <rideau@ens.fr>       **
 **                                                                     **
 ** 1995-12-08 Fare  corrected a few bugs                               **
 ** 1996-04-04 Fare  added "wait" capability                            **
 **									**
 *************************************************************************/

#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <string.h>
#include <signal.h>

#define errprintf(x...) fprintf(stderr,x)

/*#define DEBUG*/
/*#undef DEBUG*/
#ifdef DEBUG
#  define DBG(x...) errprintf(x)
#else
#  define DBG(x...) 0
#endif


void usage (int n) {
   errprintf("doprog|doprogw -hVnw /dev/ttyXX /bin/myprog arg1 arg2 ...\n");
   exit(n);
}

void main( int argc, char **argv ) {

   int fd;
   struct stat ssp;
   int shall_wait=0;
   int l =strlen(argv[0]);
   int status=0;
   int mypid=getpid();

   DBG("argc=%d !\n",argc);
   if ( (argc<=1)
        || (!strcmp(argv[1],"--help"))
        || (!strcmp(argv[1],"-h"))
        || (!strcmp(argv[1],"-?")) ) {
      usage(0);
   }

   DBG("Ok4!\n");
   if (    (!strcmp(argv[1],"--version"))
        || (!strcmp(argv[1],"-V")) ) {
      errprintf("doprogw " VERSION "\n");
      exit(0);
   }

   DBG("Shall we wait after completion ?\n");
   if (   ((l>=4) && (!strcmp(argv[0]+l-4,"wait")))
       || ((l>=1) && (argv[0][l-1]=='w')) ) {
      shall_wait=1;
   }

   if (argc<=2) usage(1) ;

   if (    (!strcmp(argv[1],"--wait"))
        || (!strcmp(argv[1],"-w")) ) {
      shall_wait=1;
      argv[1]=argv[0];
      argv++;
   }

   if (argc<=2) usage(1) ;

   if (    (!strcmp(argv[1],"--nowait"))
        || (!strcmp(argv[1],"-n")) ) {
      shall_wait=0;
      argv[1]=argv[0];
      argv++;
   }

   if (argc<=2) usage(1) ;

   DBG("Make sure the tty exists!\n");
   if ( stat(argv[1],&ssp) ) {
      perror(argv[1]);
      exit(1);
   }

   if ( !S_ISCHR(ssp.st_mode) ) {
      errprintf("%s is not a character special device.\n",argv[1]);
      exit(2);
   }

   DBG("Forking!\n");
   if( !fork() ) {

      DBG("Child!\n");
      DBG("go underground\n");
      setsid();

      DBG("get rid of existing tty\n");
      close(0); close(1); close(2);

      DBG("get new one & make it standard\n");
      fd = open(argv[1], O_RDWR);
      if (fd != 0) {
	dup2(fd,0);
	close(fd);
      }
      dup2(0,1); dup2(0,2);

/* I can't get this pgrp to work !
      DBG("set process group\n");
      if (!shall_wait) {
	 ...here, code to get/set terminal process group...
	 if ( setpgrp() ) {
	    perror(argv[0]);
	    exit(3);
	 }
      }
 */

      DBG("kill supervisor mode\n");
      setgid(getgid());
      setuid(getuid());

      DBG("do it\n");
      execvp(argv[2], argv+2);

    }
   DBG("normal exit, reached by the original process only\n");
   while (shall_wait) {
      wait(&status);
      if (WIFEXITED(status)) {
	 exit(WEXITSTATUS(status));
      } else if (WIFSIGNALED(status)) {
	 kill(mypid,WTERMSIG(status));
      } else if (WIFSTOPPED(status)) {
	 kill(mypid,WSTOPSIG(status));
      } else {
	 exit(55);
      }
  }
}
