#include<stdio.h>
#include<sys/types.h>
#include<dirent.h>
#include<unistd.h>
#include<string.h>
#include<fcntl.h>
#include<sys/ioctl.h>
#include<linux/vt.h>
#include<sys/wait.h>
#include<signal.h>
#include<sys/stat.h>
#include<malloc.h>
#include<stdlib.h>
#include<pwd.h>
#include<linux/kd.h>
#include<error.h>
#include<errno.h>
 
#define MAXV 2000
#define MAXCONS 64 /* this is indeed max + 1 as devices begin with 1 */
#define PIDFILE "/var/run/consinfod.pid"

#define EINTR 4

int debug=0;
int old_vt=-1;
unsigned int old_cols;
char old_vcsa[2*MAXV];
char attrs[2*MAXV];
int show_cmdline=0;
int waittime=1;
int fgonly=0;
int duser=0;
int last_signal=-1;
int bindkey=0;
char *execline = NULL;
int maxcons=MAXCONS-1;


int restore_console(void);

void signal_handler(int a)
{ /* reconnect */
  last_signal=a;
  signal(SIGALRM,signal_handler);
  signal(SIGHUP,signal_handler);
  signal(SIGTERM,signal_handler);
}

int do_bindkey(void)
{ int fd;
  
  fd=open("/dev/tty0",O_RDWR);
  if(fd<0)
  { perror("open /dev/tty0 failed");
    return -1;
  }
  
  ioctl(fd,KDSIGACCEPT,SIGHUP);
  close(fd);
  return 0;
}

int await_vt_change(void)
{ int fd;
  struct vt_stat v;
  
  fd=open("/dev/tty0",O_RDWR);
  if(fd<0)
  { perror("open /dev/tty0 failed");
    return -1;
  }
  
 retry:
  if(ioctl(fd,VT_WAITACTIVE,0)<0)
  { if(errno==EINTR)
    { 
      if(last_signal==SIGALRM)
      { last_signal=-1;
        restore_console();
        goto retry;
      }
      else if(last_signal==SIGHUP)
      { last_signal=-1;
        /* fall through to ioctl VT_GETSTATE */
      }
      else if(last_signal==SIGTERM)
      { last_signal=-1;
        restore_console();
        return -1;
      }
      else
      { last_signal=-1;
        goto retry;
      }
    }
    else
    { fprintf(stderr,"errno=%d\n",errno);
      perror("ioctl VT_WAITACTIVE 0 failed (maybe your kernel isn't patched)");
      return -1;
    }
  }
  ioctl(fd,VT_GETSTATE,&v);
  close(fd);
  
  return v.v_active;
}

void pidfile(void)
{ struct stat buf;
  int pid=0;
  char str[100];
  FILE*f;
  
  if(stat(PIDFILE,&buf)>=0)
  { if(debug)fprintf(stderr,"pidfile exists");
    f=fopen(PIDFILE,"r");
    if(f)
    { fscanf(f,"%d",&pid);
      fclose(f);
      sprintf(str,"/proc/%d/stat",pid);
      if(pid!=getpid()&&stat(str,&buf)>=0)
      { fprintf(stderr,"consinfod already running\n");
        exit(1);
      }
    }
    unlink(PIDFILE);
  }
  
  f=fopen(PIDFILE,"w");
  if(f==NULL)
  { fprintf(stderr,"cannot write pidfile %s\n",PIDFILE);
    exit(1);
  }
  fprintf(f,"%d\n",getpid());
  fclose(f);
}

int find_user(char*text, int vt)
{ char buf[20];
  struct stat sbuf;
  struct passwd*pw;
  
  text[0]='\0';
  sprintf(buf,"/dev/tty%d",vt);
  if(stat(buf,&sbuf)<0)return -1;
  pw=getpwuid(sbuf.st_uid);
  if(pw==NULL)return -1;
  strcpy(text,pw->pw_name);
  return 0;
}

int find_processes(char*text,int vt, int max)
{ DIR*d;
  struct dirent*de;
  FILE*f;
  char buf[1024];
  int tty_dev=0;
  char dummy=0;
  int i;
  char cmdline[1024];
  int c;
  int pid,pgid,tpgid;
  
  if(max>1024)max=1024;
  strcpy(text,"");

  d=opendir("/proc");
  if(d==NULL)
  { if(debug)fprintf(stderr,"consinfod: can't read /proc");
    return -1;
  }

  while((de=readdir(d))!=NULL)
  { if(strcmp(de->d_name,"self")==0)continue; /* prevent duplicates */
    sprintf(buf,"/proc/%s/stat",de->d_name);
    f=fopen(buf,"r");
    if(f==NULL)continue;
    fscanf(f,"%d %s %c %d %d %d %d %d",&pid,buf,&dummy,&i,&pgid,&i,&tty_dev,&tpgid);
    fclose(f);
    if(fgonly)
    { if(pid!=tpgid)continue; /*process is not in shell foreground*/
    }
    /* only get processes on device 4,vt */
    if(tty_dev==1024+vt)
    { if(strcmp(buf,"(consinfod)")==0)continue; /* prevent confusion of user */
      if(strcmp(buf,"(consd)")==0)continue; /* this can also confuse */
      
      if(show_cmdline)
      { /*try to get cmdline of process*/
        sprintf(cmdline,"/proc/%s/cmdline",de->d_name);
        f=fopen(cmdline,"r");
        if(f)
        { i=0;
          while((c=fgetc(f))!=EOF)
          { if(c==0)c=' ';
            cmdline[i]=c;
            ++i;
            if(i>=1020)break;
          }
          fclose(f);
          cmdline[i]='\0';
          if(i>0&&cmdline[i-1]==' ')cmdline[i-1]='\0';
          
          if(cmdline[0]!='\0')sprintf(buf,"[%s]",cmdline);
        }
      }
      
      /* prevent overflow */    
      if(strlen(text)+5+strlen(buf)>max)
      { strcat(text," ...");
        break; /* string is full */
      }
      
      if(*text!='\0')strcat(text," ");
      strcat(text,buf);
    }
  }

  closedir(d);
  return 0;
}

int print_console(int nr)
{ char buf[2000];
  char buf2[2000];
  char buf3[2000];
  int fd1;
  int fd2;
  unsigned int lines;
  unsigned int cols;
  unsigned int cx;
  unsigned int cy;
  
  alarm(0);
  restore_console();
  
  sprintf(buf,"/dev/vcs%d",nr);
  fd1=open(buf,O_RDWR);
  if(fd1<0)
  { perror("open vcs failed");
    return -1;
  }
  sprintf(buf,"/dev/vcsa%d",nr);
  fd2=open(buf,O_RDWR);
  if(fd2<0)
  { perror("open vcsa failed");
    close(fd1);
    return -1;
  }
  
  /* save contents */
  read(fd2,buf,4);
  lines=buf[0];
  cols=buf[1];
  if(cols>MAXV)cols=MAXV;
  
  cx=buf[2];
  cy=buf[3];
  
  read(fd2,old_vcsa,2*cols);
  lseek(fd2,4,SEEK_SET);
  old_cols=cols;
  old_vt=nr;
  
  buf3[0]='\0';
  if(duser)find_user(buf3,nr);
  find_processes(buf2,nr,cols-10-strlen(buf3));
  sprintf(buf,"VT %d: %s %s ",nr,buf3,buf2);
  write(fd2,attrs,cols*2);
  write(fd1,buf,strlen(buf));
  
  close(fd1);
  close(fd2);
  
  alarm(waittime);
  return 0;
}

int restore_console(void)
{ char buf[2000];
  int fd;

  if(old_vt<0)return 0;
    
  sprintf(buf,"/dev/vcsa%d",old_vt);
  fd=open(buf,O_RDWR);
  if(fd<0)
  { perror("open vcsa failed");
    return -1;
  }
  
  /* we check whether screen scrolled off meanwhile */
  /* this is a dirty hack but works in most cases */
  lseek(fd,2+2*old_cols,SEEK_SET);
  read(fd,buf,2);
  if(buf[0]!=attrs[2*old_cols-2]||buf[1]!=attrs[2*old_cols-1])
  { /* corner top right has changed, so ... */
    old_vt=-1;
    close(fd);
    return 0;
  }
  
  lseek(fd,4,SEEK_SET);
  write(fd,old_vcsa,old_cols*2);
  close(fd);
  
  old_vt=-1;
  
  return 0;
}

void checkvcs(void)
{ int i;
  struct stat sbuf;
  char buf[20];

  for(i=1;i<maxcons;++i)
  { sprintf(buf,"/dev/tty%d",i);
    if(stat(buf,&sbuf)<0)
      break;
    sprintf(buf,"/dev/vcs%d",i);
    if(stat(buf,&sbuf)<0)
      fprintf(stderr,"consinfod: warning: you don't have %s though /dev/tty%d exists.\n",buf,i);
    sprintf(buf,"/dev/vcsa%d",i);
    if(stat(buf,&sbuf)<0)
      fprintf(stderr,"consinfod: warning: you don't have %s though /dev/tty%d exists.\n",buf,i);
  }
}

void usage(void)
{ fprintf(stderr,"consinfod 1.5.8 (C) 1998-2009 by Frank Gockel, Martin Berentsen\n");
  fprintf(stderr,"usage: consinfod [-d] [-c] [-b] [-f] [-h] [-u] [-a attr] [-t time] [-m num] [-x string]\n\n");
  fprintf(stderr,"    -d: turn on debugging\n");
  fprintf(stderr,"    -c: show complete cmdline of processes if available\n");
  fprintf(stderr,"    -b: bind to spawn_console key\n");
  fprintf(stderr,"    -f: display only processes that are currently in the foreground\n");
  fprintf(stderr,"    -u: display name of user that is logged in at actual console\n");
  fprintf(stderr,"    -h: print this help\n");
  fprintf(stderr,"    -a: set screen attributes for info text\n");
  fprintf(stderr,"    -t: set time (in seconds) to keep info text on screen\n");  
  fprintf(stderr,"    -x: executes a given command line\n");  
  fprintf(stderr,"    -m: set maximum console number\n");
}

int main(int argc, char*argv[])
{ int i,vt,attr;

  if(getuid())
  { fprintf(stderr,"You are not root. Sorry.\n");
    exit(1);
  }

  attr=31; /* white text on blue background */

  i=1;
  while(i<argc)
  { if(strcmp(argv[i],"-d")==0)
    { debug=1;
    }
    else if(strcmp(argv[i],"-c")==0)
    { show_cmdline=1;
    }
    else if(strcmp(argv[i],"-f")==0)
    { fgonly=1;
    }
    else if(strcmp(argv[i],"-u")==0)
    { duser=1;
    }
    else if(strcmp(argv[i],"-h")==0)
    { usage();
      exit(1);
    }
    else if(strcmp(argv[i],"-a")==0)
    { ++i;
      if(argv[i]==NULL)
      { fprintf(stderr,"option -a requires an argument\n");
        exit(1);
      }
      attr=atoi(argv[i]);
    }
    else if(strcmp(argv[i],"-t")==0)
    { ++i;
      if(argv[i]==NULL||atoi(argv[i])<1)
      { fprintf(stderr,"option -t requires an argument >0\n");
        exit(1);
      }
      waittime=atoi(argv[i]);
    }
    else if(strcmp(argv[i],"-b")==0)
    { bindkey=1;
    }
    else if(strcmp(argv[i],"-x")==0)
    { ++i;
      if(argv[i]==NULL)
      { fprintf(stderr,"option -x requires an argument\n");
        exit(1);
      }
      execline=argv[i];
    }
    else if(strcmp(argv[i],"-m")==0)
    { ++i;
      if(argv[i]==NULL)
      { 
       m_err:
        fprintf(stderr,"option -m requires an integer argument [1-%d]\n",
                MAXCONS-1);
        exit(1);
      }
      maxcons=atoi(argv[i]);
      if(maxcons<1||maxcons>=MAXCONS)goto m_err;
    }
    else
    { fprintf(stderr,"unknown option %s\n",argv[i]);
      exit(1);
    }
    ++i;
  }
  
  for(i=0;i<2*MAXV;i+=2)
  { attrs[i]=' ';
    attrs[i+1]=attr;
  }

  checkvcs();

  if(debug==0)
  { if(fork())exit(0);
  }

  pidfile();
  
  signal(SIGALRM,signal_handler);
  signal(SIGHUP,signal_handler);
  signal(SIGTERM,signal_handler);
  
  if(bindkey)do_bindkey();
  
  for(;;)
  { vt=await_vt_change();
    if(vt<0)break;
    i=print_console(vt);
	if(execline != NULL)
    	system(execline);
    if(i<0)break;
    
  }
  
  unlink(PIDFILE);
  return 0;
}
